/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.GBR.dp.builder.reader;

import com.mapinfo.mapmarker.GBR.dp.builder.reader.AddressBaseDataCleaner;
import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.address.AddressFieldValue;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.RawAddress;
import com.mapinfo.mapmarker.cgge.dp.builder.InvalidFieldMappingException;
import com.mapinfo.mapmarker.cgge.dp.builder.reader.StandardRawDataReader;
import com.mapinfo.mapmarker.cgge.dp.builder.reader.StandardRawDataSource;
import com.mapinfo.midev.geometry.DirectPosition;
import java.util.Map;

public class AB_Reader
extends StandardRawDataReader {
    static final DirectPosition dummyCoords = new DirectPosition(0.0, 0.0);
    private AddressBaseDataCleaner abDataCleaner = null;
    private String lastPostDistrict = "";
    private int currentSAC;

    protected AB_Reader(StandardRawDataSource reader) throws CGGEInternalException {
        super(reader);
        this.resetSACGeneration();
    }

    @Override
    public String getCoordSysString() {
        return "epsg:4326";
    }

    @Override
    public RawAddress getNextRecord() {
        RawAddress address = super.getNextRecord();
        if (address != null) {
            address = this.postProcess(address);
        }
        return address;
    }

    private RawAddress postProcess(RawAddress addr) {
        this.abDataCleaner.cleanAddress(addr);
        this.splitPC(addr);
        this.addSAC(addr);
        return addr;
    }

    private void splitPC(RawAddress address) {
        String pc = this.getFieldValue(address, FieldType.POST_CODE_FIELD_TYPE);
        String[] pcParts = pc.split(" ");
        if (pcParts.length == 2) {
            address.setField(FieldType.POST_CODE_FIELD_TYPE, new AddressFieldValue(pcParts[0]));
            address.setField(FieldType.POST_CODE_EX_FIELD_TYPE, new AddressFieldValue(pcParts[1]));
        }
    }

    private void addSAC(RawAddress address) {
        String pd = this.getFieldValue(address, FieldType.POST_CODE_FIELD_TYPE);
        int sac = this.currentSAC++;
        if (!this.lastPostDistrict.equals(pd)) {
            sac = this.currentSAC;
            this.lastPostDistrict = pd;
        }
        address.setSac(Integer.toString(sac));
    }

    @Override
    public boolean isSacFromFile() {
        return true;
    }

    @Override
    public void setAdditionalFields(Map<String, FieldType> map) throws InvalidFieldMappingException {
        super.setAdditionalFields(map);
        this.abDataCleaner = new AddressBaseDataCleaner(map);
    }

    private String getFieldValue(RawAddress address, FieldType type) {
        AddressFieldValue fv = (AddressFieldValue)address.getField(type);
        return fv == null ? null : (String)fv.getFieldValue();
    }

    @Override
    protected boolean isValidAddressField(String str) {
        boolean isValid = ALT_LEFT_VALUES.keySet().contains(str);
        isValid = isValid || ALT_RIGHT_VALUES.keySet().contains(str);
        boolean bl = isValid = isValid || additionalFieldNames != null && additionalFieldNames.containsKey(str);
        if (isValid || str.equals("FromLeft") || str.equals("ToLeft") || str.equals("FromRight") || str.equals("ToRight") || str.equals("Sac") || str.equals("LeftSac") || str.equals("RightSac") || str.equals("IsSacFromFile") || str.equals("Combine_Alt_Vals_Delim")) {
            isValid = true;
        }
        return isValid;
    }

    @Override
    public void rewind() {
        super.rewind();
        this.resetSACGeneration();
    }

    private void resetSACGeneration() {
        this.lastPostDistrict = "";
        this.currentSAC = 100;
    }
}

