/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.GBR.dp.builder.reader;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

class LocalityAliasHandler {
    private Map<String, List<String>> aliases = new TreeMap<String, List<String>>();

    LocalityAliasHandler() {
    }

    void loadData(Properties props) throws Exception {
        String fileName = props.getProperty("localityAliasFile");
        String filePath = props.getProperty("inputPath");
        if (filePath != null && !filePath.endsWith("\\") && !filePath.endsWith("/")) {
            filePath = filePath + "/";
        }
        BufferedReader reader = new BufferedReader(new FileReader(filePath + fileName));
        String line = null;
        while ((line = reader.readLine()) != null) {
            if (line.length() < 53 || '1' != line.charAt(0) || !"PNR".equals(line.substring(50, 53))) continue;
            String postSector = line.substring(10, 14).trim().toUpperCase() + ' ' + line.charAt(14);
            String alias = line.substring(15, 50).trim();
            List<String> previous = this.aliases.get(postSector);
            if (previous != null) {
                previous.add(alias);
                continue;
            }
            ArrayList<String> temp = new ArrayList<String>();
            temp.add(alias);
            this.aliases.put(postSector, temp);
        }
    }

    Collection<String> getLocalityAliases(String postSector) {
        if (postSector == null || postSector.length() == 0) {
            return null;
        }
        List<String> result = this.aliases.get(postSector);
        if (result != null) {
            return Collections.unmodifiableList(result);
        }
        return null;
    }
}

