/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.GBR.dp.builder.reader;

import com.mapinfo.mapmarker.GBR.dp.builder.reader.AddressBaseDataCleaner;
import com.mapinfo.mapmarker.cgge.address.AddressNumber;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.RawAddress;
import com.mapinfo.mapmarker.cgge.parser.CGGEParser1;
import com.mapinfo.mapmarker.cgge.utils.IntArray;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import java.util.List;
import java.util.Map;

public class PAFDataCleaner
extends AddressBaseDataCleaner {
    private final Parser m_parser = new Parser();

    public PAFDataCleaner(Map<String, FieldType> map) {
        super(map);
        this.m_parser.init("GBR", "en");
    }

    @Override
    protected void adjustBuildingFields(RawAddress address) {
        int pos;
        String buildingName = this.getFieldValue(address, BUILDING_NAME_FIELD);
        if (MMUtils.isEmpty(buildingName)) {
            return;
        }
        String hnr = this.getFieldValue(address, HOUSE_NUM_FIELD);
        String subBuildingName = this.getFieldValue(address, SUB_BUILDING_NAME_FIELD);
        if (MMUtils.isEmpty(hnr) && this.isHNRPattern(buildingName) && !MMUtils.isNumber(buildingName)) {
            hnr = buildingName;
            buildingName = null;
        }
        if (!MMUtils.isEmpty(buildingName) && MMUtils.isEmpty(subBuildingName) && (pos = this.hnrSuffixStarts(buildingName)) != -1 && this.isUnitTypeWord(this.getWordBeforePos(buildingName, pos))) {
            if (MMUtils.isEmpty(hnr)) {
                hnr = buildingName;
                buildingName = null;
            } else {
                subBuildingName = buildingName;
                buildingName = null;
            }
        }
        if (!MMUtils.isEmpty(buildingName)) {
            AddressWord[] words = this.m_parser.getAddressWords(buildingName);
            String numValue = this.m_parser.reconstructFieldValue(new AddressWord[]{words[words.length - 1]});
            int i = this.hnrSuffixStarts(numValue);
            if (i == 0 && !MMUtils.isNumber(numValue)) {
                hnr = numValue;
                int count = words.length;
                if (count == 1) {
                    buildingName = null;
                } else {
                    AddressWord[] temp = new AddressWord[words.length - 1];
                    System.arraycopy(words, 0, temp, 0, words.length - 1);
                    buildingName = this.m_parser.reconstructFieldValue(temp);
                }
            }
            if (!MMUtils.isEmpty(buildingName)) {
                words = this.m_parser.getAddressWords(buildingName);
                AddressWord[] subBuildingWords = this.m_parser.getAddressWords(subBuildingName);
                List<AddressNumber> numbers = this.m_parser.findProbableAddressNumbers(subBuildingWords, null);
                if (numbers == null && (i = this.hnrSuffixStarts(numValue = this.m_parser.reconstructFieldValue(new AddressWord[]{words[0]}))) == 0) {
                    subBuildingName = MMUtils.isEmpty(subBuildingName) ? numValue : subBuildingName + ' ' + numValue;
                    AddressWord[] temp = new AddressWord[words.length - 1];
                    System.arraycopy(words, 1, temp, 0, words.length - 1);
                    buildingName = this.m_parser.reconstructFieldValue(temp);
                }
            }
        }
        this.setFieldValue(address, HOUSE_NUM_FIELD, hnr);
        this.setFieldValue(address, BUILDING_NAME_FIELD, this.removeCommaAndTrim(buildingName));
        this.setFieldValue(address, SUB_BUILDING_NAME_FIELD, this.removeCommaAndTrim(subBuildingName));
    }

    private static class Parser
    extends CGGEParser1 {
        private Parser() {
        }

        @Override
        protected List<AddressNumber> findProbableAddressNumbers(AddressWord[] words, IntArray ignoreWordNdxs) {
            return super.findProbableAddressNumbers(words, ignoreWordNdxs);
        }
    }
}

