/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.GBR.filters;

import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.address.AdditionalFields;
import com.mapinfo.mapmarker.cgge.address.AddressNumber;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.InternalScoringRange;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.address.ScoringItem;
import java.util.List;
import java.util.Map;

public class FilterUtils {
    private FilterUtils() {
    }

    public static boolean equalsOrBetter(ScoringItem best, ScoringItem other, FieldType fieldType) {
        if (best == null) {
            return other == null;
        }
        if (other == null) {
            return true;
        }
        FieldScore bestScore = best.getFieldScore(fieldType);
        FieldScore otherScore = other.getFieldScore(fieldType);
        if (otherScore == null) {
            return true;
        }
        if (bestScore == null) {
            return false;
        }
        return bestScore.m_value >= otherScore.m_value;
    }

    public static boolean equalsOrBetter(ScoringItem best, ScoringItem other) {
        if (best == null) {
            return other == null;
        }
        if (other == null) {
            return true;
        }
        if (best.getFieldScores() == null) {
            return other.getFieldScores() == null;
        }
        if (other.getFieldScores() == null) {
            return true;
        }
        for (FieldType type : best.getFieldScores().keySet()) {
            if (FilterUtils.equalsOrBetter(best, other, type)) continue;
            return false;
        }
        if (!best.getFieldScores().keySet().containsAll(other.getFieldScores().keySet())) {
            for (FieldType type : other.getFieldScores().keySet()) {
                FieldScore score;
                if (best.getFieldScores().containsKey(type) || (score = other.getFieldScore(type)) == null || score.m_value == 0.0) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean equalsOrBetter_addressNumber(InternalScoringRange best, InternalScoringRange other, ParsedAddress parsedAddress) {
        if (best == null) {
            return other == null;
        }
        if (other == null) {
            return true;
        }
        FieldScore bestScore = best.getFieldScore(FieldType.ADDRESS_NUMBER_FIELD_TYPE);
        FieldScore otherScore = other.getFieldScore(FieldType.ADDRESS_NUMBER_FIELD_TYPE);
        if (otherScore == null) {
            return true;
        }
        if (bestScore == null) {
            return false;
        }
        if (bestScore.m_value > otherScore.m_value) {
            return true;
        }
        if (bestScore.m_value == 1.0 && otherScore.m_value == 1.0) {
            AddressNumber bestNumber = best.getFrom();
            AddressNumber otherNumber = other.getFrom();
            if (bestNumber == null) {
                return otherNumber == null;
            }
            if (bestNumber.compare(bestNumber, otherNumber) == 0) {
                return true;
            }
            if (parsedAddress != null) {
                List<AddressNumber> list = parsedAddress.getProbableAddressNumbers();
                return list != null && list.get(0).compare(list.get(0), bestNumber) == 0;
            }
        }
        return bestScore.m_value == otherScore.m_value;
    }

    public static String getAdditionalFieldsValue(AdditionalFields additionalFields, String fieldTypeName) {
        Map<FieldType, String> fields;
        if (fieldTypeName != null && additionalFields != null && (fields = additionalFields.getAdditionalFields()) != null) {
            for (FieldType type : fields.keySet()) {
                if (!fieldTypeName.equalsIgnoreCase(type.getName())) continue;
                return fields.get(type);
            }
        }
        return null;
    }

    public static boolean sameOrBetterS3Status(InternalScoringAddress bestCand, InternalScoringAddress otherCand) {
        if (bestCand == null || otherCand == null) {
            return false;
        }
        if (bestCand.isS8()) {
            return true;
        }
        if (otherCand.isS8()) {
            return false;
        }
        if (bestCand.isS3() == otherCand.isS3()) {
            return true;
        }
        return !bestCand.isS3() && otherCand.isS3();
    }
}

