/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.GBR.filters;

import com.mapinfo.mapmarker.GBR.ICGGECloseMatchFilterRule;
import com.mapinfo.mapmarker.GBR.filters.FilterUtils;
import com.mapinfo.mapmarker.cgge.AddressNumberScore;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.InternalScoringRange;

public class PreferExactHouseNumber
implements ICGGECloseMatchFilterRule {
    @Override
    public boolean demoteOther(InternalScoringAddress bestCand, InternalScoringAddress otherCand) {
        if (bestCand.getCombinedStreetScore() < otherCand.getCombinedStreetScore()) {
            return false;
        }
        if (!FilterUtils.equalsOrBetter(bestCand, otherCand)) {
            return false;
        }
        if (bestCand.getRangeCount() > 0 && otherCand.getRangeCount() > 0) {
            InternalScoringRange bestRange = bestCand.getRangeAt(0);
            InternalScoringRange otherRange = otherCand.getRangeAt(0);
            if (otherRange != null && bestRange != null) {
                if (!FilterUtils.sameOrBetterS3Status(bestCand, otherCand)) {
                    return false;
                }
                if (!FilterUtils.equalsOrBetter_addressNumber(bestRange, otherRange, bestCand.getParsedAddress())) {
                    return false;
                }
                AddressNumberScore bestScore = (AddressNumberScore)bestRange.getFieldScore(FieldType.ADDRESS_NUMBER_FIELD_TYPE);
                AddressNumberScore otherScore = (AddressNumberScore)otherRange.getFieldScore(FieldType.ADDRESS_NUMBER_FIELD_TYPE);
                if (bestScore != null && otherScore != null && bestScore.m_value == otherScore.m_value && bestScore.m_value == 1.0 && bestScore.getInputAddressNumber().equals(bestScore.getCandidateAddressNumber()) && !otherScore.getInputAddressNumber().equals(otherScore.getCandidateAddressNumber())) {
                    return true;
                }
            }
        }
        return false;
    }
}

