/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.GBR.filters;

import com.mapinfo.mapmarker.GBR.ICGGECloseMatchFilterRule;
import com.mapinfo.mapmarker.GBR.filters.FilterUtils;
import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.InternalScoringRange;
import com.mapinfo.mapmarker.cgge.address.ScoringItem;

public class PreferPartiallyMatchedFirmName
implements ICGGECloseMatchFilterRule {
    @Override
    public boolean demoteOther(InternalScoringAddress bestCand, InternalScoringAddress otherCand) {
        if (!FilterUtils.equalsOrBetter(bestCand, otherCand)) {
            return false;
        }
        if (bestCand.getRangeCount() > 0 && otherCand.getRangeCount() > 0) {
            InternalScoringRange bestRange = bestCand.getRangeAt(0);
            InternalScoringRange otherRange = otherCand.getRangeAt(0);
            if (otherRange != null && bestRange != null) {
                if (!FilterUtils.sameOrBetterS3Status(bestCand, otherCand)) {
                    return false;
                }
                if (!FilterUtils.equalsOrBetter_addressNumber(bestRange, otherRange, bestCand.getParsedAddress())) {
                    return false;
                }
                FieldScore bestScore = this.getFieldScore(bestRange, "firm_name");
                if (bestScore == null) {
                    return false;
                }
                FieldScore otherScore = this.getFieldScore(otherRange, "firm_name");
                if (otherScore == null) {
                    return true;
                }
                if (bestScore.m_value - otherScore.m_value > 0.25) {
                    return true;
                }
            }
        }
        return false;
    }

    FieldScore getFieldScore(ScoringItem item, String name) {
        if (name == null || item.getFieldScores() == null) {
            return null;
        }
        for (FieldType key : item.getFieldScores().keySet()) {
            if (!key.getName().equalsIgnoreCase(name)) continue;
            return item.getFieldScore(key);
        }
        return null;
    }
}

