/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.GBR.helper;

import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.CodedWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.address.PostCode;
import com.mapinfo.mapmarker.cgge.soundex.ICGGESoundex;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class AlternateSoundexKeyGenerator {
    private ICGGESoundex soundex;

    AlternateSoundexKeyGenerator(ICGGESoundex soundex) {
        this.soundex = soundex;
    }

    public List<AddressWord> getAlternatePostDistrictKeyWords(ParsedAddress parsedAddr) {
        ArrayList<AddressWord> altPDKeyWords = new ArrayList<AddressWord>();
        for (AddressWord pdWord : this.getPDWords(parsedAddr)) {
            altPDKeyWords.add(pdWord);
            this.makeAlternateWords(pdWord, 22, altPDKeyWords);
            this.makeAlternateForFirstCharacterDifference(pdWord, altPDKeyWords);
        }
        return altPDKeyWords;
    }

    private List<AddressWord> getPDWords(ParsedAddress parsedAddr) {
        FieldType pcType = FieldType.POST_CODE_FIELD_TYPE;
        AddressWord[] pcWords = (AddressWord[])parsedAddr.getField(pcType);
        if (pcWords != null) {
            return Collections.singletonList(pcWords[0]);
        }
        List<PostCode> pcProbables = parsedAddr.getProbablePostcodes();
        if (pcProbables != null) {
            ArrayList<AddressWord> addrWordList = new ArrayList<AddressWord>(pcProbables.size());
            for (PostCode pc : pcProbables) {
                addrWordList.add(pc.getWords()[0]);
            }
            return addrWordList;
        }
        return Collections.emptyList();
    }

    protected void makeAlternateWords(AddressWord addrWord, int altSoundexMask, List<AddressWord> altPDWordList) {
        int[] altsoundes = this.soundex.getAlternateSoundexes(addrWord.getWord(), altSoundexMask);
        if (altsoundes != null) {
            for (int altsound : altsoundes) {
                altPDWordList.add(this.makeAlternateWordWithSoundex(addrWord, altsound));
            }
        }
    }

    protected void makeAlternateForFirstCharacterDifference(AddressWord word, List<AddressWord> altPDWordList) {
        StringBuilder sb = new StringBuilder(word.getWord());
        for (char ch = 'A'; ch <= 'Z'; ch = (char)(ch + '\u0001')) {
            sb.setCharAt(0, ch);
            int sound = this.soundex.getSoundex(sb.toString());
            altPDWordList.add(this.makeAlternateWordWithSoundex(word, sound));
        }
    }

    private AddressWord makeAlternateWordWithSoundex(AddressWord addrWord, int altSound) {
        CodedWord altCodedWord = new CodedWord(addrWord.getCodedWord());
        altCodedWord.setSoundex(altSound);
        AddressWord altWord = new AddressWord(addrWord);
        altWord.setCodedWord(altCodedWord);
        return altWord;
    }
}

