/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.GBR.matcher;

import com.mapinfo.mapmarker.cgge.AddressNumberScore;
import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.address.AddressNumber;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.CodedWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.InternalScoringRange;
import com.mapinfo.mapmarker.cgge.utils.IntArray;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import java.util.Map;

public class FieldMatchChecker {
    static final double GOOD_MATCH_THRESHOLD = 0.9;
    static final double ACCEPTABLE_MATCH_THRESHOLD = 0.8;
    static final double SCORED_THRESHOLD = 0.5;
    private static final IntArray EMPTY_INT_ARRAY = new IntArray(new int[0]);

    public boolean hasGoodStreetLevelMatch(InternalScoringAddress cand) {
        Map<FieldType, FieldScore> scoreMap = cand.getFieldScores();
        if (scoreMap != null) {
            int acceptableFields = 0;
            for (Map.Entry<FieldType, FieldScore> en : scoreMap.entrySet()) {
                if (en.getKey().getLevel() != FieldType.FieldLevel.LEVEL_STREET && en.getKey().getLevel() != FieldType.FieldLevel.LEVEL_RANGE) continue;
                FieldScore score = en.getValue();
                if (this.acceptableFieldMatch(score)) {
                    ++acceptableFields;
                }
                if (acceptableFields > 1) {
                    return true;
                }
                if (en.getKey() == FieldType.STREET_NAME_FIELD_TYPE && this.hasGoodEnoughStreetMatch(cand)) {
                    return true;
                }
                if (en.getKey() == FieldType.ADDRESS_NUMBER_FIELD_TYPE || !this.passFieldMatchThreshold(score) || !this.allWordsMatched(score) && !this.hasMatchingSignificantWords(score)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasGoodEnoughStreetMatch(InternalScoringAddress cand) {
        return this.hasGoodEnoughStreetMatch(cand, FieldType.STREET_NAME_FIELD_TYPE);
    }

    public boolean hasGoodEnoughStreetMatch(InternalScoringAddress cand, FieldType type) {
        if (this.hasPerfectMatch(cand, type)) {
            return true;
        }
        FieldScore fieldScore = cand.getFieldScore(type);
        if (fieldScore != null && this.passFieldMatchThreshold(fieldScore)) {
            return this.hasMatchingThoroughFareType(fieldScore) && this.allWordsMatched(fieldScore);
        }
        return false;
    }

    public boolean hasMatchingSignificantWords(InternalScoringAddress cand, FieldType type) {
        FieldScore fieldScore = cand.getFieldScore(type);
        return fieldScore != null && this.hasMatchingSignificantWords(fieldScore);
    }

    public boolean hasPerfectMatch(InternalScoringAddress cand, FieldType type) {
        FieldScore score = cand.getFieldScore(type);
        return score != null && score.m_matched;
    }

    private boolean passFieldMatchThreshold(FieldScore score) {
        return score.m_value >= 0.9;
    }

    boolean acceptableFieldMatch(FieldScore score) {
        return score.m_value >= 0.8;
    }

    public boolean hasMatchingThoroughFareType(FieldScore score) {
        if (score.m_perfectCandWords != null) {
            AddressWord[] candWords = score.m_candWords;
            int lastMatchedWordNdx = score.m_matchedCandWords.getLast();
            if (score.m_perfectCandWords.contains(lastMatchedWordNdx) && CodedWord.isThoroughfareTypeWord(candWords[lastMatchedWordNdx].getAttributes())) {
                return true;
            }
        }
        return false;
    }

    public boolean allWordsMatched(FieldScore score) {
        int candWordCount = score.candidateWordCount();
        if (candWordCount == 0) {
            return false;
        }
        int matchedCandWords = score.matchedCandidateWordCount();
        if (score.candidateWordCount() == matchedCandWords) {
            return true;
        }
        int matchableWords = 0;
        for (AddressWord word : score.getCandidateWords()) {
            if (word.m_weight <= 0) continue;
            ++matchableWords;
        }
        return matchableWords == matchedCandWords;
    }

    public boolean hasMatchingSignificantWords(FieldScore score) {
        boolean hasMatch = false;
        for (int ndx : score.m_matchedCandWords) {
            if (!AddressWord.isSignificantWord(score.m_candWords[ndx])) continue;
            hasMatch = true;
            break;
        }
        if (hasMatch) {
            hasMatch = false;
            for (int ndx : score.m_matchedInputWords) {
                if (!AddressWord.isSignificantWord(score.m_inputWords[ndx])) continue;
                hasMatch = true;
            }
        }
        return hasMatch;
    }

    public boolean hasPostDistrictMatch(InternalScoringAddress cand) {
        FieldScore score = cand.getFieldScore(FieldType.POST_CODE_FIELD_TYPE);
        if (score != null) {
            return score.m_matched || score.isPerfectCandWordMatch(0);
        }
        return false;
    }

    public boolean hasScoringStreetFields(InternalScoringAddress cand) {
        FieldType dependantStreetType = cand.getDataSetInfo().getMetaData().getFieldForName("DEPENDENT_STREET");
        Map<FieldType, FieldScore> scoreMap = cand.getFieldScores();
        if (scoreMap != null) {
            for (Map.Entry<FieldType, FieldScore> en : scoreMap.entrySet()) {
                FieldScore score;
                if (en.getKey().getLevel() != FieldType.FieldLevel.LEVEL_STREET || dependantStreetType != null && en.getKey().equals(dependantStreetType) || (score = en.getValue()) == null || !(score.m_value > 0.5)) continue;
                return true;
            }
        }
        return false;
    }

    int countMatchableWords(AddressWord[] words) {
        int wordCount = 0;
        for (AddressWord word : words) {
            if (CodedWord.isDelimiter(word.getAttributes())) continue;
            ++wordCount;
        }
        return wordCount;
    }

    int getMatchedWordCount(Map<FieldType, FieldScore> fieldScores, AddressWord[] inputWord) {
        IntArray matchedWordNdxs = new IntArray();
        for (FieldScore score : fieldScores.values()) {
            if (score.m_inputWords != inputWord) continue;
            matchedWordNdxs.add(score.m_matchedInputWords);
        }
        matchedWordNdxs.removeDuplicates();
        return matchedWordNdxs.size();
    }

    IntArray getMatchedWordsNdxs(Map<FieldType, FieldScore> fieldScores, AddressWord[] inputWord) {
        IntArray matchedWordNdxs = new IntArray();
        for (FieldScore score : fieldScores.values()) {
            IntArray fieldMatchedWordNdxs;
            int matchedWordCount;
            if (score.m_inputWords != inputWord || (matchedWordCount = IntArray.size(fieldMatchedWordNdxs = score.m_matchedInputWords)) <= 0) continue;
            if (matchedWordCount == 1) {
                matchedWordNdxs.add(fieldMatchedWordNdxs.get(0));
                continue;
            }
            int minNdx = fieldMatchedWordNdxs.min();
            int maxNdx = fieldMatchedWordNdxs.max();
            for (int ndx = minNdx; ndx <= maxNdx; ++ndx) {
                matchedWordNdxs.add(ndx);
            }
        }
        matchedWordNdxs.removeDuplicates();
        return matchedWordNdxs;
    }

    boolean areAllUnMatchedCandidateWordsNonSignificant(FieldScore score) {
        IntArray matchedWords = score.m_matchedCandWords == null ? EMPTY_INT_ARRAY : score.m_matchedCandWords;
        AddressWord[] candWords = score.m_candWords;
        if (candWords != null && candWords.length > matchedWords.size()) {
            for (int wordNdx = candWords.length - 1; wordNdx >= 0; --wordNdx) {
                AddressWord candWord;
                if (matchedWords.contains(wordNdx) || !AddressWord.isSignificantWord(candWord = candWords[wordNdx])) continue;
                return false;
            }
        }
        return true;
    }

    boolean areAllMatchedCandidateWordsAlphaNumerics(FieldScore score) {
        return this.allMatchedWordsAlphaNUmeric(score.getCandidateWords(), score.m_matchedCandWords == null ? EMPTY_INT_ARRAY : score.m_matchedCandWords);
    }

    boolean areAllMatchedInputWordsAlphaNumerics(FieldScore score) {
        return this.allMatchedWordsAlphaNUmeric(score.getInputWords(), score.m_matchedInputWords == null ? EMPTY_INT_ARRAY : score.m_matchedInputWords);
    }

    private boolean allMatchedWordsAlphaNUmeric(AddressWord[] words, IntArray matchedWordNdxs) {
        if (matchedWordNdxs.size() == 0) {
            return false;
        }
        for (int wordNdx : matchedWordNdxs) {
            AddressWord word = words[wordNdx];
            if (MMUtils.containsDigits(word.getWordChars())) continue;
            return false;
        }
        return true;
    }

    int inputWordCount(AddressNumberScore addrNumScore) {
        AddressNumber addrNum = addrNumScore.getInputAddressNumber();
        int count = 0;
        if (addrNum != null) {
            if (addrNum.getHnrNumber1() > 0) {
                ++count;
            }
            if (addrNum.getHnrSuffix1() != null) {
                ++count;
            }
            if (addrNum.getHnrNumber2() > 0) {
                ++count;
            }
            if (addrNum.getHnrSuffix2() != null) {
                ++count;
            }
        }
        return count;
    }

    public boolean hasRangeMatch(InternalScoringAddress addr) {
        return addr.getRangeCount() > 0 && addr.getRangeAt(0).isCloseMatch();
    }

    public boolean isFieldTypePresent(InternalScoringAddress addr, FieldType type) {
        FieldScore score = addr.getFieldScore(type);
        return score != null;
    }

    public boolean hasUsableRangeMatch(InternalScoringAddress addr) {
        return addr.getRangeCount() > 0 && this.isUsableRangeMatch(addr.getRangeAt(0));
    }

    public boolean isUsableRangeMatch(InternalScoringRange range) {
        if (range.isCloseMatch() || this.hasAcceptableAddressNumberMatch(range)) {
            return true;
        }
        return range.getCombinedScore() > 0.8;
    }

    private boolean hasAcceptableAddressNumberMatch(InternalScoringRange r1) {
        AddressNumberScore addrNumScore = (AddressNumberScore)r1.getFieldScore(FieldType.ADDRESS_NUMBER_FIELD_TYPE);
        return addrNumScore != null && (addrNumScore.isMatched() || addrNumScore.m_value >= 0.8 && addrNumScore.getOffset() > 0);
    }

    public boolean hasGoodRangeFieldMatch(InternalScoringAddress addr) {
        return addr.getRangeCount() > 0 && this.hasGoodRangeFieldMatch(addr.getRangeAt(0));
    }

    public boolean hasGoodRangeFieldMatch(InternalScoringRange r1) {
        Map<FieldType, FieldScore> scores = r1.getFieldScores();
        if (scores != null) {
            for (Map.Entry<FieldType, FieldScore> scoreEn : scores.entrySet()) {
                if (scoreEn.getKey().getLevel() != FieldType.FieldLevel.LEVEL_RANGE) continue;
                FieldScore score = scoreEn.getValue();
                if (score.m_value >= 1.0) {
                    return true;
                }
                if (!(score.m_value > 0.9)) continue;
                return this.hasPerfectNumericMatchOeNonNumericWordMatch(score);
            }
        }
        return false;
    }

    private boolean hasPerfectNumericMatchOeNonNumericWordMatch(FieldScore score) {
        int matchedWordSize = IntArray.size(score.m_matchedCandWords);
        IntArray perfectWords = score.m_perfectCandWords == null ? EMPTY_INT_ARRAY : score.m_perfectCandWords;
        for (int i = 0; i < matchedWordSize; ++i) {
            int wordNdx = score.m_matchedCandWords.get(i);
            AddressWord word = score.m_candWords[wordNdx];
            if (!(word.isNumeral() ? perfectWords.contains(wordNdx) : (double)word.m_weight > 0.0)) continue;
            return true;
        }
        return false;
    }

    public boolean isStreetMatchAfterRangeFields(InternalScoringAddress addr) {
        Map<FieldType, FieldScore> fieldScores = addr.getFieldScores();
        int lastMatchedRangeWord = this.lastMatchedWord(fieldScores, FieldType.FieldLevel.LEVEL_RANGE);
        FieldScore streetScore = addr.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE);
        if (streetScore != null && IntArray.size(streetScore.m_matchedInputWords) > 0) {
            return streetScore.m_matchedInputWords.min() > lastMatchedRangeWord;
        }
        return false;
    }

    private int lastMatchedWord(Map<FieldType, FieldScore> scores, FieldType.FieldLevel level) {
        int lastMatchedWord = -1;
        for (Map.Entry<FieldType, FieldScore> en : scores.entrySet()) {
            FieldScore score;
            if (en.getKey().getLevel() != level || (score = en.getValue()) == null || IntArray.size(score.m_matchedInputWords) <= 0) continue;
            lastMatchedWord = Math.max(lastMatchedWord, score.m_matchedInputWords.max());
        }
        return lastMatchedWord;
    }
}

