/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.GBR.matcher;

import com.mapinfo.mapmarker.GBR.matcher.FieldMatchChecker;
import com.mapinfo.mapmarker.GBR.matcher.GBR_Matcher;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.InternalScoringRange;
import com.mapinfo.mapmarker.cgge.address.ScoringItem;
import com.mapinfo.mapmarker.cgge.dp.InternalCandidateList;

public class RelativeCandidateScoreAdjuster {
    private final GBR_Matcher matcher;

    RelativeCandidateScoreAdjuster(GBR_Matcher matcher) {
        this.matcher = matcher;
    }

    void adjustScores(InternalCandidateList candList) {
        InternalScoringAddress bestStreetCandidate;
        if (candList.getCandidateCount() > 1 && (bestStreetCandidate = this.getBestCandWithStreetAndPostcodeMatch(candList)) != null) {
            double bestCombinedScore = bestStreetCandidate.getCombinedScore();
            FieldMatchChecker fieldMatchChecker = this.matcher.getFieldMatchChecker();
            for (InternalScoringAddress cand : candList.getCandidateList()) {
                if (!(bestCombinedScore < cand.getCombinedScore()) || fieldMatchChecker.hasScoringStreetFields(cand) || this.isMuchBetterRangeMatch(cand, bestStreetCandidate)) continue;
                cand.setCombinedScore(bestCombinedScore - 0.01 + 0.01 * cand.getCombinedScore());
            }
        }
    }

    private boolean isMuchBetterRangeMatch(InternalScoringAddress cand, InternalScoringAddress bestStreetCandidate) {
        InternalScoringRange bestCandRange = bestStreetCandidate.getRangeAt(0);
        InternalScoringRange candRange = cand.getRangeAt(0);
        if (bestCandRange.isCloseMatch()) {
            return false;
        }
        if (candRange.isCloseMatch()) {
            return true;
        }
        return candRange.getCombinedScore() > candRange.getCombinedScore() * 1.25;
    }

    InternalScoringAddress getBestCandWithStreetAndPostcodeMatch(InternalCandidateList candList) {
        ScoringItem best = null;
        for (InternalScoringAddress cand : candList.getCandidateList()) {
            if (!this.hasStreetAndPCMatch(cand) || best != null && !(best.getCombinedScore() < cand.getCombinedScore())) continue;
            best = cand;
        }
        return best;
    }

    private boolean hasStreetAndPCMatch(InternalScoringAddress cand) {
        FieldMatchChecker fieldMatchChecker = this.matcher.getFieldMatchChecker();
        return fieldMatchChecker.hasGoodEnoughStreetMatch(cand) && fieldMatchChecker.hasPerfectMatch(cand, FieldType.POST_CODE_FIELD_TYPE);
    }
}

