/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.GBR.matcher;

import com.mapinfo.mapmarker.GBR.matcher.GBR_Matcher;
import com.mapinfo.mapmarker.GBR.matcher.RangeScoreCalculator;
import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.CGGERuntimeException;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.MatchingOptions;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.InternalScoringRange;
import com.mapinfo.mapmarker.cgge.dp.DataSetInfo;
import com.mapinfo.mapmarker.cgge.dp.InternalCandidateList;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;

public class RelativeRangeScoreAdjuster {
    static final RelativeRangeScoreAdjuster BASE_ADJUSTER = new RelativeRangeScoreAdjuster(null, null);
    private static final String KEY_RELATIVE_RANGE_SCORE_ADJUSTER_OBJECT = "relative_range_score_adjuster";
    private final GBR_Matcher matcher;
    private RangeScoreCalculator bestRangeScoreCalculator;
    private InternalScoringAddress bestRangeCandidate;
    private DataSetInfo lastDataSetInfo;
    private MatchingOptions lastMatchingOptions;
    private GeocodeOptions geocodeOptions;

    RelativeRangeScoreAdjuster(GBR_Matcher matcher, GeocodeOptions geocodeOptions) {
        this.matcher = matcher;
        this.geocodeOptions = geocodeOptions;
    }

    void adjustOnRangeScores(InternalCandidateList candList) throws CGGERuntimeException, CGGEInternalException {
        if (candList.hasCandidates()) {
            this.setBestRangeFieldScoresWithMostMatches(candList);
            if (this.bestRangeScoreCalculator != null && this.bestRangeScoreCalculator.maxRangeFieldsMatched() > 0) {
                this.internalAdjustOnRangeScore(candList);
            }
        }
        candList.setAdditionalInfo(KEY_RELATIVE_RANGE_SCORE_ADJUSTER_OBJECT, this);
    }

    void adjustOnRangeScoresForMergingLists(InternalCandidateList candList1, InternalCandidateList candList2) throws CGGERuntimeException, CGGEInternalException {
        if (!this.hasStreetCandidates(candList2)) {
            return;
        }
        if (InternalCandidateList.isEmpty(candList1)) {
            this.copyObjectBetweenCandidateList(candList1, candList2);
            return;
        }
        this.internalAdjustOnRangeScoresForMergingLists(candList1, candList2);
    }

    private boolean hasStreetCandidates(InternalCandidateList candList) {
        if (InternalCandidateList.isEmpty(candList)) {
            return false;
        }
        return candList.getIndexedCandidate(0).getAddressType() == 1;
    }

    void checkAndSetBestRangeFieldScores(InternalScoringAddress cand) {
        RangeScoreCalculator rangeScoreCalculator = (RangeScoreCalculator)cand.getAdditionalInfo("range_score_calculator_object");
        if (rangeScoreCalculator == null) {
            return;
        }
        if (this.isBetterRangeCandidateThanCurrent(cand, rangeScoreCalculator)) {
            this.bestRangeScoreCalculator = rangeScoreCalculator;
            this.bestRangeCandidate = cand;
        }
    }

    private boolean isBetterRangeCandidateThanCurrent(InternalScoringAddress cand, RangeScoreCalculator candRangeCalculator) {
        if (this.bestRangeCandidate == null) {
            return true;
        }
        int comp = MMUtils.compareDoubleValues(cand.getCombinedPostalScore(), this.bestRangeCandidate.getCombinedPostalScore()) + MMUtils.compareDoubleValues(cand.getCombinedStreetScore(), this.bestRangeCandidate.getCombinedStreetScore());
        if (comp > 1) {
            return true;
        }
        if (comp < -1) {
            return false;
        }
        if (comp > 0) {
            if (candRangeCalculator.perfectFieldMatchCount() > this.bestRangeScoreCalculator.perfectFieldMatchCount()) {
                return true;
            }
        } else if (comp < 0 && this.bestRangeScoreCalculator.perfectFieldMatchCount() > candRangeCalculator.perfectFieldMatchCount()) {
            return false;
        }
        return this.bestRangeScoreCalculator.compareTo(candRangeCalculator) < 0;
    }

    private void internalAdjustOnRangeScoresForMergingLists(InternalCandidateList candList1, InternalCandidateList candList2) throws CGGERuntimeException, CGGEInternalException {
        int matchedFieldSize2;
        RelativeRangeScoreAdjuster adj1 = this.getAdjustingObjectFromCandidateList(candList1);
        RelativeRangeScoreAdjuster adj2 = this.getAdjustingObjectFromCandidateList(candList2);
        int matchedFieldSize1 = adj1.maxRangeFieldsMatched();
        if (matchedFieldSize1 > (matchedFieldSize2 = adj2.maxRangeFieldsMatched())) {
            adj1.internalAdjustOnRangeScore(candList2);
        } else if (matchedFieldSize1 < matchedFieldSize2) {
            adj2.internalAdjustOnRangeScore(candList1);
            candList1.setAdditionalInfo(KEY_RELATIVE_RANGE_SCORE_ADJUSTER_OBJECT, adj2);
        } else if (matchedFieldSize1 > 0 && adj2.bestRangeScoreCalculator.compareTo(adj1.bestRangeScoreCalculator) > 0) {
            candList1.setAdditionalInfo(KEY_RELATIVE_RANGE_SCORE_ADJUSTER_OBJECT, adj2);
        }
    }

    private void copyObjectBetweenCandidateList(InternalCandidateList candList1, InternalCandidateList candList2) {
        RelativeRangeScoreAdjuster savedObject = this.getAdjustingObjectFromCandidateList(candList2);
        if (savedObject != BASE_ADJUSTER) {
            candList1.setAdditionalInfo(KEY_RELATIVE_RANGE_SCORE_ADJUSTER_OBJECT, savedObject);
        }
    }

    private RelativeRangeScoreAdjuster getAdjustingObjectFromCandidateList(InternalCandidateList candList) {
        RelativeRangeScoreAdjuster adj = (RelativeRangeScoreAdjuster)candList.getAdditionalInfo(KEY_RELATIVE_RANGE_SCORE_ADJUSTER_OBJECT);
        return adj == null ? BASE_ADJUSTER : adj;
    }

    private void internalAdjustOnRangeScore(InternalCandidateList candList) throws CGGERuntimeException, CGGEInternalException {
        for (InternalScoringAddress cand : candList.getCandidateList()) {
            double missingWeight;
            MatchingOptions matchingOptions = this.getMatchingOptions(cand);
            RangeScoreCalculator rangeScoreCalculator = (RangeScoreCalculator)cand.getAdditionalInfo("range_score_calculator_object");
            if (rangeScoreCalculator == null || rangeScoreCalculator == this.bestRangeScoreCalculator || !((missingWeight = this.calculateMissingWeightComparedToBestRange(cand.getRangeAt(0))) > 0.0)) continue;
            this.adjustCandidateCombinedScoreRangeWeight(cand, missingWeight, matchingOptions);
        }
    }

    private double calculateMissingWeightComparedToBestRange(InternalScoringRange scoredRange) {
        return scoredRange.getCombinedScore() - this.bestRangeScoreCalculator.calculateCombinedRangeScore(scoredRange);
    }

    private void setBestRangeFieldScoresWithMostMatches(InternalCandidateList candList) throws CGGERuntimeException, CGGEInternalException {
        for (InternalScoringAddress cand : candList.getCandidateList()) {
            this.checkAndSetBestRangeFieldScores(cand);
        }
    }

    private MatchingOptions getMatchingOptions(InternalScoringAddress cand) throws CGGERuntimeException, CGGEInternalException {
        DataSetInfo currDataSetInfo = cand.getDataSetInfo();
        if (currDataSetInfo != this.lastDataSetInfo) {
            this.lastDataSetInfo = currDataSetInfo;
            this.lastMatchingOptions = this.matcher.getMatchingOptions(this.geocodeOptions, cand.getDataSetInfo());
        }
        return this.lastMatchingOptions;
    }

    private void adjustCandidateCombinedScoreRangeWeight(InternalScoringAddress cand, double rangeWeightAdjust, MatchingOptions matchingOptions) {
        double rangeWeight = this.calculateRangeWeightPercentage(matchingOptions);
        double currCombinedScore = cand.getCombinedScore();
        double scoreReduction = rangeWeight * rangeWeightAdjust;
        cand.setCombinedScore(currCombinedScore - scoreReduction);
    }

    private double calculateRangeWeightPercentage(MatchingOptions matchingOptions) {
        double rangeWeight = matchingOptions.getRangeAddressWeight();
        double combinedWeight = matchingOptions.getPostAddressWeight() + matchingOptions.getStreetAddressWeight() + rangeWeight;
        return rangeWeight / combinedWeight;
    }

    private int maxRangeFieldsMatched() {
        return this.bestRangeScoreCalculator == null ? 0 : this.bestRangeScoreCalculator.maxRangeFieldsMatched();
    }
}

