/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.GBR.parser;

import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.parser.CGGEParser1;
import com.mapinfo.mapmarker.cgge.scorer.CGGEScorer;
import com.mapinfo.mapmarker.cgge.scorer.ICGGEScorer;
import com.mapinfo.mapmarker.cgge.soundex.CGGESoundex;
import com.mapinfo.mapmarker.cgge.soundex.ICGGESoundex;
import com.mapinfo.mapmarker.cgge.utils.AddressWordArray;
import com.mapinfo.mapmarker.cgge.utils.IntArray;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

@Deprecated
public final class CountyHandler {
    private static int CALL_NATIVE_COPY_LIMIT = 8;
    private Object[] m_countyArray = null;
    private boolean m_loaded = false;

    public boolean load() throws IOException {
        String line;
        final CGGESoundex soundex = new CGGESoundex();
        soundex.init("GBR", null);
        final CGGEScorer scorer = new CGGEScorer();
        scorer.init("GBR", null);
        CGGEParser1 parser = new CGGEParser1(){

            @Override
            protected ICGGESoundex getSoundex() {
                return soundex;
            }

            @Override
            protected ICGGEScorer getScorer() {
                return scorer;
            }
        };
        parser.init("GBR", null);
        ArrayList<AddressWord[]> countyList = new ArrayList<AddressWord[]>(100);
        BufferedReader r = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/com/mapinfo/mapmarker/GBR/parser/counties.properties")));
        while ((line = r.readLine()) != null) {
            AddressWord[] weightedWords = parser.splitIntoWeightedWords(line, FieldType.ADDRESS_NUMBER_FIELD_TYPE);
            if (weightedWords == null) continue;
            countyList.add(weightedWords);
        }
        this.m_countyArray = countyList.toArray();
        Arrays.sort(this.m_countyArray, new CountyListComparator());
        r.close();
        this.m_loaded = true;
        return true;
    }

    public boolean isLoaded() {
        return this.m_loaded;
    }

    public AddressWord[] getCountyWords(AddressWord[] words, ICGGEScorer scorer, double minQuality, IntArray countyWordNdxs) {
        if (words != null && this.m_countyArray != null) {
            AddressWord[] inputWords = AddressWordArray.clone(words);
            int inputWordsSize = inputWords.length;
            IntArray wordsMatched = null;
            AddressWord[] countyWordsToRet = null;
            double highScore = 0.0;
            for (int i = 0; i < inputWordsSize; ++i) {
                AddressWord inputWord = inputWords[i];
                int ndx = this.binarySearch(inputWords[i]);
                if (ndx > -1) {
                    AddressWord[] countyWords;
                    while (ndx < this.m_countyArray.length && (countyWords = (AddressWord[])this.m_countyArray[ndx])[0].getSoundex() == inputWord.getSoundex()) {
                        FieldScore score = new FieldScore();
                        scorer.scoreAddressWords(inputWords, countyWords, FieldType.UNKNOWN_FIELD_TYPE, score);
                        if (score.m_value > minQuality && score.m_value > highScore) {
                            highScore = score.m_value;
                            wordsMatched = score.m_matchedInputWords;
                            countyWordsToRet = countyWords;
                            if (highScore == 1.0) break;
                        }
                        ++ndx;
                    }
                }
                if (highScore == 1.0) break;
            }
            if (highScore >= minQuality) {
                if (countyWordNdxs != null) {
                    countyWordNdxs.add(wordsMatched);
                }
                return countyWordsToRet;
            }
        }
        return null;
    }

    public AddressWord[] removeCountyWords(AddressWord[] words, IntArray countyWordNdxs) {
        return this.removeItemsFromArray(words, countyWordNdxs);
    }

    private AddressWord[] removeItemsFromArray(AddressWord[] words, IntArray ndxsToRemove) {
        if (words != null && words.length > 0) {
            if (ndxsToRemove != null && !ndxsToRemove.isEmpty()) {
                int added = 0;
                AddressWord[] wordsToReturn = new AddressWord[words.length];
                for (int i = 0; i < words.length; ++i) {
                    if (ndxsToRemove.contains(i)) continue;
                    wordsToReturn[added++] = words[i];
                }
                if (added == 0) {
                    return null;
                }
                if (added < words.length) {
                    AddressWord[] newWordsToReturn = new AddressWord[added];
                    this.arraycopy(wordsToReturn, 0, newWordsToReturn, 0, added);
                    wordsToReturn = newWordsToReturn;
                }
                return wordsToReturn;
            }
            return words;
        }
        return null;
    }

    private void arraycopy(AddressWord[] src, int srcPos, AddressWord[] dest, int destPos, int length) {
        if (length < CALL_NATIVE_COPY_LIMIT && src != dest) {
            for (int i = 0; i < length; ++i) {
                dest[destPos + i] = src[srcPos + i];
            }
        } else {
            System.arraycopy(src, srcPos, dest, destPos, length);
        }
    }

    private int binarySearch(AddressWord codedWord) {
        int low = 0;
        int high = this.m_countyArray.length - 1;
        int sndxForSearch = codedWord.getSoundex();
        while (low <= high) {
            int mid = low + high >> 1;
            int sndxCurrent = ((AddressWord[])this.m_countyArray[mid])[0].getSoundex();
            if (sndxCurrent > sndxForSearch) {
                high = mid - 1;
                continue;
            }
            if (sndxCurrent < sndxForSearch) {
                low = mid + 1;
                continue;
            }
            if (mid > 0) {
                --mid;
                while (mid >= 0 && (sndxCurrent = ((AddressWord[])this.m_countyArray[mid])[0].getSoundex()) == sndxForSearch) {
                    --mid;
                }
                return mid + 1;
            }
            return mid;
        }
        return -1;
    }

    class CountyListComparator
    implements Comparator {
        CountyListComparator() {
        }

        public int compare(Object o1, Object o2) {
            AddressWord[] w1 = (AddressWord[])o1;
            AddressWord[] w2 = (AddressWord[])o2;
            int diff = w1[0].getSoundex() - w2[0].getSoundex();
            if (diff == 0) {
                return w2.length - w1.length;
            }
            return diff;
        }
    }
}

