/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.GBR.parser;

import com.mapinfo.mapmarker.cgge.address.AddressNumber;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.CodedWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InputAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.parser.CGGEParser1;
import com.mapinfo.mapmarker.cgge.scorer.ICGGEScorer;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GBR_Parser
extends CGGEParser1 {
    private static Pattern m_pcPattern = Pattern.compile("\\b([A-Z]\\s*[A-Z]?\\s*\\d\\s*\\d?\\s*[A-Z]?|GIR)\\s*\\d[A-Z]\\s*[A-Z]");
    private static Pattern m_pcUnitPattern;
    private static Pattern m_pcDistrictPattern;
    private static Pattern m_poBoxPattern;
    private static Pattern m_poMissingBoxPattern;
    private static Pattern m_ambiguousPoBoxPattern;
    private static Pattern m_portsmouthPostcodePattern;
    private List<String> intersectionWords = Arrays.asList("AND", "&&", "&");
    String nonPoBoxMainForSL;

    @Override
    public ParsedAddress[] parse(InputAddress inputAddress, ICGGEScorer scorer) {
        String postcode = (String)inputAddress.getField(FieldType.POST_CODE_FIELD_TYPE);
        String postcodeExtracted = null;
        boolean singleLine = false;
        FieldType pcFoundField = FieldType.UNKNOWN_FIELD_TYPE;
        if (!StringUtilities.isEmpty((String)postcode)) {
            pcFoundField = FieldType.POST_CODE_FIELD_TYPE;
        }
        if (pcFoundField == FieldType.UNKNOWN_FIELD_TYPE) {
            StringBuilder buf;
            if (inputAddress.getField(FieldType.POST_ADDRESS_FIELD_TYPE) != null) {
                buf = new StringBuilder((String)inputAddress.getField(FieldType.POST_ADDRESS_FIELD_TYPE));
                postcodeExtracted = this.findPCFromInput(buf);
                pcFoundField = FieldType.POST_ADDRESS_FIELD_TYPE;
            }
            if (postcodeExtracted == null && inputAddress.getField(FieldType.STREET_NAME_FIELD_TYPE) != null) {
                buf = new StringBuilder((String)inputAddress.getField(FieldType.STREET_NAME_FIELD_TYPE));
                postcodeExtracted = this.findPCFromInput(buf);
                pcFoundField = FieldType.STREET_NAME_FIELD_TYPE;
            }
            if (postcodeExtracted != null) {
                postcode = postcodeExtracted;
            }
        }
        this.postCodeCorrection(inputAddress, postcode, pcFoundField);
        String origMain = (String)inputAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
        String origGfld1 = (String)inputAddress.getField(FieldType.GENERIC_FIELD_1_FIELD_TYPE);
        if (origMain != null && origGfld1 != null) {
            StringBuilder sb = new StringBuilder(origMain);
            sb.append(' ');
            sb.append((String)inputAddress.getField(FieldType.GENERIC_FIELD_1_FIELD_TYPE));
            inputAddress.setField(FieldType.STREET_NAME_FIELD_TYPE, sb.toString());
            inputAddress.setField(FieldType.GENERIC_FIELD_1_FIELD_TYPE, null);
        }
        if (inputAddress.getField(FieldType.POST_ADDRESS_FIELD_TYPE) == null && inputAddress.getField(FieldType.AREA_NAME_1_FIELD_TYPE) == null && inputAddress.getField(FieldType.AREA_NAME_2_FIELD_TYPE) == null && inputAddress.getField(FieldType.AREA_NAME_3_FIELD_TYPE) == null && inputAddress.getField(FieldType.AREA_NAME_4_FIELD_TYPE) == null && inputAddress.getField(FieldType.POST_CODE_FIELD_TYPE) == null) {
            singleLine = true;
        }
        ParsedAddress dummyPA = new ParsedAddress("GBR", "en");
        String main = (String)inputAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
        if (main != null && main.contains("  ")) {
            while (main.contains("  ")) {
                main = main.replaceAll("  ", " ");
            }
            inputAddress.setField(FieldType.STREET_NAME_FIELD_TYPE, main);
        }
        boolean foundPOB = this.extractPOBox(inputAddress, dummyPA, singleLine);
        ParsedAddress[] parsedAddresses = super.parse(inputAddress, scorer);
        if (foundPOB) {
            parsedAddresses[0].setPoBoxInMainAddress(dummyPA.isPoBoxInMainAddress());
            parsedAddresses[0].setPoBoxType(dummyPA.getPoBoxType());
            parsedAddresses[0].setPoBoxNumber(dummyPA.getPoBoxNumber());
            if (parsedAddresses[0].isPoBoxInMainAddress()) {
                parsedAddresses[0].setField(FieldType.STREET_NAME_FIELD_TYPE, this.makePOBTypeWords());
            }
            if (parsedAddresses[0].isPoBoxInMainAddress() && parsedAddresses[0].getAddressNumber() == null && parsedAddresses[0].getProbableAddressNumbers() != null && parsedAddresses[0].getProbableAddressNumbers().get(0) != null) {
                parsedAddresses[0].setAddressNumber(parsedAddresses[0].getProbableAddressNumbers().get(0));
                parsedAddresses[0].setProbableAddressNumbers(null);
            }
            if (singleLine) {
                parsedAddresses[0].setPoBoxInSingleLine(true);
                this.saveNonPoBoxMain(parsedAddresses[0]);
            }
        }
        this.verifyIntersection(parsedAddresses[0]);
        return parsedAddresses;
    }

    private AddressWord[] makePOBTypeWords() {
        AddressWord word;
        AddressWord[] newWords = new AddressWord[2];
        int soundex = this.getSoundex().getSoundex("PO");
        CodedWord cw = new CodedWord("PO", soundex, -1);
        newWords[0] = word = new AddressWord(cw);
        soundex = this.getSoundex().getSoundex("BOX");
        cw = new CodedWord("BOX", soundex, -1);
        newWords[1] = word = new AddressWord(cw);
        return newWords;
    }

    private void saveNonPoBoxMain(ParsedAddress tmpParsed) {
        String upperCaseSL;
        String string = upperCaseSL = this.nonPoBoxMainForSL != null ? this.nonPoBoxMainForSL.toUpperCase() : null;
        if (upperCaseSL == null) {
            return;
        }
        String[] toks = upperCaseSL.split(" ");
        AddressWord[] words = new AddressWord[toks.length];
        int idx = 0;
        for (String str : toks) {
            AddressWord word;
            int soundex = this.getSoundex().getSoundex(str);
            CodedWord cw = new CodedWord(str, soundex, -1);
            words[idx] = word = new AddressWord(cw);
            ++idx;
        }
        tmpParsed.setSL_NonPoBoxMain(words);
        tmpParsed.setSL_NonPoBoxMainString(upperCaseSL);
    }

    protected boolean extractPOBox(InputAddress inAddr, ParsedAddress tmpParsed, boolean singleLine) {
        Matcher m;
        boolean foundPOB = false;
        String mainaddr = (String)inAddr.getField(FieldType.STREET_NAME_FIELD_TYPE);
        if (!StringUtilities.isEmpty((String)mainaddr) && (m = this.testForPOBoxPattern(mainaddr = mainaddr.trim())) != null) {
            boolean hasStreet = true;
            String poBox = mainaddr.substring(m.start(), m.end());
            poBox = poBox.replaceAll("^[^a-zA-Z0-9]+", "");
            StringBuilder streetBuf = new StringBuilder(mainaddr);
            streetBuf.replace(m.start(), m.end(), "");
            String newMain = streetBuf.toString().trim();
            if (StringUtilities.isEmpty((String)newMain)) {
                hasStreet = false;
            }
            if (hasStreet) {
                tmpParsed.setPoBoxType(this.makePOBTypeWords());
                AddressNumber pobNumber = this.parserAddressNumber(m.group("POBoxNum"));
                tmpParsed.setPoBoxNumber(pobNumber);
                if (!singleLine) {
                    inAddr.setField(FieldType.STREET_NAME_FIELD_TYPE, newMain);
                } else {
                    this.nonPoBoxMainForSL = newMain;
                }
            } else {
                tmpParsed.setPoBoxInMainAddress(true);
            }
            foundPOB = true;
        }
        return foundPOB;
    }

    private void verifyIntersection(ParsedAddress parsedAddresses) {
        if (parsedAddresses.isIntersectionCase() && !this.realIntersectionFound((AddressWord[])parsedAddresses.getField(FieldType.STREET_NAME_FIELD_TYPE))) {
            parsedAddresses.setIntersectionAddress(false);
        }
    }

    private boolean realIntersectionFound(AddressWord[] streetWords) {
        int checkFrom = 1;
        if (streetWords != null) {
            int pos = this.indexOfIntersectionWord(streetWords, checkFrom);
            while (pos > -1) {
                if (this.hasIntersectingStreets(streetWords, pos)) {
                    return true;
                }
                pos = this.indexOfIntersectionWord(streetWords, pos + 1);
            }
        }
        return false;
    }

    private boolean hasIntersectingStreets(AddressWord[] streetWords, int pos) {
        return this.precedingWordisThoroughfareType(streetWords, pos) && this.hasThoroughfareType(streetWords, pos + 1, 3);
    }

    private boolean hasThoroughfareType(AddressWord[] streetWords, int pos, int wordsToSkip) {
        int c = streetWords.length;
        int skipped = 0;
        while (pos < c && skipped < wordsToSkip) {
            short wordAttributes;
            if (CodedWord.isDelimiter(wordAttributes = streetWords[pos++].getAttributes())) continue;
            if (CodedWord.isThoroughfareTypeWord(wordAttributes)) {
                return true;
            }
            ++skipped;
        }
        return false;
    }

    private boolean precedingWordisThoroughfareType(AddressWord[] streetWords, int pos) {
        if (pos == 1) {
            return false;
        }
        while (--pos >= 1) {
            short wordAttributes = streetWords[pos].getAttributes();
            if (CodedWord.isDelimiter(wordAttributes)) continue;
            if (!CodedWord.isThoroughfareTypeWord(wordAttributes)) break;
            return true;
        }
        return false;
    }

    private int indexOfIntersectionWord(AddressWord[] streetWords, int from) {
        int c = streetWords.length;
        for (int i = from; i < c; ++i) {
            if (!this.intersectionWords.contains(streetWords[i].getWord())) continue;
            return i;
        }
        return -1;
    }

    private void postCodeCorrection(InputAddress inputAddress, String postcode, FieldType pcLocField) {
        if (StringUtilities.isEmpty((String)postcode) || inputAddress == null || postcode.length() > 15) {
            return;
        }
        String postcode1 = postcode.replaceAll("\"", "");
        if (postcode1.length() == 0) {
            return;
        }
        String newpcStr = this.parseAndSetPostCodeAreas(postcode1);
        if (StringUtilities.isEmpty((String)newpcStr) || this.samePC(postcode1, newpcStr)) {
            return;
        }
        if (pcLocField == FieldType.STREET_NAME_FIELD_TYPE && postcode1.length() > 3 && m_ambiguousPoBoxPattern.matcher(postcode1).matches()) {
            return;
        }
        String str = null;
        if (pcLocField == FieldType.POST_CODE_FIELD_TYPE) {
            inputAddress.setField(FieldType.POST_CODE_FIELD_TYPE, newpcStr);
        } else if (pcLocField == FieldType.POST_ADDRESS_FIELD_TYPE) {
            str = (String)inputAddress.getField(FieldType.POST_ADDRESS_FIELD_TYPE);
            inputAddress.setField(FieldType.POST_ADDRESS_FIELD_TYPE, str.replace(postcode1, newpcStr));
        } else {
            str = (String)inputAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
            inputAddress.setField(FieldType.STREET_NAME_FIELD_TYPE, str.replace(postcode1, newpcStr));
        }
    }

    private String typoCorrectionForPostDistrict(String pd) {
        if ((pd = pd.replaceAll(" ", "")).length() > 0 && pd.charAt(pd.length() - 1) == 'O') {
            pd = pd.substring(0, pd.length() - 1) + '0';
        }
        return pd;
    }

    private String typoCorrectionForPostUnit(String pcUnitString) {
        if (pcUnitString != null) {
            if (pcUnitString.length() == 3 && pcUnitString.toUpperCase().charAt(0) == 'O') {
                pcUnitString = '0' + pcUnitString.substring(1);
            }
            pcUnitString = pcUnitString.replaceAll(" ", "");
        }
        return pcUnitString;
    }

    private String parsePostDistrict(String str, int[] startEndNdxs) {
        Matcher m = m_pcDistrictPattern.matcher(str);
        int startNdx = -1;
        int endNdx = -1;
        if (m.find()) {
            startNdx = m.start();
            endNdx = m.end();
        }
        if (startNdx > -1) {
            String pd = str.substring(startNdx, endNdx);
            if (startEndNdxs != null && startEndNdxs.length > 1) {
                startEndNdxs[0] = startNdx;
                startEndNdxs[1] = endNdx;
            }
            return pd;
        }
        return null;
    }

    private String parseAndSetPostCodeAreas(String postcode) {
        int postcodeLen;
        int n = postcodeLen = postcode == null ? 0 : postcode.length();
        if (postcodeLen > 0) {
            int[] startEndNdxs;
            String pd = null;
            String pcUnitString = null;
            Matcher m1 = m_pcUnitPattern.matcher(postcode);
            if (m1.find() && m1.start() > 0) {
                int startNdx = m1.start();
                int endNdx = m1.end();
                pcUnitString = this.typoCorrectionForPostUnit(postcode.substring(startNdx, endNdx));
                pd = this.typoCorrectionForPostDistrict(postcode.substring(0, startNdx).trim());
            }
            if (pd == null && (pd = this.parsePostDistrict(postcode, startEndNdxs = new int[2])) != null && startEndNdxs[1] < postcodeLen) {
                pcUnitString = this.typoCorrectionForPostUnit(postcode.substring(startEndNdxs[1]).trim());
                pd = this.typoCorrectionForPostDistrict(pd);
            }
            StringBuilder pc = new StringBuilder();
            if (pd != null || pcUnitString != null) {
                pc.append(pd);
                if (pcUnitString != null) {
                    pc.append(" ");
                    pc.append(pcUnitString);
                }
            }
            return pc.toString();
        }
        return postcode;
    }

    private String findPCFromInput(StringBuilder input) {
        String postcodeFromInput = null;
        if (input.length() > 0) {
            int[] startEndNdxs = new int[2];
            String str = input.toString();
            String pc = this.parseUKPostcode(str, startEndNdxs);
            if (pc != null) {
                postcodeFromInput = pc;
                input.replace(startEndNdxs[0], startEndNdxs[1], " ");
            } else {
                String pd = this.parsePostDistrict(str, startEndNdxs);
                if (pd != null) {
                    int newEndNdx = -1;
                    int charsAfter = -1;
                    for (int i = startEndNdxs[1]; i < input.length(); ++i) {
                        char ch = input.charAt(i);
                        if (ch == ' ') {
                            if (charsAfter != -1) break;
                            newEndNdx = i;
                            continue;
                        }
                        if (charsAfter < 2) {
                            newEndNdx = i;
                            ++charsAfter;
                            continue;
                        }
                        newEndNdx = -1;
                        break;
                    }
                    if (newEndNdx != -1) {
                        startEndNdxs[1] = newEndNdx + 1;
                    }
                    if (startEndNdxs[0] > -1) {
                        postcodeFromInput = input.substring(startEndNdxs[0], startEndNdxs[1]).trim();
                        if (postcodeFromInput.length() < 3 || postcodeFromInput.length() == 4 && postcodeFromInput.charAt(1) == ' ') {
                            postcodeFromInput = null;
                        } else {
                            input.replace(startEndNdxs[0], startEndNdxs[1], " ");
                        }
                    }
                }
            }
        }
        return postcodeFromInput;
    }

    private String parseUKPostcode(String str, int[] startEndNdxs) {
        Matcher m = m_pcPattern.matcher(str);
        int startNdx = -1;
        int endNdx = -1;
        while (m.find()) {
            startNdx = m.start();
            endNdx = m.end();
        }
        if (startNdx > -1) {
            String pc = str.substring(startNdx, endNdx);
            if (startEndNdxs != null && startEndNdxs.length > 1) {
                startEndNdxs[0] = startNdx;
                startEndNdxs[1] = endNdx;
            }
            return pc;
        }
        return null;
    }

    private boolean samePC(String orig, String AdustedPC) {
        String AdjustedNoSpaces;
        String origNoSpaces;
        if (orig.equalsIgnoreCase(AdustedPC)) {
            return true;
        }
        return orig.length() != AdustedPC.length() && (origNoSpaces = orig.replaceAll(" ", "")).equalsIgnoreCase(AdjustedNoSpaces = AdustedPC.replaceAll(" ", ""));
    }

    public Matcher testForPOBoxPattern(String str) {
        Matcher m = m_poBoxPattern.matcher(str);
        boolean foundBox = m.find();
        if (!foundBox && (foundBox = (m = m_poMissingBoxPattern.matcher(str)).find()) && m_portsmouthPostcodePattern.matcher(str).matches()) {
            foundBox = false;
        }
        if (foundBox && StringUtilities.hasNumeric((String)m.group("POBoxNum"))) {
            return m;
        }
        return null;
    }

    static {
        m_pcDistrictPattern = Pattern.compile("\\b[A-Z]\\s*[A-Z]?\\s*(\\d{1}\\s*[A-Z]\\b|\\d{1,2})", 2);
        m_pcUnitPattern = Pattern.compile("(\\d{1}[\\w&&[\\D]]{2})", 2);
        m_portsmouthPostcodePattern = Pattern.compile(".*\\bPO\\d\\s*\\d(\\D\\D)?\\b.*", 2);
        m_ambiguousPoBoxPattern = Pattern.compile("P\\s*(O|B)\\s*\\d+");
        m_poMissingBoxPattern = Pattern.compile("(\\b(P|POST)\\s*[.,]?\\s*(OFFICE|OB|O|B)\\.?\\s*(NUMBER|NO|#)?\\.*\\s*(?<POBoxNum>([\\dA-Z]{1,6}))\\b)", 2);
        m_poBoxPattern = Pattern.compile("(\\b[P]?\\s*[.,]?\\s*(OST)?\\.*\\s*[.,]?\\s*(OFFICE|O)?\\s*(BOX|BAG)\\.*\\s*\\.*(NUMBER|NO|#)?\\.*\\s*(?<POBoxNum>([\\dA-Z]){1,6})\\b)", 2);
    }
}

