/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.HKG.parser;

import com.mapinfo.mapmarker.HKG.HKG_Utils;
import com.mapinfo.mapmarker.HKG.address.HKG_ParsedAddress;
import com.mapinfo.mapmarker.cgge.address.AddressNumber;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.CodedWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InputAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.parser.CGGEParser1;
import com.mapinfo.mapmarker.cgge.parser.ICGGEParserTerms;
import com.mapinfo.mapmarker.cgge.scorer.ICGGEScorer;
import com.mapinfo.mapmarker.cgge.soundex.ICGGESoundex;
import com.mapinfo.mapmarker.cgge.utils.IntArray;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HKG_ZH_Parser
extends CGGEParser1 {
    public static final char SPECIAL_SPACE = '\u3000';
    public static final String SPECIAL_SPACE_STRING = Character.toString('\u3000');
    private static final String HONG_KONG = "\u68e3\u6b10\u8150";
    private static final String HONG_KONG_ALT = "\u9999\u6e2f";
    private static final char POSTTYPE_ROAD = '\u8def';
    private static final String HKG_NUMERIC_STREET_END = "D223";
    private static final char NUMBER_IDENTIFIER = '\u53f7';
    private static final char NUMBER_IDENTIFIER2 = '\u865f';
    private static String localHnrPatternString = "[A-Z]{1}\\d*|\\d+([A-Z])?((-|\\\\|/|,)(\\d+)?([A-Z])*)?";
    private static Pattern localHnrPattern = Pattern.compile(localHnrPatternString, 2);
    private static String HnrPatternString = "\\b\\d+[A-Z]{1}\\d+|\\b[A-Z]{1}\\d{1}[A-Z]{1}|\\b[A-Z]{1}\\d*\\b|\\b\\d+([A-Z]\\b)?((-|\\\\|/|,)(\\d+)?([A-Z]\\b)?)?";
    private static Pattern HnrPattern = Pattern.compile(HnrPatternString, 2);
    private static Set NUMBER_IDENTIFIER_SET = new HashSet();

    @Override
    public ParsedAddress[] parse(InputAddress inputAddress, ICGGEScorer scorer) {
        if (!HKG_Utils.isChineseLangAddress(inputAddress)) {
            ParsedAddress[] paArray = new ParsedAddress[]{new ParsedAddress(null, null)};
            return paArray;
        }
        if (inputAddress.getField(FieldType.GENERIC_FIELD_3_FIELD_TYPE) != null) {
            inputAddress.setField(FieldType.STREET_NAME_FIELD_TYPE, inputAddress.getField(FieldType.GENERIC_FIELD_3_FIELD_TYPE));
        }
        String origPostAddresswords = (String)inputAddress.getField(FieldType.POST_ADDRESS_FIELD_TYPE);
        String origStreetFieldWords = (String)inputAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
        boolean SingleLine = false;
        if (origStreetFieldWords != null && origPostAddresswords == null && inputAddress.getField(FieldType.AREA_NAME_1_FIELD_TYPE) == null && inputAddress.getField(FieldType.AREA_NAME_2_FIELD_TYPE) == null && inputAddress.getField(FieldType.AREA_NAME_3_FIELD_TYPE) == null && inputAddress.getField(FieldType.AREA_NAME_4_FIELD_TYPE) == null && inputAddress.getField(FieldType.POST_CODE_FIELD_TYPE) == null) {
            SingleLine = true;
        }
        if (origPostAddresswords != null) {
            this.separateHongKong(inputAddress, origPostAddresswords);
        }
        if (origStreetFieldWords != null) {
            this.separateHongKong(inputAddress, origStreetFieldWords);
            this.separateHouse(inputAddress);
            if (inputAddress.getField(FieldType.GENERIC_FIELD_3_FIELD_TYPE) == null) {
                inputAddress.setField(FieldType.GENERIC_FIELD_3_FIELD_TYPE, origStreetFieldWords);
            }
        }
        ParsedAddress[] parsedAddresses = super.parse(inputAddress, scorer);
        HKG_ParsedAddress hkg_parsedAddress = new HKG_ParsedAddress("CHN", "zh");
        hkg_parsedAddress.copy(parsedAddresses[0]);
        parsedAddresses[0] = hkg_parsedAddress;
        if (SingleLine) {
            this.generateAltParsings(parsedAddresses[0]);
        }
        return parsedAddresses;
    }

    @Override
    protected List<AddressNumber> findProbableAddressNumbers(AddressWord[] words, IntArray ignoreWordNdxs) {
        List<AddressNumber> probableList = super.findProbableAddressNumbers(words, ignoreWordNdxs);
        AddressWord wordLast = words[words.length - 1];
        String wordLastStr = wordLast.getWord();
        int wordLastLen = wordLast.getWordLength();
        if (words.length > 1 && probableList != null) {
            AddressWord wordNextToLast = words[words.length - 2];
            if (words != null && words.length > 1 && CodedWord.isNumber(wordLast.getAttributes()) && !Character.isDigit(wordNextToLast.getWord().charAt(0)) && Character.isDigit(wordNextToLast.getWord().charAt(wordNextToLast.getWord().length() - 1))) {
                while (probableList.size() > 1) {
                    probableList.remove(0);
                }
            }
        }
        return probableList;
    }

    @Override
    protected String cleanString(String str) {
        ICGGEParserTerms parserTerms = this.getParserTerms();
        str = this.getUpperCase(str);
        if ((str = this.cleanStringLoc(str)) != null && !parserTerms.isDelimiter(str)) {
            char[] originalCharacters = str.trim().toCharArray();
            char[] newCharacters = new char[originalCharacters.length];
            int insertNdx = -1;
            for (int i = 0; i < originalCharacters.length; ++i) {
                ++insertNdx;
                if (!(!Character.isWhitespace(originalCharacters[i]) || Character.isLetterOrDigit(originalCharacters[i - 1]) && (Character.isLetterOrDigit(originalCharacters[i + 1]) || HKG_Utils.isChineseCharacter(originalCharacters[i + 1])) || Character.isWhitespace(originalCharacters[i - 1]) || '&' == originalCharacters[i - 1])) {
                    --insertNdx;
                    continue;
                }
                newCharacters[insertNdx] = originalCharacters[i];
            }
            return new String(newCharacters).trim();
        }
        return null;
    }

    private String cleanStringLoc(String str) {
        String cleaned = HKG_Utils.zhTrim(str);
        if (cleaned != null) {
            cleaned = cleaned.replaceAll("--", "-");
            cleaned = cleaned.replaceAll("\"", "");
        }
        return cleaned;
    }

    protected void separateHongKong(InputAddress inputAddress, String origStreetWords) {
        if (inputAddress == null || StringUtilities.isEmpty((String)origStreetWords)) {
            return;
        }
        int pos = origStreetWords.indexOf(HONG_KONG);
        if (pos > -1) {
            int hkEnd = pos + 3;
            StringBuilder newInMain = new StringBuilder(origStreetWords.substring(0, hkEnd));
            newInMain.append(" " + origStreetWords.substring(hkEnd));
            inputAddress.setField(FieldType.STREET_NAME_FIELD_TYPE, newInMain.toString());
        }
    }

    protected void separateHouse(InputAddress inputAddress) {
        Matcher m;
        int specPos;
        if (inputAddress.getField(FieldType.ADDRESS_NUMBER_FIELD_TYPE) != null) {
            return;
        }
        String curStreetWords = (String)inputAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
        if (StringUtilities.isEmpty((String)(curStreetWords = this.cleanString(curStreetWords)))) {
            return;
        }
        Matcher m1 = HnrPattern.matcher(curStreetWords);
        String foundFromMainPattern = null;
        if (m1 != null && m1.find()) {
            int start = m1.start();
            int end = m1.end();
            foundFromMainPattern = curStreetWords.substring(start, end);
            boolean okayToReturn = true;
            int ampersandPos = curStreetWords.indexOf("&");
            if (ampersandPos < start && ampersandPos >= start - 2) {
                okayToReturn = false;
            }
            if (okayToReturn && start > 0 && curStreetWords.charAt(start - 1) != '-' && !foundFromMainPattern.startsWith(HKG_NUMERIC_STREET_END) || foundFromMainPattern.equalsIgnoreCase(HKG_NUMERIC_STREET_END)) {
                return;
            }
        }
        if ((specPos = curStreetWords.indexOf(HKG_NUMERIC_STREET_END)) > 0 && specPos + 4 < curStreetWords.length() && curStreetWords.charAt(specPos + 4) != ' ') {
            StringBuilder newbuf = new StringBuilder();
            newbuf.append(curStreetWords.substring(0, specPos + 4));
            newbuf.append(" ");
            newbuf.append(curStreetWords.substring(specPos + 4));
            inputAddress.setField(FieldType.STREET_NAME_FIELD_TYPE, newbuf.toString());
            curStreetWords = (String)inputAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
        }
        if ((m = localHnrPattern.matcher(curStreetWords)) != null) {
            while (m.find()) {
                int end;
                boolean skip = false;
                int start = m.start();
                String found = curStreetWords.substring(start, end = m.end());
                if (found.length() == 1 && Character.isLetter(found.charAt(0)) && end < curStreetWords.length() && HKG_Utils.isChineseCharacter(curStreetWords.charAt(end))) {
                    skip = true;
                }
                if (!skip && start > 0 && this.isaBlank(curStreetWords.charAt(start - 1))) {
                    return;
                }
                if (!this.okayToSeparate(curStreetWords, found, start, end)) continue;
                StringBuilder newbuf2 = new StringBuilder();
                newbuf2.append(curStreetWords.substring(0, start));
                newbuf2.append(" ");
                newbuf2.append(curStreetWords.substring(start));
                inputAddress.setField(FieldType.STREET_NAME_FIELD_TYPE, newbuf2.toString());
                if (!this.shouldBreakNow(curStreetWords, found, end)) continue;
                break;
            }
        }
    }

    private boolean shouldBreakNow(String curWords, String hnstr, int end) {
        if (end < curWords.length() && this.isAlphaNum(hnstr) && Character.isLetter(hnstr.charAt(0)) && Character.isLetter(curWords.charAt(end))) {
            return true;
        }
        return this.isAlphaNum(hnstr) && Character.isDigit(hnstr.charAt(0)) && end < curWords.length() && Character.isLetter(curWords.charAt(end)) && !HKG_Utils.isChineseCharacter(curWords.charAt(end));
    }

    private boolean okayToSeparate(String curWords, String possHn, int start, int end) {
        boolean goodNumIDCondition;
        if (possHn == null || start == 0) {
            return false;
        }
        if (possHn.length() > 1 && possHn.startsWith("L")) {
            return false;
        }
        if (this.isaBlank(curWords.charAt(start - 1))) {
            return false;
        }
        if (this.isaBlank(curWords.charAt(start - 1)) || this.isaBlank(curWords.charAt(end - 1))) {
            return false;
        }
        if (possHn.length() == 1 && Character.isLetter(possHn.charAt(0)) && start - 2 >= 0 && this.isaBlank(curWords.charAt(start - 1)) && this.isEnglishLetter(curWords.charAt(start - 2))) {
            return false;
        }
        if (possHn.length() == 1 && Character.isLetter(possHn.charAt(0)) && this.isEnglishLetter(curWords.charAt(start - 1))) {
            return false;
        }
        if (StringUtilities.isNumeric((String)possHn) && this.isEnglishLetter(curWords.charAt(start - 1)) && start - 2 >= 0 && Character.isDigit(curWords.charAt(start - 2))) {
            return false;
        }
        boolean bl = goodNumIDCondition = end < curWords.length() && (!NUMBER_IDENTIFIER_SET.contains(Character.valueOf(curWords.charAt(end))) || end + 1 < curWords.length() && HKG_Utils.isChineseCharacter(curWords.charAt(end)) && NUMBER_IDENTIFIER_SET.contains(Character.valueOf(curWords.charAt(end))) && (HKG_Utils.isChineseCharacter(curWords.charAt(end + 1)) || Character.isDigit(curWords.charAt(end + 1))));
        return end >= curWords.length() || !HKG_Utils.isChineseCharacter(curWords.charAt(start - 1)) || !HKG_Utils.isChineseCharacter(curWords.charAt(end)) || curWords.charAt(start - 1) == '\u8def' || !goodNumIDCondition;
    }

    private boolean isaBlank(char ch) {
        return ch == ' ' || ch == '\u3000';
    }

    private boolean isEnglishLetter(char ch) {
        return Character.isLetter(ch) && !HKG_Utils.isChineseCharacter(ch);
    }

    protected void generateAltParsings(ParsedAddress parsed) {
        int startidx;
        CodedWord cw;
        int soundex;
        ICGGESoundex altSoundex = this.getSoundex();
        int soundexFirst = -1;
        int soundexOther = -1;
        AddressWord wordFirst = null;
        AddressWord wordOther = null;
        int origHnrPos = -1;
        HKG_ParsedAddress hkgParsed = (HKG_ParsedAddress)parsed;
        AddressWord[] streetWords = (AddressWord[])hkgParsed.getField(FieldType.STREET_NAME_FIELD_TYPE);
        if (streetWords == null || streetWords.length == 0) {
            return;
        }
        int numWords = streetWords.length;
        int wordIdx = numWords - 1;
        ArrayList<AddressWord> numericList = new ArrayList<AddressWord>();
        ArrayList<AddressWord> numericList2 = new ArrayList<AddressWord>();
        ArrayList<AddressWord> otherList = new ArrayList<AddressWord>();
        if (numWords > 3 && streetWords[numWords - 2].getWord().equalsIgnoreCase("-") && StringUtilities.hasNumeric((String)streetWords[wordIdx].getWord()) && StringUtilities.hasNumeric((String)streetWords[numWords - 3].getWord())) {
            wordIdx = numWords - 4;
            for (int i = numWords - 1; i > wordIdx; --i) {
                numericList.add(streetWords[i]);
            }
            Collections.reverse(numericList);
        }
        boolean done = false;
        while (!done && StringUtilities.isNumeric((String)streetWords[wordIdx].getWord()) || streetWords[wordIdx].getWord().length() == 1 || this.isAlphaNum(streetWords[wordIdx].getWord())) {
            numericList2.add(streetWords[wordIdx]);
            if (streetWords[wordIdx].getWord().equals(")")) {
                for (int ii = wordIdx - 1; ii >= 0; --ii) {
                    numericList2.add(streetWords[ii]);
                    if (!streetWords[ii].getWord().equals("(")) continue;
                    wordIdx = ii;
                    done = true;
                    break;
                }
            }
            --wordIdx;
        }
        if (numericList2.size() > 0) {
            Collections.reverse(numericList2);
        }
        String wordToSplit = streetWords[wordIdx].getWord();
        AddressWord savedWordWithNumeric = null;
        AddressWord savedWordWithNumeric2 = null;
        int wordLen = wordToSplit.length();
        if (wordLen <= 5 && StringUtilities.hasNumeric((String)wordToSplit) && wordIdx - 1 >= 0) {
            soundex = altSoundex.getSoundex(wordToSplit);
            cw = new CodedWord(wordToSplit, soundex, -1);
            savedWordWithNumeric = new AddressWord(cw);
            wordToSplit = streetWords[--wordIdx].getWord();
            wordLen = wordToSplit.length();
        }
        if (wordLen < 4 && wordIdx == 0) {
            return;
        }
        if (wordLen <= 5 && Character.isDigit(wordToSplit.charAt(wordLen - 1)) && streetWords.length - 1 > wordIdx - 1 && wordIdx - 1 >= 0) {
            soundex = altSoundex.getSoundex(wordToSplit);
            cw = new CodedWord(wordToSplit, soundex, -1);
            savedWordWithNumeric2 = new AddressWord(cw);
            wordToSplit = streetWords[--wordIdx].getWord();
            wordLen = wordToSplit.length();
        }
        int origStartIdx = startidx = wordLen - 2;
        while (startidx > 1 && Character.isDigit(wordToSplit.charAt(startidx))) {
            --startidx;
        }
        Object possibleHN = null;
        Object possibleHNWord = null;
        boolean considerpossibleHNAttachedToStreet = false;
        for (int j = wordIdx - 1; j >= 0; --j) {
            otherList.add(streetWords[j]);
        }
        if (otherList.size() > 1) {
            Collections.reverse(otherList);
        }
        while (startidx > 1) {
            ArrayList<AddressWord> tempList = new ArrayList<AddressWord>();
            String street = wordToSplit.substring(startidx);
            String AN4 = wordToSplit.substring(0, startidx);
            soundexFirst = altSoundex.getSoundex(street);
            CodedWord cwFirst = new CodedWord(street, soundexFirst, -1);
            wordFirst = new AddressWord(cwFirst);
            soundexOther = altSoundex.getSoundex(AN4);
            CodedWord cwOther = new CodedWord(AN4, soundexOther, -1);
            wordOther = new AddressWord(cwOther);
            if (otherList.size() > 0) {
                tempList.addAll(otherList);
            }
            tempList.add(wordOther);
            tempList.add(wordFirst);
            if (savedWordWithNumeric != null) {
                tempList.add(savedWordWithNumeric);
            }
            if (savedWordWithNumeric2 != null) {
                tempList.add(savedWordWithNumeric2);
            }
            tempList.addAll(numericList2);
            tempList.addAll(numericList);
            hkgParsed.getAltParsings().add(tempList.toArray(new AddressWord[tempList.size()]));
            --startidx;
        }
    }

    private boolean isAlphaNum(String wordStr) {
        boolean foundAlpha = false;
        boolean foundDigit = false;
        if (wordStr != null && wordStr.length() > 1 && wordStr.length() < 5) {
            int len = wordStr.length();
            for (int i = 0; i < len; ++i) {
                if (!foundAlpha && this.isEnglishLetter(wordStr.charAt(i))) {
                    foundAlpha = true;
                } else if (!foundDigit && Character.isDigit(wordStr.charAt(i))) {
                    foundDigit = true;
                }
                if (!foundAlpha || !foundDigit) continue;
                return true;
            }
        }
        return false;
    }

    static {
        NUMBER_IDENTIFIER_SET.add(Character.valueOf('\u53f7'));
        NUMBER_IDENTIFIER_SET.add(Character.valueOf('\u865f'));
        NUMBER_IDENTIFIER_SET = Collections.unmodifiableSet(NUMBER_IDENTIFIER_SET);
    }
}

