/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.IND.dp.binary.reader;

import com.mapinfo.mapmarker.cgge.address.AddressFieldValue;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.RawAddress;
import com.mapinfo.mapmarker.cgge.dp.builder.reader.TAB_Reader;
import com.mapinfo.mapmarker.cgge.dp.builder.reader.TAB_RecordAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class IND_TABReader
extends TAB_Reader {
    private Map<String, String> m_sacMap = new HashMap<String, String>(1000);
    private int m_nextSAC = 1000;
    private boolean m_overrideSAC = false;
    private boolean m_isGeoTable = false;

    @Override
    public RawAddress getNextRecord() {
        RawAddress addr = super.getNextRecord();
        if ((this.m_overrideSAC || this.m_isGeoTable) && addr != null) {
            addr.setSac(this.buildSAC(addr));
        }
        return addr;
    }

    @Override
    public boolean loadData(Properties prop) throws Exception {
        if (super.loadData(prop)) {
            if ("POI".equalsIgnoreCase((String)prop.get("dataName"))) {
                this.m_overrideSAC = true;
            } else if ("Geo".equalsIgnoreCase((String)prop.get("dataName"))) {
                this.m_isGeoTable = true;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isSacFromFile() {
        if (this.m_overrideSAC) {
            return true;
        }
        return super.isSacFromFile();
    }

    private String buildSAC(RawAddress addr) {
        String sacString = this.buildSACString(addr);
        String sac = this.m_sacMap.get(sacString);
        if (sac == null) {
            sac = "" + new Integer(++this.m_nextSAC);
            this.m_sacMap.put(sacString, sac);
        }
        return sac;
    }

    private String buildSACString(RawAddress addr) {
        StringBuilder sb = new StringBuilder(20);
        String pc = this.getFieldValue(addr, FieldType.POST_CODE_FIELD_TYPE);
        sb.append(pc.length() > 5 ? pc.substring(0, 5) : pc);
        sb.append(this.getFieldValue(addr, FieldType.AREA_NAME_3_FIELD_TYPE));
        sb.append(this.getFieldValue(addr, FieldType.AREA_NAME_1_FIELD_TYPE));
        if (this.m_isGeoTable) {
            sb.append(this.getFieldValue(addr, FieldType.AREA_NAME_4_FIELD_TYPE));
        }
        return sb.toString();
    }

    private String getFieldValue(RawAddress addr, FieldType type) {
        String fvStr;
        AddressFieldValue fv = (AddressFieldValue)addr.getField(type);
        String v = "";
        if (fv != null && !fv.isEmpty() && (fvStr = (String)fv.getFieldValue()) != null) {
            v = fvStr;
        }
        return v;
    }

    @Override
    public void handleGenericFieldsLeftAddress(TAB_RecordAddress leftAddress) {
        super.handleGenericFieldsLeftAddress(leftAddress);
        if ("Street".equals(this.dataName) || "POI".equals(this.dataName)) {
            this.setAddressField(leftAddress, KEY_GENERIC_FIELD3_COL_NAME, FieldType.GENERIC_FIELD_3_FIELD_TYPE);
            leftAddress.setField(FieldType.GENERIC_FIELD_4_FIELD_TYPE, new AddressFieldValue(null));
        }
    }

    @Override
    public void handleGenericFieldsRightAddress(TAB_RecordAddress rightAddress) {
        super.handleGenericFieldsRightAddress(rightAddress);
        if ("Street".equals(this.dataName) || "POI".equals(this.dataName)) {
            this.setAddressField(rightAddress, KEY_GENERIC_FIELD4_COL_NAME, FieldType.GENERIC_FIELD_3_FIELD_TYPE);
            rightAddress.setField(FieldType.GENERIC_FIELD_4_FIELD_TYPE, new AddressFieldValue(null));
        }
    }

    @Override
    protected void populateAlternateGenericFields(RawAddress leftAddr, RawAddress rightAddr) {
        AddressFieldValue temp = null;
        super.populateAlternateGenericFields(leftAddr, rightAddr);
        if ("Street".equals(this.dataName) || "POI".equals(this.dataName)) {
            String str = this.m_properties.getProperty(KEY_ALT_GENERIC_FIELD3_COL_NAME);
            if (!this.isEmpty(str)) {
                temp = (AddressFieldValue)leftAddr.getField(FieldType.GENERIC_FIELD_3_FIELD_TYPE);
                temp.setAlternateValues(this.getAlternates(str));
            }
            if (!this.isEmpty(str = this.m_properties.getProperty(KEY_ALT_GENERIC_FIELD4_COL_NAME))) {
                temp = (AddressFieldValue)rightAddr.getField(FieldType.GENERIC_FIELD_3_FIELD_TYPE);
                temp.setAlternateValues(this.getAlternates(str));
            }
        }
    }

    @Override
    protected boolean considerRightAddress(TAB_RecordAddress left, TAB_RecordAddress right) {
        boolean isRightAddress = super.considerRightAddress(left, right);
        if (!isRightAddress && !this.bothValuesSame((AddressFieldValue)left.getField(FieldType.GENERIC_FIELD_3_FIELD_TYPE), (AddressFieldValue)right.getField(FieldType.GENERIC_FIELD_3_FIELD_TYPE))) {
            return true;
        }
        return isRightAddress;
    }
}

