/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.IND.helper;

import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.IND.address.IND_ParsedAddress;
import com.mapinfo.mapmarker.IND.dp.binary.DataSetUtils;
import com.mapinfo.mapmarker.IND.matcher.IND_Matcher1;
import com.mapinfo.mapmarker.IND.parser.IND_Parser1;
import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.CodedWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.dp.DataFetchException;
import com.mapinfo.mapmarker.cgge.dp.DataNotInitialisedException;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAddressWord;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAreaSacs;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAreaTermItem;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.cgge.dp.InternalCandidateList;
import com.mapinfo.mapmarker.cgge.helper.AbstractStreetGeocodingHelper;
import com.mapinfo.mapmarker.cgge.parser.ICGGEParser;
import com.mapinfo.mapmarker.cgge.soundex.ICGGESoundex;
import com.mapinfo.mapmarker.cgge.utils.CharArray;
import com.mapinfo.mapmarker.cgge.utils.ListUtils;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class INDStreetGeocodingHelper
extends AbstractStreetGeocodingHelper {
    public static final FieldType STATE_FIELD = FieldType.AREA_NAME_1_FIELD_TYPE;
    public static final FieldType DISTRICT_FIELD = FieldType.AREA_NAME_2_FIELD_TYPE;
    public static final FieldType CITY_FIELD = FieldType.AREA_NAME_3_FIELD_TYPE;
    public static final FieldType LOCALITY_FIELD = FieldType.AREA_NAME_4_FIELD_TYPE;
    private static final FieldType STREET_FIELD = FieldType.STREET_NAME_FIELD_TYPE;
    private static final FieldType PLACE_FIELD = FieldType.PLACE_NAME_FIELD_TYPE;
    private static final FieldType PC_FIELD = FieldType.POST_CODE_FIELD_TYPE;
    private static final FieldType GENERIC_FIELD2 = FieldType.GENERIC_FIELD_2_FIELD_TYPE;
    public static final String MATCHABLE_LOCALITY_FOUND = "matchable_locality_found";
    public static final String MATCHABLE_STATE_FOUND = "matchable_state_found";
    public static final String STATE_NAME = "state_name";
    public static final String NUMERIC_STREET_CASE = "NUMERIC_STREET_CASE";
    public static final String COMMA = ",";
    public static final double MINIMUM_SEARCH_WORD_QUALITY_STREET = 0.9;
    public static final double MINIMUM_SEARCH_WORD_QUALITY_POI = 0.93;
    private Map<String, Map<FieldType, List<DictionaryAreaTermItem>>> m_savedAreas = new HashMap<String, Map<FieldType, List<DictionaryAreaTermItem>>>();
    private AddressWord[] m_areaFilteredSearchWords;
    private Map<String, List<DictionaryAreaTermItem>> cachedAreaWords = new HashMap<String, List<DictionaryAreaTermItem>>();
    private static List<RetryCase> m_caseList;
    private List<RetryCase> m_currentCaseList;
    private RetryCase m_currentCase;
    protected Map<Integer, List<DictionaryAddressWord>> m_streetTryCaseMap;
    private static short KNOWN_WORD_MASK;
    private ParsedAddress m_savedParsedAddress = null;
    private boolean m_resetParsedAddress;

    @Override
    protected boolean generateCases(IDataManager dataManager, ParsedAddress parsedAddr, GeocodeOptions options, InternalCandidateList candidateList) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        IND_ParsedAddress iParsedAddr = (IND_ParsedAddress)parsedAddr;
        if (this.m_currentCaseList == null) {
            this.initSacAndStreetSearchFields(dataManager);
            List<FieldType> searchFields = this.getAddressSearchFields();
            ArrayList<FieldType> subLocalityFields = new ArrayList<FieldType>(3);
            if (searchFields != null) {
                for (FieldType type : searchFields) {
                    if (!DataSetUtils.isSubLocalityField(type)) continue;
                    subLocalityFields.add(type);
                }
            }
            iParsedAddr.setM_subLocalityFields(subLocalityFields);
            this.m_currentCaseList = new ArrayList<RetryCase>(m_caseList);
        }
        boolean isPOICandidateIntended = INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnPOIWithStreet");
        boolean isStreetCandidateIntended = INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnStreetCandidates");
        boolean isSubLocalityCandidateIntended = INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnSubLocalityCandidates");
        while (!this.m_currentCaseList.isEmpty()) {
            RetryCase previousCase = this.m_currentCase;
            this.m_currentCase = this.m_currentCaseList.get(0);
            this.m_areaSubTryCount = this.m_currentCase.m_areaTryCase;
            this.m_streetSubTryCount = this.m_currentCase.m_streetTryCase;
            boolean areaCaseGenerated = true;
            if ("POI".equalsIgnoreCase(this.m_currentCase.m_tryDataSet) && !isPOICandidateIntended || "Street".equalsIgnoreCase(this.m_currentCase.m_tryDataSet) && !isStreetCandidateIntended || "SG".equalsIgnoreCase(this.m_currentCase.m_tryDataSet) && !isSubLocalityCandidateIntended) {
                areaCaseGenerated = false;
                if (0 == this.m_areaSubTryCount && !this.isSameAreaTryAsPrevious(this.m_currentCase, previousCase)) {
                    iParsedAddr.setM_localityList(null);
                    options.remove(MATCHABLE_LOCALITY_FOUND);
                }
            }
            if (areaCaseGenerated && !this.isSameAreaTryAsPrevious(this.m_currentCase, previousCase)) {
                ArrayList<String> dataSetsToUse = new ArrayList<String>(1);
                dataSetsToUse.add(this.m_currentCase.m_tryDataSet);
                options.put("allowed_datasets", dataSetsToUse);
                areaCaseGenerated = this.generateAreaSubTries(dataManager, parsedAddr, options, candidateList);
            }
            this.m_currentCaseList.remove(0);
            if (!areaCaseGenerated || !this.generateStreetSubTries(dataManager, parsedAddr, options, candidateList)) continue;
            return true;
        }
        this.finishRetries();
        return false;
    }

    private boolean isSameAreaTryAsPrevious(RetryCase currentCase, RetryCase previousCase) {
        if (previousCase != null) {
            return previousCase.m_areaTryCase == currentCase.m_areaTryCase && previousCase.m_tryDataSet == currentCase.m_tryDataSet;
        }
        return false;
    }

    @Override
    protected boolean generateStreetSubTries(IDataManager dataManager, ParsedAddress parsedAddr, GeocodeOptions options, InternalCandidateList candidateList) throws CGGEInternalException, DataNotInitialisedException, DataFetchException {
        this.setSearchWordList(null);
        if (this.m_resetParsedAddress) {
            parsedAddr.copy(this.m_savedParsedAddress);
            this.m_resetParsedAddress = false;
        }
        if (parsedAddr.isIntersectionCase()) {
            return this.generateStreetSubTriesForIntersection(dataManager, parsedAddr, options, candidateList);
        }
        AddressWord[] searchWords = (AddressWord[])parsedAddr.getField(STREET_FIELD);
        if (!parsedAddr.isSeperatePostAddressFields()) {
            searchWords = this.m_areaFilteredSearchWords;
        }
        boolean isPOIInInput = ((IND_ParsedAddress)parsedAddr).isPOITypePresent();
        boolean isStreetInInput = ((IND_ParsedAddress)parsedAddr).isStreetTypePresent();
        switch (this.m_streetSubTryCount) {
            case 0: {
                AddressWord[] filteredSearchWords;
                List<DictionaryAddressWord> dictAddressWords;
                ++this.m_streetSubTryCount;
                if (!parsedAddr.isSeperatePostAddressFields() && (dictAddressWords = this.getSearchableWords(filteredSearchWords = this.filterSearchWords(this.getWordsUptoType(searchWords = (AddressWord[])parsedAddr.getField(STREET_FIELD)), true, false, false, 0), dataManager, 1.0, options, PLACE_FIELD, STREET_FIELD)) != null) {
                    this.setSearchWordList(dictAddressWords);
                    return true;
                }
                return false;
            }
            case 1: {
                AddressWord[] filteredSearchWords;
                List<DictionaryAddressWord> dictAddressWords;
                ++this.m_streetSubTryCount;
                if (!parsedAddr.isSeperatePostAddressFields() && (dictAddressWords = this.getSearchableWords(filteredSearchWords = this.filterSearchWords(this.getWordsUptoType(searchWords = (AddressWord[])parsedAddr.getField(STREET_FIELD)), true, false, false, 256), dataManager, 1.0, options, PLACE_FIELD, STREET_FIELD)) != null) {
                    this.setSearchWordList(dictAddressWords);
                    return true;
                }
                return false;
            }
            case 2: {
                AddressWord[] filteredSearchWords;
                List<DictionaryAddressWord> dictAddressWords;
                ++this.m_streetSubTryCount;
                AddressWord[] placeWords = (AddressWord[])parsedAddr.getField(PLACE_FIELD);
                if (placeWords == null && (dictAddressWords = this.getSearchableWords(filteredSearchWords = this.filterSearchWords(searchWords, true, false, false, 0), PLACE_FIELD, dataManager, 1.0, options)) != null) {
                    this.setSearchWordList(dictAddressWords);
                    return true;
                }
                return false;
            }
            case 3: {
                ++this.m_streetSubTryCount;
                AddressWord[] searchWordsForSG = (AddressWord[])parsedAddr.getField(GENERIC_FIELD2);
                if (null == searchWordsForSG) {
                    searchWordsForSG = searchWords;
                }
                AddressWord[] filteredSearchWords = this.filterSearchWords(searchWordsForSG, true, true, false, 1324);
                filteredSearchWords = this.splitAlphaNumericWords(filteredSearchWords);
                List<DictionaryAddressWord> dictAddressWords = this.getSearchableSubLocalityWords(parsedAddr, filteredSearchWords, dataManager, 1.0, options);
                List<DictionaryAddressWord> slDictionarySearchedWord = this.getSearchableSubLocalityWords(parsedAddr, searchWords, dataManager, 1.0, options);
                if (dictAddressWords != null) {
                    if (slDictionarySearchedWord != null) {
                        dictAddressWords.addAll(slDictionarySearchedWord);
                    }
                    this.setSearchWordList(dictAddressWords);
                    return true;
                }
                return false;
            }
            case 4: {
                List<DictionaryAddressWord> dictAddressWords;
                ++this.m_streetSubTryCount;
                if (!parsedAddr.isSeperatePostAddressFields() && (dictAddressWords = this.getSearchableWords(searchWords = (AddressWord[])parsedAddr.getField(STREET_FIELD), dataManager, 1.0, options, PLACE_FIELD, STREET_FIELD)) != null) {
                    this.setSearchWordList(dictAddressWords);
                    return true;
                }
                return false;
            }
            case 5: {
                AddressWord[] filteredSearchWords;
                List<DictionaryAddressWord> dictAddressWords;
                ++this.m_streetSubTryCount;
                AddressWord[] searchLocalityWords = null;
                searchLocalityWords = parsedAddr.isSeparateAreaFields() ? (AddressWord[])parsedAddr.getField(LOCALITY_FIELD) : (AddressWord[])parsedAddr.getField(STREET_FIELD);
                if (searchLocalityWords != null && (dictAddressWords = this.getSearchableWords(filteredSearchWords = this.filterSearchWords(searchLocalityWords, true, false, false, 0), LOCALITY_FIELD, dataManager, 1.0, options)) != null) {
                    this.setSearchWordList(dictAddressWords);
                    return true;
                }
                return false;
            }
            case 6: {
                AddressWord[] filteredSearchWords;
                List<DictionaryAddressWord> dictAddressWords;
                AddressWord[] placeWords;
                ++this.m_streetSubTryCount;
                if (isPOIInInput && (placeWords = (AddressWord[])parsedAddr.getField(PLACE_FIELD)) != null && (dictAddressWords = this.getSearchableWords(filteredSearchWords = this.filterSearchWords(placeWords, true, false, false, 0), PLACE_FIELD, dataManager, 1.0, options)) != null) {
                    this.setSearchWordList(dictAddressWords);
                    return true;
                }
                return false;
            }
            case 7: {
                AddressWord[] filteredSearchWords;
                List<DictionaryAddressWord> dictAddressWords;
                AddressWord[] placeWords;
                ++this.m_streetSubTryCount;
                if (isPOIInInput && (placeWords = (AddressWord[])parsedAddr.getField(PLACE_FIELD)) != null && (dictAddressWords = this.getSearchableWords(filteredSearchWords = this.filterSearchWords(placeWords, false, false, true, 260), PLACE_FIELD, dataManager, 1.0, options)) != null) {
                    this.setSearchWordList(dictAddressWords);
                    return true;
                }
                return false;
            }
            case 8: {
                AddressWord[] combinedStreetSearchWords;
                AddressWord[] filteredSearchWords;
                List<DictionaryAddressWord> dictAddressWords;
                ++this.m_streetSubTryCount;
                if (isStreetInInput && !parsedAddr.isSeperatePostAddressFields() && (dictAddressWords = this.getSearchableWords(filteredSearchWords = this.filterSearchWords(this.getWordsUptoType(searchWords = (combinedStreetSearchWords = this.getCombinedPossibles((AddressWord[])parsedAddr.getField(FieldType.GENERIC_FIELD_4_FIELD_TYPE))) != null ? combinedStreetSearchWords : (AddressWord[])parsedAddr.getField(STREET_FIELD)), true, false, false, 0), STREET_FIELD, dataManager, 1.0, options)) != null) {
                    this.setSearchWordList(dictAddressWords);
                    return true;
                }
                return false;
            }
            case 9: {
                AddressWord[] filteredSearchWords;
                List<DictionaryAddressWord> dictAddressWords;
                ++this.m_streetSubTryCount;
                if (isStreetInInput && (dictAddressWords = this.getSearchableWords(filteredSearchWords = this.filterSearchWords(searchWords, true, false, false, 0), STREET_FIELD, dataManager, 1.0, options)) != null) {
                    this.setSearchWordList(dictAddressWords);
                    return true;
                }
                return false;
            }
            case 10: {
                ++this.m_streetSubTryCount;
                if (isStreetInInput) {
                    List<DictionaryAddressWord> dictAddressWords;
                    AddressWord[] filteredSearchWords = searchWords;
                    if (this.m_areaSubTryCount < 1) {
                        filteredSearchWords = this.splitNumericWords(filteredSearchWords);
                    }
                    if ((dictAddressWords = this.getSearchableWords(filteredSearchWords = this.filterSearchWords(filteredSearchWords, false, false, false, 44), STREET_FIELD, dataManager, 1.0, options)) != null) {
                        this.setSearchWordList(dictAddressWords);
                        options.setProperty(NUMERIC_STREET_CASE, "true");
                        return true;
                    }
                }
                return false;
            }
            case 11: {
                AddressWord[] filteredSearchWords;
                List<DictionaryAddressWord> dictAddressWords;
                options.remove(NUMERIC_STREET_CASE);
                ++this.m_streetSubTryCount;
                if (isStreetInInput && (dictAddressWords = this.getSearchableWords(filteredSearchWords = this.filterSearchWords(searchWords, false, false, false, 256), STREET_FIELD, dataManager, 1.0, options)) != null) {
                    this.setSearchWordList(dictAddressWords);
                    return true;
                }
                return false;
            }
            case 12: {
                AddressWord[] filteredSearchWords;
                List<DictionaryAddressWord> dictAddressWords;
                AddressWord[] placeWords;
                ++this.m_streetSubTryCount;
                if (isPOIInInput && (placeWords = (AddressWord[])parsedAddr.getField(PLACE_FIELD)) == null && (dictAddressWords = this.getSearchableWords(filteredSearchWords = this.filterSearchWords(searchWords, true, false, false, 0), PLACE_FIELD, dataManager, 1.0, options)) != null) {
                    this.setSearchWordList(dictAddressWords);
                    return true;
                }
                return false;
            }
            case 13: {
                AddressWord[] filteredSearchWords;
                List<DictionaryAddressWord> dictAddressWords;
                AddressWord[] placeWords;
                ++this.m_streetSubTryCount;
                if (isPOIInInput && (placeWords = (AddressWord[])parsedAddr.getField(PLACE_FIELD)) == null && (dictAddressWords = this.getSearchableWords(filteredSearchWords = this.filterSearchWords(searchWords, true, false, false, 256), PLACE_FIELD, dataManager, 1.0, options)) != null) {
                    this.setSearchWordList(dictAddressWords);
                    return true;
                }
                return false;
            }
            case 14: {
                ++this.m_streetSubTryCount;
                AddressWord[] filteredSearchWords = this.filterSearchWords(searchWords, true, true, false, 0);
                List<DictionaryAddressWord> dictAddressWords = this.getSearchableWords(filteredSearchWords, STREET_FIELD, dataManager, 0.9, options);
                dictAddressWords = this.removeNumericDictWords(dictAddressWords);
                if (dictAddressWords != null) {
                    this.setSearchWordList(dictAddressWords);
                    return true;
                }
                return false;
            }
            case 15: {
                ++this.m_streetSubTryCount;
                AddressWord[] placeWords = (AddressWord[])parsedAddr.getField(PLACE_FIELD);
                AddressWord[] filteredSearchWords = this.filterSearchWords(placeWords != null ? placeWords : searchWords, true, false, false, 0);
                double minSearchQuality = this.m_areaSubTryCount <= 1 ? this.getMinimumSearchWordQuality() : 0.93;
                List<DictionaryAddressWord> dictAddressWords = this.getSearchableWords(filteredSearchWords, PLACE_FIELD, dataManager, minSearchQuality, options);
                dictAddressWords = this.removeNumericDictWords(dictAddressWords);
                dictAddressWords = this.removeDictWordsFetchedOnInvalidSearchWords(dictAddressWords);
                if (dictAddressWords != null) {
                    this.setSearchWordList(dictAddressWords);
                    return true;
                }
                return false;
            }
            case 16: {
                ++this.m_streetSubTryCount;
                AddressWord[] searchWordsForSG = (AddressWord[])parsedAddr.getField(GENERIC_FIELD2);
                AddressWord[] filteredSearchWords = this.filterSearchWords(searchWordsForSG, true, true, false, 1324);
                filteredSearchWords = this.splitAlphaNumericWords(filteredSearchWords);
                List<DictionaryAddressWord> dictAddressWords = this.getSearchableSubLocalityWords(parsedAddr, filteredSearchWords, dataManager, 1.0, options);
                if (dictAddressWords != null) {
                    this.setSearchWordList(dictAddressWords);
                    return true;
                }
                return false;
            }
            case 17: {
                ++this.m_streetSubTryCount;
                IND_Parser1 parser = (IND_Parser1)this.getHandler().getParser();
                String probableLocality = this.getStringFromAddressWordArray((AddressWord[])parsedAddr.getField(FieldType.STREET_NAME_FIELD_TYPE));
                String probableSL = parser.getListOfProbableSubLocalities(probableLocality);
                StringBuilder builder = new StringBuilder();
                if (probableSL != null) {
                    builder.append(probableSL);
                    builder.append(" ");
                    builder.append(this.getStringFromAddressWordArray((AddressWord[])parsedAddr.getField(GENERIC_FIELD2)));
                }
                AddressWord[] searchWordsForSG = parser.getAddressWords(builder.toString().trim());
                AddressWord[] filteredSearchWords = this.filterSearchWords(searchWordsForSG, true, true, false, 1324);
                List<DictionaryAddressWord> dictAddressWords = this.getSearchableSubLocalityWords(parsedAddr, filteredSearchWords = this.splitAlphaNumericWords(filteredSearchWords), dataManager, 1.0, options);
                if (dictAddressWords != null) {
                    this.setSearchWordList(dictAddressWords);
                    this.m_savedParsedAddress = new ParsedAddress(parsedAddr.getCountry(), parsedAddr.getLanguage());
                    this.m_savedParsedAddress.copy(parsedAddr);
                    String inputString = (String)parsedAddr.getInputAddress().getField(FieldType.STREET_NAME_FIELD_TYPE);
                    builder.append(" ");
                    builder.append(inputString);
                    parsedAddr.setField(FieldType.STREET_NAME_FIELD_TYPE, parser.getAddressWords(builder.toString()));
                    this.m_resetParsedAddress = true;
                    return true;
                }
                return false;
            }
            case 18: {
                ++this.m_streetSubTryCount;
                AddressWord[] searchLocalityWords = null;
                searchLocalityWords = parsedAddr.isSeparateAreaFields() ? (AddressWord[])parsedAddr.getField(LOCALITY_FIELD) : (parsedAddr.isSeperatePostAddressFields() ? (AddressWord[])parsedAddr.getField(FieldType.POST_ADDRESS_FIELD_TYPE) : searchWords);
                if (searchLocalityWords != null) {
                    AddressWord[] filteredSearchWords = this.filterSearchWords(searchLocalityWords, true, false, false, 256);
                    filteredSearchWords = this.filterWithParsedSubLocalityField(filteredSearchWords, parsedAddr);
                    List<DictionaryAddressWord> dictAddressWords = this.getSearchableSubLocalityWords(parsedAddr, filteredSearchWords = this.filterNumericsAndSingleLetterWords(filteredSearchWords), dataManager, 1.0, options);
                    if (dictAddressWords != null) {
                        this.setSearchWordList(dictAddressWords);
                        return true;
                    }
                }
                return false;
            }
            case 19: {
                ++this.m_streetSubTryCount;
                AddressWord[] searchLocalityWords = null;
                searchLocalityWords = parsedAddr.isSeparateAreaFields() ? (AddressWord[])parsedAddr.getField(LOCALITY_FIELD) : (parsedAddr.isSeperatePostAddressFields() ? (AddressWord[])parsedAddr.getField(FieldType.POST_ADDRESS_FIELD_TYPE) : searchWords);
                if (searchLocalityWords != null) {
                    AddressWord[] filteredSearchWords = this.filterSearchWords(searchLocalityWords, false, true, false, 300);
                    List<DictionaryAddressWord> dictAddressWords = this.getSearchableSubLocalityWords(parsedAddr, filteredSearchWords = this.filterWithParsedSubLocalityField(filteredSearchWords, parsedAddr), dataManager, 1.0, options);
                    if (dictAddressWords != null) {
                        this.setSearchWordList(dictAddressWords);
                        return true;
                    }
                }
                return false;
            }
            case 20: {
                AddressWord[] filteredSearchWords;
                AddressWord[] splitStreetSearchWords;
                List<DictionaryAddressWord> dictAddressWords;
                ++this.m_streetSubTryCount;
                if (!parsedAddr.isSeperatePostAddressFields() && (dictAddressWords = this.getSearchableWords(splitStreetSearchWords = this.getSplitWords(filteredSearchWords = this.filterSearchWords(this.getWordsUptoType(searchWords), true, false, false, 256)), STREET_FIELD, dataManager, 1.0, options)) != null) {
                    this.setSearchWordList(dictAddressWords);
                    return true;
                }
                return false;
            }
            case 21: {
                ++this.m_streetSubTryCount;
                searchWords = (AddressWord[])parsedAddr.getField(STREET_FIELD);
                if (searchWords != null) {
                    if (!parsedAddr.isSeperatePostAddressFields()) {
                        searchWords = this.removeHNRPatterns(searchWords);
                    }
                    AddressWord[] combinedStreetSearchWords = this.getCombinedPossibles(searchWords);
                    List<DictionaryAddressWord> dictAddressWords = this.getSearchableWords(combinedStreetSearchWords = this.filterAllCommonWords(combinedStreetSearchWords), STREET_FIELD, dataManager, 1.0, options);
                    if (dictAddressWords != null) {
                        this.setSearchWordList(dictAddressWords);
                        return true;
                    }
                }
                return false;
            }
            case 22: {
                AddressWord[] filteredSearchWords;
                List<DictionaryAddressWord> dictAddressWords;
                ++this.m_streetSubTryCount;
                if (!parsedAddr.isSeperatePostAddressFields() && (dictAddressWords = this.getSearchableWords(filteredSearchWords = this.filterSearchWords(searchWords, false, false, false, 768), STREET_FIELD, dataManager, 1.0, options)) != null) {
                    this.setSearchWordList(dictAddressWords);
                    return true;
                }
                return false;
            }
            case 23: {
                ++this.m_streetSubTryCount;
                AddressWord[] searchWordsForSG = (AddressWord[])parsedAddr.getField(GENERIC_FIELD2);
                if (searchWordsForSG == null) {
                    AddressWord[] searchLocalityWords = null;
                    searchLocalityWords = parsedAddr.isSeparateAreaFields() ? (AddressWord[])parsedAddr.getField(LOCALITY_FIELD) : (parsedAddr.isSeperatePostAddressFields() ? (AddressWord[])parsedAddr.getField(FieldType.POST_ADDRESS_FIELD_TYPE) : searchWords);
                    if (searchLocalityWords != null) {
                        AddressWord[] filteredSearchWords = this.filterNumericsAndSingleLetterWords(searchLocalityWords);
                        List<DictionaryAddressWord> dictAddressWords = this.getSearchableSubLocalityWords(parsedAddr, filteredSearchWords = this.filterSearchWords(filteredSearchWords, true, false, false, 0), dataManager, 0.94, options);
                        if (dictAddressWords != null) {
                            this.setSearchWordList(dictAddressWords);
                            return true;
                        }
                    }
                }
                return false;
            }
            case 24: {
                AddressWord[] filteredSearchWords;
                AddressWord[] splitSubLoaclitySearchWords;
                List<DictionaryAddressWord> dictAddressWords;
                ++this.m_streetSubTryCount;
                AddressWord[] searchLocalityWords = null;
                searchLocalityWords = parsedAddr.isSeparateAreaFields() ? (AddressWord[])parsedAddr.getField(LOCALITY_FIELD) : (parsedAddr.isSeperatePostAddressFields() ? (AddressWord[])parsedAddr.getField(FieldType.POST_ADDRESS_FIELD_TYPE) : searchWords);
                if (searchLocalityWords != null && (dictAddressWords = this.getSearchableSubLocalityWords(parsedAddr, splitSubLoaclitySearchWords = this.getSplitWords(filteredSearchWords = this.filterSearchWords(searchLocalityWords, true, false, false, 256)), dataManager, 1.0, options)) != null) {
                    this.setSearchWordList(dictAddressWords);
                    return true;
                }
                return false;
            }
            case 25: {
                AddressWord[] filteredSearchWords;
                AddressWord[] combineSubLoaclitySearchWords;
                List<DictionaryAddressWord> dictAddressWords;
                ++this.m_streetSubTryCount;
                AddressWord[] searchLocalityWords = null;
                searchLocalityWords = parsedAddr.isSeparateAreaFields() ? (AddressWord[])parsedAddr.getField(LOCALITY_FIELD) : (parsedAddr.isSeperatePostAddressFields() ? (AddressWord[])parsedAddr.getField(FieldType.POST_ADDRESS_FIELD_TYPE) : searchWords);
                if (searchLocalityWords != null && (dictAddressWords = this.getSearchableSubLocalityWords(parsedAddr, combineSubLoaclitySearchWords = this.getCombinedPossibles(filteredSearchWords = this.filterSearchWords(searchLocalityWords, true, false, false, 256)), dataManager, 0.94, options)) != null) {
                    this.setSearchWordList(dictAddressWords);
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private List<DictionaryAddressWord> removeDictWordsFetchedOnInvalidSearchWords(List<DictionaryAddressWord> dictAddressWords) {
        if (!ListUtils.isEmpty(dictAddressWords)) {
            ArrayList<DictionaryAddressWord> filteredDictWords = new ArrayList<DictionaryAddressWord>();
            for (DictionaryAddressWord dictAddWord : dictAddressWords) {
                AddressWord searchWord = dictAddWord.getSearchWord();
                if (searchWord.getWord().length() <= 3 && !(dictAddWord.getMatchQuality() > 0.93) || StringUtilities.hasNumeric((String)searchWord.getWord())) continue;
                filteredDictWords.add(dictAddWord);
            }
            return filteredDictWords;
        }
        return dictAddressWords;
    }

    private AddressWord[] filterAllCommonWords(AddressWord[] combinedStreetSearchWords) {
        if (null == combinedStreetSearchWords) {
            return combinedStreetSearchWords;
        }
        ArrayList<AddressWord> addWords = new ArrayList<AddressWord>();
        for (AddressWord word : combinedStreetSearchWords) {
            if (!AddressWord.isSignificantWord(word)) continue;
            addWords.add(word);
        }
        if (addWords.size() > 0) {
            return addWords.toArray(new AddressWord[addWords.size()]);
        }
        return null;
    }

    private List<DictionaryAddressWord> removeNumericDictWords(List<DictionaryAddressWord> dictAddressWords) {
        if (!ListUtils.isEmpty(dictAddressWords)) {
            ArrayList<DictionaryAddressWord> filteredDictWords = new ArrayList<DictionaryAddressWord>();
            for (DictionaryAddressWord dictAddWord : dictAddressWords) {
                if (StringUtilities.hasNumeric((String)dictAddWord.getAddressWord().getWord())) continue;
                filteredDictWords.add(dictAddWord);
            }
            return filteredDictWords;
        }
        return dictAddressWords;
    }

    private boolean isNumber(AddressWord word) {
        if (null == word) {
            return false;
        }
        return StringUtilities.hasNumeric((String)word.getWord());
    }

    private boolean isDelimiter(AddressWord word) {
        boolean isDelim = CodedWord.isDelimiter(word.getCodedWord().getAttributes());
        if (isDelim && COMMA.equals(word.getCodedWord().getWord())) {
            isDelim = false;
        }
        return isDelim;
    }

    public AddressWord[] removeHNRPatterns(AddressWord[] filteredSearchWords) {
        if (null != filteredSearchWords && filteredSearchWords.length > 2) {
            ArrayList<AddressWord> filterWords = new ArrayList<AddressWord>();
            int indx = 1;
            while (indx < filteredSearchWords.length - 1) {
                AddressWord prev = filteredSearchWords[indx - 1];
                AddressWord mid = filteredSearchWords[indx];
                AddressWord next = filteredSearchWords[indx + 1];
                boolean isPrevNumber = this.isNumber(prev);
                boolean isMidNumber = this.isNumber(mid);
                boolean isNextNumber = this.isNumber(next);
                boolean isPrevDelim = this.isDelimiter(prev);
                boolean isMidDelim = this.isDelimiter(mid);
                boolean isNextDelim = this.isDelimiter(next);
                if (isMidDelim) {
                    if (isPrevNumber && isNextNumber) {
                        indx += 3;
                        continue;
                    }
                    if (isNextNumber) {
                        if (!isPrevDelim) {
                            filterWords.add(prev);
                        }
                        indx += 2;
                        continue;
                    }
                    if (!isPrevDelim) {
                        filterWords.add(prev);
                    }
                    if (!isNextDelim) {
                        filterWords.add(next);
                    }
                    indx += 3;
                    continue;
                }
                if (isMidNumber) {
                    if (!isPrevDelim) {
                        filterWords.add(prev);
                    }
                    if (isPrevDelim) {
                        indx += 2;
                        continue;
                    }
                    ++indx;
                    continue;
                }
                if (isNextNumber) {
                    if (!isPrevDelim) {
                        filterWords.add(prev);
                    }
                    if (!isMidDelim) {
                        filterWords.add(mid);
                    }
                    indx += 2;
                    continue;
                }
                if (!isPrevDelim) {
                    filterWords.add(prev);
                }
                if (!isMidDelim) {
                    filterWords.add(mid);
                }
                if (!isNextDelim) {
                    filterWords.add(next);
                }
                indx += 3;
            }
            if (filterWords.size() > 0) {
                return filterWords.toArray(new AddressWord[filterWords.size()]);
            }
        }
        return filteredSearchWords;
    }

    public AddressWord[] splitNumericWords(AddressWord[] filteredSearchWords) {
        if (null != filteredSearchWords && filteredSearchWords.length > 0) {
            Pattern NUMERIC_PATTERN = Pattern.compile("[0-9]+|[A-Z]+");
            ICGGEParser parser = this.getHelperParser();
            ICGGESoundex soundex = this.getHelperSoundex();
            ArrayList<AddressWord> numericSplitWords = new ArrayList<AddressWord>();
            for (AddressWord searchWord : filteredSearchWords) {
                String addrWordStr = searchWord.getWord();
                Matcher matcher = NUMERIC_PATTERN.matcher(addrWordStr);
                while (matcher.find()) {
                    String matchedStr = matcher.group();
                    numericSplitWords.add(parser.convertToAddressWord(matchedStr, soundex));
                }
                if (numericSplitWords.contains(searchWord)) continue;
                numericSplitWords.add(searchWord);
            }
            if (numericSplitWords.size() > 0) {
                return numericSplitWords.toArray(new AddressWord[numericSplitWords.size()]);
            }
        }
        return filteredSearchWords;
    }

    private String getStringFromAddressWordArray(AddressWord[] wordArray) {
        StringBuilder builder = new StringBuilder();
        if (wordArray != null) {
            for (AddressWord addressWord : wordArray) {
                builder.append(addressWord.getWord());
                builder.append(" ");
            }
        }
        return builder.toString();
    }

    private AddressWord[] splitAlphaNumericWords(AddressWord[] words) {
        if (words != null) {
            ArrayList<AddressWord> newWordList = new ArrayList<AddressWord>(words.length);
            for (AddressWord word : words) {
                AddressWord[] splitWords;
                newWordList.add(word);
                if (word.isNumeral() || word.getWordLength() <= 1 || (splitWords = this.splitAlphaNumericWord(word)) == null) continue;
                newWordList.add(splitWords[0]);
                newWordList.add(splitWords[1]);
            }
            if (newWordList.size() > words.length) {
                words = newWordList.toArray(new AddressWord[newWordList.size()]);
            }
        }
        return words;
    }

    private AddressWord[] splitAlphaNumericWord(AddressWord word) {
        char[] chars = word.getWordChars();
        char[] prefix = MMUtils.splitFromDigits(chars);
        ICGGEParser parser = this.getHelperParser();
        ICGGESoundex soundex = this.getHelperSoundex();
        if (prefix != null) {
            AddressWord splitWord1 = parser.convertToAddressWord(new String(prefix), soundex);
            AddressWord splitWord2 = parser.convertToAddressWord(new String(CharArray.subArray(chars, prefix.length)), soundex);
            return new AddressWord[]{splitWord1, splitWord2};
        }
        String prefixStr = MMUtils.getStartingNumberPart(new String(chars));
        if (prefixStr != null && prefixStr.length() < chars.length) {
            AddressWord splitWord1 = parser.convertToAddressWord(prefixStr, soundex);
            AddressWord splitWord2 = parser.convertToAddressWord(new String(CharArray.subArray(chars, prefixStr.length())), soundex);
            return new AddressWord[]{splitWord1, splitWord2};
        }
        return null;
    }

    private AddressWord[] filterWithParsedSubLocalityField(AddressWord[] filteredSearchWords, ParsedAddress parsedAddr) {
        int c;
        int n = c = filteredSearchWords == null ? 0 : filteredSearchWords.length;
        if (c > 0) {
            AddressWord[] subLocalityWords = (AddressWord[])parsedAddr.getField(GENERIC_FIELD2);
            int removed = 0;
            if (subLocalityWords != null) {
                for (int i = 0; i < c; ++i) {
                    AddressWord word = filteredSearchWords[i];
                    if (!CodedWord.isNumber(word.getAttributes()) && !CodedWord.isNumeric(word.getAttributes()) && word.getWordLength() != 1 && !this.contains(subLocalityWords, word)) continue;
                    filteredSearchWords[i] = null;
                    ++removed;
                }
            }
            if (removed > 0) {
                filteredSearchWords = this.removedNullWords(filteredSearchWords);
            }
        }
        return filteredSearchWords;
    }

    private AddressWord[] filterNumericsAndSingleLetterWords(AddressWord[] words) {
        int c;
        int n = c = words == null ? 0 : words.length;
        if (c > 0) {
            ArrayList<AddressWord> filteredList = new ArrayList<AddressWord>(c);
            for (int i = 0; i < c; ++i) {
                AddressWord word = words[i];
                if (word.isNumeral() || word.getWordLength() == 1) continue;
                filteredList.add(word);
            }
            if (filteredList.size() > 0) {
                words = filteredList.toArray(new AddressWord[filteredList.size()]);
            }
        }
        return words;
    }

    private boolean contains(AddressWord[] subLocalityWords, AddressWord searchWord) {
        CodedWord searchCodedWord = searchWord.getCodedWord();
        for (AddressWord word : subLocalityWords) {
            if (CodedWord.compareBytes(word.getCodedWord(), searchCodedWord) != 0) continue;
            return true;
        }
        return false;
    }

    private AddressWord[] removedNullWords(AddressWord[] words) {
        ArrayList<AddressWord> list = new ArrayList<AddressWord>(words.length);
        for (AddressWord word : words) {
            if (word == null) continue;
            list.add(word);
        }
        return list.toArray(new AddressWord[list.size()]);
    }

    private AddressWord[] getWordsUptoType(AddressWord[] words) {
        int n = words == null ? 0 : words.length;
        for (int ndx = n - 1; ndx > 0; --ndx) {
            AddressWord word = words[ndx];
            if (!CodedWord.isThoroughfareTypeWord(word.getAttributes())) continue;
            int filteredLen = ndx + 1;
            AddressWord[] filteredWords = new AddressWord[filteredLen];
            System.arraycopy(words, 0, filteredWords, 0, filteredLen);
            return filteredWords;
        }
        return null;
    }

    public static boolean canSearchFieldType(GeocodeOptions options, String fieldTypeStr) {
        boolean flag = true;
        IConstraints geocodeCons = options.getGeocodeConstraints();
        if (geocodeCons != null && !StringUtilities.isEmpty((String)fieldTypeStr)) {
            String b = geocodeCons.getCustomString(fieldTypeStr);
            flag = StringUtilities.isEmpty((String)b) || "true".equalsIgnoreCase(b);
        }
        return flag;
    }

    @Override
    public boolean init(String country, String language) {
        boolean b = super.init(country, language);
        return b;
    }

    protected List<DictionaryAddressWord> getSearchableSubLocalityWords(ParsedAddress parsedAddr, AddressWord[] searchWords, IDataManager dataManager, double minQuality, GeocodeOptions options) throws CGGEInternalException, DataNotInitialisedException, DataFetchException {
        List<DictionaryAddressWord> searchList = null;
        IND_ParsedAddress iParsedAddr = (IND_ParsedAddress)parsedAddr;
        List<FieldType> subLocalityFields = iParsedAddr.getM_subLocalityFields();
        if (subLocalityFields != null) {
            for (FieldType type : subLocalityFields) {
                List<DictionaryAddressWord> dictWordList = super.getSearchableWords(searchWords, type, dataManager, minQuality, options);
                searchList = ListUtils.addToList(searchList, dictWordList);
            }
        }
        return searchList;
    }

    @Override
    protected boolean generateAreaSubTries(IDataManager dataManager, ParsedAddress parsedAddr, GeocodeOptions options, InternalCandidateList candidateList) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        boolean seperateAreas = parsedAddr.isSeparateAreaFields();
        switch (this.m_areaSubTryCount) {
            case 0: {
                List<DictionaryAreaTermItem> pcList = this.findPCAreaList(dataManager, parsedAddr, 1.0, options);
                if (!ListUtils.isEmpty(pcList)) {
                    this.saveAreaList(PC_FIELD, pcList);
                }
                AddressWord[] postAddressWords = null;
                if (!seperateAreas) {
                    postAddressWords = (AddressWord[])parsedAddr.getField(FieldType.POST_ADDRESS_FIELD_TYPE);
                    ArrayList<AddressWord[]> matchableLocalityList = new ArrayList<AddressWord[]>();
                    this.findAreas(postAddressWords, true, dataManager, options, matchableLocalityList, STATE_FIELD, DISTRICT_FIELD, CITY_FIELD, LOCALITY_FIELD);
                    ((IND_ParsedAddress)parsedAddr).setM_localityList(matchableLocalityList);
                } else {
                    this.findAreas(parsedAddr, true, dataManager, options);
                }
                this.setAreasForSacFetching(postAddressWords, true, true, true, true, true);
                this.setSacIntersectionFieldList(STATE_FIELD, DISTRICT_FIELD, CITY_FIELD, LOCALITY_FIELD, PC_FIELD);
                return true;
            }
            case 1: {
                if (this.containsAnyAreas(DISTRICT_FIELD, LOCALITY_FIELD)) {
                    AddressWord[] postAddressWords = null;
                    if (!seperateAreas) {
                        postAddressWords = (AddressWord[])parsedAddr.getField(FieldType.POST_ADDRESS_FIELD_TYPE);
                        this.findAreas(postAddressWords, true, dataManager, options, new ArrayList<AddressWord[]>(), STATE_FIELD, CITY_FIELD);
                    }
                    this.setAreasForSacFetching(postAddressWords, true, true, false, true, false);
                    this.setSacIntersectionFieldList(STATE_FIELD, CITY_FIELD, PC_FIELD);
                    return true;
                }
                return false;
            }
            case 2: {
                if (this.containsAnyAreas(DISTRICT_FIELD, LOCALITY_FIELD, PC_FIELD)) {
                    AddressWord[] postAddressWords = null;
                    if (!seperateAreas) {
                        postAddressWords = (AddressWord[])parsedAddr.getField(FieldType.POST_ADDRESS_FIELD_TYPE);
                    }
                    this.setAreasForSacFetching(postAddressWords, false, true, false, true, false);
                    this.setSacIntersectionFieldList(STATE_FIELD, CITY_FIELD);
                    return true;
                }
                return false;
            }
            case 3: {
                if (this.containsAllAreas(STATE_FIELD, PC_FIELD)) {
                    AddressWord[] postAddressWords = null;
                    if (!seperateAreas) {
                        postAddressWords = (AddressWord[])parsedAddr.getField(FieldType.POST_ADDRESS_FIELD_TYPE);
                    }
                    this.setAreasForSacFetching(postAddressWords, true, true, false, false, false);
                    this.setSacIntersectionFieldList(STATE_FIELD, PC_FIELD);
                    return true;
                }
                return false;
            }
            case 4: {
                if (this.containsAllAreas(STATE_FIELD, LOCALITY_FIELD)) {
                    AddressWord[] postAddressWords = null;
                    if (!seperateAreas) {
                        postAddressWords = (AddressWord[])parsedAddr.getField(FieldType.POST_ADDRESS_FIELD_TYPE);
                    }
                    this.setAreasForSacFetching(postAddressWords, false, true, false, false, true);
                    this.setSacIntersectionFieldList(STATE_FIELD, LOCALITY_FIELD);
                    return true;
                }
                return false;
            }
            case 5: {
                List<DictionaryAreaTermItem> pcList = this.findPCAreaList(dataManager, parsedAddr, 1.0, options);
                if (!ListUtils.isEmpty(pcList)) {
                    this.saveAreaList(PC_FIELD, pcList);
                }
                AddressWord[] postAddressWords = null;
                if (!seperateAreas) {
                    postAddressWords = (AddressWord[])parsedAddr.getField(FieldType.POST_ADDRESS_FIELD_TYPE);
                    ArrayList<AddressWord[]> matchableLocalityList = new ArrayList<AddressWord[]>();
                    this.findAreas(postAddressWords, true, dataManager, options, matchableLocalityList, STATE_FIELD, DISTRICT_FIELD, CITY_FIELD, LOCALITY_FIELD);
                    ((IND_ParsedAddress)parsedAddr).setM_localityList(matchableLocalityList);
                } else {
                    this.findAreas(parsedAddr, true, dataManager, options);
                }
                this.setAreasForSacFetching(postAddressWords, true, true, true, true, true);
                this.setSacIntersectionFieldList(STATE_FIELD, DISTRICT_FIELD, CITY_FIELD, LOCALITY_FIELD);
                return true;
            }
            case 6: {
                List<DictionaryAreaTermItem> pcList = this.findPCAreaList(dataManager, parsedAddr, 1.0, options);
                if (!ListUtils.isEmpty(pcList)) {
                    this.saveAreaList(PC_FIELD, pcList);
                }
                AddressWord[] postAddressWords = null;
                if (!seperateAreas) {
                    postAddressWords = (AddressWord[])parsedAddr.getField(FieldType.POST_ADDRESS_FIELD_TYPE);
                    ArrayList<AddressWord[]> matchableLocalityList = new ArrayList<AddressWord[]>();
                    this.findAreas(postAddressWords, true, dataManager, options, matchableLocalityList, STATE_FIELD, DISTRICT_FIELD, CITY_FIELD);
                    ((IND_ParsedAddress)parsedAddr).setM_localityList(matchableLocalityList);
                } else {
                    this.findAreas(parsedAddr, true, dataManager, options);
                }
                this.setAreasForSacFetching(postAddressWords, true, true, true, true, true);
                this.setSacIntersectionFieldList(STATE_FIELD, DISTRICT_FIELD, CITY_FIELD, PC_FIELD);
                return true;
            }
            case 7: {
                List<DictionaryAreaTermItem> pcList = this.findPCAreaList(dataManager, parsedAddr, 1.0, options);
                if (!ListUtils.isEmpty(pcList)) {
                    this.saveAreaList(PC_FIELD, pcList);
                }
                AddressWord[] postAddressWords = null;
                if (!seperateAreas) {
                    postAddressWords = (AddressWord[])parsedAddr.getField(FieldType.POST_ADDRESS_FIELD_TYPE);
                    ArrayList<AddressWord[]> matchableLocalityList = new ArrayList<AddressWord[]>();
                    this.findAreas(postAddressWords, true, dataManager, options, matchableLocalityList, STATE_FIELD, CITY_FIELD, LOCALITY_FIELD);
                    ((IND_ParsedAddress)parsedAddr).setM_localityList(matchableLocalityList);
                } else {
                    this.findAreas(parsedAddr, true, dataManager, options);
                }
                this.setAreasForSacFetching(postAddressWords, true, true, true, true, true);
                this.setSacIntersectionFieldList(STATE_FIELD, CITY_FIELD, LOCALITY_FIELD, PC_FIELD);
                return true;
            }
            case 8: {
                List<DictionaryAreaTermItem> pcList = this.findPCAreaList(dataManager, parsedAddr, 1.0, options);
                if (!ListUtils.isEmpty(pcList)) {
                    this.saveAreaList(PC_FIELD, pcList);
                }
                AddressWord[] postAddressWords = null;
                if (!seperateAreas) {
                    postAddressWords = (AddressWord[])parsedAddr.getField(FieldType.POST_ADDRESS_FIELD_TYPE);
                    ArrayList<AddressWord[]> matchableLocalityList = new ArrayList<AddressWord[]>();
                    this.findAreas(postAddressWords, true, dataManager, options, matchableLocalityList, STATE_FIELD, CITY_FIELD, LOCALITY_FIELD);
                    ((IND_ParsedAddress)parsedAddr).setM_localityList(matchableLocalityList);
                } else {
                    this.findAreas(parsedAddr, true, dataManager, options);
                }
                this.setAreasForSacFetching(postAddressWords, true, true, true, true, true);
                this.setSacIntersectionFieldList(STATE_FIELD, CITY_FIELD, LOCALITY_FIELD);
                return true;
            }
            case 9: {
                List<DictionaryAreaTermItem> pcList = this.findPCAreaList(dataManager, parsedAddr, 1.0, options);
                if (!ListUtils.isEmpty(pcList)) {
                    this.saveAreaList(PC_FIELD, pcList);
                }
                AddressWord[] postAddressWords = null;
                if (!seperateAreas) {
                    postAddressWords = (AddressWord[])parsedAddr.getField(FieldType.POST_ADDRESS_FIELD_TYPE);
                    ArrayList<AddressWord[]> matchableLocalityList = new ArrayList<AddressWord[]>();
                    this.findAreas(postAddressWords, true, dataManager, options, matchableLocalityList, DISTRICT_FIELD, CITY_FIELD, LOCALITY_FIELD);
                    ((IND_ParsedAddress)parsedAddr).setM_localityList(matchableLocalityList);
                } else {
                    this.findAreas(parsedAddr, true, dataManager, options);
                }
                this.setAreasForSacFetching(postAddressWords, true, true, true, true, true);
                this.setSacIntersectionFieldList(DISTRICT_FIELD, CITY_FIELD, LOCALITY_FIELD, PC_FIELD);
                return true;
            }
            case 10: {
                List<DictionaryAreaTermItem> pcList = this.findPCAreaList(dataManager, parsedAddr, 1.0, options);
                if (!ListUtils.isEmpty(pcList)) {
                    this.saveAreaList(PC_FIELD, pcList);
                }
                AddressWord[] postAddressWords = null;
                if (!seperateAreas) {
                    postAddressWords = (AddressWord[])parsedAddr.getField(FieldType.POST_ADDRESS_FIELD_TYPE);
                    ArrayList<AddressWord[]> matchableLocalityList = new ArrayList<AddressWord[]>();
                    this.findAreas(postAddressWords, true, dataManager, options, matchableLocalityList, DISTRICT_FIELD, CITY_FIELD, LOCALITY_FIELD);
                    ((IND_ParsedAddress)parsedAddr).setM_localityList(matchableLocalityList);
                } else {
                    this.findAreas(parsedAddr, true, dataManager, options);
                }
                this.setAreasForSacFetching(postAddressWords, true, true, true, true, true);
                this.setSacIntersectionFieldList(DISTRICT_FIELD, CITY_FIELD, LOCALITY_FIELD);
                return true;
            }
            case 11: {
                List<DictionaryAreaTermItem> pcList = this.findPCAreaList(dataManager, parsedAddr, 1.0, options);
                if (!ListUtils.isEmpty(pcList)) {
                    this.saveAreaList(PC_FIELD, pcList);
                }
                AddressWord[] postAddressWords = null;
                if (!seperateAreas) {
                    postAddressWords = (AddressWord[])parsedAddr.getField(FieldType.POST_ADDRESS_FIELD_TYPE);
                    ArrayList<AddressWord[]> matchableLocalityList = new ArrayList<AddressWord[]>();
                    this.findAreas(postAddressWords, true, dataManager, options, matchableLocalityList, CITY_FIELD, LOCALITY_FIELD);
                    ((IND_ParsedAddress)parsedAddr).setM_localityList(matchableLocalityList);
                } else {
                    this.findAreas(parsedAddr, true, dataManager, options);
                }
                this.setAreasForSacFetching(postAddressWords, true, true, true, true, true);
                this.setSacIntersectionFieldList(CITY_FIELD, LOCALITY_FIELD, PC_FIELD);
                return true;
            }
            case 12: {
                List<DictionaryAreaTermItem> pcList = this.findPCAreaList(dataManager, parsedAddr, 1.0, options);
                if (!ListUtils.isEmpty(pcList)) {
                    this.saveAreaList(PC_FIELD, pcList);
                }
                AddressWord[] postAddressWords = null;
                if (!seperateAreas) {
                    postAddressWords = (AddressWord[])parsedAddr.getField(FieldType.POST_ADDRESS_FIELD_TYPE);
                    ArrayList<AddressWord[]> matchableLocalityList = new ArrayList<AddressWord[]>();
                    this.findAreas(postAddressWords, true, dataManager, options, matchableLocalityList, STATE_FIELD, DISTRICT_FIELD, LOCALITY_FIELD);
                    ((IND_ParsedAddress)parsedAddr).setM_localityList(matchableLocalityList);
                } else {
                    this.findAreas(parsedAddr, true, dataManager, options);
                }
                this.setAreasForSacFetching(postAddressWords, true, true, true, true, true);
                this.setSacIntersectionFieldList(STATE_FIELD, DISTRICT_FIELD, LOCALITY_FIELD, PC_FIELD);
                return true;
            }
            case 13: {
                if (!(!parsedAddr.isSeparateAreaFields() || parsedAddr.isEmpty(CITY_FIELD) && parsedAddr.isEmpty(LOCALITY_FIELD))) {
                    this.findFlippedCityAndLocality(parsedAddr, true, dataManager, options);
                    if (this.containsAnyAreas(LOCALITY_FIELD, CITY_FIELD)) {
                        this.setAreasForSacFetching(null, true, true, false, true, true);
                        this.setSacIntersectionFieldList(STATE_FIELD, CITY_FIELD, LOCALITY_FIELD);
                        return true;
                    }
                }
                return false;
            }
            case 14: {
                if (!seperateAreas && this.containsArea(STATE_FIELD)) {
                    AddressWord[] postAddressWords = (AddressWord[])parsedAddr.getField(FieldType.POST_ADDRESS_FIELD_TYPE);
                    this.findAreas(postAddressWords, true, dataManager, options, new ArrayList<AddressWord[]>(), CITY_FIELD);
                    this.setAreasForSacFetching(postAddressWords, true, false, false, true, false);
                    this.setSacIntersectionFieldList(CITY_FIELD, PC_FIELD);
                    return true;
                }
                return false;
            }
            case 15: {
                if (!this.doesBestCandidateHasPerfectField(candidateList, CITY_FIELD) || !this.doesBestCandidateHasPerfectField(candidateList, LOCALITY_FIELD)) {
                    AddressWord[] postAddressWords = null;
                    if (!seperateAreas) {
                        postAddressWords = (AddressWord[])parsedAddr.getField(FieldType.POST_ADDRESS_FIELD_TYPE);
                        this.findAreas(postAddressWords, true, dataManager, options, new ArrayList<AddressWord[]>(), STATE_FIELD, DISTRICT_FIELD, CITY_FIELD, LOCALITY_FIELD);
                    } else {
                        this.findAreas(parsedAddr, false, dataManager, options);
                    }
                    this.setAreasForSacFetching(postAddressWords, true, true, true, true, true);
                    this.setSacIntersectionFieldList(STATE_FIELD, DISTRICT_FIELD, CITY_FIELD, LOCALITY_FIELD, PC_FIELD);
                    return true;
                }
                return false;
            }
            case 16: {
                if (!(this.doesBestCandidateHasPerfectField(candidateList, CITY_FIELD) && this.doesBestCandidateHasPerfectField(candidateList, LOCALITY_FIELD) || !this.containsAnyAreas(DISTRICT_FIELD, LOCALITY_FIELD))) {
                    AddressWord[] postAddressWords = null;
                    if (!seperateAreas) {
                        postAddressWords = (AddressWord[])parsedAddr.getField(FieldType.POST_ADDRESS_FIELD_TYPE);
                        this.findAreas(postAddressWords, true, dataManager, options, new ArrayList<AddressWord[]>(), STATE_FIELD, CITY_FIELD);
                    }
                    this.setAreasForSacFetching(postAddressWords, true, true, false, true, false);
                    this.setSacIntersectionFieldList(STATE_FIELD, CITY_FIELD, PC_FIELD);
                    return true;
                }
                return false;
            }
            case 17: {
                if (!(this.doesBestCandidateHasPerfectField(candidateList, CITY_FIELD) && this.doesBestCandidateHasPerfectField(candidateList, LOCALITY_FIELD) || !this.containsAnyAreas(DISTRICT_FIELD, LOCALITY_FIELD, PC_FIELD))) {
                    AddressWord[] postAddressWords = null;
                    if (!seperateAreas) {
                        postAddressWords = (AddressWord[])parsedAddr.getField(FieldType.POST_ADDRESS_FIELD_TYPE);
                    }
                    this.setAreasForSacFetching(postAddressWords, true, true, false, true, false);
                    this.setSacIntersectionFieldList(STATE_FIELD, CITY_FIELD);
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    protected boolean generateStreetSubTriesForIntersection(IDataManager dataManager, ParsedAddress parsedAddress, GeocodeOptions options, InternalCandidateList candidateList) throws CGGEInternalException, DataNotInitialisedException, DataFetchException {
        switch (this.m_streetSubTryCount) {
            case 8: {
                ++this.m_streetSubTryCount;
                AddressWord[] searchWords = null;
                searchWords = !parsedAddress.isSeperatePostAddressFields() ? this.m_areaFilteredSearchWords : (AddressWord[])parsedAddress.getField(STREET_FIELD);
                List<DictionaryAddressWord> searchWordList = this.getSearchableWords(searchWords, FieldType.STREET_NAME_FIELD_TYPE, dataManager, this.getMinimumSearchWordQuality(), options);
                if (searchWordList != null) {
                    this.setSearchWordList(searchWordList);
                    return true;
                }
                return false;
            }
            case 9: {
                List<DictionaryAddressWord> searchWordList;
                ++this.m_streetSubTryCount;
                AddressWord[] searchWords = null;
                if (!parsedAddress.isSeperatePostAddressFields() && (searchWordList = this.getSearchableWords(searchWords = (AddressWord[])parsedAddress.getField(STREET_FIELD), FieldType.STREET_NAME_FIELD_TYPE, dataManager, this.getMinimumSearchWordQuality(), options)) != null) {
                    this.setSearchWordList(searchWordList);
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private boolean containsAnyAreas(FieldType ... types) {
        for (FieldType type : types) {
            if (!this.containsArea(type)) continue;
            return true;
        }
        return false;
    }

    private boolean containsArea(FieldType type) {
        Map<FieldType, List<DictionaryAreaTermItem>> areaMap = this.m_savedAreas.get(this.m_currentCase.m_tryDataSet);
        if (areaMap != null) {
            List<DictionaryAreaTermItem> areaList = areaMap.get(type);
            return !ListUtils.isEmpty(areaList);
        }
        return false;
    }

    private boolean containsAllAreas(FieldType ... types) {
        Map<FieldType, List<DictionaryAreaTermItem>> areaMap = this.m_savedAreas.get(this.m_currentCase.m_tryDataSet);
        if (areaMap != null) {
            for (FieldType type : types) {
                List<DictionaryAreaTermItem> areaList = areaMap.get(type);
                if (!ListUtils.isEmpty(areaList)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void setAreasForSacFetching(AddressWord[] searchWords, boolean includePC, boolean includeState, boolean includeDistrict, boolean includeCity, boolean includeLocality) {
        if (searchWords != null) {
            searchWords = (AddressWord[])searchWords.clone();
        }
        ArrayList<DictionaryAreaTermItem> areaList = new ArrayList<DictionaryAreaTermItem>();
        if (includeState) {
            searchWords = this.setAreaToList(areaList, STATE_FIELD, searchWords);
        }
        if (includeDistrict) {
            searchWords = this.setAreaToList(areaList, DISTRICT_FIELD, searchWords);
        }
        if (includeCity) {
            searchWords = this.setAreaToList(areaList, CITY_FIELD, searchWords);
        }
        if (includeLocality) {
            searchWords = this.setAreaToList(areaList, LOCALITY_FIELD, searchWords);
        }
        if (includePC) {
            this.setAreaToList(areaList, PC_FIELD, null);
        }
        this.setSearchAreaList(areaList);
        this.m_areaFilteredSearchWords = searchWords;
    }

    private AddressWord[] setAreaToList(List<DictionaryAreaTermItem> areaList, FieldType areaType, AddressWord[] searchWords) {
        List<DictionaryAreaTermItem> typeAreaList;
        Map<FieldType, List<DictionaryAreaTermItem>> areaMap = this.m_savedAreas.get(this.m_currentCase.m_tryDataSet);
        if (areaMap != null && !ListUtils.isEmpty(typeAreaList = areaMap.get(areaType))) {
            areaList.addAll(typeAreaList);
            if (searchWords != null) {
                DictionaryAreaTermItem area = this.getRightMostMatchedArea(searchWords, typeAreaList);
                searchWords = this.removeMatchingSearchWords(searchWords, area);
            }
        }
        return searchWords;
    }

    private DictionaryAreaTermItem getRightMostMatchedArea(AddressWord[] searchWords, List<DictionaryAreaTermItem> areaList) {
        int areaLen = areaList.size();
        if (areaLen > 1) {
            for (int searchWordNdx = searchWords.length - 1; searchWordNdx >= 0; --searchWordNdx) {
                AddressWord searchWord = searchWords[searchWordNdx];
                for (int areaNdx = 0; areaNdx < areaLen; ++areaNdx) {
                    DictionaryAreaTermItem areaItem = areaList.get(areaNdx);
                    DictionaryAddressWord[] matchedDictWords = areaItem.getMatchedWords();
                    if (matchedDictWords == null) continue;
                    for (DictionaryAddressWord matchedDictWord : matchedDictWords) {
                        if (matchedDictWord == null || matchedDictWord.getSearchWord() != searchWord) continue;
                        return areaItem;
                    }
                }
            }
        }
        return areaList.get(0);
    }

    private AddressWord[] removeMatchingSearchWords(AddressWord[] searchWords, DictionaryAreaTermItem area) {
        if (null == area || null == searchWords) {
            return searchWords;
        }
        DictionaryAddressWord[] matchedDictWords = area.getMatchedWords();
        int searchWordsLen = searchWords.length;
        int removed = 0;
        if (matchedDictWords != null) {
            for (DictionaryAddressWord matchedDictWord : matchedDictWords) {
                if (matchedDictWord == null) continue;
                for (int ndx = 0; ndx < searchWordsLen; ++ndx) {
                    if (matchedDictWord.getSearchWord() != searchWords[ndx] || "SG".equals(this.m_currentCase.m_tryDataSet) && matchedDictWord.getSearchWord().isNumeral() || FieldType.AREA_NAME_4_FIELD_TYPE == area.m_type && matchedDictWord.getSearchWord().isNumeral()) continue;
                    searchWords[ndx] = null;
                    ++removed;
                }
            }
        }
        if (removed > 0) {
            int remaining = searchWordsLen - removed;
            if (remaining > 0) {
                AddressWord[] filteredWords = new AddressWord[remaining];
                int added = 0;
                for (int ndx = 0; ndx < searchWordsLen; ++ndx) {
                    AddressWord word = searchWords[ndx];
                    if (word == null) continue;
                    filteredWords[added++] = word;
                }
                searchWords = filteredWords;
            } else {
                searchWords = null;
            }
        }
        return searchWords;
    }

    private void findFlippedCityAndLocality(ParsedAddress parsedAddress, boolean perfect, IDataManager dataManager, GeocodeOptions options) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        this.findAreaList((AddressWord[])parsedAddress.getField(LOCALITY_FIELD), CITY_FIELD, dataManager, perfect, options);
        this.findAreaList((AddressWord[])parsedAddress.getField(CITY_FIELD), LOCALITY_FIELD, dataManager, perfect, options);
    }

    @Override
    protected InternalCandidateList retrieveCandidates(IDataManager dataManager, ParsedAddress parsedAddress, List<DictionaryAreaTermItem> areaList, List<DictionaryAddressWord> searchWordList, GeocodeOptions options) throws CGGEInternalException, DataFetchException, DataNotInitialisedException {
        Object candList = null;
        List<DictionaryAreaSacs> areaSacList = this.findSACIntersection(dataManager, areaList, searchWordList, options);
        if (areaSacList != null && areaSacList.size() > 0 && "POI".equalsIgnoreCase(this.m_currentCase.m_tryDataSet)) {
            this.matchableAreaName(areaSacList, options, parsedAddress);
        }
        InternalCandidateList cands = this.filterCandidates(dataManager, areaList, areaSacList, searchWordList, options);
        return cands;
    }

    protected void matchableAreaName(List<DictionaryAreaSacs> areaSacList, GeocodeOptions options, ParsedAddress parsedAddress) {
        Map<FieldType, List<AddressWord[]>> areaMap = ((IND_ParsedAddress)parsedAddress).getM_areaListMap();
        for (DictionaryAreaSacs dictionaryAreaSacs : areaSacList) {
            FieldType type = dictionaryAreaSacs.getAreaTerm().getFieldType();
            DictionaryAreaTermItem areaName = dictionaryAreaSacs.getAreaTerm();
            List<AddressWord[]> areaList = areaMap.get(type);
            if (areaList == null) {
                areaList = new ArrayList<AddressWord[]>();
            }
            areaList.add(areaName.getAreaAddressWords());
            areaMap.put(type, areaList);
        }
    }

    private AddressWord[] findAreas(AddressWord[] searchWords, boolean perfect, IDataManager dataManager, GeocodeOptions options, List<AddressWord[]> matchableLocalityList, FieldType ... types) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        if (searchWords != null) {
            searchWords = (AddressWord[])searchWords.clone();
        }
        boolean matchableLocalityFound = false;
        boolean matchableStateFound = false;
        ArrayList<AddressWord[]> localityList = new ArrayList<AddressWord[]>();
        List<Object> updatedAreaNameList = new ArrayList();
        ArrayList<DictionaryAreaTermItem> SingleState = new ArrayList<DictionaryAreaTermItem>();
        for (FieldType type : types) {
            List<DictionaryAreaTermItem> areaList = this.findAreaList(searchWords, type, dataManager, perfect, options);
            updatedAreaNameList = this.removeMultipleStateName(areaList, type);
            if (type == LOCALITY_FIELD && !ListUtils.isEmpty(updatedAreaNameList)) {
                matchableLocalityFound = true;
                for (DictionaryAreaTermItem dictionaryAreaTermItem : areaList) {
                    localityList.add(dictionaryAreaTermItem.getAreaAddressWords());
                }
            }
            if (type == STATE_FIELD && !ListUtils.isEmpty(updatedAreaNameList)) {
                matchableStateFound = true;
                SingleState.add((DictionaryAreaTermItem)updatedAreaNameList.get(0));
            }
            if (ListUtils.isEmpty(areaList)) continue;
            Collections.sort(areaList, MMUtils.getReverseComparator(new AreaQualityComparator()));
            searchWords = this.filterSearchWordOnMatchingAreaWords(searchWords, updatedAreaNameList);
        }
        if (this.m_areaSubTryCount == 0) {
            options.setProperty(MATCHABLE_LOCALITY_FOUND, matchableLocalityFound ? "true" : "false");
            if (localityList != null && localityList.size() > 0) {
                matchableLocalityList.clear();
                matchableLocalityList.addAll(localityList);
            }
            if (matchableStateFound && SingleState != null && SingleState.size() == 1) {
                options.setProperty(MATCHABLE_STATE_FOUND, matchableLocalityFound ? "true" : "false");
                options.setProperty(STATE_NAME, this.returnStateName(SingleState));
            }
        }
        return searchWords;
    }

    private int getSignificantWordCount(AddressWord[] words) {
        int c = 0;
        for (AddressWord word : words) {
            if (!AddressWord.isSignificantWord(word)) continue;
            ++c;
        }
        return c;
    }

    private AddressWord[] filterSearchWordOnMatchingAreaWords(AddressWord[] searchWords, List<DictionaryAreaTermItem> areaList) {
        return this.removeMatchingSearchWords(searchWords, areaList.get(0));
    }

    private void setSacIntersectionFieldList(FieldType ... types) {
        List<FieldType> sacInterectionList = null;
        for (FieldType type : types) {
            if (!this.containsArea(type)) continue;
            sacInterectionList = ListUtils.addToList(sacInterectionList, type);
        }
        if (sacInterectionList != null && sacInterectionList.size() < 2) {
            sacInterectionList = null;
        }
        this.setAreaSacIntersectionFieldList(sacInterectionList);
    }

    private void findAreas(ParsedAddress parsedAddress, boolean perfect, IDataManager dataManager, GeocodeOptions options) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        this.findAreaList((AddressWord[])parsedAddress.getField(STATE_FIELD), STATE_FIELD, dataManager, perfect, options);
        this.findAreaList((AddressWord[])parsedAddress.getField(DISTRICT_FIELD), DISTRICT_FIELD, dataManager, perfect, options);
        this.findAreaList((AddressWord[])parsedAddress.getField(CITY_FIELD), CITY_FIELD, dataManager, perfect, options);
        this.findAreaList((AddressWord[])parsedAddress.getField(LOCALITY_FIELD), LOCALITY_FIELD, dataManager, perfect, options);
    }

    @Override
    protected void filterSearchedSacs(List<DictionaryAreaSacs> areaSacList, List<DictionaryAddressWord> searchWordList) {
        if (areaSacList != null) {
            Iterator<DictionaryAreaSacs> it = areaSacList.iterator();
            while (it.hasNext()) {
                FieldType type = it.next().getFieldType();
                if (type != STATE_FIELD && type != DISTRICT_FIELD) continue;
                it.remove();
            }
        }
        super.filterSearchedSacs(areaSacList, searchWordList);
    }

    private List<DictionaryAreaTermItem> findAreaList(AddressWord[] searchWords, FieldType type, IDataManager dataManager, boolean perfect, GeocodeOptions options) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        List<DictionaryAreaTermItem> areaList = null;
        StringBuilder key = new StringBuilder();
        key.append(this.m_currentCase.m_tryDataSet).append("-").append(type.getName());
        if (type != FieldType.AREA_NAME_3_FIELD_TYPE) {
            areaList = this.cachedAreaWords.get(key.toString());
        }
        if (searchWords != null && null == areaList) {
            double minQuality;
            double d = minQuality = perfect ? 1.0 : this.getMinimumSearchAreaQuality();
            if (this.m_areaSubTryCount == 0 && FieldType.AREA_NAME_4_FIELD_TYPE.equals(type)) {
                minQuality = 0.98f;
            }
            areaList = this.findAreaList(searchWords, type, minQuality, dataManager, options);
            this.cachedAreaWords.put(key.toString(), areaList);
        }
        this.saveAreaList(type, areaList);
        return areaList;
    }

    private void saveAreaList(FieldType type, List<DictionaryAreaTermItem> areaList) {
        if (areaList != null) {
            Map<FieldType, List<DictionaryAreaTermItem>> areaMap = this.m_savedAreas.get(this.m_currentCase.m_tryDataSet);
            if (areaMap == null) {
                areaMap = new HashMap<FieldType, List<DictionaryAreaTermItem>>(5);
                this.m_savedAreas.put(this.m_currentCase.m_tryDataSet, areaMap);
            }
            areaMap.put(type, areaList);
        }
    }

    @Override
    protected boolean continueRetrying(ParsedAddress parsedAddress, InternalCandidateList curCandList) {
        InternalScoringAddress cand;
        int closeMatchCount;
        if (parsedAddress.isIntersectionCase()) {
            return super.continueRetrying(parsedAddress, curCandList);
        }
        int n = closeMatchCount = curCandList == null ? 0 : curCandList.getNumberOfCloseMatches();
        if (closeMatchCount > 0 && DataSetUtils.isPOIDataSetItem(cand = curCandList.getIndexedCandidate(0)) && !this.acceptablePOICandidate(cand)) {
            return true;
        }
        return closeMatchCount < 1;
    }

    private boolean acceptablePOICandidate(InternalScoringAddress cand) {
        return IND_Matcher1.acceptableAreaScore(cand, FieldType.AREA_NAME_4_FIELD_TYPE, true) || IND_Matcher1.acceptableAreaScore(cand, FieldType.POST_CODE_FIELD_TYPE, true);
    }

    @Override
    public AddressWord[] getCombinedPossibles(AddressWord[] words) {
        int wordsLen;
        int n = wordsLen = words == null ? 0 : words.length;
        if (wordsLen > 1) {
            ArrayList<AddressWord> addrWordList = new ArrayList<AddressWord>(wordsLen * 3);
            ICGGEParser parser = this.getHelperParser();
            ICGGESoundex soundex = this.getHelperSoundex();
            block0: for (int wordNdx = 0; wordNdx < wordsLen - 1; ++wordNdx) {
                AddressWord word = words[wordNdx];
                if (!this.considerWordForCombining(word)) continue;
                CharArray charArray = new CharArray();
                charArray.add(word.getWordChars());
                boolean prevWordWasAKnownWord = this.isKnownWord(word);
                for (int wordNdx1 = wordNdx + 1; wordNdx1 < wordsLen; ++wordNdx1) {
                    AddressWord word1 = words[wordNdx1];
                    if (this.considerWordForCombining(word1)) {
                        boolean knownWord = this.isKnownWord(word1);
                        if (prevWordWasAKnownWord && knownWord) continue block0;
                        prevWordWasAKnownWord = knownWord;
                        charArray.add(word1.getWordChars());
                        AddressWord combinedWord = parser.convertToAddressWord(charArray.toString(), soundex);
                        addrWordList.add(combinedWord);
                        if (charArray.length() <= 15) continue;
                        continue block0;
                    }
                    if (!CodedWord.isDelimiter(word1.getAttributes())) continue block0;
                }
            }
            if (addrWordList.size() > 0) {
                return addrWordList.toArray(new AddressWord[addrWordList.size()]);
            }
        }
        return null;
    }

    private boolean considerWordForCombining(AddressWord word) {
        short attribs = word.getAttributes();
        return !CodedWord.isDelimiter(attribs);
    }

    private boolean isKnownWord(AddressWord word) {
        return word.getWordLength() > 1 && (word.getAttributes() & KNOWN_WORD_MASK) > 0;
    }

    private List<DictionaryAreaTermItem> removeMultipleStateName(List<DictionaryAreaTermItem> areaList, FieldType type) {
        if (this.m_areaSubTryCount == 0 && FieldType.AREA_NAME_1_FIELD_TYPE.equals(type) && areaList != null && areaList.size() > 1) {
            ArrayList<DictionaryAreaTermItem> singleState = new ArrayList<DictionaryAreaTermItem>(1);
            singleState.add(areaList.get(areaList.size() - 1));
            return singleState;
        }
        return areaList;
    }

    private String returnStateName(List<DictionaryAreaTermItem> areaList) {
        int properSpaceForState = 0;
        if (!ListUtils.isEmpty(areaList) && areaList.size() == 1) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < areaList.get(0).getWordCount(); ++i) {
                builder.append(areaList.get((int)0).m_areaWords[i].getWord());
                if (areaList.get(0).getWordCount() <= 1 || ++properSpaceForState != 1) continue;
                builder.append(" ");
            }
            return builder.toString().trim();
        }
        return null;
    }

    protected List<DictionaryAddressWord> getSearchableWords(AddressWord[] searchWords, IDataManager dataManager, double minQuality, GeocodeOptions options, FieldType ... type) throws CGGEInternalException, DataNotInitialisedException, DataFetchException {
        ArrayList<DictionaryAddressWord> searchableWordList = new ArrayList<DictionaryAddressWord>();
        for (FieldType fieldType : type) {
            List<DictionaryAddressWord> newSearchableWordList = super.getSearchableWords(searchWords, fieldType, dataManager, minQuality, options);
            if (newSearchableWordList == null) continue;
            searchableWordList.addAll(newSearchableWordList);
        }
        return searchableWordList;
    }

    static {
        KNOWN_WORD_MASK = (short)3868;
        m_caseList = new ArrayList<RetryCase>(20);
        int maxAreaTries = 17;
        for (int areaTryCase = 0; areaTryCase <= maxAreaTries; ++areaTryCase) {
            if (areaTryCase > 4 && areaTryCase < 12) continue;
            m_caseList.add(new RetryCase(areaTryCase, 0, "AP"));
            m_caseList.add(new RetryCase(areaTryCase, 1, "AP"));
            m_caseList.add(new RetryCase(areaTryCase, 2, "AP"));
            m_caseList.add(new RetryCase(areaTryCase, 3, "AP"));
            m_caseList.add(new RetryCase(areaTryCase, 4, "AP"));
            m_caseList.add(new RetryCase(areaTryCase, 5, "AP"));
            if (areaTryCase == 12) {
                m_caseList.add(new RetryCase(areaTryCase, 12, "POI"));
                continue;
            }
            m_caseList.add(new RetryCase(areaTryCase, 6, "POI"));
            m_caseList.add(new RetryCase(areaTryCase, 7, "POI"));
            m_caseList.add(new RetryCase(areaTryCase, 13, "POI"));
            m_caseList.add(new RetryCase(areaTryCase, 15, "POI"));
            m_caseList.add(new RetryCase(areaTryCase, 8, "Street"));
            m_caseList.add(new RetryCase(areaTryCase, 9, "Street"));
            if (areaTryCase <= 1) {
                m_caseList.add(new RetryCase(areaTryCase, 10, "Street"));
            }
            m_caseList.add(new RetryCase(areaTryCase, 11, "Street"));
            m_caseList.add(new RetryCase(areaTryCase, 14, "Street"));
            m_caseList.add(new RetryCase(areaTryCase, 20, "Street"));
            m_caseList.add(new RetryCase(areaTryCase, 21, "Street"));
            m_caseList.add(new RetryCase(areaTryCase, 22, "Street"));
            m_caseList.add(new RetryCase(areaTryCase, 16, "SG"));
            if (areaTryCase == 0) {
                m_caseList.add(new RetryCase(areaTryCase, 17, "SG"));
            }
            m_caseList.add(new RetryCase(areaTryCase, 18, "SG"));
            if (areaTryCase == 0 || areaTryCase == 4 || areaTryCase == 13 || areaTryCase == 15) {
                m_caseList.add(new RetryCase(areaTryCase, 19, "SG"));
            }
            m_caseList.add(new RetryCase(areaTryCase, 23, "SG"));
            m_caseList.add(new RetryCase(areaTryCase, 24, "SG"));
            m_caseList.add(new RetryCase(areaTryCase, 25, "SG"));
        }
    }

    private static class RetryCase {
        int m_areaTryCase;
        int m_streetTryCase;
        String m_tryDataSet;

        RetryCase(int areaCase, int streetCase, String dataSet) {
            this.m_areaTryCase = areaCase;
            this.m_streetTryCase = streetCase;
            this.m_tryDataSet = dataSet;
        }
    }

    private class AreaQualityComparator
    implements Comparator<DictionaryAreaTermItem> {
        private AreaQualityComparator() {
        }

        @Override
        public int compare(DictionaryAreaTermItem o1, DictionaryAreaTermItem o2) {
            int c = MMUtils.compareDoubleValues(o1.m_quality, o2.m_quality);
            if (c == 0) {
                c = o1.getMatchedWordCount() - o2.getMatchedWordCount();
            }
            if (c == 0) {
                c = o1.m_areaWords.length - o2.m_areaWords.length;
            }
            if (c == 0) {
                c = INDStreetGeocodingHelper.this.getSignificantWordCount(o1.m_areaWords) - INDStreetGeocodingHelper.this.getSignificantWordCount(o2.m_areaWords);
            }
            return c;
        }
    }
}

