/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.IND.matcher;

import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.IND.IND_MatchingOptions;
import com.mapinfo.mapmarker.IND.address.IND_AddressNumber;
import com.mapinfo.mapmarker.IND.address.IND_ParsedAddress;
import com.mapinfo.mapmarker.IND.dp.binary.DataSetUtils;
import com.mapinfo.mapmarker.IND.helper.INDStreetGeocodingHelper;
import com.mapinfo.mapmarker.IND.matcher.IND_FieldScoreAdjuster;
import com.mapinfo.mapmarker.IND.parser.IND_Parser1;
import com.mapinfo.mapmarker.cgge.AddressNumberScore;
import com.mapinfo.mapmarker.cgge.CGGEHandler;
import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.CGGERuntimeException;
import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.MatchingOptions;
import com.mapinfo.mapmarker.cgge.address.AddressNumber;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.CodedWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalFieldValue;
import com.mapinfo.mapmarker.cgge.address.InternalRangeAddress;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.InternalScoringRange;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.address.PostCode;
import com.mapinfo.mapmarker.cgge.address.ScoringItem;
import com.mapinfo.mapmarker.cgge.dp.DataSetInfo;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.cgge.matcher.CGGEMatcher1;
import com.mapinfo.mapmarker.cgge.matcher.MatchedWordStats;
import com.mapinfo.mapmarker.cgge.scorer.CGGEScorer;
import com.mapinfo.mapmarker.cgge.scorer.ICGGEScorer;
import com.mapinfo.mapmarker.cgge.utils.IntArray;
import com.mapinfo.mapmarker.cgge.utils.ListUtils;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IND_Matcher1
extends CGGEMatcher1 {
    private static final String LOCALITY_MATCH_FOUND = "loc_match_found";
    private static final double MINIMUM_SEARCH_FIELD_SCORE = 0.8;
    private static final double MINIMUM_PLACE_NAME_SCORE = 0.89;
    private static final double MINIMUM_STREET_NAME_SCORE = 0.85;
    private static final double ACCEPTABLE_AREA_SCORE = 0.85;
    private static final double ACCEPTABLE_POSTCODE_SCORE = (double)0.99f;
    private static final double MINIMUM_ADDRESS_NUMBER_SCORE = 1.0;
    private static final double ACCEPTABLE_AREA_SCORE_FOR_GEO = 0.92;
    private static final double ACCEPTABLE_AREA_SCORE_FOR_STATE = 0.96;
    private static final double ZERO = 0.0;
    public static final String STATE_NAME = "state_name";
    private boolean doesInputHasTown = false;
    private boolean doesInputHasLocality = false;
    private static final double MINIMUM_GEOGRAPHIC_FIELD_SCORE = 0.825;

    public IND_Matcher1() {
        this.m_fieldScoreAdjuster = new IND_FieldScoreAdjuster();
    }

    @Override
    public boolean calculateCloseMatch(InternalScoringAddress scoringAddr, ParsedAddress parsedAddr, GeocodeOptions options, MatchingOptions matchOptions) throws CGGEInternalException {
        this.calculateCombinedAddressScore(scoringAddr, matchOptions);
        return super.calculateCloseMatch(scoringAddr, parsedAddr, options, matchOptions);
    }

    @Override
    public void scoreCandidate(ParsedAddress parsedAddr, InternalScoringAddress cand, MatchingOptions matchingOptions, ICGGEScorer scorer, IDataManager dataManager) throws CGGEInternalException {
        if (DataSetUtils.isAPDataSetItem(cand)) {
            this.scoreAPCandidate(parsedAddr, cand, matchingOptions, scorer, dataManager);
            return;
        }
        boolean isPOICand = DataSetUtils.isPOIDataSetItem(cand);
        boolean isSGCand = !isPOICand && DataSetUtils.isSGDataSetItem(cand);
        boolean isStreetCand = DataSetUtils.isStreetDataSetItem(cand);
        boolean isGeoCand = DataSetUtils.isGeographicDataSetItem(cand);
        if (isPOICand && !this.passInitialPOICandidateCheck(cand, parsedAddr, scorer, matchingOptions)) {
            return;
        }
        if (isStreetCand && !this.passInitialStreetCandidateCheck(cand, parsedAddr, scorer, matchingOptions)) {
            return;
        }
        this.scorePostalFields(cand, parsedAddr, matchingOptions, scorer);
        if (parsedAddr.getProbablePostcodes() != null && cand.getField(FieldType.POST_CODE_FIELD_TYPE) != null && (cand.getFieldScore(FieldType.POST_CODE_FIELD_TYPE) == null || cand.getFieldScore((FieldType)FieldType.POST_CODE_FIELD_TYPE).m_value < 1.0)) {
            List<PostCode> postcodeList = parsedAddr.getProbablePostcodes();
            FieldScore score = null;
            for (PostCode postCode : postcodeList) {
                AddressWord[] cnadPCWords = (AddressWord[])((InternalFieldValue)cand.getField(FieldType.POST_CODE_FIELD_TYPE)).getFieldValue();
                score = scorer.scoreAddressWords(postCode.getWords(), cnadPCWords, FieldType.POST_CODE_FIELD_TYPE, null);
                if (score.m_value != 1.0) continue;
                score.m_matched = true;
                cand.setFieldScore(FieldType.POST_CODE_FIELD_TYPE, score);
            }
        }
        if ((isPOICand || isSGCand || isStreetCand) && !this.removeStateLevelFalsePositive(cand, matchingOptions.getGeocodeOptions())) {
            return;
        }
        boolean locMatchFound = false;
        if (IND_Matcher1.acceptableAreaScore(cand, FieldType.AREA_NAME_4_FIELD_TYPE, true)) {
            locMatchFound = true;
        }
        matchingOptions.setAdditionalOption(LOCALITY_MATCH_FOUND, locMatchFound ? "true" : "false");
        if (isSGCand && !this.passSGCandidateCheck(parsedAddr, cand, scorer, matchingOptions.getGeocodeOptions())) {
            return;
        }
        this.scoreStreetFields(cand, parsedAddr, matchingOptions, scorer);
        boolean shouldproceed = this.filterCandIfLocalityNotMatched(parsedAddr, cand, scorer, isSGCand);
        if (!shouldproceed) {
            return;
        }
        boolean filterCand = this.filterLocalityCandidateForAbbreviation(cand, FieldType.AREA_NAME_4_FIELD_TYPE, matchingOptions.getGeocodeOptions());
        if (filterCand) {
            return;
        }
        this.adjustNumericLocalityScore(cand);
        if (isGeoCand && !this.passGeoCandidateCheck(parsedAddr, cand, scorer, matchingOptions.getGeocodeOptions())) {
            return;
        }
        if (isPOICand && !this.passPOICandidateCheck(parsedAddr, cand, scorer, matchingOptions)) {
            return;
        }
        if (isStreetCand && !this.passStreetCandidateCheck(cand, scorer, matchingOptions, parsedAddr)) {
            return;
        }
        if (!isSGCand) {
            this.scoreRanges(cand, parsedAddr, matchingOptions, scorer);
        }
        if (DataSetUtils.isStreetGeocodingCandidate(cand) && !isSGCand) {
            this.adjustScores(cand, parsedAddr, matchingOptions);
        }
        this.calculateCombinedPostAddressScore(cand, parsedAddr, matchingOptions);
        this.calculateCombinedStreetScore(cand, parsedAddr, matchingOptions);
        this.calculateDictionaryUsagePriority(cand, dataManager, matchingOptions);
    }

    private boolean filterLocalityCandidateForAbbreviation(InternalScoringAddress cand, FieldType type, GeocodeOptions options) {
        FieldScore score = cand.getFieldScore(type);
        boolean isNumericMatchWord = false;
        if (score != null && score.m_value > 0.0) {
            AddressWord[] candWords = score.m_candWords;
            double w = 0.0;
            for (AddressWord word : candWords) {
                if (!CodedWord.isNumber(word.getCodedWord().getAttributes()) && !CodedWord.isNumeric(word.getCodedWord().getAttributes())) continue;
                AddressWord[] inputWords = score.m_inputWords;
                IntArray matchedIdxs = score.m_matchedInputWords;
                int size = matchedIdxs.size();
                if (size <= 1) {
                    return false;
                }
                for (int i = 0; i < size; ++i) {
                    int j = matchedIdxs.get(i);
                    if (CodedWord.isNumber(inputWords[j].getCodedWord().getAttributes()) || CodedWord.isNumeric(inputWords[j].getCodedWord().getAttributes()) || !CodedWord.isAbbreviation(inputWords[j].getCodedWord().getAttributes()) || inputWords[j].getWordLength() != 1) continue;
                    isNumericMatchWord = true;
                }
            }
        }
        return isNumericMatchWord;
    }

    @Override
    protected double moderateMissingFieldWeight(InternalScoringAddress scoringAddr, double calculatedMissingFieldWeight, double actualMissingWeight, boolean hasSeperatePostalFields) {
        if (!hasSeperatePostalFields && DataSetUtils.isGeographicDataSetItem(scoringAddr)) {
            calculatedMissingFieldWeight = actualMissingWeight;
        }
        return calculatedMissingFieldWeight;
    }

    @Override
    protected int weightedFieldWeightsAtLevel(ScoringItem scoringItem, FieldType.FieldLevel level, MatchingOptions matchOptions, boolean hasSeperatePostalFields) {
        int n = 0;
        if (DataSetUtils.isGeographicDataSetItem(scoringItem) && !hasSeperatePostalFields) {
            List<FieldType> postalFields = FieldType.getPredefinedFieldTypes(FieldType.FieldLevel.LEVEL_POSTAL);
            for (FieldType type : postalFields) {
                if (!(matchOptions.getFieldWeight(type) > 1.0E-4)) continue;
                ++n;
            }
            return n;
        }
        return super.weightedFieldWeightsAtLevel(scoringItem, level, matchOptions, hasSeperatePostalFields);
    }

    @Override
    protected int incrementInputFieldsAvailable(InternalScoringAddress scoringAddr, FieldType type, int inputFieldsAvailable) {
        if (DataSetUtils.isGeographicDataSetItem(scoringAddr) && null == scoringAddr.getField(type)) {
            return inputFieldsAvailable;
        }
        return super.incrementInputFieldsAvailable(scoringAddr, type, inputFieldsAvailable);
    }

    @Override
    protected double combineFieldWeightsAtLevel(ScoringItem scoringItem, FieldType.FieldLevel level, MatchingOptions matchOptions, boolean hasSeperatePostalFields) {
        if (DataSetUtils.isGeographicDataSetItem(scoringItem) && !hasSeperatePostalFields) {
            double totalWeight = 0.0;
            List<FieldType> postalFields = FieldType.getPredefinedFieldTypes(FieldType.FieldLevel.LEVEL_POSTAL);
            for (FieldType type : postalFields) {
                totalWeight += matchOptions.getFieldWeight(type);
            }
            return totalWeight;
        }
        return super.combineFieldWeightsAtLevel(scoringItem, level, matchOptions, hasSeperatePostalFields);
    }

    @Override
    protected double adjustScoreOnMissingInputs(InternalScoringAddress scoringAddr, boolean hasSeperatePostalFields, List<AddressWord[]> matchedInputWords, double missingFieldsWeight, int matchedWordCount, int inputWordCount) {
        if (!hasSeperatePostalFields && matchedWordCount < inputWordCount && !this.areNonMatchedWordsIgnorable(matchedInputWords, scoringAddr)) {
            return missingFieldsWeight * 0.25;
        }
        if (!hasSeperatePostalFields && DataSetUtils.isGeographicDataSetItem(scoringAddr) && matchedWordCount == inputWordCount) {
            return 0.0;
        }
        return missingFieldsWeight * 0.1;
    }

    @Override
    protected boolean areNonMatchedWordsIgnorable(List<AddressWord[]> inputList, InternalScoringAddress addr) {
        boolean retVal = false;
        if (DataSetUtils.isGeographicDataSetItem(addr)) {
            if (null != addr.getField(FieldType.AREA_NAME_4_FIELD_TYPE)) {
                List<FieldType> postalFields = FieldType.getPredefinedFieldTypes(FieldType.FieldLevel.LEVEL_POSTAL);
                for (FieldType type : postalFields) {
                    if (type == FieldType.AREA_NAME_4_FIELD_TYPE || null == addr.getFieldScore(type) || !(addr.getFieldScore((FieldType)type).m_value > 0.0)) continue;
                    retVal = true;
                    break;
                }
                if (!retVal) {
                    retVal = super.areNonMatchedWordsIgnorable(inputList, addr);
                }
            } else {
                retVal = true;
            }
        } else {
            retVal = super.areNonMatchedWordsIgnorable(inputList, addr);
        }
        return retVal;
    }

    @Override
    protected double calculateUnmatchedWordWeight(MatchedWordStats matchWordStats, double matchWordWeight, InternalScoringAddress scoringAddr) {
        if (DataSetUtils.isGeographicDataSetItem(scoringAddr)) {
            return 0.0;
        }
        return super.calculateUnmatchedWordWeight(matchWordStats, matchWordWeight, scoringAddr);
    }

    @Override
    protected boolean isFieldMatch(FieldScore score) {
        boolean retVal = super.isFieldMatch(score);
        if (retVal) {
            IntArray matchedIdxs = score.m_matchedInputWords;
            if (null == matchedIdxs) {
                return retVal;
            }
            matchedIdxs.sort();
            int size = matchedIdxs.size();
            AddressWord[] inputWords = score.m_inputWords;
            for (int i = 1; i < size; ++i) {
                int diff = Math.abs(matchedIdxs.get(i) - matchedIdxs.get(i - 1));
                if (diff <= 1) continue;
                for (int j = matchedIdxs.get(i - 1) + 1; j < matchedIdxs.get(i); ++j) {
                    if (!CodedWord.isDelimiter(inputWords[j].getCodedWord().getAttributes())) continue;
                    --diff;
                }
                if (1 == diff) continue;
                retVal = false;
                break;
            }
        }
        return retVal;
    }

    public void scoreAPCandidate(ParsedAddress parsedAddr, InternalScoringAddress cand, MatchingOptions matchingOptions, ICGGEScorer scorer, IDataManager dataManager) throws CGGEInternalException {
        boolean flag;
        boolean townFlag;
        double v;
        this.scoreRanges(cand, parsedAddr, matchingOptions, scorer);
        double d = v = cand.getFieldScore(FieldType.ADDRESS_NUMBER_FIELD_TYPE) != null ? cand.getFieldScore((FieldType)FieldType.ADDRESS_NUMBER_FIELD_TYPE).m_value : 0.0;
        if (v < 1.0) {
            return;
        }
        this.scorePostalFields(cand, parsedAddr, matchingOptions, scorer);
        this.scoreStreetFields(cand, parsedAddr, matchingOptions, scorer);
        FieldScore localityScore = cand.getFieldScore(FieldType.AREA_NAME_4_FIELD_TYPE);
        FieldScore postalScore = cand.getFieldScore(FieldType.POST_CODE_FIELD_TYPE);
        if (localityScore != null && localityScore.m_value < 1.0) {
            this.adjustNumericLocalityScore(cand);
            if (localityScore.m_value == 0.0) {
                return;
            }
        }
        if (localityScore == null || localityScore.m_value < 0.85) {
            townFlag = IND_Matcher1.acceptableAreaScore(cand, FieldType.AREA_NAME_3_FIELD_TYPE, true);
            boolean postalFlag = IND_Matcher1.acceptableAreaScore(cand, FieldType.POST_CODE_FIELD_TYPE, true);
            if (!townFlag || !postalFlag) {
                return;
            }
        }
        if (postalScore == null || postalScore.m_value < (double)0.99f) {
            townFlag = IND_Matcher1.acceptableAreaScore(cand, FieldType.AREA_NAME_3_FIELD_TYPE, true);
            boolean localityFlag = IND_Matcher1.acceptableAreaScore(cand, FieldType.AREA_NAME_4_FIELD_TYPE, true);
            if (!townFlag || !localityFlag) {
                return;
            }
        }
        if ((flag = this.passStreetCandidateCheckforAP(parsedAddr, cand, scorer, matchingOptions.getGeocodeOptions())) && (flag = this.passPOICandidateCheckforAP(parsedAddr, cand, scorer, matchingOptions))) {
            flag = this.passSGCandidateCheckforAP(parsedAddr, cand, scorer, matchingOptions.getGeocodeOptions());
        }
        if (!flag) {
            return;
        }
        this.adjustScores(cand, parsedAddr, matchingOptions);
        this.calculateCombinedPostAddressScore(cand, parsedAddr, matchingOptions);
        this.calculateCombinedStreetScore(cand, parsedAddr, matchingOptions);
        this.calculateDictionaryUsagePriority(cand, dataManager, matchingOptions);
    }

    @Override
    protected void scoreRangeList(int rangeCount, LinkedList<InternalScoringRange> sortedRanges, InternalScoringAddress scoringAddr, ParsedAddress parsedAddr, MatchingOptions matchingOptions, ICGGEScorer scorer, Comparator<InternalScoringRange> reverseComparator) {
        for (int i = 0; i < rangeCount; ++i) {
            InternalScoringRange range = scoringAddr.getRangeAt(i);
            this.scoreRange(scoringAddr, range, parsedAddr, matchingOptions, scorer);
            this.calculateCombinedRangeScore(range, parsedAddr, matchingOptions);
            this.calculateRangeCloseMatch(range, parsedAddr, matchingOptions);
            int ndx = MMUtils.nextInsertPosition(sortedRanges, range, reverseComparator);
            sortedRanges.add(ndx, range);
            FieldScore rangeScore = range.getFieldScore(FieldType.ADDRESS_NUMBER_FIELD_TYPE);
            if (null != rangeScore && 1.0 == rangeScore.m_value) break;
        }
    }

    protected AddressNumber findAdditionalProbables(AddressNumber addrNum, List<AddressNumber> list, int lastMatchedBeforeStreet, int firstMatchedAfterStreet, boolean preferFirst) {
        if (null == addrNum && lastMatchedBeforeStreet > 0) {
            addrNum = this.findFromProbables(list, -1, lastMatchedBeforeStreet, preferFirst);
        }
        return addrNum;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean filterCandIfLocalityNotMatched(ParsedAddress parsedAddr, InternalScoringAddress cand, ICGGEScorer scorer, boolean isSGCand) {
        boolean localityflag;
        if (parsedAddr.isIntersectionCase() || !(localityflag = this.doesLocalityPresentInUnMatchedWords(cand, scorer, parsedAddr))) return true;
        FieldScore locScore = cand.getFieldScore(FieldType.AREA_NAME_4_FIELD_TYPE);
        if (locScore == null) {
            if (!isSGCand) return false;
            FieldScore score = cand.getFieldScore(FieldType.GENERIC_FIELD_4_FIELD_TYPE);
            if (score != null && score.m_value >= 0.85) return true;
            return false;
        }
        if (!(locScore.m_value < 0.85)) return true;
        return false;
    }

    private void adjustNumericLocalityScore(InternalScoringAddress cand) {
        if (this.scoreWeightedOnNumericWord(cand, FieldType.AREA_NAME_4_FIELD_TYPE) && !IND_Matcher1.acceptableAreaScore(cand, FieldType.AREA_NAME_4_FIELD_TYPE, true)) {
            FieldScore score = cand.getFieldScore(FieldType.AREA_NAME_4_FIELD_TYPE);
            score.m_value = 0.0;
        }
    }

    private boolean acceptPlaceNameScore(InternalScoringAddress cand, FieldScore score, ICGGEScorer scorer, GeocodeOptions options) {
        double v = score.m_value;
        if (v >= 1.0) {
            return true;
        }
        return v >= 0.89 && IND_Matcher1.exactNumericMatch(score) && this.matchLastCommonWord(score, scorer) && this.matchedOnMostWordsForPOI(score);
    }

    private boolean acceptStreetNameScore(InternalScoringAddress cand, FieldScore score, ICGGEScorer scorer, GeocodeOptions options) {
        double v = score.m_value;
        if (v >= 1.0) {
            return true;
        }
        return v >= 0.85 && IND_Matcher1.exactNumericMatch(score);
    }

    private boolean matchLastCommonWord(FieldScore score, ICGGEScorer scorer) {
        AddressWord[] candWords = score.m_candWords;
        AddressWord[] inputWords = score.m_inputWords;
        int ndx = this.getLastCommonWordNdx(candWords);
        if (ndx > -1) {
            if (!IND_Matcher1.contains(score.m_perfectCandWords, ndx)) {
                AddressWord canWord;
                AddressWord lastInputWord;
                double v;
                int lastInputWordNdx;
                return IND_Matcher1.contains(score.m_matchedCandWords, ndx) && (lastInputWordNdx = this.getLastMatchedInputWord(score)) > -1 && (v = scorer.scoreAddressWords(lastInputWord = inputWords[lastInputWordNdx], canWord = candWords[ndx])) >= 0.9;
            }
        } else {
            AddressWord canWord;
            double v;
            AddressWord lastInputWord;
            ndx = this.getLastMatchedInputWord(score);
            if (ndx > -1 && !IND_Matcher1.contains(score.m_perfectInputWords, ndx) && !AddressWord.isSignificantWord(lastInputWord = inputWords[ndx]) && (v = scorer.scoreAddressWords(lastInputWord, canWord = candWords[candWords.length - 1])) < 0.9) {
                return false;
            }
        }
        return true;
    }

    private boolean matchFirstCommonWord(FieldScore score, ICGGEScorer scorer) {
        AddressWord[] candWords = score.m_candWords;
        AddressWord[] inputWords = score.m_inputWords;
        int ndx = this.getFirstCommonWordNdx(candWords);
        if (ndx > -1) {
            if (!IND_Matcher1.contains(score.m_perfectCandWords, ndx)) {
                AddressWord canWord;
                AddressWord lastInputWord;
                double v;
                int lastInputWordNdx;
                return IND_Matcher1.contains(score.m_matchedCandWords, ndx) && (lastInputWordNdx = this.getLastMatchedInputWord(score)) > -1 && (v = scorer.scoreAddressWords(lastInputWord = inputWords[lastInputWordNdx], canWord = candWords[ndx])) >= 0.9;
            }
        } else {
            AddressWord canWord;
            double v;
            AddressWord lastInputWord;
            ndx = this.getFirstMatchedInputWord(score);
            if (ndx > -1 && !IND_Matcher1.contains(score.m_perfectInputWords, ndx) && !AddressWord.isSignificantWord(lastInputWord = inputWords[ndx]) && (v = scorer.scoreAddressWords(lastInputWord, canWord = candWords[candWords.length - 1])) < 0.9) {
                return false;
            }
        }
        return true;
    }

    private int getLastMatchedInputWord(FieldScore score) {
        int lastWordNdx = -1;
        IntArray matchedWordArray = score.m_matchedInputWords;
        if (matchedWordArray != null && !matchedWordArray.isEmpty()) {
            lastWordNdx = matchedWordArray.getLast();
        }
        return lastWordNdx;
    }

    private int getFirstMatchedInputWord(FieldScore score) {
        IntArray matchedWordArray = score.m_matchedInputWords;
        int firstWordNdx = -1;
        if (matchedWordArray != null && !matchedWordArray.isEmpty()) {
            firstWordNdx = matchedWordArray.getFirst();
        }
        return firstWordNdx;
    }

    private static boolean contains(IntArray array, int v) {
        return array != null && array.contains(v);
    }

    private int getLastCommonWordNdx(AddressWord[] candWords) {
        int len = candWords.length;
        for (int i = len - 1; i >= 0; --i) {
            AddressWord word = candWords[i];
            short attribs = word.getAttributes();
            if (CodedWord.isCommonWord(attribs)) {
                return i;
            }
            if (CodedWord.isDelimiter(attribs)) continue;
            return -1;
        }
        return -1;
    }

    private int getFirstCommonWordNdx(AddressWord[] candWords) {
        int len = candWords.length;
        for (int i = 0; i < len; ++i) {
            AddressWord word = candWords[i];
            short attribs = word.getAttributes();
            if (CodedWord.isCommonWord(attribs) || CodedWord.isArticleWord(attribs)) {
                return i;
            }
            if (CodedWord.isDelimiter(attribs)) continue;
            return -1;
        }
        return -1;
    }

    private AddressWord[] getPlaceNameInputWords(ParsedAddress parsedAddr, InternalScoringAddress cand) {
        AddressWord[] placeWords = (AddressWord[])parsedAddr.getField(FieldType.PLACE_NAME_FIELD_TYPE);
        return placeWords != null ? placeWords : (AddressWord[])parsedAddr.getField(FieldType.STREET_NAME_FIELD_TYPE);
    }

    @Override
    protected boolean passMustMatchContraints(InternalScoringAddress scoringAddr, MatchingOptions matchOptions) {
        boolean pass;
        GeocodeOptions options = matchOptions.getGeocodeOptions();
        boolean mustMatchStreetReset = false;
        if (DataSetUtils.isPOIDataSetItem(scoringAddr) && options.isMustMatchStreetName() && scoringAddr.isEmpty(FieldType.STREET_NAME_FIELD_TYPE)) {
            options.getGeocodeConstraints().setMustMatchMainAddress(false);
            options.getGeocodeConstraints().setMustMatchInput(false);
            mustMatchStreetReset = true;
        }
        if (pass = super.passMustMatchContraints(scoringAddr, matchOptions)) {
            FieldScore score;
            GeocodeOptions geoOptions = matchOptions.getGeocodeOptions();
            IConstraints cons = geoOptions.getGeocodeConstraints();
            String mustMatchPlaceName = cons.getCustomString("MustMatchPlaceName", "FALSE");
            if ("true".equalsIgnoreCase(mustMatchPlaceName) && (score = scoringAddr.getFieldScore(FieldType.PLACE_NAME_FIELD_TYPE)) != null && !score.m_matched) {
                pass = false;
            }
            if (pass) {
                pass = this.passSLMatchConstraint(scoringAddr, cons);
            }
        }
        if (mustMatchStreetReset) {
            options.getGeocodeConstraints().setMustMatchMainAddress(true);
        }
        return pass;
    }

    private boolean passSLMatchConstraint(InternalScoringAddress scoringAddr, IConstraints cons) {
        double combinedSLScore;
        String mustMatchSubLocality = cons.getCustomString("MustMatchSubLocality", "FALSE");
        return !"true".equalsIgnoreCase(mustMatchSubLocality) || !((combinedSLScore = IND_Matcher1.calculateCombinedSubLocalityScore(scoringAddr)) > 0.0) || !(combinedSLScore < 1.0);
    }

    public static double calculateCombinedSubLocalityScore(InternalScoringAddress scoringAddr) {
        Map<FieldType, FieldScore> fieldMap = scoringAddr.getFieldScores();
        int numberofFields = 0;
        double combinedScore = 0.0;
        if (fieldMap != null && fieldMap.size() > 0) {
            for (Map.Entry<FieldType, FieldScore> entry : fieldMap.entrySet()) {
                FieldType type = entry.getKey();
                FieldScore score = entry.getValue();
                if (score == null || !DataSetUtils.isSubLocalityField(type)) continue;
                combinedScore += score.m_value;
                ++numberofFields;
            }
            if (numberofFields > 0) {
                combinedScore /= (double)numberofFields;
            }
        }
        return combinedScore;
    }

    private boolean passSGCandidateCheck(ParsedAddress parsedAddr, InternalScoringAddress cand, ICGGEScorer scorer, GeocodeOptions options) {
        if (this.doesSearchedLocalityHasGoodQualityScore(cand, scorer, options)) {
            return true;
        }
        this.reScoreSublocality(parsedAddr, cand);
        return this.doesSearchedLocalityHasGoodQualityScore(cand, scorer, options);
    }

    private List<AddressWord> returnCommonWords(AddressWord[] addressWord) {
        ArrayList<AddressWord> commonWords = new ArrayList<AddressWord>();
        if (addressWord == null) {
            return commonWords;
        }
        int len = addressWord.length;
        for (int i = len - 1; i >= 0; --i) {
            AddressWord word = addressWord[i];
            short attribs = word.getAttributes();
            if (!CodedWord.isCommonWord(attribs)) continue;
            commonWords.add(word);
        }
        return commonWords;
    }

    private List<AddressWord> returnSignificantWords(AddressWord[] addressWord) {
        ArrayList<AddressWord> significantWords = new ArrayList<AddressWord>();
        if (addressWord == null) {
            return significantWords;
        }
        int len = addressWord.length;
        for (int i = len - 1; i >= 0; --i) {
            AddressWord word = addressWord[i];
            if (!AddressWord.isSignificantWord(word)) continue;
            significantWords.add(word);
        }
        return significantWords;
    }

    private List<AddressWord> returnThroughFareWords(AddressWord[] addressWord) {
        int len = addressWord.length;
        ArrayList<AddressWord> throughFareWords = new ArrayList<AddressWord>();
        for (int i = len - 1; i >= 0; --i) {
            AddressWord word = addressWord[i];
            short attribs = word.getAttributes();
            if (!CodedWord.isThoroughfareTypeWord(attribs)) continue;
            throughFareWords.add(word);
        }
        return throughFareWords;
    }

    private boolean passInitialPOICandidateCheck(InternalScoringAddress cand, ParsedAddress parsedAddr, ICGGEScorer scorer, MatchingOptions matchingOptions) {
        AddressWord[] streetInputWords;
        AddressWord[] placeInputWords = this.getPlaceNameInputWords(parsedAddr, cand);
        FieldScore score = this.scoreCandField(placeInputWords, cand, FieldType.PLACE_NAME_FIELD_TYPE, null, scorer);
        if (score == null || !this.acceptPlaceNameScore(cand, score, scorer, matchingOptions.getGeocodeOptions())) {
            return false;
        }
        boolean isStreetPresent = ((IND_ParsedAddress)parsedAddr).isStreetPresent();
        return !isStreetPresent || null == (score = this.scoreCandField(streetInputWords = (AddressWord[])parsedAddr.getField(FieldType.STREET_NAME_FIELD_TYPE), cand, FieldType.STREET_NAME_FIELD_TYPE, null, scorer)) || this.acceptStreetNameScore(cand, score, scorer, matchingOptions.getGeocodeOptions());
    }

    private boolean passInitialStreetCandidateCheck(InternalScoringAddress cand, ParsedAddress parsedAddr, ICGGEScorer scorer, MatchingOptions matchingOptions) {
        AddressWord[] streetInputWords = (AddressWord[])parsedAddr.getField(FieldType.STREET_NAME_FIELD_TYPE);
        FieldScore score = this.scoreCandField(streetInputWords, cand, FieldType.STREET_NAME_FIELD_TYPE, null, scorer);
        if (null == score) {
            return false;
        }
        return this.acceptStreetNameScore(cand, score, scorer, matchingOptions.getGeocodeOptions());
    }

    private boolean passPOICandidateCheck(ParsedAddress parsedAddr, InternalScoringAddress cand, ICGGEScorer scorer, MatchingOptions options) {
        boolean acceptablePOI = false;
        if (DataSetUtils.isPOIDataSetItem(cand)) {
            double v;
            FieldScore score = cand.getFieldScore(FieldType.PLACE_NAME_FIELD_TYPE);
            double d = v = score != null ? score.m_value : 0.0;
            if (v < 0.89) {
                return false;
            }
            boolean singleWordPOICand = this.isSingleWordPOIField(cand);
            boolean matchedOnAllWord = IND_Matcher1.matchedOnAllWords(score);
            boolean matchedOnSignificantWord = this.matchedOnSignificantWords(score, cand);
            boolean checkAreas = singleWordPOICand || !IND_Matcher1.matchedOnAllWords(score);
            AddressWord[] placeInputWords = this.getPlaceNameInputWords(parsedAddr, cand);
            AddressWord[] areaFilteredPlaceWords = this.removeAreaWordsFromPlaceNames(placeInputWords, parsedAddr);
            List<AddressWord> commonPOIPart = this.returnCommonWords(areaFilteredPlaceWords);
            List<AddressWord> significantPOIPart = this.returnSignificantWords(areaFilteredPlaceWords);
            boolean acceptLocalityScore = IND_Matcher1.acceptableAreaScore(cand, FieldType.AREA_NAME_4_FIELD_TYPE, true);
            boolean acceptPlaceNameScore = this.acceptPlaceNameScore(cand, score, scorer, options.getGeocodeOptions());
            Map<FieldType, List<AddressWord[]>> areaMap = ((IND_ParsedAddress)parsedAddr).getM_areaListMap();
            boolean isLocListEmpty = areaMap.get(INDStreetGeocodingHelper.LOCALITY_FIELD) == null;
            InternalFieldValue poiCand = (InternalFieldValue)cand.getField(FieldType.PLACE_NAME_FIELD_TYPE);
            boolean isCommonPOIExistInCand = this.addressWordsExistInCand(commonPOIPart, poiCand);
            boolean isSignificantPOIExistInCand = this.addressWordsExistInCand(significantPOIPart, poiCand);
            FieldScore sl_score = cand.getFieldScore(FieldType.GENERIC_FIELD_3_FIELD_TYPE);
            if (sl_score != null && sl_score.m_value > 0.85 && !IND_Matcher1.exactMatchOnWords(sl_score)) {
                return false;
            }
            if (!isLocListEmpty) {
                if (!commonPOIPart.isEmpty() && !significantPOIPart.isEmpty() && acceptLocalityScore && acceptPlaceNameScore) {
                    acceptablePOI = true;
                }
                if (commonPOIPart.isEmpty() && !significantPOIPart.isEmpty() && acceptLocalityScore && acceptPlaceNameScore) {
                    acceptablePOI = true;
                }
                if (!commonPOIPart.isEmpty() && significantPOIPart.isEmpty() && acceptLocalityScore && acceptPlaceNameScore) {
                    acceptablePOI = true;
                }
            } else {
                if (!commonPOIPart.isEmpty() && !significantPOIPart.isEmpty() && acceptPlaceNameScore && isCommonPOIExistInCand && isSignificantPOIExistInCand) {
                    acceptablePOI = true;
                }
                if (commonPOIPart.isEmpty() && !significantPOIPart.isEmpty() && acceptPlaceNameScore) {
                    acceptablePOI = true;
                }
                if (!commonPOIPart.isEmpty() && significantPOIPart.isEmpty() && acceptPlaceNameScore) {
                    acceptablePOI = true;
                }
            }
            if (!acceptablePOI) {
                if (checkAreas && !IND_Matcher1.acceptableAreaScore(cand, FieldType.AREA_NAME_4_FIELD_TYPE, true) && !IND_Matcher1.acceptableAreaScore(cand, FieldType.POST_CODE_FIELD_TYPE, true) && IND_Matcher1.acceptableAreaScore(cand, FieldType.AREA_NAME_3_FIELD_TYPE, false)) {
                    return false;
                }
                if (!(!(v <= 1.0) || !singleWordPOICand && matchedOnAllWord && matchedOnSignificantWord && IND_Matcher1.acceptableAreaScore(cand, FieldType.POST_CODE_FIELD_TYPE, true) || !"true".equals(options.getGeocodeOptions().getProperty("matchable_locality_found")) || "true".equals(options.getAdditionalOption(LOCALITY_MATCH_FOUND)))) {
                    return false;
                }
            }
            acceptablePOI = true;
        }
        return acceptablePOI;
    }

    private boolean addressWordsExistInCand(List<AddressWord> commonPOIPart, InternalFieldValue candPOI) {
        int poiMatchCount = 0;
        block0: for (AddressWord addressWord : commonPOIPart) {
            AddressWord[] candidatePOIs = (AddressWord[])candPOI.getFieldValue();
            if (candidatePOIs == null) continue;
            for (AddressWord areaWordcandPOI : candidatePOIs) {
                if (!areaWordcandPOI.getWord().equals(addressWord.getWord())) continue;
                ++poiMatchCount;
                continue block0;
            }
        }
        return poiMatchCount == commonPOIPart.size();
    }

    private List<AddressWord[]> getAreaList(ParsedAddress parsedAddr) {
        Map<FieldType, List<AddressWord[]>> areaMap = ((IND_ParsedAddress)parsedAddr).getM_areaListMap();
        ArrayList<AddressWord[]> areaList = null;
        int length = areaMap.size();
        if (length > 0) {
            areaList = new ArrayList<AddressWord[]>();
        }
        for (Map.Entry<FieldType, List<AddressWord[]>> mapEntry : areaMap.entrySet()) {
            List<AddressWord[]> list = mapEntry.getValue();
            areaList.addAll(list);
        }
        return areaList;
    }

    private AddressWord[] removeAreaWordsFromPlaceNames(AddressWord[] searchWords, ParsedAddress parsedAddr) {
        List<AddressWord[]> areaList = this.getAreaList(parsedAddr);
        if (null == areaList || null == searchWords) {
            return searchWords;
        }
        searchWords = (AddressWord[])searchWords.clone();
        int searchWordsLen = searchWords.length;
        int removed = 0;
        for (int i = 0; i < areaList.size(); ++i) {
            AddressWord[] area;
            for (AddressWord areaWord : area = areaList.get(i)) {
                for (int ndx = 0; ndx < searchWordsLen; ++ndx) {
                    if (searchWords[ndx] == null || !areaWord.getWord().equals(searchWords[ndx].getWord())) continue;
                    searchWords[ndx] = null;
                    ++removed;
                }
            }
        }
        if (removed > 0) {
            int remaining = searchWordsLen - removed;
            if (remaining > 0) {
                AddressWord[] filteredWords = new AddressWord[remaining];
                int added = 0;
                for (int ndx = 0; ndx < searchWordsLen; ++ndx) {
                    AddressWord word = searchWords[ndx];
                    if (word == null) continue;
                    filteredWords[added++] = word;
                }
                searchWords = filteredWords;
            } else {
                searchWords = null;
            }
        }
        return searchWords;
    }

    private boolean passStreetCandidateCheck(InternalScoringAddress cand, ICGGEScorer scorer, MatchingOptions options, ParsedAddress parsedAddr) {
        if (DataSetUtils.isStreetDataSetItem(cand)) {
            boolean checkAreas;
            double v;
            FieldScore score = cand.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE);
            double d = v = score != null ? score.m_value : 0.0;
            if (v < 0.85) {
                return false;
            }
            boolean singleWordStreetCand = this.isSingleWordStreetField(cand);
            boolean matchedOnAllWord = IND_Matcher1.matchedOnAllWords(score);
            boolean matchedOnSignificantWord = this.matchedOnSignificantWords(score, cand);
            boolean bl = checkAreas = singleWordStreetCand || !IND_Matcher1.matchedOnAllWords(score);
            if (checkAreas && !IND_Matcher1.acceptableAreaScore(cand, FieldType.AREA_NAME_4_FIELD_TYPE, true) && !IND_Matcher1.acceptableAreaScore(cand, FieldType.POST_CODE_FIELD_TYPE, true) && IND_Matcher1.acceptableAreaScore(cand, FieldType.AREA_NAME_3_FIELD_TYPE, false)) {
                return false;
            }
            if (v <= 1.0) {
                if (!(!singleWordStreetCand && matchedOnAllWord && matchedOnSignificantWord && IND_Matcher1.acceptableAreaScore(cand, FieldType.POST_CODE_FIELD_TYPE, true) || !"true".equals(options.getGeocodeOptions().getProperty("matchable_locality_found")) || "true".equals(options.getAdditionalOption(LOCALITY_MATCH_FOUND)))) {
                    return this.acceptLocality(cand);
                }
                if ("true".equals(options.getGeocodeOptions().getProperty("matchable_locality_found")) && !"true".equals(options.getAdditionalOption(LOCALITY_MATCH_FOUND))) {
                    return this.acceptLocality(cand);
                }
            }
            boolean retVal = this.handleCaseForNumericSearchWord(cand, parsedAddr, options);
            return retVal;
        }
        return true;
    }

    private boolean handleCaseForNumericSearchWord(InternalScoringAddress cand, ParsedAddress parsedAddr, MatchingOptions options) {
        boolean retVal = true;
        if (this.hasSeperateAreaFields(parsedAddr)) {
            List<AddressWord> searchWords = cand.getSearchWords();
            Pattern NUMERIC_PATTERN = Pattern.compile("[A-Z]*[0-9]+[A-Z]*");
            if (!ListUtils.isEmpty(searchWords)) {
                for (AddressWord addWord : searchWords) {
                    Matcher matcher;
                    boolean isNumeral;
                    boolean bl = isNumeral = addWord.isNumeral() || "true".equals(options.getGeocodeOptions().getProperty("NUMERIC_STREET_CASE"));
                    if (!isNumeral && (matcher = NUMERIC_PATTERN.matcher(addWord.getWord())).find()) {
                        isNumeral = true;
                    }
                    if (!isNumeral) continue;
                    FieldScore score = cand.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE);
                    AddressWord[] candWords = score.m_candWords;
                    if (null != candWords) {
                        for (AddressWord candWord : candWords) {
                            if (!CodedWord.isThoroughfareTypeWord(candWord.getCodedWord().getAttributes())) continue;
                            IntArray streetMatchIndx = score.m_matchedInputWords;
                            AddressWord[] inputWords = score.m_inputWords;
                            boolean isThoroughTypeMatched = false;
                            if (null != streetMatchIndx) {
                                for (int indx : streetMatchIndx) {
                                    AddressWord word;
                                    if (inputWords.length <= indx || !CodedWord.isThoroughfareTypeWord((word = inputWords[indx]).getCodedWord().getAttributes())) continue;
                                    isThoroughTypeMatched = true;
                                    break;
                                }
                            }
                            retVal = isThoroughTypeMatched;
                            break;
                        }
                    }
                    if (!(score.m_value < 0.95)) continue;
                    FieldScore postScore = cand.getFieldScore(FieldType.POST_CODE_FIELD_TYPE);
                    if (postScore == null || postScore.m_value < 1.0) {
                        retVal = false;
                        continue;
                    }
                    retVal = true;
                }
            }
        }
        return retVal;
    }

    private boolean doesLocalityPresentInUnMatchedWords(InternalScoringAddress cand, ICGGEScorer scorer, ParsedAddress parsedAddr) {
        AddressWord[] unMatchedWords = this.findAllUnMatchedWors(cand, null, false);
        boolean confirmCheckForLocality = false;
        List<AddressWord[]> matchedLocalitiesfound = ((IND_ParsedAddress)parsedAddr).getlocalityList();
        if (matchedLocalitiesfound != null && matchedLocalitiesfound.size() > 0) {
            FieldScore localityScore = new FieldScore();
            for (AddressWord[] localities : matchedLocalitiesfound) {
                FieldScore locscore = ((CGGEScorer)scorer).scoreAddressWords(unMatchedWords, localities, FieldType.AREA_NAME_4_FIELD_TYPE, localityScore);
                if (locscore == null || !(locscore.m_value > (double)0.95f) || !IND_Matcher1.exactNumericMatch(locscore)) continue;
                confirmCheckForLocality = true;
                break;
            }
        }
        return confirmCheckForLocality;
    }

    private boolean acceptLocality(InternalScoringAddress cand) {
        double value;
        FieldScore localityScore = cand.getFieldScore(FieldType.AREA_NAME_4_FIELD_TYPE);
        double d = value = localityScore == null ? 0.0 : localityScore.m_value;
        return !(value > 0.0) || !(value < 0.85);
    }

    private boolean isSingleWordPOIField(InternalScoringAddress cand) {
        AddressWord[] candWord;
        int len;
        FieldScore score = cand.getFieldScore(FieldType.PLACE_NAME_FIELD_TYPE);
        return score != null && (len = (candWord = score.m_candWords).length) == 1;
    }

    private boolean isSingleWordStreetField(InternalScoringAddress cand) {
        AddressWord[] candWord;
        int len;
        FieldScore score = cand.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE);
        return score != null && (len = (candWord = score.m_candWords).length) == 1;
    }

    private boolean doesSearchedLocalityHasGoodQualityScore(InternalScoringAddress cand, ICGGEScorer scorer, GeocodeOptions options) {
        List<AddressWord> searchWords = cand.getSearchWords();
        if (searchWords != null) {
            boolean doesInputHasLocality = options.get("matchable_locality_found") != null;
            for (AddressWord searchWord : searchWords) {
                FieldType type = searchWord.m_wordType;
                FieldScore score = cand.getFieldScore(type);
                if (score == null) continue;
                boolean significantWord = AddressWord.isSignificantWord(searchWord);
                double scoreValue = score.m_value;
                if (scoreValue >= 1.0 && significantWord) {
                    boolean isLocalityAcceptable = this.acceptableHigherLocalities1(cand, type, significantWord, doesInputHasLocality);
                    if (!isLocalityAcceptable) {
                        if (!IND_Matcher1.acceptableAreaScore(cand, FieldType.POST_CODE_FIELD_TYPE, true) && IND_Matcher1.acceptableAreaScore(cand, FieldType.AREA_NAME_3_FIELD_TYPE, false)) {
                            return false;
                        }
                        if (doesInputHasLocality && !isLocalityAcceptable) {
                            double value;
                            FieldScore localityScore = cand.getFieldScore(FieldType.AREA_NAME_4_FIELD_TYPE);
                            double d = value = localityScore == null ? 0.0 : localityScore.m_value;
                            if (value > 0.0 && value < 0.85) {
                                return false;
                            }
                        }
                        return true;
                    }
                    return isLocalityAcceptable;
                }
                if (!(scoreValue >= 0.8)) continue;
                if (!(scoreValue >= 1.0) && scoreValue <= 0.95 && !IND_Matcher1.matchedOnAllWords(score)) {
                    return false;
                }
                if (!IND_Matcher1.exactNumericMatch(score) || !significantWord && !this.matchFirstCommonWord(score, scorer)) {
                    return false;
                }
                boolean matchLastCommonWord = this.matchLastCommonWord(score, scorer);
                if (!this.matchedOnSignificantWords(score, cand) && !IND_Matcher1.matchedOnAllWords(score) || !matchLastCommonWord) continue;
                return this.acceptableHigherLocalities1(cand, type, !significantWord || !matchLastCommonWord, doesInputHasLocality);
            }
        }
        return false;
    }

    private boolean acceptableHigherLocalities(InternalScoringAddress cand, FieldType type, boolean mustMatchSubLocalities) {
        if (type == FieldType.GENERIC_FIELD_4_FIELD_TYPE) {
            return IND_Matcher1.acceptableAreaScore(cand, FieldType.AREA_NAME_3_FIELD_TYPE, mustMatchSubLocalities);
        }
        if ("block".equals(type.getName())) {
            FieldType subLocType = cand.getDataSetInfo().getMetaData().getFieldForName("sub_locality");
            if (subLocType != null && !cand.isEmpty(subLocType)) {
                return IND_Matcher1.acceptableAreaScore(cand, subLocType, mustMatchSubLocalities);
            }
            if (!cand.isEmpty(FieldType.GENERIC_FIELD_4_FIELD_TYPE)) {
                return IND_Matcher1.acceptableAreaScore(cand, FieldType.GENERIC_FIELD_4_FIELD_TYPE, mustMatchSubLocalities);
            }
            if (!cand.isEmpty(FieldType.AREA_NAME_4_FIELD_TYPE)) {
                return IND_Matcher1.acceptableAreaScore(cand, FieldType.AREA_NAME_4_FIELD_TYPE, mustMatchSubLocalities);
            }
        } else if ("sub_locality".equals(type.getName())) {
            if (!cand.isEmpty(FieldType.GENERIC_FIELD_4_FIELD_TYPE)) {
                return IND_Matcher1.acceptableAreaScore(cand, FieldType.GENERIC_FIELD_4_FIELD_TYPE, mustMatchSubLocalities);
            }
            if (!cand.isEmpty(FieldType.AREA_NAME_4_FIELD_TYPE)) {
                return IND_Matcher1.acceptableAreaScore(cand, FieldType.AREA_NAME_4_FIELD_TYPE, mustMatchSubLocalities);
            }
        }
        return true;
    }

    private boolean acceptableHigherLocalities1(InternalScoringAddress cand, FieldType type, boolean mustMatchSubLocalities, boolean doesLocalityfoundInGC) {
        if (type == FieldType.GENERIC_FIELD_4_FIELD_TYPE) {
            return IND_Matcher1.acceptableAreaScore(cand, FieldType.AREA_NAME_3_FIELD_TYPE, mustMatchSubLocalities);
        }
        FieldType sublocaluity = cand.getDataSetInfo().getMetaData().getFieldForName("sub_locality");
        boolean sublocalityCheck = sublocaluity != null && !cand.isEmpty(sublocaluity);
        boolean genericField4Check = !cand.isEmpty(FieldType.GENERIC_FIELD_4_FIELD_TYPE);
        boolean localityCheck = !cand.isEmpty(FieldType.AREA_NAME_4_FIELD_TYPE);
        boolean postCodeCheck = !cand.isEmpty(FieldType.POST_CODE_FIELD_TYPE);
        boolean returnFlag = false;
        if ("block".equals(type.getName()) && (sublocalityCheck || genericField4Check)) {
            if (sublocalityCheck ? !(returnFlag = IND_Matcher1.acceptableAreaScore(cand, sublocaluity, mustMatchSubLocalities)) : genericField4Check && !(returnFlag = IND_Matcher1.acceptableAreaScore(cand, sublocaluity, mustMatchSubLocalities))) {
                return returnFlag;
            }
            if (localityCheck) {
                returnFlag = IND_Matcher1.acceptableAreaScore(cand, FieldType.AREA_NAME_4_FIELD_TYPE, mustMatchSubLocalities);
                if (!returnFlag && postCodeCheck && !doesLocalityfoundInGC) {
                    returnFlag = IND_Matcher1.acceptableAreaScore(cand, FieldType.POST_CODE_FIELD_TYPE, mustMatchSubLocalities);
                }
                return returnFlag;
            }
            if (postCodeCheck) {
                returnFlag = IND_Matcher1.acceptableAreaScore(cand, FieldType.POST_CODE_FIELD_TYPE, mustMatchSubLocalities);
            }
            return returnFlag;
        }
        if ("sub_locality".equals(type.getName()) && genericField4Check) {
            returnFlag = IND_Matcher1.acceptableAreaScore(cand, FieldType.GENERIC_FIELD_4_FIELD_TYPE, mustMatchSubLocalities);
            if (returnFlag) {
                return returnFlag;
            }
            if (localityCheck) {
                returnFlag = IND_Matcher1.acceptableAreaScore(cand, FieldType.AREA_NAME_4_FIELD_TYPE, mustMatchSubLocalities);
                if (!returnFlag && postCodeCheck && !doesLocalityfoundInGC) {
                    returnFlag = IND_Matcher1.acceptableAreaScore(cand, FieldType.POST_CODE_FIELD_TYPE, mustMatchSubLocalities);
                }
                return returnFlag;
            }
            if (postCodeCheck) {
                returnFlag = IND_Matcher1.acceptableAreaScore(cand, FieldType.POST_CODE_FIELD_TYPE, mustMatchSubLocalities);
            }
            return returnFlag;
        }
        if (localityCheck) {
            returnFlag = IND_Matcher1.acceptableAreaScore(cand, FieldType.AREA_NAME_4_FIELD_TYPE, mustMatchSubLocalities);
            if (!returnFlag && postCodeCheck) {
                returnFlag = IND_Matcher1.acceptableAreaScore(cand, FieldType.POST_CODE_FIELD_TYPE, mustMatchSubLocalities);
                if (returnFlag && doesLocalityfoundInGC) {
                    if (doesLocalityfoundInGC) {
                        double value;
                        FieldScore localityScore = cand.getFieldScore(FieldType.AREA_NAME_4_FIELD_TYPE);
                        double d = value = localityScore == null ? 0.0 : localityScore.m_value;
                        if (value > 0.0 && value < 0.85) {
                            return false;
                        }
                    }
                    return returnFlag;
                }
                return returnFlag;
            }
            return returnFlag;
        }
        if (postCodeCheck) {
            returnFlag = IND_Matcher1.acceptableAreaScore(cand, FieldType.POST_CODE_FIELD_TYPE, mustMatchSubLocalities);
        }
        return true;
    }

    public static boolean acceptableAreaScore(InternalScoringAddress cand, FieldType type, boolean mustMatch) {
        FieldScore score;
        double checkValue = 0.85;
        if (type.equals(FieldType.POST_CODE_FIELD_TYPE)) {
            checkValue = 0.99f;
        }
        if ((score = cand.getFieldScore(type)) != null) {
            double v = score.m_value;
            if (v >= checkValue) {
                return !(v < 1.0) || IND_Matcher1.exactNumericMatch(score) || type.equals(FieldType.POST_CODE_FIELD_TYPE);
            }
        } else if (!mustMatch) {
            return true;
        }
        return cand.isEmpty(type);
    }

    public boolean scoreWeightedOnNumericWord(InternalScoringAddress cand, FieldType type) {
        FieldScore score = cand.getFieldScore(type);
        if (score != null && score.m_value > 0.0) {
            AddressWord[] candWords = score.m_candWords;
            double w = 0.0;
            for (AddressWord word : candWords) {
                if (!word.isNumeral()) continue;
                w += (double)word.m_weight;
            }
            return w >= 0.5;
        }
        return false;
    }

    public boolean scoreWeightedOnNumericWordExceptRoman(InternalScoringAddress cand, FieldType type) {
        FieldScore score = cand.getFieldScore(type);
        if (score != null && score.m_value > 0.0) {
            AddressWord[] candWords = score.m_candWords;
            double w = 0.0;
            for (AddressWord word : candWords) {
                if (!CodedWord.isNumber(word.getCodedWord().getAttributes()) && !CodedWord.isNumeric(word.getCodedWord().getAttributes())) continue;
                w += (double)word.m_weight;
            }
            return w >= 0.5;
        }
        return false;
    }

    private static boolean exactNumericMatch(FieldScore score) {
        AddressWord[] words = score.m_candWords;
        int len = words.length;
        for (int ndx = 0; ndx < len; ++ndx) {
            AddressWord word = words[ndx];
            if (!word.isNumeral() || score.m_perfectCandWords != null && score.m_perfectCandWords.contains(ndx) && IND_Matcher1.matchedOnAllWords(score)) continue;
            return false;
        }
        return true;
    }

    private static boolean exactMatchOnWords(FieldScore score) {
        AddressWord[] words = score.m_candWords;
        int len = words.length;
        for (int ndx = 0; ndx < len; ++ndx) {
            AddressWord word = words[ndx];
            if (!word.isNumeral() || score.m_perfectCandWords != null && score.m_perfectCandWords.contains(ndx) && IND_Matcher1.matchedOnAllWordsExceptCommon(score)) continue;
            return false;
        }
        return true;
    }

    private static boolean matchedOnAllWordsExceptCommon(FieldScore score) {
        IntArray matchedWordNdxs = score.m_matchedCandWords;
        if (matchedWordNdxs != null && !matchedWordNdxs.isEmpty()) {
            AddressWord[] candWords = score.m_candWords;
            int n = candWords.length;
            for (int i = 0; i < n; ++i) {
                AddressWord candWord = candWords[i];
                if (matchedWordNdxs.contains(i) || CodedWord.isDelimiter(candWord.getAttributes()) || CodedWord.isCommonWord(candWord.getAttributes()) || CodedWord.isArticleWord(candWord.getAttributes())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean matchedOnSignificantWords(FieldScore score, InternalScoringAddress cand) {
        IntArray matchedWordNdxs = score.m_matchedCandWords;
        if (matchedWordNdxs != null && !matchedWordNdxs.isEmpty()) {
            AddressWord[] candWords = score.m_candWords;
            int n = candWords.length;
            for (int i = 0; i < n; ++i) {
                AddressWord candWord = candWords[i];
                if (!matchedWordNdxs.contains(i) || !AddressWord.isSignificantWord(candWord)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matchedOnMostWordsForPOI(FieldScore score) {
        int checkForUnmatchedPOIWords = 0;
        IntArray matchedWordNdxs = score.m_perfectCandWords;
        if (matchedWordNdxs != null && !matchedWordNdxs.isEmpty()) {
            AddressWord[] candWords = score.m_candWords;
            int candidateWords = candWords.length;
            for (int i = 0; i < candidateWords; ++i) {
                if (matchedWordNdxs.contains(i)) continue;
                ++checkForUnmatchedPOIWords;
            }
            if (checkForUnmatchedPOIWords > matchedWordNdxs.size()) {
                return false;
            }
        }
        return true;
    }

    private static boolean isAttributeWordInCand(FieldScore score) {
        IntArray matchedWordNdxs = score.m_matchedCandWords;
        if (matchedWordNdxs != null && !matchedWordNdxs.isEmpty()) {
            AddressWord[] candWords = score.m_candWords;
            int n = candWords.length;
            for (int i = 0; i < n; ++i) {
                AddressWord candWord = candWords[i];
                if (matchedWordNdxs.contains(i) || !CodedWord.isArticleWord(candWord.getAttributes())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean matchedOnAllWords(FieldScore score) {
        IntArray matchedWordNdxs = score.m_matchedCandWords;
        if (matchedWordNdxs != null && !matchedWordNdxs.isEmpty()) {
            AddressWord[] candWords = score.m_candWords;
            int n = candWords.length;
            for (int i = 0; i < n; ++i) {
                AddressWord candWord = candWords[i];
                if (matchedWordNdxs.contains(i) || CodedWord.isDelimiter(candWord.getAttributes()) || CodedWord.isCommonWord(candWord.getAttributes())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void calculateCombinedStreetScore(InternalScoringAddress scoringAddr, ParsedAddress parsedAddress, MatchingOptions options) {
        if (DataSetUtils.isPOIDataSetItem(scoringAddr)) {
            CGGEHandler handler = CGGEHandler.getInstance(this.getDataSetInfo(), parsedAddress.getCountry(), parsedAddress.getLanguage());
            IND_Parser1 parser = (IND_Parser1)handler.getParser();
            int[] pos = parser.getThoroughfareTypeHandler().findThoroughfareType((String)parsedAddress.getInputAddress().getField(FieldType.STREET_NAME_FIELD_TYPE));
            boolean doesInputHasStreetType = pos != null;
            FieldScore streetScore1 = scoringAddr.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE);
            if (streetScore1 != null && streetScore1.m_value < 0.5 && !parsedAddress.isSeperatePostAddressFields() && !streetScore1.m_inputFieldPresent && !doesInputHasStreetType) {
                scoringAddr.getFieldScoreList().remove(streetScore1);
            }
        }
        super.calculateCombinedStreetScore(scoringAddr, parsedAddress, options);
        int parsedFieldCount = parsedAddress.getFields() == null ? 0 : parsedAddress.getFields().size();
        ArrayList<AddressWord[]> matchedInputWords = new ArrayList<AddressWord[]>(parsedFieldCount);
        Map<FieldType, FieldScore> fieldMap = scoringAddr.getFieldScores();
        if (fieldMap != null && fieldMap.size() > 0) {
            for (Map.Entry<FieldType, FieldScore> entry : fieldMap.entrySet()) {
                FieldType type = entry.getKey();
                FieldScore fieldScore = entry.getValue();
                if (fieldScore == null || type.getLevel() != FieldType.FieldLevel.LEVEL_STREET) continue;
                double fieldWeight = options.getFieldWeight(type);
                if (!(fieldWeight > 0.0)) break;
                boolean acceptScore = IND_Matcher1.acceptScore(fieldScore, type, options);
                boolean separateFieldinput = this.hasSeparateStreetInput(parsedAddress, type);
                if (!separateFieldinput && !acceptScore && !this.inputFieldPresent(fieldScore) || fieldScore.m_inputWords == null || matchedInputWords.contains(fieldScore.m_inputWords)) break;
                matchedInputWords.add(fieldScore.m_inputWords);
                break;
            }
        }
        if (!parsedAddress.isIntersectionCase()) {
            int[] inputWordMatchStat = this.getInputWordMatchStats(matchedInputWords, scoringAddr);
            int inputWordCount = inputWordMatchStat[0];
            int signficantMatchedWordCount = inputWordMatchStat[2];
            int totalUnMatchedSignificantWords = inputWordMatchStat[7];
            int toalUnMatchedInSignificantWords = inputWordMatchStat[3] - totalUnMatchedSignificantWords + inputWordMatchStat[4];
            int totalUnMatchedWords = totalUnMatchedSignificantWords + toalUnMatchedInSignificantWords;
            int matchedWordCount = inputWordMatchStat[1];
            double missingWordsWeight = 0.0;
            double streetScore = scoringAddr.getCombinedStreetScore();
            if (inputWordCount > signficantMatchedWordCount) {
                int diffInMatchedWords = Math.abs(inputWordCount - signficantMatchedWordCount);
                if (signficantMatchedWordCount > 0 && diffInMatchedWords < 1) {
                    double streetFeildCutOff = options.getStreetFieldCutoff();
                    if (streetFeildCutOff > streetScore) {
                        double additionalWeight = streetFeildCutOff - streetScore;
                        scoringAddr.setCombinedStreetScore(streetScore + additionalWeight);
                    }
                } else if (matchedWordCount == 1 && totalUnMatchedWords > 0) {
                    missingWordsWeight = (double)totalUnMatchedSignificantWords * 0.01 + (double)toalUnMatchedInSignificantWords * 0.14;
                    scoringAddr.setCombinedStreetScore(streetScore - missingWordsWeight);
                }
            } else if (matchedWordCount == 1 && totalUnMatchedWords > 0) {
                missingWordsWeight = (double)totalUnMatchedSignificantWords * 0.01 + (double)toalUnMatchedInSignificantWords * 0.12;
                scoringAddr.setCombinedStreetScore(streetScore - missingWordsWeight);
            }
        }
    }

    @Override
    public MatchingOptions getMatchingOptions(GeocodeOptions options, DataSetInfo dataSetInfo) throws CGGERuntimeException, CGGEInternalException {
        if (dataSetInfo.getGeocodeType() == 3) {
            return new IND_MatchingOptions(super.getMatchingOptions(options, dataSetInfo));
        }
        return super.getMatchingOptions(options, dataSetInfo);
    }

    private AddressWord[] findAllUnMatchedWors(InternalScoringAddress cand, List<FieldType> exceptionTypeList, boolean ignoreInsignigicantWords) {
        Map<FieldType, FieldScore> scores = cand.getFieldScores();
        Iterator<FieldType> scoreTypeIterator = scores.keySet().iterator();
        ArrayList<AddressWord> matchedWordsList = new ArrayList<AddressWord>();
        ArrayList<AddressWord> allWordsList = new ArrayList<AddressWord>();
        boolean oneTimeJob = false;
        while (scoreTypeIterator.hasNext()) {
            FieldScore score;
            FieldType candFieldType = scoreTypeIterator.next();
            if (exceptionTypeList != null && exceptionTypeList.contains(candFieldType) || (score = scores.get(candFieldType)) == null) continue;
            AddressWord[] inputAddressWords = score.m_inputWords;
            IntArray matchedIndex = score.m_matchedInputWords;
            if (matchedIndex != null) {
                int i;
                for (i = 0; i < matchedIndex.size(); ++i) {
                    int index = matchedIndex.get(i);
                    if (index >= inputAddressWords.length || matchedWordsList.contains(inputAddressWords[index])) continue;
                    matchedWordsList.add(inputAddressWords[index]);
                }
                if (!oneTimeJob) {
                    for (i = 0; i < inputAddressWords.length; ++i) {
                        allWordsList.add(inputAddressWords[i]);
                    }
                    oneTimeJob = true;
                }
            }
            allWordsList.removeAll(matchedWordsList);
        }
        if (allWordsList.size() > 0) {
            if (!ignoreInsignigicantWords) {
                Iterator iter = allWordsList.iterator();
                while (iter.hasNext()) {
                    AddressWord word = (AddressWord)iter.next();
                    if (!CodedWord.isNumeric(word.getAttributes()) && !CodedWord.isNumber(word.getAttributes()) && !CodedWord.isDelimiter(word.getAttributes())) continue;
                    iter.remove();
                }
            }
            return allWordsList.toArray(new AddressWord[allWordsList.size()]);
        }
        return null;
    }

    private void reScoreSublocality(ParsedAddress parsedAddr, InternalScoringAddress cand) {
        HashMap<FieldType, FieldScore> newScoreMap = new HashMap<FieldType, FieldScore>();
        Map<FieldType, FieldScore> scoreMap = cand.getFieldScores();
        Iterator<FieldType> iter = scoreMap.keySet().iterator();
        AddressWord[] inputWords = null;
        while (iter.hasNext()) {
            FieldType type = iter.next();
            if (!"block".equalsIgnoreCase(type.getName()) && !"sub_locality".equalsIgnoreCase(type.getName())) continue;
            FieldScore score = scoreMap.get(type);
            if (!(score.m_value > 0.94) || !(score.m_value < 1.0)) continue;
            FieldScore newScore = new FieldScore();
            ArrayList<FieldType> typeList = new ArrayList<FieldType>();
            typeList.add(type);
            inputWords = (AddressWord[])parsedAddr.getField(FieldType.GENERIC_FIELD_2_FIELD_TYPE);
            if (inputWords != null && this.getNumberOfSublocalityWords(inputWords) > 1) continue;
            InternalFieldValue internalfieldValue = (InternalFieldValue)cand.getField(type);
            AddressWord[] canAddressWords = (AddressWord[])internalfieldValue.getFieldValue();
            AddressWord[] newCandAddressWords = (AddressWord[])canAddressWords.clone();
            ArrayList<AddressWord> wordList = new ArrayList<AddressWord>();
            for (int i = newCandAddressWords.length - 1; i > -1; --i) {
                wordList.add(newCandAddressWords[i]);
            }
            newCandAddressWords = wordList.toArray(newCandAddressWords);
            cand.setField(type, new InternalFieldValue(newCandAddressWords));
            newScore = this.scoreCandField(inputWords, cand, type, null, CGGEHandler.getInstance(this.getDataSetInfo(), parsedAddr.getCountry(), parsedAddr.getLanguage()).getScorer());
            cand.setField(type, internalfieldValue);
            if (newScore == null || !(newScore.m_value > score.m_value) || !IND_Matcher1.matchedOnAllWords(newScore) || !IND_Matcher1.exactNumericMatch(newScore)) continue;
            newScoreMap.put(type, newScore);
        }
        for (FieldType type : newScoreMap.keySet()) {
            scoreMap.put(type, (FieldScore)newScoreMap.get(type));
        }
    }

    private int getNumberOfSublocalityWords(AddressWord[] inputWords) {
        int count = 0;
        String str = CGGEHandler.getInstance(this.getDataSetInfo(), this.getCountry(), this.getLanguage()).getParser().reconstructFieldValue(inputWords);
        str = str.replaceAll("\\p{Punct}|\\s", "");
        String[] inputString = str.split("PHASE|PH|SECTOR|SEC|BLOCK|BLK|POCKET|PKT");
        count = inputString.length;
        return count;
    }

    protected void scoreAddressNumber(AddressNumber addrNum, InternalRangeAddress range, AddressNumberScore addrNumScore, ParsedAddress pAddr, MatchingOptions matchingOptions, ICGGEScorer scorer) {
        addrNumScore.setInputAddressNumber(addrNum);
        InternalFieldValue addressNumber = (InternalFieldValue)range.getField(DataSetUtils.getINDAddressNumberField(range));
        if (null != addressNumber) {
            AddressWord[] inputWords = (AddressWord[])pAddr.getField(FieldType.STREET_NAME_FIELD_TYPE);
            IND_AddressNumber IaddrNum = (IND_AddressNumber)addrNum;
            int[] startEnd = IaddrNum.getPositionInInputStreet();
            int length = startEnd[1] - startEnd[0];
            AddressWord[] addNumWords = new AddressWord[length];
            System.arraycopy(inputWords, startEnd[0], addNumWords, 0, length);
            this.scoreAddressWords(addNumWords, addressNumber, DataSetUtils.getINDAddressNumberField(range), addrNumScore, scorer);
            addrNumScore.m_inputWords = inputWords;
        }
    }

    @Override
    protected void scoreRangeAddressNumber(InternalScoringAddress scoringAddr, InternalScoringRange scoringRange, ParsedAddress pAddr, MatchingOptions matchingOptions, ICGGEScorer scorer) {
        List<AddressNumber> list;
        Map<FieldType, FieldScore> scores = scoringAddr.getFieldScores();
        if (scores != null && scores.size() > 0) {
            for (Map.Entry<FieldType, FieldScore> scoreEntry : scores.entrySet()) {
                FieldScore score = scoreEntry.getValue();
                if (score == null) continue;
                FieldScore clonedScore = new FieldScore();
                clonedScore.copy(score);
                scoringRange.setFieldScore(scoreEntry.getKey(), clonedScore);
            }
        }
        if ((list = pAddr.getProbableAddressNumbers()) == null) {
            return;
        }
        AddressNumberScore score = new AddressNumberScore();
        AddressNumberScore bestScore = new AddressNumberScore();
        for (AddressNumber addressNumber : list) {
            this.scoreAddressNumber(addressNumber, scoringRange.getRange(), score, pAddr, matchingOptions, scorer);
            if (!(bestScore.m_value < score.m_value)) continue;
            bestScore.copy(score);
            bestScore.m_inputFieldPresent = true;
            if (bestScore.m_value != 1.0) continue;
            break;
        }
        scoringRange.setFieldScore(FieldType.ADDRESS_NUMBER_FIELD_TYPE, bestScore);
    }

    @Override
    protected void scoreRange(InternalScoringAddress scoringAddr, InternalScoringRange scoringRange, ParsedAddress pAddr, MatchingOptions matchingOptions, ICGGEScorer scorer) {
        this.scoreRangeAddressNumber(scoringAddr, scoringRange, pAddr, matchingOptions, scorer);
    }

    private boolean passSGCandidateCheckforAP(ParsedAddress parsedAddr, InternalScoringAddress cand, ICGGEScorer scorer, GeocodeOptions options) {
        boolean flag = true;
        List<FieldType> subLocalityTypes = ((IND_ParsedAddress)parsedAddr).getM_subLocalityFields();
        for (FieldType fieldType : subLocalityTypes) {
            if (cand.getField(fieldType) == null || cand.getFieldScore(fieldType) != null && !(cand.getFieldScore((FieldType)fieldType).m_value < (double)0.95f)) continue;
            flag = false;
            break;
        }
        return flag;
    }

    private boolean passStreetCandidateCheckforAP(ParsedAddress parsedAddr, InternalScoringAddress cand, ICGGEScorer scorer, GeocodeOptions options) {
        CGGEHandler handler = CGGEHandler.getInstance(this.getDataSetInfo(), parsedAddr.getCountry(), parsedAddr.getLanguage());
        IND_Parser1 parser = (IND_Parser1)handler.getParser();
        int[] positionOfStreetType = parser.getThoroughfareTypeHandler().findThoroughfareType(parser.reconstructFieldValue((AddressWord[])parsedAddr.getField(FieldType.STREET_NAME_FIELD_TYPE)));
        return positionOfStreetType == null || cand.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE) != null && !(cand.getFieldScore((FieldType)FieldType.STREET_NAME_FIELD_TYPE).m_value < (double)0.9f) || !this.doReallyNeedTodiscardCandidate(parsedAddr, cand, parser.reconstructFieldValue((AddressWord[])parsedAddr.getField(FieldType.STREET_NAME_FIELD_TYPE)).substring(positionOfStreetType[0], positionOfStreetType[1]));
    }

    private boolean passPOICandidateCheckforAP(ParsedAddress parsedAddr, InternalScoringAddress cand, ICGGEScorer scorer, MatchingOptions options) {
        if (cand.getFieldScore(FieldType.PLACE_NAME_FIELD_TYPE) != null && cand.getFieldScore((FieldType)FieldType.PLACE_NAME_FIELD_TYPE).m_value > (double)0.95f) {
            return true;
        }
        IND_Parser1 parser = (IND_Parser1)CGGEHandler.getInstance(this.getDataSetInfo(), parsedAddr.getCountry(), parsedAddr.getLanguage()).getParser();
        boolean hasPOI = parser.doesInputhasPOI((String)parsedAddr.getInputAddress().getField(FieldType.STREET_NAME_FIELD_TYPE));
        if (hasPOI && cand.getField(FieldType.PLACE_NAME_FIELD_TYPE) != null) {
            return this.passInitialPOICandidateCheck(cand, parsedAddr, scorer, options);
        }
        if (!hasPOI && cand.getField(FieldType.PLACE_NAME_FIELD_TYPE) == null) {
            return true;
        }
        if (hasPOI && cand.getField(FieldType.PLACE_NAME_FIELD_TYPE) == null) {
            String string;
            List<String> buildingNames = parser.returnInputPOIList((String)parsedAddr.getInputAddress().getField(FieldType.STREET_NAME_FIELD_TYPE));
            boolean flag = true;
            Iterator<String> iterator = buildingNames.iterator();
            while (iterator.hasNext() && !(flag = this.doReallyNeedTodiscardCandidate(parsedAddr, cand, string = iterator.next()))) {
            }
            return !flag;
        }
        return false;
    }

    private boolean doReallyNeedTodiscardCandidate(ParsedAddress parsedAddr, InternalScoringAddress cand, String inputString) {
        ArrayList<FieldType> fieldTypeList = new ArrayList<FieldType>();
        fieldTypeList.add(FieldType.AREA_NAME_4_FIELD_TYPE);
        fieldTypeList.add(FieldType.AREA_NAME_3_FIELD_TYPE);
        fieldTypeList.add(FieldType.AREA_NAME_2_FIELD_TYPE);
        fieldTypeList.add(FieldType.AREA_NAME_1_FIELD_TYPE);
        fieldTypeList.add(FieldType.STREET_NAME_FIELD_TYPE);
        fieldTypeList.add(FieldType.PLACE_NAME_FIELD_TYPE);
        List<FieldType> subLocalityTypes = ((IND_ParsedAddress)parsedAddr).getM_subLocalityFields();
        for (FieldType subLocalityFieldType : subLocalityTypes) {
            fieldTypeList.add(subLocalityFieldType);
        }
        boolean flag = true;
        for (FieldType fieldType : fieldTypeList) {
            if (cand.getField(fieldType) == null || StringUtilities.isEmpty((String)((InternalFieldValue)cand.getField(fieldType)).toString()) || ((InternalFieldValue)cand.getField(fieldType)).toString().toUpperCase().indexOf(inputString.toUpperCase()) <= -1) continue;
            flag = false;
            break;
        }
        return flag;
    }

    private boolean passGeoCandidateCheck(ParsedAddress parsedAddr, InternalScoringAddress cand, ICGGEScorer scorer, GeocodeOptions options) {
        Map<FieldType, FieldScore> fieldScores;
        if (parsedAddr != null && !parsedAddr.isSeparateAreaFields()) {
            FieldScore an4Score;
            this.doesInputHasTown = options.get("matchable_town_found") != null;
            this.doesInputHasLocality = options.get("matchable_locality_found") != null;
            InternalFieldValue localityExistInCandidate = (InternalFieldValue)cand.getField(FieldType.AREA_NAME_4_FIELD_TYPE);
            FieldScore localityScore = cand.getFieldScore(FieldType.AREA_NAME_4_FIELD_TYPE);
            double localityAcceptableScore = 0.92;
            if (this.scoreWeightedOnNumericWordExceptRoman(cand, FieldType.AREA_NAME_4_FIELD_TYPE)) {
                localityAcceptableScore = 1.0;
            }
            if (this.doesInputHasLocality && (null == localityScore && null != localityExistInCandidate || null != localityScore && localityScore.m_value < localityAcceptableScore)) {
                return false;
            }
            if (!this.preferLocalityOrTownCandidate(cand, options)) {
                return false;
            }
            if (null != localityExistInCandidate && "true".equals(options.get("WITHOUT_TOWN_CASE")) && (null == (an4Score = cand.getFieldScore(FieldType.AREA_NAME_4_FIELD_TYPE)) || an4Score.m_value < 1.0)) {
                return false;
            }
        } else if (parsedAddr.isSeparateAreaFields() && "true".equals(options.get("split_areaname_case"))) {
            fieldScores = cand.getFieldScores();
            for (Map.Entry<FieldType, FieldScore> fieldEntry : fieldScores.entrySet()) {
                FieldScore anScore = fieldEntry.getValue();
                if (null == anScore || !(anScore.m_value > 0.0) || !(anScore.m_value < 0.75)) continue;
                return false;
            }
        }
        fieldScores = cand.getFieldScores();
        for (Map.Entry<FieldType, FieldScore> entry : fieldScores.entrySet()) {
            FieldScore score = entry.getValue();
            if (!(score.m_value < 0.825)) continue;
            score.m_value = 0.0;
            score.m_inputWords = new AddressWord[0];
        }
        return true;
    }

    private boolean preferLocalityOrTownCandidate(InternalScoringAddress cand, GeocodeOptions options) {
        String returnLocalityCandidate = options.getGeocodeConstraints().getCustomString("ReturnLocalityCandidates");
        boolean isPreferLocalitycandidate = StringUtilities.isEmpty((String)returnLocalityCandidate) || "true".equalsIgnoreCase(returnLocalityCandidate);
        String returnTownCandidate = options.getGeocodeConstraints().getCustomString("ReturnTownCandidates");
        boolean isPreferTownCandidate = StringUtilities.isEmpty((String)returnTownCandidate) || "true".equalsIgnoreCase(returnTownCandidate);
        FieldScore an3Score = cand.getFieldScore(FieldType.AREA_NAME_3_FIELD_TYPE);
        FieldScore an4Score = cand.getFieldScore(FieldType.AREA_NAME_4_FIELD_TYPE);
        if (null == an3Score || an3Score.m_value < 0.92) {
            isPreferTownCandidate = false;
        }
        if (null == an4Score || an4Score.m_value < 0.92) {
            isPreferLocalitycandidate = false;
        }
        return isPreferTownCandidate || isPreferLocalitycandidate;
    }

    private boolean removeStateLevelFalsePositive(InternalScoringAddress cand, GeocodeOptions options) {
        boolean doesInputHasState = options.get("matchable_state_found") != null;
        FieldScore stateScore = cand.getFieldScore(FieldType.AREA_NAME_1_FIELD_TYPE);
        return !doesInputHasState || stateScore != null && !(stateScore.m_value <= 0.96) || !this.isStateLikeDistrictAndTown(cand, options);
    }

    private boolean isStateLikeDistrictAndTown(InternalScoringAddress cand, GeocodeOptions options) {
        if (this.getFieldValueOfAreaNames(cand, FieldType.AREA_NAME_1_FIELD_TYPE).equalsIgnoreCase(this.getFieldValueOfAreaNames(cand, FieldType.AREA_NAME_2_FIELD_TYPE))) {
            return !this.checkState(cand, options);
        }
        if (this.getFieldValueOfAreaNames(cand, FieldType.AREA_NAME_1_FIELD_TYPE).equalsIgnoreCase(this.getFieldValueOfAreaNames(cand, FieldType.AREA_NAME_3_FIELD_TYPE))) {
            return !this.checkState(cand, options);
        }
        return true;
    }

    private String getFieldValueOfAreaNames(InternalScoringAddress cand, FieldType type) {
        if (cand.getField(type) != null) {
            InternalFieldValue areaName = (InternalFieldValue)cand.getField(type);
            return areaName.toString();
        }
        return null;
    }

    private boolean checkState(InternalScoringAddress cand, GeocodeOptions options) {
        String inputtedStateName = options.getProperty(STATE_NAME);
        if (inputtedStateName != null) {
            StringTokenizer stateWordsTokens = new StringTokenizer(inputtedStateName, " ");
            InternalFieldValue candStateName = (InternalFieldValue)cand.getField(FieldType.AREA_NAME_1_FIELD_TYPE);
            while (stateWordsTokens.hasMoreTokens()) {
                if (!stateWordsTokens.nextToken().toString().equalsIgnoreCase(candStateName.toString().trim())) continue;
                return true;
            }
        }
        return false;
    }
}

