/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.IND.parser;

import com.mapinfo.mapmarker.IND.address.IND_AddressNumber;
import com.mapinfo.mapmarker.IND.parser.IHNRPattern;
import com.mapinfo.mapmarker.IND.parser.IND_HNRPattern3;
import com.mapinfo.mapmarker.IND.parser.IND_HNRUtilities;
import com.mapinfo.mapmarker.cgge.address.AddressNumber;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IND_HNRPattern2
implements IHNRPattern {
    public static final String ADRESS_PATTERN = "(?:(?:^|\\s)-?)([A-Z]|\\d{1,5})((-|\\\\|/|,|\\s)([A-Z]|\\d{1,5})){1,3}((?:(?:^|\\s)-?)|,)";
    private static Pattern m_pattern = Pattern.compile("(?:(?:^|\\s)-?)([A-Z]|\\d{1,5})((-|\\\\|/|,|\\s)([A-Z]|\\d{1,5})){1,3}((?:(?:^|\\s)-?)|,)", 2);
    private static IHNRPattern m_nextPattern = new IND_HNRPattern3();

    @Override
    public List<AddressNumber> getpatterns(String target) {
        if (m_pattern != null) {
            List<AddressNumber> nextProbableNumber;
            ArrayList<AddressNumber> addNumbers = new ArrayList<AddressNumber>();
            Matcher m = m_pattern.matcher(target);
            IND_AddressNumber addNum = null;
            if (m.find()) {
                String hnr1 = m.group(0).trim();
                if (hnr1.length() > 0 && ',' == hnr1.charAt(hnr1.length() - 1)) {
                    hnr1 = hnr1.replaceAll(",", "");
                } else {
                    String[] hnrs = hnr1.split(",");
                    hnr1 = hnrs[0];
                }
                if (MMUtils.containsDigits(hnr1)) {
                    addNum = new IND_AddressNumber(hnr1);
                    int start = m.start();
                    int end = m.end();
                    addNum.startEndInx[0] = start;
                    addNum.startEndInx[1] = end;
                    addNumbers.add(addNum);
                    String[] spaceDelimChars = hnr1.split("\\s");
                    if (spaceDelimChars.length > 1) {
                        String hnr2 = spaceDelimChars[0];
                        if (MMUtils.containsDigits(hnr2)) {
                            addNum = new IND_AddressNumber(hnr2);
                            addNum.startEndInx[0] = start;
                            addNum.startEndInx[1] = start + hnr2.length();
                            addNumbers.add(addNum);
                        } else if (MMUtils.containsDigits(hnr2)) {
                            StringBuilder hnr3 = new StringBuilder();
                            for (int i = 0; i < spaceDelimChars.length; ++i) {
                                if (spaceDelimChars[i].length() != 1) {
                                    hnr3.append(spaceDelimChars[i]);
                                    break;
                                }
                                hnr3.append(spaceDelimChars[i]).append(" ");
                            }
                            if (hnr3.length() > 0) {
                                String hnr3Str = hnr3.toString().trim();
                                addNum = new IND_AddressNumber(hnr3Str);
                                addNum.startEndInx[0] = start;
                                addNum.startEndInx[1] = start + hnr3Str.length();
                                addNumbers.add(addNum);
                            }
                        }
                    }
                }
            }
            if ((nextProbableNumber = m_nextPattern.getpatterns(target = IND_HNRUtilities.extractStringForNextHnrPattern(target, addNum))) != null && nextProbableNumber.size() > 0) {
                addNumbers.addAll(nextProbableNumber);
            }
            return addNumbers;
        }
        return null;
    }
}

