/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.IND.parser;

import com.mapinfo.mapmarker.IND.address.IND_InputAddress;
import com.mapinfo.mapmarker.IND.address.IND_ParsedAddress;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.CodedWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InputAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.parser.CGGEParser1;
import com.mapinfo.mapmarker.cgge.parser.CGGEParserTerms;
import com.mapinfo.mapmarker.cgge.parser.ICGGEThoroughfareTypeHandler;
import com.mapinfo.mapmarker.cgge.scorer.ICGGEScorer;
import com.mapinfo.mapmarker.cgge.soundex.ICGGESoundex;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IND_Parser
extends CGGEParser1 {
    private static final Pattern HIGHWAY = Pattern.compile("\\b(NH|SH)(\\s*\\d{1,4}([a-zA-Z]*))\\b", 2);
    private Set<String> m_TFTs;
    private Set<String> m_POIIdentifiers;
    private Set<String> m_ArticleWords;
    private Set<String> m_NearByIdentifiers;

    public IND_Parser() {
    }

    public IND_Parser(CGGEParserTerms terms, ICGGESoundex soundex, ICGGEThoroughfareTypeHandler tftHandler) {
        super(terms, soundex, tftHandler);
    }

    @Override
    public boolean init(String country, String language) {
        boolean isInitSuccess = super.init(country, language);
        if (isInitSuccess) {
            List<String> tftList = this.getThoroughfareTypeHandler().getAllThoroughfareTypes();
            this.m_TFTs = Collections.unmodifiableSet(new HashSet<String>(tftList));
            this.m_POIIdentifiers = this.getParserTerms().getBuildingIdentifiers();
            this.fillArticleWords();
            this.fillNearByIdentifiers();
        }
        return isInitSuccess;
    }

    @Override
    public ParsedAddress[] parse(InputAddress inputAddress, ICGGEScorer scorer) {
        IND_InputAddress indInputAddress = new IND_InputAddress(inputAddress);
        boolean isMultiLineInput = this.isMultiLineInput(indInputAddress);
        if (!isMultiLineInput) {
            this.prepareMuiltiLineInputFromSingleLine(indInputAddress);
        } else {
            String inputPlacenameString = (String)inputAddress.getField(FieldType.PLACE_NAME_FIELD_TYPE);
            if (!StringUtilities.isEmpty((String)inputPlacenameString)) {
                inputPlacenameString = this.cleanInputString(inputPlacenameString);
                this.parsePOI(indInputAddress, new StringBuilder(inputPlacenameString), true);
            }
        }
        ParsedAddress[] parsedAddressArray = super.parse(indInputAddress, scorer);
        IND_ParsedAddress indParsedAddress = new IND_ParsedAddress(parsedAddressArray[0].getCountry(), parsedAddressArray[0].getLanguage());
        indParsedAddress.copy(parsedAddressArray[0]);
        indParsedAddress.setProbableParsedPOIs(indInputAddress.getProbablePOIContainer(), this);
        parsedAddressArray[0] = indParsedAddress;
        return parsedAddressArray;
    }

    private String cleanInputString(String inputPlacenameString) {
        inputPlacenameString = inputPlacenameString.replace("(", "");
        inputPlacenameString = inputPlacenameString.replace("\"", "");
        inputPlacenameString = inputPlacenameString.replace(")", "");
        inputPlacenameString = inputPlacenameString.replace(",", " ");
        return inputPlacenameString.toUpperCase();
    }

    private void fillArticleWords() {
        this.m_ArticleWords = new HashSet<String>();
        this.m_ArticleWords.add("OF");
        this.m_ArticleWords.add("AND");
        this.m_ArticleWords.add("REPORTER");
    }

    private void fillNearByIdentifiers() {
        this.m_NearByIdentifiers = new HashSet<String>();
        this.m_NearByIdentifiers.add("NEAR");
        this.m_NearByIdentifiers.add("OPPOSITE");
        this.m_NearByIdentifiers.add("OPP.");
        this.m_NearByIdentifiers.add("OPP");
        this.m_NearByIdentifiers.add("BESIDE");
    }

    private boolean isMultiLineInput(IND_InputAddress inputAddress) {
        boolean isMultilineInput = true;
        String postCode = (String)inputAddress.getField(FieldType.POST_CODE_FIELD_TYPE);
        String areaName3 = (String)inputAddress.getField(FieldType.AREA_NAME_3_FIELD_TYPE);
        String postaddress = (String)inputAddress.getField(FieldType.POST_ADDRESS_FIELD_TYPE);
        if (StringUtilities.isEmpty((String)postCode) && StringUtilities.isEmpty((String)areaName3) && StringUtilities.isEmpty((String)postaddress)) {
            isMultilineInput = false;
        }
        return isMultilineInput;
    }

    private void prepareMuiltiLineInputFromSingleLine(IND_InputAddress inputAddress) {
        String inputStreet = (String)inputAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
        if (!StringUtilities.isEmpty((String)inputStreet)) {
            inputStreet = this.cleanInputString(inputStreet);
            StringBuilder singleLineInput = new StringBuilder(inputStreet);
            this.parsePOI(inputAddress, singleLineInput, false);
            this.parseStreet(inputAddress, singleLineInput, true);
            this.parsePostalAddress(inputAddress, singleLineInput);
        }
    }

    private void parsePostalAddress(IND_InputAddress inputAddress, StringBuilder singleLineInput) {
        String parsedStreet = (String)inputAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
        String parsedPOI = (String)inputAddress.getField(FieldType.PLACE_NAME_FIELD_TYPE);
        if (StringUtilities.isEmpty((String)parsedStreet) && StringUtilities.isEmpty((String)parsedPOI)) {
            inputAddress.setField(FieldType.STREET_NAME_FIELD_TYPE, singleLineInput.toString());
        } else {
            this.extractUnitInformation(singleLineInput);
            String postAddress = this.cleanAddress(singleLineInput.toString());
            inputAddress.setField(FieldType.POST_ADDRESS_FIELD_TYPE, StringUtilities.isEmpty((String)postAddress) ? null : postAddress);
        }
    }

    private void extractUnitInformation(StringBuilder builder) {
        String[] tokens = builder.toString().split(" ");
        List<String> unitWords = this.getParserTerms().getUnitTypeList();
        for (int i = tokens.length - 1; i > 0; --i) {
            if (!unitWords.contains(tokens[i])) continue;
            builder.delete(0, builder.indexOf(tokens[i]) + tokens[i].length());
            break;
        }
    }

    private void parseStreet(IND_InputAddress inputAddress, StringBuilder singleLineInput, boolean isLastTokenNeeded) {
        String splitToken = this.getInterestedStreetSplitToken(singleLineInput);
        if (!StringUtilities.isEmpty((String)splitToken)) {
            String streetName = this.extractAddressElement(splitToken, singleLineInput, isLastTokenNeeded);
            inputAddress.setField(FieldType.STREET_NAME_FIELD_TYPE, streetName);
        } else {
            Matcher match = HIGHWAY.matcher(singleLineInput);
            if (match.find()) {
                inputAddress.setField(FieldType.STREET_NAME_FIELD_TYPE, match.group());
                singleLineInput.delete(match.start(), match.end());
            } else {
                inputAddress.setField(FieldType.STREET_NAME_FIELD_TYPE, null);
            }
        }
    }

    private void parsePOI(IND_InputAddress inputAddress, StringBuilder singleLineInput, boolean isLastTokenNeeded) {
        String extractedPOI;
        String[] probablePOIs;
        String splitToken = this.getInterestedPOISplitToken(singleLineInput);
        if (!StringUtilities.isEmpty((String)splitToken) && (probablePOIs = this.getPlaceNameArray(extractedPOI = this.extractAddressElement(splitToken, singleLineInput, isLastTokenNeeded), this.m_POIIdentifiers)) != null) {
            inputAddress.setField(FieldType.PLACE_NAME_FIELD_TYPE, probablePOIs[probablePOIs.length - 1]);
            inputAddress.addProbablePOIsToContainer(probablePOIs);
        }
    }

    private String[] getPlaceNameArray(String inputPlaceName, Set<String> identifiers) {
        if (!StringUtilities.isEmpty((String)inputPlaceName)) {
            StringBuilder inputPlaceNameBuilder = new StringBuilder(inputPlaceName);
            String[] tokens = inputPlaceNameBuilder.toString().split(" ");
            ArrayList<INDSplitToken> tokenList = new ArrayList<INDSplitToken>();
            ArrayList<String> poiList = new ArrayList<String>();
            for (int i = tokens.length - 1; i > 0; --i) {
                String fetchedIdentifier = tokens[i];
                if (identifiers.contains(fetchedIdentifier)) {
                    tokenList.add(new INDSplitToken((byte)i, fetchedIdentifier, false));
                    continue;
                }
                if (!this.m_ArticleWords.contains(fetchedIdentifier)) continue;
                tokenList.add(new INDSplitToken((byte)i, fetchedIdentifier, true));
            }
            if (tokenList.size() > 0) {
                INDSplitToken basePOIToken = (INDSplitToken)tokenList.get(0);
                for (int i = 1; i < tokenList.size(); ++i) {
                    INDSplitToken poiToken = (INDSplitToken)tokenList.get(i);
                    if (basePOIToken.m_tokenIndex - poiToken.m_tokenIndex > 1 && !poiToken.m_isArticle) {
                        poiList.add(this.cleanAddress(inputPlaceNameBuilder.substring(inputPlaceNameBuilder.lastIndexOf(poiToken.m_token) + poiToken.m_token.length())));
                        inputPlaceNameBuilder.delete(inputPlaceNameBuilder.lastIndexOf(poiToken.m_token) + poiToken.m_token.length(), inputPlaceNameBuilder.length());
                    }
                    basePOIToken = poiToken;
                }
                if (inputPlaceNameBuilder.length() > 0) {
                    poiList.add(this.cleanAddress(inputPlaceNameBuilder.toString()));
                }
                return poiList.toArray(new String[poiList.size()]);
            }
        }
        return null;
    }

    private String getInterestedPOISplitToken(StringBuilder inputLine) {
        String[] strArray = inputLine.toString().split(" ");
        for (int i = strArray.length - 1; i > 0; --i) {
            String fetchedIdentifier = strArray[i];
            if (!this.m_POIIdentifiers.contains(fetchedIdentifier) || strArray.length - i > 2 && this.m_TFTs.contains(strArray[i + 1])) continue;
            return fetchedIdentifier;
        }
        return null;
    }

    private String getInterestedStreetSplitToken(StringBuilder inputLine) {
        String[] strArray = inputLine.toString().split(" ");
        for (int i = strArray.length; i > 0; --i) {
            String fetchedIdentifier = strArray[i - 1];
            if (!this.m_TFTs.contains(fetchedIdentifier)) continue;
            return fetchedIdentifier;
        }
        return null;
    }

    private String extractAddressElement(String identifier, StringBuilder mainString, boolean isLastTokenNeeded) {
        String addressElement = null;
        int endIndex = mainString.lastIndexOf(identifier) + identifier.length();
        if (isLastTokenNeeded) {
            addressElement = mainString.substring(0, endIndex);
            mainString.delete(0, endIndex);
        } else if (endIndex < mainString.length()) {
            addressElement = mainString.substring(0, endIndex);
            mainString.delete(0, endIndex);
        }
        return addressElement;
    }

    private String cleanAddress(String singleLineInput) {
        String[] tokens = singleLineInput.split(" ");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (!this.m_NearByIdentifiers.contains(token)) continue;
            singleLineInput = singleLineInput.replaceAll(token, "");
        }
        return singleLineInput;
    }

    @Override
    public AddressWord[] splitIntoWeightedWords(String str, FieldType type) {
        AddressWord[] weightedWords = super.splitIntoWeightedWords(str, type);
        if (weightedWords != null) {
            int streetTypeCount = 0;
            for (AddressWord addressWord : weightedWords) {
                if (FieldType.POST_THOROUGHFARE_FIELD_TYPE != addressWord.m_wordType) continue;
                ++streetTypeCount;
            }
            if (streetTypeCount == 0 && CodedWord.isThoroughfareTypeWord(weightedWords[weightedWords.length - 1].getAttributes())) {
                weightedWords[weightedWords.length - 1].m_wordType = FieldType.POST_THOROUGHFARE_FIELD_TYPE;
            }
        }
        return weightedWords;
    }

    private static class INDSplitToken {
        private byte m_tokenIndex;
        private String m_token;
        private boolean m_isArticle;

        public INDSplitToken(byte index, String token, boolean isArticle) {
            this.m_tokenIndex = index;
            this.m_token = token;
            this.m_isArticle = isArticle;
        }
    }
}

