/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.IND.parser;

import com.mapinfo.mapmarker.IND.address.IND_AddressNumber;
import com.mapinfo.mapmarker.IND.address.IND_InputAddress;
import com.mapinfo.mapmarker.IND.address.IND_ParsedAddress;
import com.mapinfo.mapmarker.IND.dp.binary.DataSetUtils;
import com.mapinfo.mapmarker.IND.parser.IHNRPattern;
import com.mapinfo.mapmarker.IND.parser.IND_HNRPattern1;
import com.mapinfo.mapmarker.cgge.address.AddressNumber;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.CodedWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InputAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.parser.CGGEParser1;
import com.mapinfo.mapmarker.cgge.parser.CGGEParserTerms;
import com.mapinfo.mapmarker.cgge.parser.ICGGEThoroughfareTypeHandler;
import com.mapinfo.mapmarker.cgge.scorer.ICGGEScorer;
import com.mapinfo.mapmarker.cgge.soundex.ICGGESoundex;
import com.mapinfo.mapmarker.cgge.utils.IntArray;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import com.mapinfo.mapmarker.cgge.utils.RomanNumeral;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IND_Parser1
extends CGGEParser1 {
    private static final Pattern FORWARD_SUB_LOC_PATTERN1 = Pattern.compile("\\b(BLOCK|BLK|SECTORS|SECTOR|SEC|POCKET|PKT|PHASE|PH)([NO]|\\s|\\p{Punct})+(\\d+|[A-Z]|[IXV]+)((\\s|\\p{Punct})+(TO(\\s|\\p{Punct}))?(\\d+|[A-Za-z]|[IXV]+))?\\b", 2);
    private static final Pattern BACKWARD_SUB_LOC_PATTERN1 = Pattern.compile("(?:(?:^|\\s)-?)[A-Z](\\s|\\p{Punct})+((BLOCK|BLK|SECTORS|SECTOR|SEC|POCKET|PKT|PHASE|PH))\\b", 2);
    private static final Pattern FORWARD_SUB_LOC_PATTERN2 = Pattern.compile("\\b(BLOCK|BLK|SECTORS|SECTOR|SEC|POCKET|PKT|PHASE|PH)(\\s|\\p{Punct})+(\\p{Alnum}{1,3})(\\s|\\p{Punct})+(TO\\s)?(\\p{Alnum}{1,3})?\\b", 2);
    private static final Pattern NH_SH = Pattern.compile("\\b(NH|SH)(\\s|\\p{Punct})*(\\d{1,3})(\\s|\\p{Punct})*([A-Z]{1,2})?\\b", 2);
    private static final Pattern BACKWARD_SUB_LOC_PATTERN2 = Pattern.compile("(?:(?:^|\\s)-?)((\\p{Alnum}{1,3})(\\s|\\p{Punct})+(BLOCK|BLK|SECTORS|SECTOR|SEC|POCKET|PKT){1})\\b", 2);
    private static final Pattern FORWARD_PROBABLE_SUB_LOC_PATTERN1 = Pattern.compile("\\b((\\w{1,2})(\\s|\\p{Punct})+(\\d+))\\b", 2);
    private static final String[] m_stateCommonWords = new String[]{"ANDHRA", "ASSAM", "BIHAR", "CHANDIGARH", "CHHATTISGARH", "DELHI", "GOA", "GUJARAT", "HARYANA", "HIMACHAL", "JAMMU", "KASHMIR", "JHARKHAND", "KARNATAKA", "KERALA", "MADHYA", "MAHARASHTRA", "MANIPUR", "MEGHALAYA", "ORISSA", "PUDUCHERRY", "PUNJAB", "RAJASTHAN", "SIKKIM", "STATE", "TAMIL", "NADU", "UTTAR", "UTTARAKHAND", "BENGAL", "MUMBAI", "KOLKATTA", "CHENNAI", "BANGALORE", "BOMBAY", "MADRAS"};
    private static final List<Pattern> m_sublocalityPatterns;
    private static final String[] m_subLocalityIdentifiers;
    private static final Pattern POST_CODE_PATTERN;
    private static final Pattern HNR_PATTERN;
    private static final Pattern CARE_OF_PATTERN;
    private static final Pattern VILLPO;
    private static final Pattern AREA_SPECIFIER_PATTERN;
    private IHNRPattern hnrPatternHandler;

    public IND_Parser1() {
    }

    public IND_Parser1(CGGEParserTerms terms, ICGGESoundex soundex, ICGGEThoroughfareTypeHandler tftHandler) {
        super(terms, soundex, tftHandler);
    }

    @Override
    public boolean init(String country, String language) {
        super.init(country, language);
        this.hnrPatternHandler = new IND_HNRPattern1();
        return true;
    }

    @Override
    public ParsedAddress[] parse(InputAddress inputAddress, ICGGEScorer scorer) {
        IND_InputAddress indInputAddress = new IND_InputAddress(inputAddress);
        boolean doesInputHasPOI = true;
        boolean isMultiLineInput = this.isMultiLineInput(indInputAddress);
        if (!isMultiLineInput) {
            this.parseSubLocalityInforamtion(indInputAddress);
        }
        int[] index = this.getThoroughfareTypeHandler().findThoroughfareType((String)inputAddress.getField(FieldType.STREET_NAME_FIELD_TYPE));
        String inputAddrss = null;
        if (!StringUtilities.isEmpty((String)((String)inputAddress.getField(FieldType.STREET_NAME_FIELD_TYPE)))) {
            inputAddrss = ((String)inputAddress.getField(FieldType.STREET_NAME_FIELD_TYPE)).replaceAll(",", " ");
        }
        if (!StringUtilities.isEmpty((String)((String)inputAddress.getField(FieldType.PLACE_NAME_FIELD_TYPE)))) {
            doesInputHasPOI = true;
        } else if (!StringUtilities.isEmpty((String)inputAddrss)) {
            doesInputHasPOI = this.doesInputhasPOI(inputAddrss);
        }
        if (!StringUtilities.isEmpty((String)inputAddrss)) {
            inputAddrss = HNR_PATTERN.matcher(inputAddrss).replaceAll("");
            inputAddrss = CARE_OF_PATTERN.matcher(inputAddrss).replaceAll("");
            inputAddrss = VILLPO.matcher(inputAddrss).replaceAll("");
            inputAddrss = AREA_SPECIFIER_PATTERN.matcher(inputAddrss).replaceAll("");
            indInputAddress.setField(FieldType.STREET_NAME_FIELD_TYPE, inputAddrss);
        }
        ParsedAddress[] parsedAddressArray = super.parse(indInputAddress, scorer);
        IND_ParsedAddress indParsedAddress = new IND_ParsedAddress(parsedAddressArray[0].getCountry(), parsedAddressArray[0].getLanguage());
        if (index == null) {
            if (!StringUtilities.isEmpty((String)inputAddrss)) {
                if (!isMultiLineInput) {
                    this.parseNHSHInforamtion(indInputAddress, NH_SH);
                    if (indInputAddress.getField(FieldType.GENERIC_FIELD_4_FIELD_TYPE) == null) {
                        indParsedAddress.setStreetTypePresent(false);
                    }
                }
            } else {
                indParsedAddress.setStreetTypePresent(false);
            }
        }
        String stThroughFare = null;
        Map<FieldType, String> fieldMap = indInputAddress.getFields();
        indParsedAddress.setPOITypePresent(doesInputHasPOI);
        this.parseInputPOI(inputAddrss, fieldMap, stThroughFare, indParsedAddress);
        indParsedAddress.copy(parsedAddressArray[0]);
        indParsedAddress.setProbableParsedPOIs(indInputAddress.getProbablePOIContainer(), this);
        indParsedAddress.setField(FieldType.GENERIC_FIELD_2_FIELD_TYPE, this.getAddressWords((String)indInputAddress.getField(FieldType.GENERIC_FIELD_2_FIELD_TYPE)));
        indParsedAddress.setField(FieldType.GENERIC_FIELD_4_FIELD_TYPE, this.getAddressWords((String)indInputAddress.getField(FieldType.GENERIC_FIELD_4_FIELD_TYPE)));
        parsedAddressArray[0] = indParsedAddress;
        return parsedAddressArray;
    }

    private String formatSublocalityString(String inputString) {
        return inputString.replaceAll("\\b(\\d+)(\\s+|\\p{Punct}+)([A-Za-z]{1})\\b", "$1$3");
    }

    public boolean doesInputhasPOI(String inputAddress) {
        String[] arr;
        boolean hasPOI = false;
        for (String string : arr = inputAddress.split(",;| ")) {
            if (StringUtilities.isEmpty((String)string) || !this.getParserTerms().isBuildingIdentifier(string)) continue;
            hasPOI = true;
            break;
        }
        return hasPOI;
    }

    public void parseInputPOI(String inputAddress, Map<FieldType, String> fieldMap, String streetTh, IND_ParsedAddress indParsedAddress) {
        int i;
        if (inputAddress == null) {
            return;
        }
        String[] arr = inputAddress.split(",;| ");
        int k = 0;
        int startIndex = 0;
        for (int i2 = 0; i2 < arr.length; ++i2) {
            if (arr[i2] == null || arr[i2].equals("") || arr[i2].equals(" ")) continue;
            ++k;
        }
        String[] arr1 = new String[k];
        int j = 0;
        for (i = 0; i < arr.length; ++i) {
            if (arr[i] == null || arr[i].equals("") || arr[i].equals(" ")) continue;
            arr1[j] = arr[i];
            ++j;
        }
        i = 0;
        for (String string : arr1) {
            if (!StringUtilities.isEmpty((String)string) && this.getParserTerms().isBuildingIdentifier(string) && i >= startIndex) {
                this.streetThrfareAfterPOIIdentifier(arr1, i, indParsedAddress);
            }
            ++i;
        }
    }

    private void streetThrfareAfterPOIIdentifier(String[] inputAddress, int i, IND_ParsedAddress indParsedAddress) {
        if (inputAddress.length > i + 1 && this.getThoroughfareTypeHandler().isThoroughfareType(inputAddress[i + 1])) {
            indParsedAddress.setStreetPresent(true);
        }
    }

    public List<String> returnInputPOIList(String inputAddress) {
        String[] arr;
        ArrayList<String> inputPOIList = new ArrayList<String>();
        for (String string : arr = inputAddress.split(",;| ")) {
            if (StringUtilities.isEmpty((String)string) || !this.getParserTerms().isBuildingIdentifier(string)) continue;
            inputPOIList.add(string);
        }
        return inputPOIList;
    }

    private boolean isMultiLineInput(IND_InputAddress inputAddress) {
        boolean isMultilineInput = true;
        String postCode = (String)inputAddress.getField(FieldType.POST_CODE_FIELD_TYPE);
        String areaName3 = (String)inputAddress.getField(FieldType.AREA_NAME_3_FIELD_TYPE);
        String postaddress = (String)inputAddress.getField(FieldType.POST_ADDRESS_FIELD_TYPE);
        if (StringUtilities.isEmpty((String)postCode) && StringUtilities.isEmpty((String)areaName3) && StringUtilities.isEmpty((String)postaddress)) {
            isMultilineInput = false;
        }
        return isMultilineInput;
    }

    @Override
    protected short getNumericAttributes(String word, short wordAttribs) {
        if (MMUtils.isNumber(word)) {
            wordAttribs = (short)(wordAttribs | 4);
        } else if (this.getParserTerms().isNumericWord(word)) {
            wordAttribs = (short)(wordAttribs | 8);
        } else if (RomanNumeral.isValidRomanNumeral(word)) {
            wordAttribs = (short)(wordAttribs | 0x20);
        }
        return wordAttribs;
    }

    private void parseSubLocalityInforamtion(IND_InputAddress inputAddress) {
        String inputStreet = (String)inputAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
        if (!StringUtilities.isEmpty((String)inputStreet)) {
            inputStreet = this.cleanInputString(inputStreet);
            StringBuilder singleLineInput = new StringBuilder(inputStreet);
            StringBuilder sublocalityBuilder = new StringBuilder();
            for (Pattern pattern : m_sublocalityPatterns) {
                Matcher match = pattern.matcher(singleLineInput);
                while (match.find()) {
                    String matchedString = match.group();
                    if (StringUtilities.isEmpty((String)matchedString)) continue;
                    if ((matchedString = matchedString.trim()).contains("SECTOR") || matchedString.contains("SEC") || matchedString.contains("SECTORS")) {
                        sublocalityBuilder.append(" " + this.formatSublocalityString(matchedString));
                    } else if (matchedString.contains("BLOCK") || matchedString.contains("BLK")) {
                        sublocalityBuilder.append(" " + matchedString);
                    } else if (matchedString.contains("POCKET") || matchedString.contains("PKT")) {
                        sublocalityBuilder.append(" " + matchedString);
                    } else if (matchedString.contains("PHASE") || matchedString.contains("PH")) {
                        sublocalityBuilder.append(" " + matchedString);
                    }
                    singleLineInput.delete(match.start(), match.end());
                    match.reset();
                }
            }
            if (!StringUtilities.isEmpty((String)sublocalityBuilder.toString())) {
                inputAddress.setField(FieldType.GENERIC_FIELD_2_FIELD_TYPE, sublocalityBuilder.toString().trim());
            }
        }
    }

    private void parseNHSHInforamtion(IND_InputAddress inputAddress, Pattern pattern) {
        String inputStreet = (String)inputAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
        if (!StringUtilities.isEmpty((String)inputStreet)) {
            inputStreet = this.cleanInputString(inputStreet);
            StringBuilder singleLineInput = new StringBuilder(inputStreet);
            StringBuilder NH_SHBuilder = new StringBuilder();
            Matcher match = pattern.matcher(singleLineInput);
            if (match.find()) {
                String matchedString = match.group();
                if (!StringUtilities.isEmpty((String)matchedString)) {
                    NH_SHBuilder.append(matchedString.trim());
                    singleLineInput.delete(match.start(), match.end());
                }
                if (!StringUtilities.isEmpty((String)NH_SHBuilder.toString())) {
                    inputAddress.setField(FieldType.GENERIC_FIELD_4_FIELD_TYPE, NH_SHBuilder.toString().trim());
                }
            }
        }
    }

    private String cleanInputString(String inputString) {
        inputString = inputString.replace("(", "");
        inputString = inputString.replace("\"", "");
        inputString = inputString.replace(")", "");
        inputString = inputString.replace(",", " ");
        return inputString.toUpperCase();
    }

    @Override
    public AddressWord[] splitIntoWeightedWords(String str, FieldType type) {
        AddressWord[] addrWords = super.splitIntoWeightedWords(str, type);
        if (addrWords != null && addrWords.length > 0) {
            if (type == FieldType.PLACE_NAME_FIELD_TYPE) {
                this.adjustPlaceNameWeights(addrWords);
            } else if (DataSetUtils.isSubLocalityField(type)) {
                this.adjustSubLocalityWeights(addrWords);
            }
        }
        return addrWords;
    }

    private void adjustSubLocalityWeights(AddressWord[] addrWords) {
        int n = addrWords.length;
        if (n > 1) {
            byte cww = this.getParserTerms().getCommonWordWeight();
            byte aww = this.getParserTerms().getArticleWeight();
            for (int i = 0; i < n; ++i) {
                AddressWord word = addrWords[i];
                byte currentWeight = word.m_weight;
                if (currentWeight <= aww || !this.isSubLocalityIdentifier(word)) continue;
                word.m_weight = aww;
                int currentTotal = this.redistributeWeights(addrWords, currentWeight - aww, cww, i);
                if (currentTotal < 100) {
                    currentTotal = this.redistributeWeights(addrWords, word.m_weight - cww, this.getParserTerms().getArticleWeight(), i);
                }
                if (currentTotal >= 100) continue;
                word.m_weight = (byte)(word.m_weight + (100 - currentTotal));
            }
        }
    }

    private boolean isSubLocalityIdentifier(AddressWord word) {
        String str = new String(word.getWordChars());
        return Arrays.binarySearch(m_subLocalityIdentifiers, str) > -1;
    }

    private boolean isStateCommonWord(AddressWord word) {
        String str = new String(word.getWordChars());
        return Arrays.binarySearch(m_stateCommonWords, str) > -1;
    }

    private void adjustStreetNameWeights(AddressWord[] addrWords) {
        AddressWord lastWord;
        AddressWord typeWord = null;
        int nWords = addrWords.length;
        byte tpw = this.getParserTerms().getThoroughfareTypeWeight();
        if (nWords > 1 && CodedWord.isThoroughfareTypeWord((lastWord = addrWords[nWords - 1]).getAttributes()) && lastWord.m_weight == tpw && this.containsNonNumericWords(addrWords, 1, nWords - 1)) {
            typeWord = lastWord;
            lastWord.m_weight = 0;
        }
        this.adjustNumericWordWeight(addrWords);
        if (typeWord != null) {
            typeWord.m_weight = tpw;
        }
    }

    private void adjustPlaceNameWeights(AddressWord[] addrWords) {
        byte cww;
        AddressWord lastWord;
        this.adjustNumericWordWeight(addrWords);
        this.adjustStateCommonWordWeight(addrWords);
        int nWords = addrWords.length;
        if (nWords > 1 && CodedWord.isCommonWord((lastWord = addrWords[nWords - 1]).getAttributes()) && lastWord.m_weight > (cww = this.getParserTerms().getCommonWordWeight()) && this.containsWords(addrWords, cww, nWords - 1)) {
            this.redistributeWeights(addrWords, lastWord.m_weight - cww, cww, nWords - 1);
            lastWord.m_weight = cww;
        }
    }

    private void adjustStateCommonWordWeight(AddressWord[] addrWords) {
        int nWords = addrWords.length;
        if (nWords > 1) {
            byte cww = this.getParserTerms().getCommonWordWeight();
            byte aww = this.getParserTerms().getArticleWeight();
            for (int ndx = 0; ndx < nWords; ++ndx) {
                AddressWord word = addrWords[ndx];
                byte wordWeight = word.m_weight;
                if (wordWeight <= cww || !this.isStateCommonWord(word)) continue;
                word.m_weight = cww;
                if (this.redistributeWeights(addrWords, wordWeight - cww, cww, ndx) >= 100) continue;
                this.redistributeWeights(addrWords, wordWeight - cww, aww, -1);
                break;
            }
        }
    }

    private void adjustNumericWordWeight(AddressWord[] addrWords) {
        int nWords = addrWords.length;
        if (nWords > 1) {
            byte aww = this.getParserTerms().getArticleWeight();
            byte cww = this.getParserTerms().getCommonWordWeight();
            IntArray intWords = new IntArray(nWords);
            for (int i = 0; i < nWords; ++i) {
                AddressWord word = addrWords[i];
                if (word.m_weight <= cww || !word.isNumeral() || !this.containsWords(addrWords, aww, i)) continue;
                this.redistributeWeights(addrWords, word.m_weight - cww, aww, i);
                word.m_weight = 0;
                intWords.add(i);
            }
            if (!intWords.isEmpty()) {
                int n = intWords.size();
                for (int i = 0; i < n; ++i) {
                    addrWords[intWords.get((int)i)].m_weight = cww;
                }
            }
        }
    }

    private int redistributeWeights(AddressWord[] addrWords, int adjustAmount, int minAdjustableWeight, int ignoreWord) {
        int n = addrWords.length;
        IntArray adjustWords = new IntArray(addrWords.length);
        int totalWeights = 0;
        for (int i = 0; i < n; ++i) {
            AddressWord word = addrWords[i];
            if (i != ignoreWord && word.m_weight > minAdjustableWeight) {
                adjustWords.add(i);
                continue;
            }
            totalWeights += word.m_weight;
        }
        int c = adjustWords.size();
        if (c > 0) {
            int adjustBy = adjustAmount / c + adjustAmount % c;
            for (int i = 0; i < c; ++i) {
                AddressWord word = addrWords[adjustWords.get(i)];
                word.m_weight = (byte)(word.m_weight + adjustBy);
                totalWeights += word.m_weight;
                adjustBy = adjustAmount / c;
                if (adjustBy == 0) break;
            }
            return totalWeights;
        }
        return 0;
    }

    private boolean containsWords(AddressWord[] addrWords, int minWeight, int ignoreWord) {
        int n = addrWords.length;
        for (int i = 0; i < n; ++i) {
            if (i == ignoreWord) continue;
            AddressWord word = addrWords[i];
            if (word.m_weight <= minWeight) continue;
            return true;
        }
        return false;
    }

    private boolean containsNonNumericWords(AddressWord[] addrWords, int minWeight, int ignoreWord) {
        int n = addrWords.length;
        for (int i = 0; i < n; ++i) {
            AddressWord word;
            if (i == ignoreWord || (word = addrWords[i]).isNumeral() || word.m_weight <= minWeight) continue;
            return true;
        }
        return false;
    }

    public String getListOfProbableSubLocalities(String inputString) {
        Matcher match = FORWARD_PROBABLE_SUB_LOC_PATTERN1.matcher(inputString);
        StringBuilder builder = new StringBuilder();
        while (match.find()) {
            String foundString = match.group(2);
            if (StringUtilities.isEmpty((String)foundString)) continue;
            builder.append("Block " + foundString);
            break;
        }
        return builder.toString();
    }

    @Override
    public List<AddressNumber> findProbableAddressNumbers(AddressWord[] words, IntArray ignoreWordNdxs) {
        List<AddressNumber> probableList = null;
        if (words != null && words.length > 0) {
            StringBuilder mainStr = new StringBuilder();
            int wordSize = words.length;
            boolean prevWordIsDelimiter = false;
            for (int wordNdx = 0; wordNdx < wordSize; ++wordNdx) {
                char[] chars = words[wordNdx].getWordChars();
                boolean wordIsDelimiter = CodedWord.isDelimiter(words[wordNdx].getAttributes());
                if (!(mainStr.length() <= 0 || wordIsDelimiter || prevWordIsDelimiter || chars.length == 1 && '%' == chars[0] || '%' == mainStr.charAt(mainStr.length() - 1))) {
                    mainStr.append(' ');
                }
                prevWordIsDelimiter = wordIsDelimiter;
                mainStr.append(chars);
            }
            if (null != this.hnrPatternHandler) {
                String matchedString;
                for (Pattern pattern : m_sublocalityPatterns) {
                    Matcher m = pattern.matcher(mainStr);
                    if (!m.find()) continue;
                    mainStr.delete(m.start(), m.end());
                }
                Matcher match = POST_CODE_PATTERN.matcher(mainStr.toString());
                if (match.find() && !StringUtilities.isEmpty((String)(matchedString = match.group()))) {
                    mainStr.delete(match.start(), match.end());
                }
                if (null != (probableList = this.hnrPatternHandler.getpatterns(mainStr.toString()))) {
                    for (AddressNumber addNum : probableList) {
                        IND_AddressNumber IaddNum = (IND_AddressNumber)addNum;
                        int[] wordStartEndNdxs = this.findWordNdxs(words, IaddNum.startEndInx);
                        if (wordStartEndNdxs == null || wordStartEndNdxs[0] <= -1) continue;
                        boolean ignore = false;
                        if (ignoreWordNdxs != null) {
                            for (int wordStartNdx = wordStartEndNdxs[0]; wordStartNdx < wordStartEndNdxs[1]; ++wordStartNdx) {
                                if (!ignoreWordNdxs.contains(wordStartNdx)) continue;
                                ignore = true;
                                break;
                            }
                        }
                        if (ignore) continue;
                        addNum.setPositionInInputStreet(wordStartEndNdxs);
                    }
                }
            }
        }
        return probableList;
    }

    public AddressWord[] getAddressWordsWithDelims(String str) {
        return this.getAddressWords(str, true, false);
    }

    static {
        m_subLocalityIdentifiers = new String[]{"BLOCK", "BLK", "POCKET", "PKT", "PHASE", "SECTOR", "SEC"};
        POST_CODE_PATTERN = Pattern.compile("\\b(\\d{6})\\b", 2);
        HNR_PATTERN = Pattern.compile("\\b((HOUSE|FLAT|DOOR|ROOM|HOME)(\\s|\\p{Punct})+(NO|N|N O))\\b");
        CARE_OF_PATTERN = Pattern.compile("\\b(C|W|S|D)(\\s*)(\\p{Punct}+)(\\s*)(O)(\\s*)\\b");
        VILLPO = Pattern.compile("\\b(VILLAGE|VILL)(\\s|\\p{Punct})+(AND)*(\\s|\\p{Punct})+(POST|PO)(\\s|\\p{Punct})+\\b");
        AREA_SPECIFIER_PATTERN = Pattern.compile("\\b(DIST|DISTT|VILL|VIL|PIN|PO|PS)(\\s*)(\\p{Punct}*)(\\s*)\\b");
        m_sublocalityPatterns = new ArrayList<Pattern>();
        m_sublocalityPatterns.add(FORWARD_SUB_LOC_PATTERN1);
        m_sublocalityPatterns.add(BACKWARD_SUB_LOC_PATTERN1);
        m_sublocalityPatterns.add(FORWARD_SUB_LOC_PATTERN2);
        m_sublocalityPatterns.add(BACKWARD_SUB_LOC_PATTERN2);
        Arrays.sort(m_subLocalityIdentifiers);
        Arrays.sort(m_stateCommonWords);
    }
}

