/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.IND.scorer;

import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.CodedWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.scorer.CGGEScorer;
import com.mapinfo.mapmarker.utils.DebugLevel;
import com.mapinfo.mapmarker.utils.MMJLog;

public class IND_Scorer
extends CGGEScorer {
    @Override
    protected void scoreAddressWordArrays(AddressWord[] inputWords, AddressWord[] candWords, FieldType type, FieldScore fieldScore) {
        if (type != null && "ind_addressnum".equals(type.getName())) {
            this.scoreAddressWordArraysForAddressNumber(inputWords, candWords, fieldScore);
        } else {
            super.scoreAddressWordArrays(inputWords, candWords, type, fieldScore);
        }
    }

    protected final void scoreAddressWordArraysForAddressNumber(AddressWord[] inputWords, AddressWord[] candWords, FieldScore fieldScore) {
        int size2;
        fieldScore.m_inputWords = inputWords;
        fieldScore.m_candWords = candWords;
        if (DebugLevel.getDebugLevel((int)4) >= 3) {
            MMJLog.getLog().debug("CGGEScorer::scoreAddressWordArraysGeneral");
            if (inputWords != null) {
                MMJLog.getLog().debug("inputWords: ");
                for (AddressWord word : inputWords) {
                    MMJLog.getLog().debug("\t" + word.toString());
                }
            } else {
                MMJLog.getLog().debug("inputWords: none");
            }
            if (candWords != null) {
                MMJLog.getLog().debug("candWords: ");
                for (AddressWord word : candWords) {
                    MMJLog.getLog().debug("\t" + word.toString());
                }
            } else {
                MMJLog.getLog().debug("candWords: none");
            }
        }
        int size1 = inputWords == null ? 0 : inputWords.length;
        int n = size2 = candWords == null ? 0 : candWords.length;
        if (size2 == 0 && size1 == 0) {
            fieldScore.m_value = 1.0;
        } else if (size2 != 0 && size1 != 0) {
            CGGEScorer.WordScore[][] matchMatrix = new CGGEScorer.WordScore[size2][size1];
            for (int row = 0; row < size2; ++row) {
                AddressWord compareWord = candWords[row];
                for (int col = 0; col < size1; ++col) {
                    AddressWord compareToWord = inputWords[col];
                    if (!this.canMatchWords(compareWord, compareToWord)) continue;
                    matchMatrix[row][col] = this.privateScoreAddressWords(compareToWord, compareWord);
                }
            }
            this.calculateCombinedScoreFromMatrix(matchMatrix, inputWords, size1, candWords, size2, fieldScore, false);
            this.handleExactWordCountMatch(false, fieldScore, size1, size2);
            if (DebugLevel.getDebugLevel((int)4) >= 3) {
                MMJLog.getLog().debug("fieldScore: " + fieldScore);
            }
        }
    }

    @Override
    public boolean canMatchWords(AddressWord addrWord1, AddressWord addrWord2) {
        CodedWord word1 = addrWord1.getCodedWord();
        CodedWord word2 = addrWord2.getCodedWord();
        boolean retVal = super.canMatchWords(addrWord1, addrWord2);
        if (!(!retVal || !word1.isSameStartLetter(word2) || addrWord1.m_wordType != FieldType.AREA_NAME_1_FIELD_TYPE && addrWord1.m_wordType != FieldType.AREA_NAME_2_FIELD_TYPE && addrWord1.m_wordType != FieldType.AREA_NAME_3_FIELD_TYPE || word1.isNumeral() && word2.isNumeral() || !CodedWord.isProbableRomanNumeral(word2.getAttributes()) && (word1.getWordLength() <= 1 || 1 != word2.getWordLength()))) {
            return false;
        }
        return retVal;
    }

    @Override
    protected double handleSwappedWordsScoring(double highScore, CGGEScorer.WordScore[][] matchMatrix, AddressWord[] inputWords, int size1, AddressWord[] candWords, int size2, CGGEScorer.FieldScoreEx fieldScoreEx, boolean considerSwap) {
        if (considerSwap) {
            return super.handleSwappedWordsScoring(highScore, matchMatrix, inputWords, size1, candWords, size2, fieldScoreEx, considerSwap);
        }
        return highScore;
    }

    protected void handleExactWordCountMatch(boolean considerSwap, FieldScore score, int size1, int size2) {
        double highScore = score.m_value;
        if (!considerSwap && 1.0 == highScore && size1 != size2) {
            score.m_value = highScore -= 0.05;
        }
    }

    @Override
    protected boolean[] handleCombinedWordsScoring(AddressWord[] addressWords1, AddressWord[] addressWords2, FieldType type, FieldScore fieldScore, FieldScore retScore, boolean words1Changed, boolean words2Changed, short[] combinedWithNumeric) {
        if (!"ind_addressnum".equals(type.getName())) {
            return super.handleCombinedWordsScoring(addressWords1, addressWords2, type, fieldScore, retScore, words1Changed, words2Changed, combinedWithNumeric);
        }
        boolean[] wordsChanged = new boolean[2];
        wordsChanged[0] = words1Changed;
        wordsChanged[0] = words2Changed;
        return wordsChanged;
    }
}

