/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.ISR.parser;

import com.mapinfo.mapmarker.ISR.util.ISR_Utils;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InputAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.address.PostCode;
import com.mapinfo.mapmarker.cgge.parser.CGGEParser1;
import com.mapinfo.mapmarker.cgge.scorer.ICGGEScorer;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.List;

public class ISR_Parser
extends CGGEParser1 {
    private static final String STARTING_BRACKET = "{";
    private static final String ENDING_BRACKET = "}";
    private static final String EMPTY_STRING = "";
    private static final String DOT = ".";
    private static final int FULL_POSTALCODE_LENGTH = 7;

    @Override
    public AddressWord[] splitIntoWeightedWords(String str, FieldType type) {
        if (FieldType.STREET_NAME_FIELD_TYPE == type) {
            str = this.cleanInputString(str);
        }
        return super.splitIntoWeightedWords(str, type);
    }

    @Override
    public ParsedAddress[] parse(InputAddress inputAddress, ICGGEScorer scorer) {
        ParsedAddress[] parsedAddresses = super.parse(inputAddress, scorer);
        if (parsedAddresses != null && parsedAddresses.length > 0) {
            ParsedAddress parsedAddr = parsedAddresses[0];
            if (parsedAddr.getField(FieldType.POST_CODE_FIELD_TYPE) != null) {
                this.populatePartialPostCodeToGenericField(parsedAddr, (AddressWord[])parsedAddr.getField(FieldType.POST_CODE_FIELD_TYPE));
            } else {
                List<PostCode> pcProbables = parsedAddr.getProbablePostcodes();
                if (pcProbables != null) {
                    for (PostCode pc : pcProbables) {
                        this.populatePartialPostCodeToGenericField(parsedAddr, pc.getWords());
                    }
                    if (parsedAddr.getField(FieldType.GENERIC_FIELD_4_FIELD_TYPE) != null) {
                        parsedAddr.getProbablePostcodes().add(new PostCode((AddressWord[])parsedAddr.getField(FieldType.GENERIC_FIELD_4_FIELD_TYPE), parsedAddr.getProbablePostcodes().get(0).getPositionInInputStreet()));
                    }
                }
            }
        }
        return parsedAddresses;
    }

    private void populatePartialPostCodeToGenericField(ParsedAddress parsedAddr, AddressWord[] pcWords) {
        String inputPC = ISR_Utils.getStringFromAddressWordArray(pcWords);
        if (!MMUtils.isEmpty(inputPC) && inputPC.length() == 7) {
            parsedAddr.setField(FieldType.GENERIC_FIELD_4_FIELD_TYPE, this.getAddressWords(ISR_Utils.getInitialFiveDigitPC(pcWords)));
        }
    }

    private String cleanInputString(String str) {
        String string = str = StringUtilities.isEmpty((String)str) ? str : str.replace(STARTING_BRACKET, EMPTY_STRING).replace(ENDING_BRACKET, EMPTY_STRING);
        if (!StringUtilities.isEmpty((String)str) && str.endsWith(DOT)) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }
}

