/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.ITA.helper;

import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.dp.DataFetchException;
import com.mapinfo.mapmarker.cgge.dp.DataNotInitialisedException;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAddressWord;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.cgge.dp.InternalCandidateList;
import com.mapinfo.mapmarker.cgge.helper.CGGEStreetGeocodingHelper;
import java.util.List;

public class ITAStreetGeocodingHelper
extends CGGEStreetGeocodingHelper {
    private byte m_subtryCount;
    private static double m_minStreetSearchQuality = 0.8;

    @Override
    protected boolean generateStreetSubTries(IDataManager dataManager, ParsedAddress parsedAddress, GeocodeOptions options, InternalCandidateList candidateList) throws CGGEInternalException, DataNotInitialisedException, DataFetchException {
        boolean isSubTryValid = false;
        switch (this.m_subtryCount) {
            case 0: {
                this.m_subtryCount = (byte)(this.m_subtryCount + 1);
                isSubTryValid = super.generateStreetSubTries(dataManager, parsedAddress, options, candidateList);
                if (parsedAddress.isIntersectionCase()) break;
                AddressWord[] streetWords = (AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
                AddressWord[] filteredWords = this.filterSearchWords(streetWords, true, false, 12);
                List<DictionaryAddressWord> addressWords = this.getSearchableWords(filteredWords, FieldType.STREET_NAME_FIELD_TYPE, dataManager, m_minStreetSearchQuality, options);
                this.setAddressSearchWordList(addressWords);
                List<DictionaryAddressWord> searchWordList = this.filterSearchWords(addressWords, true, 1792);
                this.setSearchWordList(searchWordList);
                break;
            }
            case 1: {
                this.m_subtryCount = (byte)(this.m_subtryCount + 1);
                if (!parsedAddress.isIntersectionCase() && this.getSearchWordList() == null) {
                    List<DictionaryAddressWord> addressSearchWordsList = this.getAddressSearchWordList();
                    AddressWord[] streetWords = (AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
                    AddressWord[] filteredWords = this.filterSearchWords(streetWords, false, false, 256);
                    List<DictionaryAddressWord> searchableWords = this.getSearchableWords(filteredWords, FieldType.STREET_NAME_FIELD_TYPE, dataManager, m_minStreetSearchQuality, options);
                    if (addressSearchWordsList != null && searchableWords != null) {
                        addressSearchWordsList.addAll(searchableWords);
                    } else if (searchableWords != null) {
                        this.setAddressSearchWordList(searchableWords);
                    }
                    this.setSearchWordList(this.filterSearchWords(searchableWords, true, 1536));
                }
                isSubTryValid = true;
                break;
            }
            case 2: {
                this.m_subtryCount = (byte)(this.m_subtryCount + 1);
                if (!parsedAddress.isIntersectionCase() && this.getSearchWordList() == null) {
                    List<DictionaryAddressWord> addressSearchWordsList = this.getAddressSearchWordList();
                    AddressWord[] streetWords = (AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
                    AddressWord[] filteredWords = this.filterSearchWords(streetWords, false, false, 2560);
                    List<DictionaryAddressWord> searchableWords = this.getSearchableWords(filteredWords, FieldType.STREET_NAME_FIELD_TYPE, dataManager, m_minStreetSearchQuality, options);
                    if (addressSearchWordsList != null && searchableWords != null) {
                        addressSearchWordsList.addAll(searchableWords);
                    } else if (searchableWords != null) {
                        this.setAddressSearchWordList(searchableWords);
                    }
                    this.setSearchWordList(this.filterSearchWords(searchableWords, true, 1024));
                }
                isSubTryValid = true;
                break;
            }
            default: {
                this.m_subtryCount = (byte)(this.m_subtryCount + 1);
                isSubTryValid = super.generateStreetSubTries(dataManager, parsedAddress, options, candidateList);
            }
        }
        return isSubTryValid;
    }
}

