/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.JPN;

import com.mapinfo.mapmarker.cgge.CGGECandidateFilter;
import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.CGGERuntimeException;
import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.dp.InternalCandidateList;
import java.util.Map;

public class JPNCandidateFilter
extends CGGECandidateFilter {
    @Override
    public void filterMultipleCloseCandidates(InternalCandidateList internalCandList, ParsedAddress addr, GeocodeOptions options) throws CGGERuntimeException, CGGEInternalException {
        InternalScoringAddress cand;
        int closeMatches;
        super.filterMultipleCloseCandidates(internalCandList, addr, options);
        int n = closeMatches = internalCandList == null ? 0 : internalCandList.getNumberOfCloseMatches();
        if (closeMatches > 1 && (cand = internalCandList.getIndexedCandidate(0)).getAddressType() == 2) {
            for (int i = 1; i < closeMatches; ++i) {
                internalCandList.getIndexedCandidate(i).setCloseMatch(false);
            }
            internalCandList.setNumberOfCloseMatches(1);
        }
    }

    @Override
    public void filterCandidates(InternalCandidateList candList, ParsedAddress parsedAddr, GeocodeOptions options) throws CGGERuntimeException, CGGEInternalException {
        super.filterCandidates(candList, parsedAddr, options);
        this.filterFalseLngCandidate(candList, parsedAddr, options);
    }

    void filterFalseLngCandidate(InternalCandidateList candList, ParsedAddress parsedAddr, GeocodeOptions options) {
        if (options.getGeocodeType() == 1 && candList.hasCloseCandidates() && !this.isLatinInputAndCandidate(candList.getIndexedCandidate(0), parsedAddr)) {
            this.filterNonAreaMatchingCandidates(candList, parsedAddr, options);
        }
    }

    private boolean isLatinInputAndCandidate(InternalScoringAddress cand, ParsedAddress parsedAddr) {
        if ("en".equalsIgnoreCase(cand.getDataSetInfo().getLanguage())) {
            return this.hasLatinAreaNameInput(parsedAddr);
        }
        return false;
    }

    private boolean hasLatinAreaNameInput(ParsedAddress parsedAddr) {
        return this.hasLatinCharacters((AddressWord[])parsedAddr.getField(FieldType.POST_ADDRESS_FIELD_TYPE)) || this.hasLatinCharacters((AddressWord[])parsedAddr.getField(FieldType.AREA_NAME_1_FIELD_TYPE)) || this.hasLatinCharacters((AddressWord[])parsedAddr.getField(FieldType.AREA_NAME_2_FIELD_TYPE)) || this.hasLatinCharacters((AddressWord[])parsedAddr.getField(FieldType.AREA_NAME_3_FIELD_TYPE)) || this.hasLatinCharacters((AddressWord[])parsedAddr.getField(FieldType.AREA_NAME_4_FIELD_TYPE));
    }

    private boolean hasLatinCharacters(AddressWord[] addrWords) {
        if (addrWords != null) {
            for (AddressWord addrWord : addrWords) {
                if (!this.hasLatinCharacters(addrWord.getWordChars())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasLatinCharacters(char[] wordChars) {
        for (char ch : wordChars) {
            if (ch < 'A' || ch > 'Z') continue;
            return true;
        }
        return false;
    }

    private void filterNonAreaMatchingCandidates(InternalCandidateList candList, ParsedAddress addr, GeocodeOptions options) {
        if (this.hasSeperateAreaInput(addr)) {
            InternalScoringAddress cand;
            int checkedCandNdx;
            int closeCount = candList.getNumberOfCloseMatches();
            for (checkedCandNdx = 0; checkedCandNdx < closeCount && this.hasNonNumericFieldMatch(cand = candList.getIndexedCandidate(checkedCandNdx)); ++checkedCandNdx) {
            }
            if (checkedCandNdx < closeCount) {
                this.degradeCloseMatches(candList, checkedCandNdx);
            }
        }
    }

    private boolean hasSeperateAreaInput(ParsedAddress addr) {
        return !this.isEmptyField(addr, FieldType.POST_ADDRESS_FIELD_TYPE) || !this.isEmptyField(addr, FieldType.AREA_NAME_1_FIELD_TYPE) || !this.isEmptyField(addr, FieldType.AREA_NAME_2_FIELD_TYPE) || !this.isEmptyField(addr, FieldType.AREA_NAME_3_FIELD_TYPE) || !this.isEmptyField(addr, FieldType.AREA_NAME_4_FIELD_TYPE);
    }

    private void degradeCloseMatches(InternalCandidateList candList, int from) {
        int closeCount = candList.getNumberOfCloseMatches();
        for (int checkedCandNdx = from; checkedCandNdx < closeCount; ++checkedCandNdx) {
            candList.getIndexedCandidate(checkedCandNdx).setCloseMatch(false);
        }
        candList.setNumberOfCloseMatches(from);
    }

    private boolean hasNonNumericFieldMatch(InternalScoringAddress cand) {
        Map<FieldType, FieldScore> scores = cand.getFieldScores();
        if (scores != null) {
            for (Map.Entry<FieldType, FieldScore> scoreEn : scores.entrySet()) {
                FieldScore score;
                FieldType type = scoreEn.getKey();
                if (type == FieldType.POST_CODE_FIELD_TYPE || type == FieldType.STREET_NAME_FIELD_TYPE || type == FieldType.ADDRESS_NUMBER_FIELD_TYPE || (score = scoreEn.getValue()) == null || !(score.m_value > 0.3)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isEmptyField(ParsedAddress addr, FieldType type) {
        return addr.getField(type) == null;
    }
}

