/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.JPN.convertor;

import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.JPN.convertor.JPNAbstractCandidateConvertor;
import com.mapinfo.mapmarker.JPN.utils.JapaneseNumerals;
import com.mapinfo.mapmarker.cgge.address.Address;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalFieldValue;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.user.IResponseCandidate;
import com.mapinfo.mapmarker.user.ReverseGeocodeCandidateAddress;
import com.mapinfo.mapmarker.utils.StringUtilities;

public class JPNLatinCandidateConvertor
extends JPNAbstractCandidateConvertor {
    @Override
    public void adjustBeforeCreatingCandidateAddress(Address address) {
    }

    @Override
    protected String replaceToDoubleByteNumber(String str) {
        return str;
    }

    @Override
    public void adjustOutputCandidateFields(IResponseCandidate candAddr) {
        super.adjustOutputCandidateFields(candAddr);
        StringBuilder builder = new StringBuilder();
        boolean bPrevOutput = false;
        boolean b_AlphaAreaName4 = false;
        if (!StringUtilities.isEmpty((String)candAddr.getMainAddress())) {
            bPrevOutput = true;
            if (!StringUtilities.isEmpty((String)candAddr.getAreaName4())) {
                char lastCh = candAddr.getAreaName4().charAt(candAddr.getAreaName4().length() - 1);
                if (MMUtils.isDigit(lastCh) || JapaneseNumerals.isNumber(new char[]{lastCh})) {
                    builder.append(candAddr.getAreaName4());
                    builder.append('-');
                } else {
                    b_AlphaAreaName4 = true;
                }
            }
            builder.append(candAddr.getMainAddress());
            if (!StringUtilities.isEmpty((String)candAddr.getAddressNumber())) {
                builder.append('-');
                builder.append(candAddr.getAddressNumber());
            }
            if (b_AlphaAreaName4) {
                builder.append(' ');
                builder.append(candAddr.getAreaName4());
            }
        } else if (!StringUtilities.isEmpty((String)candAddr.getAreaName4())) {
            bPrevOutput = true;
            builder.append(candAddr.getAreaName4());
        }
        if (!StringUtilities.isEmpty((String)candAddr.getAreaName3())) {
            if (bPrevOutput) {
                builder.append(' ');
            } else {
                bPrevOutput = true;
            }
            builder.append(candAddr.getAreaName3());
        }
        if (!StringUtilities.isEmpty((String)candAddr.getAreaName2())) {
            if (bPrevOutput) {
                builder.append(' ');
            } else {
                bPrevOutput = true;
            }
            builder.append(candAddr.getAreaName2());
        }
        if (!StringUtilities.isEmpty((String)candAddr.getAreaName1())) {
            if (bPrevOutput) {
                builder.append(' ');
            }
            builder.append(candAddr.getAreaName1());
        }
        if (candAddr instanceof CandidateAddress) {
            ((CandidateAddress)candAddr).setFormattedStreetAddress(builder.toString());
        } else if (candAddr instanceof ReverseGeocodeCandidateAddress) {
            ((ReverseGeocodeCandidateAddress)candAddr).setFormattedStreetAddress(builder.toString());
        }
    }

    @Override
    public void setPrecisionCode(CandidateAddress cand) {
        cand.addKeyValueToAdditionalFields("RESULT_CODE", InternalCandidateAddress.buildPrecisionCodeFromCandidate((CandidateAddress)cand));
    }

    @Override
    protected String getPlaceInfo(InternalScoringAddress scoringAddress, boolean includeAddressNumber) {
        InternalFieldValue placeInfo = (InternalFieldValue)scoringAddress.getField(FieldType.PLACE_NAME_FIELD_TYPE);
        if (placeInfo != null) {
            AddressWord[] words;
            StringBuilder sb = new StringBuilder(20);
            for (AddressWord word : words = (AddressWord[])placeInfo.getFieldValue()) {
                sb.append(word.getWord());
                sb.append(' ');
            }
            if (sb.length() > 0) {
                return sb.toString().trim();
            }
        }
        return null;
    }
}

