/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.JPN.dp.builder.reader;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class HistoricCityNames {
    private Map<String, Map<String, Map<String, List<OldCity>>>> m_newPrefsMap = new HashMap<String, Map<String, Map<String, List<OldCity>>>>();

    public void add(String pref, String newCity, String ooazaPrefix, String oldCity) {
        if (pref == null) {
            throw new NullPointerException("pref is null");
        }
        if (newCity == null) {
            throw new NullPointerException("newCity is null");
        }
        if (oldCity == null) {
            throw new NullPointerException("oldCity is null");
        }
        if (ooazaPrefix == null) {
            ooazaPrefix = "";
        }
        if (!newCity.equals(oldCity) || ooazaPrefix.length() != 0) {
            List<OldCity> oldCities;
            Map<String, List<OldCity>> newOoazaPrefixMap;
            Map<String, Map<String, List<OldCity>>> newCitiesMap = this.m_newPrefsMap.get(pref);
            if (newCitiesMap == null) {
                newCitiesMap = new HashMap<String, Map<String, List<OldCity>>>();
                this.m_newPrefsMap.put(pref, newCitiesMap);
            }
            if ((newOoazaPrefixMap = newCitiesMap.get(newCity)) == null) {
                newOoazaPrefixMap = new HashMap<String, List<OldCity>>(5);
                newCitiesMap.put(newCity, newOoazaPrefixMap);
            }
            if ((oldCities = newOoazaPrefixMap.get(ooazaPrefix)) == null) {
                oldCities = new ArrayList<OldCity>(5);
                newOoazaPrefixMap.put(ooazaPrefix, oldCities);
            }
            OldCity oldCityObj = new OldCity(pref, newCity, ooazaPrefix, oldCity);
            oldCities.add(oldCityObj);
        }
    }

    public List<OldCity> getOldCities(String pref, String newCity, String newOoaza) {
        Map<String, List<OldCity>> ooazaPrefixMap;
        if (pref == null) {
            throw new NullPointerException("pref is null");
        }
        if (newCity == null) {
            throw new NullPointerException("newCity is null");
        }
        if (newOoaza == null) {
            throw new NullPointerException("newOoaza is null");
        }
        List oldCities = null;
        Map<String, Map<String, List<OldCity>>> newCitiesMap = this.m_newPrefsMap.get(pref);
        if (newCitiesMap != null && (ooazaPrefixMap = newCitiesMap.get(newCity)) != null) {
            int newOoazaLen = newOoaza == null ? 0 : newOoaza.length();
            Iterator<Map.Entry<String, List<OldCity>>> it = ooazaPrefixMap.entrySet().iterator();
            Map.Entry<String, List<OldCity>> matchingEntry = null;
            while (it.hasNext()) {
                Map.Entry<String, List<OldCity>> en = it.next();
                String ooazaPrefix = en.getKey();
                int ooazaPrefixLen = ooazaPrefix.length();
                if (newOoazaLen == 0 && ooazaPrefixLen == 0) {
                    matchingEntry = en;
                    break;
                }
                if (ooazaPrefixLen <= 0 || newOoaza.indexOf(en.getKey()) != 0 || matchingEntry != null && ooazaPrefix.length() <= matchingEntry.getKey().length()) continue;
                matchingEntry = en;
            }
            if (matchingEntry != null) {
                oldCities = (List)matchingEntry.getValue();
            }
        }
        return oldCities;
    }

    public List<OldCity> getOldCities(String pref, String newCity) {
        Map<String, List<OldCity>> ooazaPrefixMap;
        if (pref == null) {
            throw new NullPointerException("pref is null");
        }
        if (newCity == null) {
            throw new NullPointerException("newCity is null");
        }
        HashSet oldCities = null;
        Map<String, Map<String, List<OldCity>>> newCitiesMap = this.m_newPrefsMap.get(pref);
        if (newCitiesMap != null && (ooazaPrefixMap = newCitiesMap.get(newCity)) != null) {
            Iterator<List<OldCity>> it = ooazaPrefixMap.values().iterator();
            oldCities = new HashSet();
            while (it.hasNext()) {
                oldCities.addAll(it.next());
            }
        }
        if (oldCities != null) {
            return new ArrayList<OldCity>(oldCities);
        }
        return null;
    }

    public class OldCity {
        public String m_oldCityName;
        public String m_prefeture;
        public String m_newCityName;
        public String m_newOoazaPrefix;

        public OldCity(String pref, String newCity, String ooazaPrefix, String oldCity) {
            this.m_oldCityName = oldCity;
            this.m_newOoazaPrefix = ooazaPrefix;
            this.m_newCityName = newCity;
            this.m_prefeture = pref;
        }
    }
}

