/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.JPN.dp.builder.reader;

import com.mapinfo.mapmarker.JPN.dp.builder.reader.HistoricCityNames;
import com.mapinfo.mapmarker.cgge.address.AddressFieldValue;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.RawAddress;
import com.mapinfo.mapmarker.cgge.dp.builder.InvalidFieldMappingException;
import com.mapinfo.mapmarker.cgge.dp.builder.RawDataReader;
import com.mapinfo.mapmarker.cgge.dp.builder.reader.DataReadException;
import com.mapinfo.mapmarker.cgge.utils.CGGEResourceBundle;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import com.mapinfo.midev.geometry.DirectPosition;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPN_TextFileReader
extends RawDataReader {
    static final Logger logger = LoggerFactory.getLogger(JPN_TextFileReader.class);
    private String m_filepath = null;
    private String m_filename = null;
    private BufferedReader m_reader = null;
    private int m_recordsRead = 0;
    private static final String KEY_FILE_NAME = "file_name";
    private static final String KEY_HISTROIC_CITY_FILE_NAME = "historic_city_file_name";
    private static final double DATUM_CONVERSION_DIVISOR = 921600.0;
    public static final String KEY_PREF_CODE_COL = "pref_code_column";
    public static final String KEY_CITY_CODE_COL = "city_code_column";
    public static final String KEY_OOAZA_CODE_COL = "ooaza_code_column";
    public static final String KEY_PREF_COL = "pref_column";
    public static final String KEY_CITY_COL = "city_column";
    public static final String KEY_OOAZA_COL = "ooaza_column";
    public static final String KEY_OOAZA_ALT_COL = "ooaza_alt_column";
    public static final String KEY_CHOME_CODE_COL = "chome_code_column";
    public static final String KEY_CHOME_COL = "chome_column";
    public static final String KEY_BLOCK_COL = "block_column";
    public static final String KEY_LOT_COL = "lot_column";
    public static final String KEY_PC_COL = "pc_column";
    public static final String KEY_X_COL = "x_column";
    public static final String KEY_Y_COL = "y_column";
    private int PREF_CODE_COL = 0;
    private int CITY_CODE_COL = 3;
    private int OOAZA_CODE_COL = 6;
    private int PREF_COL = 1;
    private int CITY_COL = 4;
    private int OOAZA_COL = 7;
    private int OOAZA_ALT_COL = 8;
    private int CHOME_CODE_COL = 11;
    private int CHOME_COL = 12;
    private int BLOCK_COL = 16;
    private int LOT_COL = 19;
    private int PC_COL = 14;
    private int X_COL = 21;
    private int Y_COL = 22;
    private String m_coordSys = "epsg:4301";
    private HistoricCityNames m_histroicCityNames;
    private FieldType m_jushoCodeField = null;
    private FieldType m_oldCityField = null;
    private FieldType m_ooazaPrefixIndicator = null;
    private boolean m_geographicType = false;

    @Override
    protected void confirmMappings() throws InvalidFieldMappingException {
    }

    @Override
    public String getCurrentFileSetName() {
        return this.m_filename;
    }

    @Override
    public RawAddress getNextRecord() {
        JPN_RawAddress addr = null;
        String addrLine = null;
        try {
            addrLine = this.m_reader.readLine();
        }
        catch (IOException e) {
            throw new DataReadException(e);
        }
        if (addrLine != null) {
            ++this.m_recordsRead;
            addr = new JPN_RawAddress();
            String[] fields = addrLine.split(";");
            this.setField(addr, FieldType.AREA_NAME_1_FIELD_TYPE, fields, this.PREF_COL);
            this.setField(addr, FieldType.AREA_NAME_2_FIELD_TYPE, fields, this.CITY_COL);
            this.setField(addr, FieldType.AREA_NAME_3_FIELD_TYPE, fields, this.OOAZA_COL);
            AddressFieldValue fv = (AddressFieldValue)addr.getField(FieldType.AREA_NAME_3_FIELD_TYPE);
            if (fv != null) {
                this.setAltField(fv, fields, this.OOAZA_ALT_COL);
            }
            this.setField(addr, FieldType.AREA_NAME_4_FIELD_TYPE, fields, this.CHOME_COL);
            this.setField(addr, FieldType.STREET_NAME_FIELD_TYPE, fields, this.BLOCK_COL);
            this.setField(addr, FieldType.POST_CODE_FIELD_TYPE, fields, this.PC_COL);
            String lot = this.getFieldValue(fields, this.LOT_COL);
            if (lot != null) {
                addr.setField(FieldType.ADDRESS_NUMBER_FROM_FIELD_TYPE, new AddressFieldValue(lot));
            }
            if (this.m_oldCityField != null) {
                this.assignOldCities(addr);
            }
            if (this.m_jushoCodeField != null) {
                fv = new AddressFieldValue(this.getJushoCode(fields));
                addr.setField(this.m_jushoCodeField, fv);
            }
            ((RawAddress)addr).setSac(this.getSac(fields));
            ((RawAddress)addr).setCoordinates(this.getCoordinates(fields));
        } else {
            logger.debug("Records processed " + this.m_recordsRead);
        }
        return addr;
    }

    protected DirectPosition[] getCoordinates(String[] fields) {
        DirectPosition point = new DirectPosition();
        try {
            String x = this.getFieldValue(fields, this.X_COL);
            String y = this.getFieldValue(fields, this.Y_COL);
            double x_coord = this.adjustForDatum(Double.parseDouble(x));
            double y_coord = this.adjustForDatum(Double.parseDouble(y));
            point.setX(x_coord);
            point.setY(y_coord);
        }
        catch (Exception e) {
            throw new DataReadException("Error parsing coordinate values: " + e.toString());
        }
        return new DirectPosition[]{point};
    }

    protected String getSac(String[] fields) {
        StringBuilder sb = new StringBuilder(15);
        String prefCode = this.getFieldValue(fields, this.PREF_CODE_COL);
        String cityCode = this.getFieldValue(fields, this.CITY_CODE_COL);
        String ooazaCode = this.getFieldValue(fields, this.OOAZA_CODE_COL);
        sb.append(prefCode);
        sb.append(cityCode);
        if (MMUtils.isNumber(ooazaCode)) {
            sb.append(ooazaCode);
        } else if (MMUtils.startsWithDigits(ooazaCode.toCharArray()) && (ooazaCode = MMUtils.getStartingNumberPart(ooazaCode)) != null) {
            sb.append(ooazaCode);
        }
        return sb.toString();
    }

    protected String getJushoCode(String[] fields) {
        StringBuilder sb = new StringBuilder(15);
        String prefCode = this.getFieldValue(fields, this.PREF_CODE_COL);
        String cityCode = this.getFieldValue(fields, this.CITY_CODE_COL);
        String ooazaCode = this.getFieldValue(fields, this.OOAZA_CODE_COL);
        String chomeCode = this.getFieldValue(fields, this.CHOME_CODE_COL);
        sb.append(prefCode);
        sb.append(cityCode);
        sb.append(ooazaCode);
        sb.append(chomeCode);
        return sb.toString();
    }

    protected String adjustOoazaCase(String ooaza) {
        return ooaza;
    }

    protected void assignOldCities(RawAddress addr) {
        if (this.m_histroicCityNames != null) {
            String pref = this.getFieldValue(addr, FieldType.AREA_NAME_1_FIELD_TYPE);
            String city = this.getFieldValue(addr, FieldType.AREA_NAME_2_FIELD_TYPE);
            String ooaza = this.adjustOoazaCase(this.getFieldValue(addr, FieldType.AREA_NAME_3_FIELD_TYPE));
            String chome = this.getFieldValue(addr, FieldType.AREA_NAME_4_FIELD_TYPE);
            String street = this.getFieldValue(addr, FieldType.STREET_NAME_FIELD_TYPE);
            boolean matchOoazaPrefix = true;
            if (pref != null && city != null) {
                int n;
                List<HistoricCityNames.OldCity> oldCities = null;
                if (MMUtils.isEmpty(ooaza) && MMUtils.isEmpty(chome) && MMUtils.isEmpty(street)) {
                    oldCities = this.m_histroicCityNames.getOldCities(pref, city);
                    if (oldCities == null) {
                        oldCities = this.m_histroicCityNames.getOldCities(this.removePrefectureSuffix(pref), city);
                    }
                    matchOoazaPrefix = false;
                } else {
                    oldCities = this.m_histroicCityNames.getOldCities(pref, city, ooaza == null ? "" : ooaza);
                    if (oldCities == null) {
                        oldCities = this.m_histroicCityNames.getOldCities(this.removePrefectureSuffix(pref), city, ooaza == null ? "" : ooaza);
                    }
                    if (oldCities == null && ooaza != null) {
                        matchOoazaPrefix = false;
                        oldCities = this.m_histroicCityNames.getOldCities(pref, city, "");
                        if (oldCities == null) {
                            this.m_histroicCityNames.getOldCities(this.removePrefectureSuffix(pref), city, "");
                        }
                    } else {
                        matchOoazaPrefix = ooaza != null && ooaza.length() > 0;
                    }
                }
                int n2 = n = oldCities == null ? 0 : oldCities.size();
                if (n > 0) {
                    AddressFieldValue fv = new AddressFieldValue(oldCities.get((int)0).m_oldCityName);
                    if (n > 1) {
                        String[] oldCityNames = new String[n - 1];
                        for (int i = 1; i < n; ++i) {
                            oldCityNames[i - 1] = oldCities.get((int)i).m_oldCityName;
                        }
                        fv.setAlternateValues(oldCityNames);
                    }
                    addr.setField(this.m_oldCityField, fv);
                    this.assignOldCityAsCityAlternates(oldCities, addr);
                    if (matchOoazaPrefix && this.m_ooazaPrefixIndicator != null) {
                        addr.setField(this.m_ooazaPrefixIndicator, new AddressFieldValue("Y"));
                    }
                    if (this.m_geographicType && matchOoazaPrefix) {
                        this.assignOldCityAsOoazaAlternates(oldCities, addr);
                    }
                }
            }
        }
    }

    protected String removePrefectureSuffix(String pref) {
        return pref;
    }

    private void assignOldCityAsOoazaAlternates(List<HistoricCityNames.OldCity> oldCities, RawAddress addr) {
        AddressFieldValue fv = (AddressFieldValue)addr.getField(FieldType.AREA_NAME_3_FIELD_TYPE);
        if (fv != null) {
            String[] alts = (String[])fv.getAlternateValues();
            ArrayList<String> altList = new ArrayList<String>(10);
            if (alts != null) {
                altList.addAll(Arrays.asList(alts));
            }
            for (HistoricCityNames.OldCity oldCity : oldCities) {
                if (oldCity.m_newOoazaPrefix == null || oldCity.m_newOoazaPrefix.length() <= 0) continue;
                altList.add(oldCity.m_oldCityName);
            }
            if (altList.size() > 0) {
                fv.setAlternateValues(altList.toArray(new String[altList.size()]));
            }
        }
    }

    private void assignOldCityAsCityAlternates(List<HistoricCityNames.OldCity> oldCities, RawAddress addr) {
        AddressFieldValue fv = (AddressFieldValue)addr.getField(FieldType.AREA_NAME_2_FIELD_TYPE);
        if (fv != null) {
            String[] alts = (String[])fv.getAlternateValues();
            ArrayList<String> altList = new ArrayList<String>(10);
            if (alts != null) {
                altList.addAll(Arrays.asList(alts));
            }
            for (HistoricCityNames.OldCity oldCity : oldCities) {
                altList.add(oldCity.m_oldCityName);
            }
            if (altList.size() > 0) {
                fv.setAlternateValues(altList.toArray(new String[altList.size()]));
            }
        }
    }

    private String getFieldValue(RawAddress addr, FieldType type) {
        AddressFieldValue fv = (AddressFieldValue)addr.getField(type);
        if (fv != null) {
            return (String)fv.getFieldValue();
        }
        return null;
    }

    @Override
    public final boolean isSacFromFile() {
        return true;
    }

    private void setField(RawAddress address, FieldType type, String[] fields, int column) {
        String fv = this.getFieldValue(fields, column);
        if (fv != null && fv.length() > 0) {
            AddressFieldValue afv = new AddressFieldValue(fv);
            address.setField(type, afv);
        }
    }

    private void setAltField(AddressFieldValue fv, String[] fields, int column) {
        String v = this.getFieldValue(fields, column);
        if (v != null && v.length() > 0) {
            String[] alts = MMUtils.splitString(v, '|');
            fv.setAlternateValues(alts);
        }
    }

    private String getFieldValue(String[] fields, int column) {
        String fv = null;
        if (column > -1 && column < fields.length && (fv = fields[column]) != null) {
            if ((fv = fv.trim()).length() > 0 && fv.startsWith("\"")) {
                fv = fv.substring(1);
            }
            if (fv.length() > 0 && fv.endsWith("\"")) {
                fv = fv.substring(0, fv.length() - 1);
            }
        }
        return fv;
    }

    private int getColumnNumber(Properties prop, String key) throws Exception {
        String strCol = prop.getProperty(key);
        int col = -1;
        if (strCol != null) {
            try {
                col = Integer.parseInt(strCol);
            }
            catch (NumberFormatException e) {
                throw new Exception("Invalid column mapping. ", e);
            }
        }
        return col;
    }

    private boolean isDoubleIntegralType(double doub) {
        return doub == Math.floor(doub) && !Double.isInfinite(doub);
    }

    private double adjustForDatum(double coord) {
        if (this.isDoubleIntegralType(coord)) {
            return coord / 921600.0;
        }
        return coord;
    }

    @Override
    public boolean loadData(Properties prop) throws Exception {
        String country = prop.getProperty("country");
        String dn = prop.getProperty("dataName");
        String dp = prop.getProperty("dataProviderName");
        String path = "/com/mapinfo/mapmarker/" + country + "/config/" + dn + "_" + dp + "_TextColumnMapping.properties";
        this.m_properties = null;
        this.m_properties = CGGEResourceBundle.getBundle(path);
        this.m_filepath = (String)prop.get("inputPath");
        this.m_filename = (String)this.m_properties.get(KEY_FILE_NAME);
        this.m_filepath = MMUtils.appendToPath(this.m_filepath, this.m_filename);
        String fileName = (String)this.m_properties.get(KEY_HISTROIC_CITY_FILE_NAME);
        if (fileName != null && fileName.trim().length() > 0) {
            String historicFilepath = MMUtils.appendToPath((String)prop.get("inputPath"), fileName.trim());
            this.m_histroicCityNames = this.loadHistoricalCityNameData(historicFilepath);
        }
        this.PREF_CODE_COL = this.getColumnNumber(this.m_properties, KEY_PREF_CODE_COL);
        this.CITY_CODE_COL = this.getColumnNumber(this.m_properties, KEY_CITY_CODE_COL);
        this.OOAZA_CODE_COL = this.getColumnNumber(this.m_properties, KEY_OOAZA_CODE_COL);
        this.PREF_COL = this.getColumnNumber(this.m_properties, KEY_PREF_COL);
        this.CITY_COL = this.getColumnNumber(this.m_properties, KEY_CITY_COL);
        this.OOAZA_COL = this.getColumnNumber(this.m_properties, KEY_OOAZA_COL);
        this.CHOME_COL = this.getColumnNumber(this.m_properties, KEY_CHOME_COL);
        this.BLOCK_COL = this.getColumnNumber(this.m_properties, KEY_BLOCK_COL);
        this.LOT_COL = this.getColumnNumber(this.m_properties, KEY_LOT_COL);
        this.PC_COL = this.getColumnNumber(this.m_properties, KEY_PC_COL);
        this.X_COL = this.getColumnNumber(this.m_properties, KEY_X_COL);
        this.Y_COL = this.getColumnNumber(this.m_properties, KEY_Y_COL);
        this.CHOME_CODE_COL = this.getColumnNumber(this.m_properties, KEY_CHOME_CODE_COL);
        if (m_dditionalFieldNames != null) {
            this.m_jushoCodeField = (FieldType)m_dditionalFieldNames.get("JUSHO_CODE");
            this.m_ooazaPrefixIndicator = (FieldType)m_dditionalFieldNames.get("HAS_NEW_CITY_OOAZA_PREFIX");
            this.m_oldCityField = (FieldType)m_dditionalFieldNames.get("old_city");
        }
        String dictType = prop.getProperty("dictionaryType", "");
        this.m_geographicType = "geographic".equals(dictType);
        return true;
    }

    public HistoricCityNames loadHistoricalCityNameData(String path) throws IOException {
        InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(path), "UTF-8");
        BufferedReader r = new BufferedReader(in);
        String line = r.readLine();
        HistoricCityNames names = new HistoricCityNames();
        while ((line = r.readLine()) != null) {
            String[] cols = MMUtils.splitString(line, ',');
            if (cols == null || cols.length != 4) continue;
            names.add(cols[0].trim(), cols[1].trim(), cols[2].trim(), cols[3].trim());
        }
        return names;
    }

    @Override
    public boolean loadNextFileSet() {
        try {
            if (this.m_reader == null) {
                InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(this.m_filepath), "UTF-8");
                this.m_reader = new BufferedReader(in);
                this.m_reader.readLine();
                this.m_recordsRead = 0;
                return true;
            }
            this.m_reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    protected void populateAdditionalFields(RawAddress addr) {
    }

    @Override
    public void rewind() {
        if (this.m_reader != null) {
            try {
                this.m_reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.m_reader = null;
    }

    @Override
    public String getCoordSysString() {
        return this.m_coordSys;
    }

    class JPN_RawAddress
    extends RawAddress {
        private int m_oddEvenType = 0;
        private int m_streetSide = 0;
        DirectPosition[] m_points;
        private String m_sac;

        JPN_RawAddress() {
        }

        @Override
        public DirectPosition[] getCoordinates() {
            return this.m_points;
        }

        @Override
        public int getOddEvenType() {
            return this.m_oddEvenType;
        }

        @Override
        public String getSac() {
            return this.m_sac;
        }

        @Override
        public int getStreetSide() {
            return this.m_streetSide;
        }

        @Override
        public void setCoordinates(DirectPosition[] points) {
            this.m_points = points;
        }

        @Override
        public void setOddEvenType(int type) {
            this.m_oddEvenType = type;
        }

        @Override
        public void setSac(String sac) {
            this.m_sac = sac;
        }

        @Override
        public void setStreetSide(int side) {
            this.m_streetSide = side;
        }
    }
}

