/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.JPN.helper;

import com.mapinfo.mapmarker.JPN.utils.JPNCandidateUtils;
import com.mapinfo.mapmarker.JPN.utils.JPNCharUtils;
import com.mapinfo.mapmarker.JPN.utils.JapaneseNumerals;
import com.mapinfo.mapmarker.cgge.CGGEHandler;
import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.address.AddressNumber;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.CodedWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalFieldValue;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.address.PostCode;
import com.mapinfo.mapmarker.cgge.address.WordAlternate;
import com.mapinfo.mapmarker.cgge.dp.DataFetchException;
import com.mapinfo.mapmarker.cgge.dp.DataNotInitialisedException;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAddressWord;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAreaSacs;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAreaTermItem;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.cgge.dp.IDictionaryMetaData;
import com.mapinfo.mapmarker.cgge.dp.InternalCandidateList;
import com.mapinfo.mapmarker.cgge.helper.ICGGEGeocodingHelper;
import com.mapinfo.mapmarker.cgge.parser.ICGGEParser;
import com.mapinfo.mapmarker.cgge.soundex.ICGGESoundex;
import com.mapinfo.mapmarker.cgge.utils.AddressWordArray;
import com.mapinfo.mapmarker.cgge.utils.CharArray;
import com.mapinfo.mapmarker.cgge.utils.IntArray;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class JPNAbstractHelper
implements ICGGEGeocodingHelper {
    private static final char[][] STREET_SEPERATORS = new char[][]{{'\u756a', '\u5730', '\u306e'}, {'\u756a', '\u5730'}};
    private static final char[] CHOME_IDENTIFIER = new char[]{'\u4e01', '\u76ee'};
    private static final char[] PREF_IDENTIFIER_CHARS = new char[]{'\u770c', '\u90fd', '\u9053', '\u5e9c'};
    private static final char[] NUMERIC_SEPARATOR_CHARS = new char[]{'\u306e', '\u30ce', '\u30fc', '\u756a'};
    private static final char ADDRESS_NUMBER_SEPERATOR = '\u53f7';
    private static final Pattern m_streetPattern = Pattern.compile("(\\d+|[\uff10-\uff190-9]+|(\u96f6|\u4e00|\u4e8c|\u4e09|\u56db|\u4e94|\u516d|\u4e03|\u516b|\u4e5d|\u767e|\u5341|\u62fe|\u5343|\u4e07)+) *((\u756a(\u5730\u306e?)?)|\u53f7)");
    protected static final FieldType PREFECTURE_FIELD = FieldType.AREA_NAME_1_FIELD_TYPE;
    protected static final FieldType CITY_FIELD = FieldType.AREA_NAME_2_FIELD_TYPE;
    protected static final FieldType OOAZA_FIELD = FieldType.AREA_NAME_3_FIELD_TYPE;
    protected static final FieldType CHOME_FIELD = FieldType.AREA_NAME_4_FIELD_TYPE;
    protected static final FieldType BLOCK_FIELD = FieldType.STREET_NAME_FIELD_TYPE;
    protected static final FieldType LOT_FIELD = FieldType.ADDRESS_NUMBER_FIELD_TYPE;
    private String m_country;
    private String m_language;
    private ParsedAddress m_savedParsedAddress;
    private FieldType m_addressSearchField;
    private boolean m_canTryAgain;
    private GeocodeOptions m_savedOptions;
    private ICGGESoundex m_soundex;
    private ICGGEParser m_parser;
    private int m_geoType;
    private boolean m_containsUnparsedInputs = false;
    private List<char[]> m_singleLnInputList = null;
    private Map<FieldType, DictSearchResult> m_searchFieldResults = null;
    private Map<FieldType, DictSearchResult> m_savedSearchFieldResults = null;
    private Stack<Map<FieldType, DictSearchResult>> m_searchResultStack = new Stack();
    private boolean an2an3intersectionFound = false;

    @Override
    public boolean init(String country, String language) {
        this.m_country = country;
        this.m_language = language;
        this.m_canTryAgain = true;
        this.m_savedOptions = null;
        this.m_soundex = null;
        this.m_parser = null;
        this.m_geoType = 1;
        this.setAddressSearchField(BLOCK_FIELD);
        this.m_savedParsedAddress = null;
        return true;
    }

    protected List<char[]> getSingleLineInputList() {
        return this.m_singleLnInputList;
    }

    protected void setSingleLineInputList(List<char[]> inputList) {
        this.m_singleLnInputList = inputList;
    }

    protected void setSavedParsedAddress(ParsedAddress pAddr) {
        this.m_savedParsedAddress = pAddr;
    }

    protected ParsedAddress getSavedParsedAddress() {
        return this.m_savedParsedAddress;
    }

    protected void setGeocodeType(int geoType) {
        this.m_geoType = geoType;
    }

    protected int getGeocodeType() {
        return this.m_geoType;
    }

    protected ICGGEParser getParser() {
        if (this.m_parser == null) {
            this.m_parser = CGGEHandler.getInstance(null, this.m_country, this.m_language).getParser();
        }
        return this.m_parser;
    }

    protected ICGGESoundex getSoundex() {
        if (this.m_soundex == null) {
            this.m_soundex = CGGEHandler.getInstance(null, this.m_country, this.m_language).getSoundex();
        }
        return this.m_soundex;
    }

    protected AddressWord[] removeDelimiterWords(AddressWord[] words) {
        int c;
        int n = c = words == null ? 0 : words.length;
        if (c > 0) {
            ArrayList<AddressWord> wordList = new ArrayList<AddressWord>(c);
            for (int wordNdx = 0; wordNdx < c; ++wordNdx) {
                AddressWord word = words[wordNdx];
                if (CodedWord.isDelimiter(word.getAttributes())) continue;
                wordList.add(word);
            }
            if (wordList.size() < c) {
                return wordList.toArray(new AddressWord[wordList.size()]);
            }
        }
        return words;
    }

    protected char[] getChomeIdentiers() {
        return CHOME_IDENTIFIER;
    }

    protected List<DictionaryAreaTermItem> searchAreaItem(AddressWord searchWord, IDataManager dataManager, FieldType type, GeocodeOptions options) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        AddressWord[] searchWords = new AddressWord[]{searchWord};
        List<DictionaryAreaTermItem> areaList = dataManager.findAreaTerms(this.m_geoType, searchWords, type, 1.0, options);
        if (areaList == null && searchWord.hasAlternates()) {
            for (WordAlternate alt : searchWord.getAlternates()) {
                AddressWord altWord;
                if (alt.getAltType() == WordAlternate.ALT_TYPE.MULTI_WORD_ABBREVIATION) continue;
                searchWords[0] = altWord = alt.getAltWord();
                List<DictionaryAreaTermItem> altList = dataManager.findAreaTerms(this.m_geoType, searchWords, type, 1.0, options);
                if (areaList == null) {
                    areaList = altList;
                    continue;
                }
                if (altList == null) continue;
                areaList.addAll(altList);
            }
        }
        if (areaList != null && areaList.size() > 0) {
            return areaList;
        }
        return null;
    }

    protected String toggleChomeIdentifier(char[] str) {
        char[] newWord = null;
        char[] chars = CharArray.splitAtDelim(str, CHOME_IDENTIFIER[0], false);
        if (chars != null) {
            int originalLen = str.length;
            if (chars.length == originalLen - 1) {
                newWord = chars;
            } else if (chars.length == originalLen - 2 && str[originalLen - 1] == CHOME_IDENTIFIER[1]) {
                newWord = chars;
            }
        } else {
            newWord = new char[str.length + CHOME_IDENTIFIER.length];
            CharArray.arraycopy(str, 0, newWord, 0, str.length);
            CharArray.arraycopy(CHOME_IDENTIFIER, 0, newWord, str.length, CHOME_IDENTIFIER.length);
        }
        if (newWord != null) {
            return new String(newWord);
        }
        return null;
    }

    private <T> List<T> combineAreaList(List<T> list1, List<T> list2) {
        if (list1 != null) {
            if (list2 != null) {
                list1.addAll(list2);
                return list1;
            }
        } else if (list2 != null) {
            return list2;
        }
        return list1;
    }

    protected DictSearchResult findAndSetFieldFromWord(char[] str, FieldType type, ICGGESoundex soundex, ICGGEParser parser, IDataManager dataManager, GeocodeOptions options, boolean partialAllowed) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        String searchWord = null;
        AddressWord searchAddressWord = null;
        List<DictionaryAreaTermItem> areaList = null;
        if (!partialAllowed) {
            AddressWord searchWord1;
            List<DictionaryAreaTermItem> areaList1;
            String tryWord1;
            searchWord = new String(str);
            searchAddressWord = parser.convertToAddressWord(searchWord, soundex);
            areaList = this.searchAreaItem(searchAddressWord, dataManager, type, options);
            if (type == CHOME_FIELD && (tryWord1 = this.toggleChomeIdentifier(str)) != null && (areaList1 = this.searchAreaItem(searchWord1 = parser.convertToAddressWord(tryWord1, soundex), dataManager, type, options)) != null) {
                searchAddressWord.addAlternate(new WordAlternate(searchWord1, WordAlternate.ALT_TYPE.SINGLE_WORD_ABBREVIATION));
                areaList = this.combineAreaList(areaList, areaList1);
            }
        } else {
            char[] newStr;
            char[] knownIdentifiers = null;
            if (type == PREFECTURE_FIELD) {
                knownIdentifiers = PREF_IDENTIFIER_CHARS;
            }
            if (knownIdentifiers != null && (newStr = CharArray.splitAtAnyDelim(str, knownIdentifiers, true)) != null) {
                searchWord = new String(newStr);
                searchAddressWord = parser.convertToAddressWord(searchWord, soundex);
                areaList = this.searchAreaItem(searchAddressWord, dataManager, type, options);
            }
            if (areaList == null) {
                StringBuilder sb = new StringBuilder(str.length);
                sb.append(str);
                boolean lastCharWasDigit = false;
                boolean lastCharWasJapaneseNumeral = false;
                for (int len = sb.length(); len > 0; --len) {
                    boolean charIsJapaneseNumeral;
                    char ch = sb.charAt(len - 1);
                    boolean charIsDigit = MMUtils.isDigit(ch);
                    boolean bl = charIsJapaneseNumeral = charIsDigit ? false : JapaneseNumerals.isDigit(ch);
                    if (!(lastCharWasDigit && charIsDigit || lastCharWasJapaneseNumeral && charIsJapaneseNumeral)) {
                        searchWord = sb.toString();
                        searchAddressWord = parser.convertToAddressWord(searchWord, soundex);
                        areaList = this.searchAreaItem(searchAddressWord, dataManager, type, options);
                    }
                    if (areaList != null) break;
                    sb.deleteCharAt(len - 1);
                    lastCharWasDigit = charIsDigit;
                    lastCharWasJapaneseNumeral = charIsJapaneseNumeral;
                }
            }
        }
        DictSearchResult sr = null;
        if (areaList != null) {
            sr = new DictSearchResult(areaList, type, searchWord, searchAddressWord);
        }
        return sr;
    }

    private DictSearchResult findAndSetChomeFromWord(char[] searchWord, ICGGESoundex soundex, ICGGEParser parser, IDataManager dataManager, GeocodeOptions options, boolean partialAllowed) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        int pos = CharArray.indexOf(searchWord, '\u306e');
        for (int wordLen = searchWord.length; pos == 0 && wordLen > 1; --wordLen) {
            char[] trimmedSearchWord = new char[wordLen - 1];
            CharArray.arraycopy(searchWord, 1, trimmedSearchWord, 0, wordLen - 1);
            pos = CharArray.indexOf(searchWord, '\u306e');
            searchWord = trimmedSearchWord;
        }
        DictSearchResult sr = null;
        if (JapaneseNumerals.isNumber(searchWord)) {
            int n = JapaneseNumerals.toNumber(searchWord);
            sr = this.findAndSetFieldFromWord(Integer.toString(n).toCharArray(), CHOME_FIELD, soundex, parser, dataManager, options, false);
        }
        if (sr == null) {
            sr = this.findAndSetFieldFromWord(searchWord, CHOME_FIELD, soundex, parser, dataManager, options, false);
        }
        return sr;
    }

    private SearchOffset getNextCharOffsetForMatching(List<char[]> wordList, DictSearchResult searchResult) {
        if (searchResult != null) {
            int matchedLen = searchResult.getSearchLength();
            return this.getNextCharOffsetForMatching(wordList, searchResult.m_searchOffset.m_wordOffset, searchResult.m_searchOffset.m_charOffset, matchedLen);
        }
        return null;
    }

    private SearchOffset getNextCharOffsetForMatching(List<char[]> wordList, int matchedWordNdx, int matchedWordOffset, int matchedWordLen) {
        if ((matchedWordOffset += matchedWordLen) == wordList.get(matchedWordNdx).length) {
            ++matchedWordNdx;
            matchedWordOffset = 0;
        }
        return new SearchOffset(matchedWordNdx, matchedWordOffset);
    }

    protected void separateAreasAndBlockFromSingleLine(List<char[]> wordList, SearchOffset searchOffset, ParsedAddress parsedAddr, IDataManager dataManager, GeocodeOptions options, FieldType fromType, FieldType toType) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        DictSearchResult an1Result;
        ICGGEParser parser = this.getParser();
        ICGGESoundex soundex = this.getSoundex();
        ArrayList<FieldType> fieldList = new ArrayList<FieldType>(7);
        boolean search = false;
        if (fromType == PREFECTURE_FIELD) {
            fieldList.add(PREFECTURE_FIELD);
            boolean bl = search = toType != PREFECTURE_FIELD;
        }
        if (search || fromType == CITY_FIELD) {
            fieldList.add(CITY_FIELD);
            boolean bl = search = toType != CITY_FIELD;
        }
        if (search || fromType == OOAZA_FIELD) {
            fieldList.add(OOAZA_FIELD);
            boolean bl = search = toType != OOAZA_FIELD;
        }
        if (search || fromType == CHOME_FIELD) {
            fieldList.add(CHOME_FIELD);
            boolean bl = search = toType != CHOME_FIELD;
        }
        if (search || fromType == BLOCK_FIELD) {
            fieldList.add(BLOCK_FIELD);
            boolean bl = search = toType != BLOCK_FIELD;
        }
        if (search || fromType == LOT_FIELD) {
            fieldList.add(LOT_FIELD);
        }
        int wordListSize = wordList.size();
        if (searchOffset == null) {
            searchOffset = new SearchOffset(0, 0);
        }
        for (FieldType type : fieldList) {
            DictSearchResult sr = null;
            if (searchOffset.m_wordOffset < wordListSize && this.shouldSearchField(type, this.m_searchFieldResults) && (sr = this.seperateField(wordList, type, searchOffset, -1, parser, soundex, dataManager, options)) != null) {
                this.addSearchFieldResult(type, sr);
                searchOffset = this.getNextCharOffsetForMatching(wordList, sr);
            }
            this.addSearchFieldResult(type, sr);
        }
        boolean bl = this.m_containsUnparsedInputs = searchOffset.m_wordOffset < wordListSize;
        if (this.getSearchFieldResult(CITY_FIELD) == null && (an1Result = this.getSearchFieldResult(PREFECTURE_FIELD)) != null) {
            DictSearchResult an2Result = new DictSearchResult(an1Result);
            an2Result.m_type = CITY_FIELD;
        }
    }

    protected DictSearchResult seperateField(List<char[]> wordList, FieldType type, SearchOffset searchOffset, int maxLen, ICGGEParser parser, ICGGESoundex soundex, IDataManager dataManager, GeocodeOptions options) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        DictSearchResult sr = null;
        if (searchOffset.m_wordOffset < wordList.size()) {
            char[] currentWord = wordList.get(searchOffset.m_wordOffset);
            int len = currentWord.length - searchOffset.m_charOffset;
            if (maxLen > 0 && maxLen < len) {
                len = maxLen;
            }
            char[] searchWord = currentWord;
            if (searchOffset.m_charOffset != 0 || len != currentWord.length) {
                searchWord = CharArray.subArray(currentWord, searchOffset.m_charOffset, len);
            }
            if ((sr = this.searchFieldInData(searchWord, type, soundex, parser, dataManager, options, maxLen < 1)) != null) {
                sr.m_searchOffset = searchOffset;
            }
        }
        return sr;
    }

    private boolean shouldSearchField(FieldType type, Map<FieldType, DictSearchResult> currentFieldSearchs) {
        if (this.m_geoType != 1 && (type == BLOCK_FIELD || type == LOT_FIELD)) {
            return false;
        }
        if (type == LOT_FIELD) {
            return currentFieldSearchs.get(BLOCK_FIELD) != null;
        }
        return true;
    }

    protected void separateAreasAndBlockFromSingleLine(List<char[]> wordList, ParsedAddress parsedAddr, IDataManager dataManager, GeocodeOptions options) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        this.separateAreasAndBlockFromSingleLine(wordList, null, parsedAddr, dataManager, options, PREFECTURE_FIELD, LOT_FIELD);
    }

    protected DictSearchResult findAddressNumber(char[] searchWord, ICGGESoundex soundex, ICGGEParser parser, IDataManager dataManager, GeocodeOptions options) {
        char[] lotChars;
        if (searchWord == null) {
            return null;
        }
        DictSearchResult dsr = null;
        String skippedChars = null;
        if (searchWord.length > 1 && this.startsWithNumericSeparator(searchWord)) {
            skippedChars = new String(Arrays.copyOf(searchWord, 1));
            searchWord = Arrays.copyOfRange(searchWord, 1, searchWord.length);
        }
        if ((lotChars = this.splitLotCharacters(searchWord)) != null) {
            searchWord = lotChars;
        }
        dsr = new DictSearchResult();
        if (skippedChars != null) {
            dsr.m_searchedWord = skippedChars + new String(searchWord);
            dsr.m_partialSearchWord = searchWord;
        } else {
            dsr.m_searchedWord = new String(searchWord);
        }
        return dsr;
    }

    private char[] splitLotCharacters(char[] searchChars) {
        char[] lotChars = CharArray.splitAtDelim(searchChars, '\u53f7', true);
        if (lotChars == null) {
            lotChars = JPNCharUtils.getNumericPrefix(searchChars);
        }
        return lotChars;
    }

    protected DictSearchResult findCity(char[] searchWord, ICGGESoundex soundex, ICGGEParser parser, IDataManager dataManager, GeocodeOptions options) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        int pos;
        DictSearchResult sr = null;
        if (searchWord != null && (sr = this.findAndSetFieldFromWord(searchWord, CITY_FIELD, soundex, parser, dataManager, options, true)) == null && (pos = CharArray.indexOf(searchWord, '\u5e02')) > -1) {
            sr = new DictSearchResult();
            sr.m_skippedSearchWord = CharArray.subArray(searchWord, 0, pos + 1);
            sr.m_partialSearchWord = sr.m_skippedSearchWord;
        }
        return sr;
    }

    protected int getBlockStartPosition(char[] searchWord) {
        Matcher m = m_streetPattern.matcher(new String(searchWord));
        if (m.find()) {
            char ch;
            int end = m.end();
            if (end < searchWord.length && (this.isNumericSeparator(ch = searchWord[end]) || MMUtils.isDigit(ch) || JapaneseNumerals.isDigit(ch))) {
                return m.start();
            }
            if (end > 1 && ((ch = searchWord[end - 1]) == '\u5730' || ch == '\u306e')) {
                return m.start();
            }
        }
        return -1;
    }

    private boolean isNumericSeparator(char ch) {
        for (char sep : NUMERIC_SEPARATOR_CHARS) {
            if (sep != ch) continue;
            return true;
        }
        return false;
    }

    protected DictSearchResult findChome(char[] searchWord, ICGGESoundex soundex, ICGGEParser parser, IDataManager dataManager, GeocodeOptions options) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        int blockPos;
        DictSearchResult sr = null;
        int remaingStartPos = -1;
        boolean chomeTransferableAsBlock = true;
        if (searchWord != null && (blockPos = this.getBlockStartPosition(searchWord)) > -1) {
            searchWord = blockPos == 0 ? null : CharArray.subArray(searchWord, 0, blockPos);
            chomeTransferableAsBlock = false;
        }
        if (searchWord != null) {
            char[] newSearchWord;
            char[] originalSearchWord = searchWord;
            chomeTransferableAsBlock = CharArray.indexOf(searchWord, CHOME_IDENTIFIER) == -1;
            char[] splitSearchChars = this.splitChomeFromNumericDelimiter(searchWord);
            if (splitSearchChars != null) {
                searchWord = splitSearchChars;
                remaingStartPos = splitSearchChars.length + 1;
            }
            if ((sr = this.findAndSetChomeFromWord(searchWord, soundex, parser, dataManager, options, false)) == null) {
                int currentLen = searchWord.length;
                char[] newSearchWord2 = CharArray.splitAtChars(searchWord, CHOME_IDENTIFIER, false);
                if (newSearchWord2 != null) {
                    int directionalCharPos = newSearchWord2.length + CHOME_IDENTIFIER.length;
                    if (currentLen > directionalCharPos) {
                        char charAfterChomeIdentifier = searchWord[directionalCharPos];
                        if (charAfterChomeIdentifier == '\u5317' || charAfterChomeIdentifier == '\u5357') {
                            searchWord = CharArray.addArrays(newSearchWord2, new char[]{charAfterChomeIdentifier});
                            remaingStartPos = searchWord.length + CHOME_IDENTIFIER.length;
                        } else {
                            searchWord = CharArray.addArrays(newSearchWord2, CHOME_IDENTIFIER);
                            remaingStartPos = searchWord.length;
                        }
                    } else {
                        searchWord = CharArray.addArrays(newSearchWord2, CHOME_IDENTIFIER);
                        remaingStartPos = searchWord.length;
                    }
                    sr = this.findAndSetChomeFromWord(searchWord, soundex, parser, dataManager, options, false);
                } else {
                    sr = this.addChomeIdentifierAndSearch(searchWord, soundex, parser, dataManager, options);
                }
                if (sr != null) {
                    chomeTransferableAsBlock = false;
                }
            }
            if (sr == null) {
                char[] newSearchWord3 = CharArray.splitAtDelim(searchWord, '\u5b57', false);
                if (newSearchWord3 != null) {
                    sr = this.findAndSetChomeFromWord(newSearchWord3, soundex, parser, dataManager, options, false);
                }
                if (sr != null) {
                    remaingStartPos = newSearchWord3.length + 1;
                    chomeTransferableAsBlock = false;
                }
            }
            if (sr == null) {
                String n = MMUtils.getStartingNumberPart(new String(searchWord));
                if (n != null) {
                    if (n.length() < searchWord.length && Character.isDigit(searchWord[searchWord.length - 1])) {
                        int hh;
                        for (hh = n.length(); hh < searchWord.length && !Character.isDigit(searchWord[hh]); ++hh) {
                        }
                        n = new String(searchWord).substring(0, hh);
                    }
                    sr = this.findAndSetChomeFromWord(n.toCharArray(), soundex, parser, dataManager, options, false);
                }
                if (sr != null) {
                    remaingStartPos = n.length();
                }
            }
            if (sr == null && chomeTransferableAsBlock) {
                sr = this.splitChomeFromLastNumberAndSearch(searchWord, soundex, parser, dataManager, options);
            }
            if (sr == null) {
                sr = this.splitChomeFromKnownDelimitersAndSearch(originalSearchWord, soundex, parser, dataManager, options);
            }
            if (sr == null && (newSearchWord = CharArray.splitAtAnyDelim(searchWord, new char[]{'\u5317', '\u5357'}, true)) != null) {
                sr = this.findAndSetChomeFromWord(searchWord, soundex, parser, dataManager, options, false);
            }
            if (sr != null && remaingStartPos > 0) {
                sr.m_searchedWord = new String(CharArray.subArray(originalSearchWord, 0, remaingStartPos));
            }
            if (sr != null) {
                sr.m_chomeTranferableToBlock = chomeTransferableAsBlock;
            }
        }
        return sr;
    }

    private char[] splitChomeFromNumericDelimiter(char[] inputChars) {
        int posAfterDelim;
        char[] knownNumericDelimiters = new char[]{'\u306e', '\u30ce'};
        char[] splitChars = CharArray.splitAtAnyDelim(inputChars, knownNumericDelimiters, false);
        if (splitChars != null && (posAfterDelim = splitChars.length + 1) < inputChars.length && !JapaneseNumerals.isDigit(inputChars[posAfterDelim])) {
            splitChars = null;
        }
        return splitChars;
    }

    private DictSearchResult splitChomeFromLastNumberAndSearch(char[] searchChars, ICGGESoundex soundex, ICGGEParser parser, IDataManager dataManager, GeocodeOptions options) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        do {
            DictSearchResult sr;
            if ((searchChars = JPNCharUtils.splitFromLastNumber(searchChars)) == null || (sr = this.findAndSetChomeFromWord(searchChars, soundex, parser, dataManager, options, false)) == null) continue;
            return sr;
        } while (searchChars != null);
        return null;
    }

    private DictSearchResult splitChomeFromKnownDelimitersAndSearch(char[] searchWord, ICGGESoundex soundex, ICGGEParser parser, IDataManager dataManager, GeocodeOptions options) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        char[] subStr = CharArray.splitAtAnyDelim(searchWord, new char[]{'\u306e', '\u30fc'}, false);
        if (subStr != null) {
            DictSearchResult sr = this.findAndSetChomeFromWord(subStr, soundex, parser, dataManager, options, false);
            return sr == null ? this.splitChomeFromLastNumberAndSearch(subStr, soundex, parser, dataManager, options) : sr;
        }
        return null;
    }

    private DictSearchResult addChomeIdentifierAndSearch(char[] searchWord, ICGGESoundex soundex, ICGGEParser parser, IDataManager dataManager, GeocodeOptions options) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        char[] newSearchWord = Arrays.copyOf(searchWord, searchWord.length + 2);
        newSearchWord[searchWord.length] = 19969;
        newSearchWord[searchWord.length + 1] = 30446;
        return this.findAndSetChomeFromWord(newSearchWord, soundex, parser, dataManager, options, false);
    }

    private void setPartialSearchWord(DictSearchResult sr, char[] partialChars) {
        String partialNumericString = JapaneseNumerals.substituteJapaneseNumeral(partialChars);
        sr.m_partialSearchWord = partialNumericString == null ? partialChars : partialNumericString.toCharArray();
    }

    private DictSearchResult skipOoazaCharsAndSearch(SearchOffset searchOffset, int charsToSkip, ParsedAddress parsedAddress, IDataManager dataManager, GeocodeOptions options) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        DictSearchResult newOoazaResult = null;
        SearchOffset nextSearchOffset = this.getNextCharOffsetForMatching(this.m_singleLnInputList, searchOffset.m_wordOffset, searchOffset.m_charOffset, charsToSkip);
        this.separateAreasAndBlockFromSingleLine(this.m_singleLnInputList, nextSearchOffset, parsedAddress, dataManager, options, CHOME_FIELD, null);
        if (this.getSearchFieldResult(CHOME_FIELD) != null || this.getSearchFieldResult(BLOCK_FIELD) != null) {
            newOoazaResult = this.getSkippedResult(searchOffset, charsToSkip, OOAZA_FIELD);
        }
        return newOoazaResult;
    }

    private DictSearchResult getSkippedResult(SearchOffset searchOffset, int charsToSkip, FieldType type) {
        DictSearchResult newResult = new DictSearchResult();
        newResult.m_searchOffset = searchOffset;
        newResult.m_skippedSearchWord = CharArray.subArray(this.m_singleLnInputList.get(searchOffset.m_wordOffset), searchOffset.m_charOffset, charsToSkip);
        this.setPartialSearchWord(newResult, newResult.m_skippedSearchWord);
        this.addSearchFieldResult(type, newResult);
        return newResult;
    }

    protected boolean generatePartialOoazaCases(ParsedAddress parsedAddr, IDataManager dataManager, GeocodeOptions options) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        DictSearchResult ooazaResult = this.getSearchFieldResult(OOAZA_FIELD);
        DictSearchResult cityResult = this.getSearchFieldResult(CITY_FIELD);
        if (cityResult != null) {
            int ooazaCharToSkip;
            int startOffset;
            char[] word;
            SearchOffset searchOffset;
            if (!this.an2an3intersectionFound && ooazaResult != null && ooazaResult.m_searchedWord != null) {
                this.getSkippedResult(ooazaResult.m_searchOffset, ooazaResult.getSearchLength(), OOAZA_FIELD);
                return true;
            }
            if (ooazaResult == null || ooazaResult.m_searchedWord == null) {
                searchOffset = this.getNextCharOffsetForMatching(this.m_singleLnInputList, cityResult);
                if (searchOffset.m_wordOffset < this.m_singleLnInputList.size()) {
                    word = this.m_singleLnInputList.get(searchOffset.m_wordOffset);
                    startOffset = searchOffset.m_charOffset;
                    if (ooazaResult != null) {
                        startOffset += ooazaResult.getSearchLength();
                    }
                    while (++startOffset < word.length && !JapaneseNumerals.isDigit(word[startOffset])) {
                        ooazaCharToSkip = startOffset - searchOffset.m_charOffset;
                        if (this.skipOoazaCharsAndSearch(searchOffset, ooazaCharToSkip, parsedAddr, dataManager, options) == null) continue;
                        return true;
                    }
                }
            }
            if (ooazaResult == null || ooazaResult.m_searchedWord == null) {
                searchOffset = this.getNextCharOffsetForMatching(this.m_singleLnInputList, cityResult);
                if (searchOffset.m_wordOffset < this.m_singleLnInputList.size()) {
                    word = this.m_singleLnInputList.get(searchOffset.m_wordOffset);
                    startOffset = searchOffset.m_charOffset;
                    if (ooazaResult != null) {
                        startOffset += ooazaResult.getSearchLength();
                        startOffset = JPNCharUtils.findNextNonNumericPosition(word, startOffset);
                    }
                    while (startOffset > -1) {
                        int ooazaCharToSkip2;
                        int pos = JPNCharUtils.findNextNumericPosition(word, startOffset);
                        int n = ooazaCharToSkip2 = pos > -1 ? pos - searchOffset.m_charOffset : word.length - searchOffset.m_charOffset;
                        if (ooazaCharToSkip2 > 0 && this.skipOoazaCharsAndSearch(searchOffset, ooazaCharToSkip2, parsedAddr, dataManager, options) != null) {
                            return true;
                        }
                        startOffset = pos > -1 ? JPNCharUtils.findNextNonNumericPosition(word, pos) : -1;
                    }
                }
            }
            DictSearchResult chomeResult = this.getSearchFieldResult(CHOME_FIELD);
            if (ooazaResult == null || ooazaResult.m_skippedSearchWord != null || chomeResult == null) {
                SearchOffset searchOffset2 = this.getNextCharOffsetForMatching(this.m_singleLnInputList, cityResult);
                if (searchOffset2.m_wordOffset < this.m_singleLnInputList.size()) {
                    char[] word2 = this.m_singleLnInputList.get(searchOffset2.m_wordOffset);
                    ooazaCharToSkip = word2.length - searchOffset2.m_charOffset;
                    if (ooazaResult != null && ooazaResult.m_skippedSearchWord != null && ooazaCharToSkip == ooazaResult.m_skippedSearchWord.length) {
                        ooazaCharToSkip = -1;
                    }
                    if (ooazaCharToSkip > 0 && this.skipOoazaCharsAndSearch(searchOffset2, ooazaCharToSkip, parsedAddr, dataManager, options) != null) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    protected boolean generateCaseForIncorrectOoazaChomeSplit(ParsedAddress parsedAddr, IDataManager dataManager, GeocodeOptions options) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        DictSearchResult newOoazaResult;
        String ooazaWord;
        char[] ooazaChars;
        char[] newOoazaChars;
        DictSearchResult ooazaResult = this.getSearchFieldResult(OOAZA_FIELD);
        if (ooazaResult != null && ooazaResult.m_searchedWord != null && (newOoazaChars = JPNCharUtils.splitAtNumeric(ooazaChars = (ooazaWord = ooazaResult.m_searchedWord).toCharArray())) != null && (newOoazaResult = this.seperateField(this.m_singleLnInputList, OOAZA_FIELD, ooazaResult.m_searchOffset, newOoazaChars.length, this.getParser(), this.getSoundex(), dataManager, options)) != null && newOoazaResult.m_searchedWord != null) {
            SearchOffset nextSearchOffset = this.getNextCharOffsetForMatching(this.m_singleLnInputList, newOoazaResult);
            this.separateAreasAndBlockFromSingleLine(this.m_singleLnInputList, nextSearchOffset, parsedAddr, dataManager, options, CHOME_FIELD, null);
            if (this.getSearchFieldResult(CHOME_FIELD) != null) {
                this.addSearchFieldResult(OOAZA_FIELD, newOoazaResult);
                return true;
            }
        }
        return false;
    }

    protected boolean generateSubOoazaCase(ParsedAddress parsedAddr, IDataManager dataManager, GeocodeOptions options) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        DictSearchResult ooazaResult = this.getSearchFieldResult(OOAZA_FIELD);
        if (ooazaResult != null && ooazaResult.m_searchedWord != null) {
            DictionaryAreaTermItem ooazaAreaItem;
            DictionaryAreaTermItem dictionaryAreaTermItem = ooazaAreaItem = ooazaResult.m_areaList != null ? ooazaResult.m_areaList.get(0) : null;
            if (ooazaAreaItem != null) {
                String ooazaWord = ooazaResult.m_searchedWord;
                char[] ooazaChars = ooazaWord.toCharArray();
                for (int i = 1; i < ooazaChars.length - 1; ++i) {
                    int newLen = ooazaChars.length - i;
                    DictSearchResult newOoazaResult = this.seperateField(this.m_singleLnInputList, OOAZA_FIELD, ooazaResult.m_searchOffset, newLen, this.getParser(), this.getSoundex(), dataManager, options);
                    if (newOoazaResult == null || newOoazaResult.m_searchedWord == null) continue;
                    SearchOffset nextSearchOffset = this.getNextCharOffsetForMatching(this.m_singleLnInputList, newOoazaResult);
                    this.separateAreasAndBlockFromSingleLine(this.m_singleLnInputList, nextSearchOffset, parsedAddr, dataManager, options, CHOME_FIELD, null);
                    this.addSearchFieldResult(OOAZA_FIELD, newOoazaResult);
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean generateCaseForFullySkippedOoaza(ParsedAddress parsedAddr, IDataManager dataManager, GeocodeOptions options) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        DictSearchResult newChomeResult;
        DictSearchResult ooazaResult = this.getSearchFieldResult(OOAZA_FIELD);
        if (ooazaResult != null && ooazaResult.m_searchedWord != null && (newChomeResult = this.seperateField(this.m_singleLnInputList, CHOME_FIELD, ooazaResult.m_searchOffset, 0, this.getParser(), this.getSoundex(), dataManager, options)) != null && newChomeResult.m_searchedWord != null) {
            this.addSearchFieldResult(OOAZA_FIELD, null);
            this.addSearchFieldResult(CHOME_FIELD, newChomeResult);
            SearchOffset nextSearchOffset = this.getNextCharOffsetForMatching(this.m_singleLnInputList, newChomeResult);
            this.separateAreasAndBlockFromSingleLine(this.m_singleLnInputList, nextSearchOffset, parsedAddr, dataManager, options, BLOCK_FIELD, null);
            return true;
        }
        return false;
    }

    protected boolean generateCaseForIngoredChome(ParsedAddress parsedAddress, IDataManager dataManager, GeocodeOptions options) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        DictSearchResult chomeResult = this.getSearchFieldResult(CHOME_FIELD);
        if (chomeResult != null && chomeResult.m_searchOffset != null && this.an2an3intersectionFound && this.getSearchFieldResult(OOAZA_FIELD) != null && !this.doesSearchWordContainNumericDigits(chomeResult)) {
            this.saveCurrentSearchResult();
            SearchOffset searchOffset = this.getNextCharOffsetForMatching(this.m_singleLnInputList, chomeResult);
            this.separateAreasAndBlockFromSingleLine(this.m_singleLnInputList, searchOffset, parsedAddress, dataManager, options, BLOCK_FIELD, null);
            this.addAsSkippedSearchResult(chomeResult);
            return true;
        }
        return false;
    }

    private void addAsSkippedSearchResult(DictSearchResult dsr) {
        DictSearchResult skippedResult = new DictSearchResult();
        skippedResult.m_skippedSearchWord = dsr.m_searchedWord.toCharArray();
        skippedResult.m_type = dsr.m_type;
        this.addSearchFieldResult(dsr.m_type, skippedResult);
    }

    protected boolean generateCaseForIncorrectCityOoazaSplit(ParsedAddress parsedAddr, IDataManager dataManager, GeocodeOptions options) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        int citySearchWordLen;
        DictSearchResult cityResult = this.getSearchFieldResult(CITY_FIELD);
        String citySearchWord = cityResult != null ? cityResult.m_searchedWord : null;
        int n = citySearchWordLen = citySearchWord == null ? 0 : citySearchWord.length();
        if (citySearchWordLen > 0) {
            DictionaryAreaTermItem cityDictItem;
            DictionaryAreaTermItem dictionaryAreaTermItem = cityDictItem = cityResult.m_areaList == null ? null : cityResult.m_areaList.get(0);
            if (cityDictItem != null) {
                SearchOffset nextSearchOffset;
                DictSearchResult newCityResult;
                DictionaryAddressWord dword = cityDictItem.getMatchedWords()[0];
                int dictWordLen = dword.getAddressWord().getWordLength();
                if (dictWordLen < citySearchWordLen && (newCityResult = this.seperateField(this.m_singleLnInputList, CITY_FIELD, cityResult.m_searchOffset, dictWordLen, this.getParser(), this.getSoundex(), dataManager, options)) != null) {
                    this.saveCurrentSearchResult();
                    nextSearchOffset = this.getNextCharOffsetForMatching(this.m_singleLnInputList, newCityResult);
                    this.separateAreasAndBlockFromSingleLine(this.m_singleLnInputList, nextSearchOffset, parsedAddr, dataManager, options, OOAZA_FIELD, null);
                    if (this.getSearchFieldResult(OOAZA_FIELD) != null) {
                        this.addSearchFieldResult(CITY_FIELD, newCityResult);
                        return true;
                    }
                }
                while (citySearchWordLen > 3) {
                    if ((newCityResult = this.seperateField(this.m_singleLnInputList, CITY_FIELD, cityResult.m_searchOffset, --citySearchWordLen, this.getParser(), this.getSoundex(), dataManager, options)) == null) continue;
                    nextSearchOffset = this.getNextCharOffsetForMatching(this.m_singleLnInputList, newCityResult);
                    this.separateAreasAndBlockFromSingleLine(this.m_singleLnInputList, nextSearchOffset, parsedAddr, dataManager, options, OOAZA_FIELD, null);
                    if (this.getSearchFieldResult(OOAZA_FIELD) == null) continue;
                    this.addSearchFieldResult(CITY_FIELD, newCityResult);
                    return true;
                }
            }
        }
        return false;
    }

    protected DictSearchResult searchFieldInData(char[] word, FieldType type, ICGGESoundex soundex, ICGGEParser parser, IDataManager dataManager, GeocodeOptions options, boolean allowPartial) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        DictSearchResult sr = null;
        sr = type == CITY_FIELD ? this.findCity(word, soundex, parser, dataManager, options) : (type == CHOME_FIELD ? this.findChome(word, soundex, parser, dataManager, options) : (type == BLOCK_FIELD ? this.findStreetField(word, soundex, parser, dataManager, options) : (type == LOT_FIELD ? this.findAddressNumber(word, soundex, parser, dataManager, options) : this.findAndSetFieldFromWord(word, type, soundex, parser, dataManager, options, allowPartial))));
        return sr;
    }

    private boolean startsWithNumericSeparator(char[] str) {
        char firstChar = str[0];
        for (char ch : NUMERIC_SEPARATOR_CHARS) {
            if (ch != firstChar) continue;
            return true;
        }
        return false;
    }

    private DictSearchResult findStreetField(char[] searchWord, ICGGESoundex soundex, ICGGEParser parser, IDataManager dataManager, GeocodeOptions options) throws CGGEInternalException, DataNotInitialisedException, DataFetchException {
        DictSearchResult sr = null;
        boolean streetIdentiferFound = false;
        int usedChars = searchWord.length;
        char[] originalSearchWord = searchWord;
        if (searchWord != null) {
            char[] newSearchChars;
            if (searchWord.length > 1 && this.startsWithNumericSeparator(searchWord)) {
                searchWord = CharArray.subArray(searchWord, 1);
            }
            for (int idx = 0; idx < STREET_SEPERATORS.length; ++idx) {
                char[] newSearchChars2 = CharArray.splitAtChars(searchWord, STREET_SEPERATORS[idx], false);
                if (newSearchChars2 == null) continue;
                searchWord = newSearchChars2;
                streetIdentiferFound = true;
                usedChars = searchWord.length + STREET_SEPERATORS[idx].length;
                break;
            }
            if (!streetIdentiferFound && (newSearchChars = CharArray.splitAtAnyDelim(searchWord, NUMERIC_SEPARATOR_CHARS, false)) != null) {
                searchWord = newSearchChars;
                usedChars = searchWord.length + 1;
            }
            String strSearchWord = new String(searchWord);
            AddressWord addrWord = parser.convertToAddressWord(strSearchWord, soundex);
            addrWord.m_wordType = BLOCK_FIELD;
            List<DictionaryAddressWord> searchWordList = null;
            if (CodedWord.isNumber(addrWord.getAttributes()) || CodedWord.isNumeric(addrWord.getAttributes()) || JapaneseNumerals.isNumber(searchWord)) {
                searchWordList = this.getSearchableWords(addrWord, BLOCK_FIELD, dataManager, 1.0, options);
            } else if (MMUtils.startsWithDigits(searchWord)) {
                strSearchWord = MMUtils.getStartingNumberPart(strSearchWord);
                addrWord = parser.convertToAddressWord(strSearchWord, soundex);
                searchWordList = this.getSearchableWords(addrWord, BLOCK_FIELD, dataManager, 1.0, options);
                usedChars = strSearchWord.length();
                streetIdentiferFound = false;
            }
            if (searchWordList != null && searchWordList.size() > 0) {
                sr = new DictSearchResult();
                sr.m_searchedWord = usedChars != strSearchWord.length() ? new String(CharArray.subArray(originalSearchWord, 0, usedChars)) : strSearchWord;
                sr.m_type = BLOCK_FIELD;
                sr.m_dictWords = searchWordList;
                sr.m_searchedAddressWord = addrWord;
                sr.m_streetIdentifierFound = streetIdentiferFound;
            }
        }
        return sr;
    }

    protected List<char[]> getAddressWordCharList(AddressWord[] words) {
        ArrayList<char[]> wordCharList = null;
        if (words != null) {
            int wordCount = words.length;
            wordCharList = new ArrayList<char[]>(wordCount);
            for (int i = 0; i < wordCount; ++i) {
                if (CodedWord.isDelimiter(words[i].getAttributes())) continue;
                wordCharList.add(words[i].getWordChars());
            }
        }
        return wordCharList;
    }

    protected boolean generateCaseForIncorrectChomeBlockSplit(IDataManager dataManager, GeocodeOptions options) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        String currentChome;
        DictSearchResult currentChomeResult = this.getSearchFieldResult(CHOME_FIELD);
        String string = currentChome = currentChomeResult == null ? null : currentChomeResult.m_searchedWord;
        if (currentChome != null) {
            SearchOffset offset;
            DictSearchResult newStreetResult;
            DictSearchResult newChomeResult;
            int partialLen;
            char[] chomeChars = currentChome.toCharArray();
            char[] subStr = MMUtils.splitFromDigits(chomeChars);
            int n = partialLen = subStr == null ? 0 : subStr.length;
            if (partialLen > 0 && (newChomeResult = this.seperateField(this.m_singleLnInputList, CHOME_FIELD, currentChomeResult.m_searchOffset, partialLen, this.getParser(), this.getSoundex(), dataManager, options)) != null && newChomeResult.m_searchedWord != null && (newStreetResult = this.seperateField(this.m_singleLnInputList, BLOCK_FIELD, offset = this.getNextCharOffsetForMatching(this.m_singleLnInputList, newChomeResult), 0, this.getParser(), this.getSoundex(), dataManager, options)) != null) {
                this.saveCurrentSearchResult();
                this.addSearchFieldResult(CHOME_FIELD, newChomeResult);
                this.addSearchFieldResult(BLOCK_FIELD, newStreetResult);
                offset = this.getNextCharOffsetForMatching(this.m_singleLnInputList, newStreetResult);
                DictSearchResult newLotResult = this.seperateField(this.m_singleLnInputList, LOT_FIELD, offset, 0, this.getParser(), this.getSoundex(), dataManager, options);
                this.addSearchFieldResult(LOT_FIELD, newLotResult);
                return true;
            }
        }
        return false;
    }

    protected boolean generateCaseForChomeBlockSubstition(IDataManager dataManager, GeocodeOptions options) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        DictSearchResult streetResult;
        String currentChome;
        DictSearchResult currentChomeResult = this.getSearchFieldResult(CHOME_FIELD);
        if (currentChomeResult != null && currentChomeResult.m_chomeTranferableToBlock && (currentChome = currentChomeResult.m_searchedWord) != null && this.isBlockPattern(currentChome) && (streetResult = this.seperateField(this.m_singleLnInputList, BLOCK_FIELD, currentChomeResult.m_searchOffset, 0, this.getParser(), this.getSoundex(), dataManager, options)) != null) {
            this.saveCurrentSearchResult();
            this.addSearchFieldResult(CHOME_FIELD, null);
            this.addSearchFieldResult(BLOCK_FIELD, streetResult);
            SearchOffset offset = this.getNextCharOffsetForMatching(this.m_singleLnInputList, streetResult);
            DictSearchResult addrNumResult = this.seperateField(this.m_singleLnInputList, LOT_FIELD, offset, 0, this.getParser(), this.getSoundex(), dataManager, options);
            this.addSearchFieldResult(LOT_FIELD, addrNumResult);
            return true;
        }
        return false;
    }

    private boolean isBlockPattern(String str) {
        return JapaneseNumerals.isNumber(str) || m_streetPattern.matcher(str).matches();
    }

    protected boolean generateCaseForPartialCityName(ParsedAddress parsedAddr, IDataManager dataManager, GeocodeOptions options) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        String currentCity;
        DictSearchResult currentResult = this.getSearchFieldResult(CITY_FIELD);
        if (currentResult != null && currentResult.m_searchedWord != null && (currentCity = currentResult.m_searchedWord).charAt(currentCity.length() - 1) == '\u5e02') {
            this.saveCurrentSearchResult();
            currentResult.m_partialSearchWord = currentCity.toCharArray();
            currentResult.m_searchedWord = null;
            currentResult.m_dictWords = null;
            currentResult.m_areaList = null;
            return true;
        }
        return false;
    }

    protected boolean candChomeMatchedWithSearchResult(InternalScoringAddress cand) {
        if (this.candFieldMatchedWithSearchedResult(cand, CHOME_FIELD)) {
            return true;
        }
        DictSearchResult searchFieldResult = this.getSearchFieldResult(CHOME_FIELD);
        InternalFieldValue chomeFv = (InternalFieldValue)cand.getField(CHOME_FIELD);
        if (chomeFv == null || searchFieldResult == null || searchFieldResult.m_searchedWord == null) {
            return false;
        }
        String searchChomeStr = searchFieldResult.m_searchedWord;
        if (!JapaneseNumerals.isNumber(searchChomeStr)) {
            return false;
        }
        int searchChomeNumber = JapaneseNumerals.toNumber(searchChomeStr);
        String candChomeNumber = JPNCharUtils.getFirstNumber(JPNCandidateUtils.toStringWord((AddressWord[])chomeFv.getFieldValue()));
        if (candChomeNumber != null) {
            return searchChomeNumber == JapaneseNumerals.toNumber(candChomeNumber);
        }
        return false;
    }

    protected boolean candFieldMatchedWithSearchedResult(InternalScoringAddress cand, FieldType type) {
        boolean matched;
        block2: {
            DictSearchResult searchFieldResult;
            InternalFieldValue fv;
            block3: {
                fv = (InternalFieldValue)cand.getField(type);
                searchFieldResult = this.getSearchFieldResult(type);
                boolean bl = matched = fv == null && searchFieldResult == null;
                if (searchFieldResult == null) break block2;
                if (type != BLOCK_FIELD || searchFieldResult.m_dictWords == null) break block3;
                Iterator<DictionaryAddressWord> it = searchFieldResult.m_dictWords.iterator();
                while (it.hasNext()) {
                    matched = false;
                    DictionaryAddressWord addrWord = it.next();
                    if (fv == null || !JPNCandidateUtils.wordsMatchedWithFieldValue(new AddressWord[]{addrWord.getAddressWord()}, fv)) continue;
                    return true;
                }
                break block2;
            }
            if (searchFieldResult.m_areaList == null) break block2;
            for (DictionaryAreaTermItem areaTerm : searchFieldResult.m_areaList) {
                if (areaTerm.m_type != type) continue;
                matched = false;
                if (!(areaTerm.m_quality >= 1.0) || fv == null || !JPNCandidateUtils.wordsMatchedWithFieldValue(areaTerm.m_areaWords, fv)) continue;
                return true;
            }
        }
        return matched;
    }

    protected boolean matchedWithOldCity(DictSearchResult citySearch, char[] partialOoazaChars, InternalScoringAddress cand, boolean onlyWithOoazaPrefix, boolean matchWithNormalizedChars, IDataManager dataManager) throws CGGEInternalException {
        if (citySearch != null && citySearch.m_searchedAddressWord != null) {
            FieldType ooazaPrefixIndicatorField = null;
            if (onlyWithOoazaPrefix) {
                IDictionaryMetaData metaData = dataManager.getMetaData(cand.getDictionaryNumber(), cand.getAddressType());
                ooazaPrefixIndicatorField = metaData.getFieldForName("HAS_NEW_CITY_OOAZA_PREFIX");
            }
            AddressWord searchedCity = citySearch.m_searchedAddressWord;
            InternalFieldValue fv = (InternalFieldValue)cand.getField(CITY_FIELD);
            if (fv != null && fv.hasAlternates()) {
                AddressWord[][] alts;
                for (AddressWord[] alt : alts = (AddressWord[][])fv.getAlternateValues()) {
                    if (!JPNCandidateUtils.isMatchingWord(searchedCity, alt[0]) || onlyWithOoazaPrefix && (ooazaPrefixIndicatorField == null || cand.getField(ooazaPrefixIndicatorField) == null) || partialOoazaChars == null) continue;
                    char[] candOoazaChars = matchWithNormalizedChars ? JPNCandidateUtils.getWordNormalizedCharacters(cand, OOAZA_FIELD) : JPNCandidateUtils.getWordCharacters(cand, OOAZA_FIELD);
                    return CharArray.endsWith(candOoazaChars, partialOoazaChars);
                }
            }
        }
        return false;
    }

    protected boolean matchPartial(AddressWord[] words, char[] partialChars) {
        if (words != null && words.length > 0) {
            AddressWord word = words[0];
            if (this.matchPartial(word.getWordChars(), partialChars) || this.matchPartial(word.getNormalizedChars(), partialChars)) {
                return true;
            }
            String str = JapaneseNumerals.substituteJapaneseNumeral(word.getWordChars());
            if (str != null) {
                return this.matchPartial(str.toCharArray(), partialChars);
            }
        }
        return false;
    }

    protected boolean matchPartial(char[] match, AddressWord addrWord) {
        return addrWord != null && this.matchPartial(match, addrWord.getWordChars());
    }

    protected boolean matchPartial(char[] word, char[] partialChars) {
        return MMUtils.startsWith(word, partialChars);
    }

    protected boolean matchPartialWithField(InternalScoringAddress scoringAddress, FieldType type, char[] partialChars) {
        InternalFieldValue fv = (InternalFieldValue)scoringAddress.getField(type);
        if (fv != null) {
            if (this.matchPartial((AddressWord[])fv.getFieldValue(), partialChars)) {
                return true;
            }
            AddressWord[][] altWords = (AddressWord[][])fv.getAlternateValues();
            if (altWords != null) {
                for (AddressWord[] altWord : altWords) {
                    if (!this.matchPartial(altWord, partialChars)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean matchPartialFieldWithInput(InternalScoringAddress scoringAddress, FieldType type, char[] word) {
        InternalFieldValue fv = (InternalFieldValue)scoringAddress.getField(type);
        return fv != null && this.matchPartial(word, ((AddressWord[])fv.getFieldValue())[0]);
    }

    protected InternalCandidateList filterCandidates(InternalCandidateList cands, ParsedAddress parsedAddress, IDataManager dataManager) throws CGGEInternalException {
        int candCount;
        int n = candCount = cands == null ? 0 : cands.getCandidateCount();
        if (candCount > 0) {
            InternalScoringAddress scoringAddress;
            Iterator<InternalScoringAddress> candIt = cands.getCandidateList().iterator();
            int partialCityMatches = 0;
            int chomeCands = 0;
            DictSearchResult prefSearchResult = this.getSearchFieldResult(PREFECTURE_FIELD);
            DictSearchResult citySearchResult = this.getSearchFieldResult(CITY_FIELD);
            DictSearchResult ooazaSearchResult = this.getSearchFieldResult(OOAZA_FIELD);
            DictSearchResult chomeSearchResult = this.getSearchFieldResult(CHOME_FIELD);
            DictSearchResult streetSearchResult = this.getSearchFieldResult(BLOCK_FIELD);
            boolean allowMultiples = true;
            int candsWithOoazaSkipped = 0;
            int partialOoazaMatches = 0;
            char[] partialOoazaChars = null;
            if (ooazaSearchResult != null && ooazaSearchResult.m_partialSearchWord != null) {
                partialOoazaChars = this.getSoundex().normalizeChars(new String(ooazaSearchResult.m_partialSearchWord));
            }
            while (candIt.hasNext()) {
                scoringAddress = candIt.next();
                boolean checkNextField = true;
                if (!(this.m_geoType != 1 || streetSearchResult != null && this.candFieldMatchedWithSearchedResult(scoringAddress, BLOCK_FIELD))) {
                    checkNextField = false;
                }
                if (checkNextField && prefSearchResult != null && !this.candFieldMatchedWithSearchedResult(scoringAddress, PREFECTURE_FIELD)) {
                    checkNextField = false;
                }
                if (checkNextField && !this.candFieldMatchedWithSearchedResult(scoringAddress, CITY_FIELD)) {
                    if (citySearchResult != null) {
                        if (citySearchResult.m_partialSearchWord != null) {
                            if (this.matchPartialWithField(scoringAddress, CITY_FIELD, citySearchResult.m_partialSearchWord)) {
                                ++partialCityMatches;
                            } else {
                                checkNextField = false;
                            }
                        } else {
                            checkNextField = false;
                        }
                    } else {
                        allowMultiples = false;
                    }
                }
                if (checkNextField && !this.candChomeMatchedWithSearchResult(scoringAddress) && !this.acceptEmptyCandidateChome(scoringAddress)) {
                    if (scoringAddress.getField(CHOME_FIELD) != null && chomeSearchResult == null) {
                        if (this.getGeocodeType() == 3 && !this.m_containsUnparsedInputs && ooazaSearchResult != null && citySearchResult != null) {
                            ++chomeCands;
                        } else {
                            checkNextField = false;
                        }
                    } else {
                        checkNextField = false;
                    }
                }
                if (checkNextField && !this.candFieldMatchedWithSearchedResult(scoringAddress, OOAZA_FIELD)) {
                    checkNextField = false;
                    if (partialOoazaChars != null) {
                        if (this.acceptPartialOoazaMatch(scoringAddress, ooazaSearchResult.m_partialSearchWord) || this.matchedWithOldCity(citySearchResult, partialOoazaChars, scoringAddress, true, true, dataManager)) {
                            ++partialOoazaMatches;
                            checkNextField = true;
                        }
                    } else if (ooazaSearchResult == null && citySearchResult != null) {
                        allowMultiples = false;
                        ++candsWithOoazaSkipped;
                        checkNextField = true;
                    }
                }
                if (checkNextField) continue;
                candIt.remove();
                --candCount;
            }
            if (candCount > 1 && chomeSearchResult != null) {
                cands = this.filterMultiplesForExactSearchWord(cands, chomeSearchResult);
                candCount = cands.getCandidateCount();
            }
            if (candCount > 1 && ooazaSearchResult != null) {
                cands = this.filterMultiplesForExactSearchWord(cands, ooazaSearchResult);
                candCount = cands.getCandidateCount();
            }
            if (candCount > 1 && (candsWithOoazaSkipped > 0 || partialOoazaMatches > 0)) {
                cands = this.filterMultiplesForPartialOoazaMatch(cands, partialOoazaChars, dataManager);
                candCount = cands.getCandidateCount();
            }
            if (candCount > 1) {
                if (allowMultiples) {
                    if (partialCityMatches > 0 && candCount != partialCityMatches) {
                        cands.getCandidateList().clear();
                    }
                    if (chomeCands > 0 && candCount != chomeCands) {
                        candIt = cands.getCandidateList().iterator();
                        while (candIt.hasNext()) {
                            scoringAddress = candIt.next();
                            if (this.candFieldMatchedWithSearchedResult(scoringAddress, CHOME_FIELD)) continue;
                            candIt.remove();
                        }
                    }
                } else {
                    cands.getCandidateList().clear();
                }
            }
            return cands;
        }
        return cands;
    }

    private boolean acceptEmptyCandidateChome(InternalScoringAddress scoringAddress) {
        if (scoringAddress.isEmpty(CHOME_FIELD) && this.an2an3intersectionFound) {
            DictSearchResult dsr = this.getSearchFieldResult(CHOME_FIELD);
            if (dsr == null) {
                return true;
            }
            return dsr.m_searchedWord == null && this.matchedWithoutIgnoredCharacters(this.getSearchFieldResult(OOAZA_FIELD)) && !this.didSearchedChomeMatchedOoaza(scoringAddress, dsr);
        }
        return false;
    }

    private boolean matchedWithoutIgnoredCharacters(DictSearchResult dsr) {
        if (dsr != null && dsr.m_searchedWord != null && dsr.m_areaList != null) {
            int searchLen = dsr.m_searchedWord.length();
            for (DictionaryAreaTermItem areaItem : dsr.m_areaList) {
                if (searchLen != JPNCandidateUtils.toStringWord(areaItem.m_areaWords).length()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean didSearchedChomeMatchedOoaza(InternalScoringAddress scoringAddress, DictSearchResult chomeSearchResult) {
        InternalFieldValue ooazaFv = (InternalFieldValue)scoringAddress.getField(OOAZA_FIELD);
        if (ooazaFv != null) {
            String searchWord = chomeSearchResult.m_searchedWord;
            if (searchWord == null) {
                searchWord = new String(chomeSearchResult.m_skippedSearchWord);
            }
            if (searchWord != null) {
                return JPNCandidateUtils.strMatchedWithFieldValue(searchWord, ooazaFv);
            }
        }
        return false;
    }

    private boolean doesSearchWordContainNumericDigits(DictSearchResult dsr) {
        return dsr.m_searchedWord == null || JapaneseNumerals.containsNumericDigits(dsr.m_searchedWord.toCharArray());
    }

    protected InternalCandidateList filterMultiplesForExactSearchWord(InternalCandidateList candList, DictSearchResult sr) {
        int candCount;
        int n = candCount = candList == null ? 0 : candList.getCandidateCount();
        if (sr != null && sr.m_searchedWord != null && candCount > 1) {
            List<InternalScoringAddress> cands = candList.getCandidateList();
            IntArray exactMatchNdx = new IntArray(candCount);
            char[] searchChars = sr.m_searchedWord.toCharArray();
            for (int i = 0; i < candCount; ++i) {
                InternalScoringAddress cand = cands.get(i);
                char[] chars = JPNCandidateUtils.getWordCharacters(cand, sr.m_type);
                if (!Arrays.equals(chars, searchChars)) continue;
                exactMatchNdx.add(i);
            }
            int exactMatchedCands = exactMatchNdx.size();
            if (exactMatchedCands > 0 && exactMatchedCands < candCount) {
                ArrayList<InternalScoringAddress> newCands = new ArrayList<InternalScoringAddress>(exactMatchedCands);
                for (int i = 0; i < exactMatchedCands; ++i) {
                    newCands.add(cands.get(exactMatchNdx.get(i)));
                }
                candList = new InternalCandidateList(newCands);
            }
        }
        return candList;
    }

    private boolean isOldCityInput(InternalScoringAddress cand, DictSearchResult cityResult, IDataManager dataManager) throws CGGEInternalException {
        IDictionaryMetaData metaData;
        FieldType oldCityType;
        InternalFieldValue fv;
        return cityResult != null && cityResult.m_searchedAddressWord != null && (fv = (InternalFieldValue)cand.getField(oldCityType = (metaData = dataManager.getMetaData(cand.getDictionaryNumber(), cand.getAddressType())).getFieldForName("old_city"))) != null && JPNCandidateUtils.wordsMatchedWithFieldValue(new AddressWord[]{cityResult.m_searchedAddressWord}, fv);
    }

    protected InternalCandidateList filterMultiplesForPartialOoazaMatch(InternalCandidateList candList, char[] partialOoazaChars, IDataManager dataManager) throws CGGEInternalException {
        block4: {
            DictSearchResult ooazaResult;
            block3: {
                if (partialOoazaChars != null) break block3;
                Iterator<InternalScoringAddress> it = candList.getCandidateList().iterator();
                while (it.hasNext()) {
                    InternalScoringAddress cand = it.next();
                    if (this.candFieldMatchedWithSearchedResult(cand, OOAZA_FIELD)) continue;
                    it.remove();
                }
                break block4;
            }
            DictSearchResult citySearchResult = this.getSearchFieldResult(CITY_FIELD);
            Iterator<InternalScoringAddress> it = candList.getCandidateList().iterator();
            while (it.hasNext()) {
                InternalScoringAddress cand = it.next();
                if (this.matchedWithOldCity(citySearchResult, partialOoazaChars, cand, true, true, dataManager)) continue;
                it.remove();
            }
            int candCount = candList.getCandidateCount();
            if (candCount <= 1 || (ooazaResult = this.getSearchFieldResult(OOAZA_FIELD)) == null || ooazaResult.m_partialSearchWord == null || Arrays.equals(ooazaResult.m_partialSearchWord, partialOoazaChars)) break block4;
            it = candList.getCandidateList().iterator();
            while (it.hasNext()) {
                InternalScoringAddress cand = it.next();
                if (this.matchedWithOldCity(citySearchResult, ooazaResult.m_partialSearchWord, cand, true, false, dataManager)) continue;
                it.remove();
            }
        }
        return candList;
    }

    private boolean acceptPartialOoazaMatch(InternalScoringAddress addr, char[] searchChars) {
        boolean match = this.matchPartialWithField(addr, OOAZA_FIELD, searchChars);
        if (!match && !JapaneseNumerals.containsNumericDigits(searchChars)) {
            match = this.matchPartialFieldWithInput(addr, OOAZA_FIELD, searchChars);
        }
        return match;
    }

    protected List<DictionaryAreaTermItem> getAreaListForCandSearch() {
        ArrayList<DictionaryAreaTermItem> areaList = new ArrayList<DictionaryAreaTermItem>(10);
        if (this.m_searchFieldResults != null) {
            Iterator<Map.Entry<FieldType, DictSearchResult>> it = this.m_searchFieldResults.entrySet().iterator();
            while (it.hasNext()) {
                DictSearchResult dsr = it.next().getValue();
                if (dsr == null || dsr.m_areaList == null) continue;
                areaList.addAll(dsr.m_areaList);
            }
        }
        return areaList;
    }

    protected List<FieldType> getSacIntersectionAreaList() {
        ArrayList<FieldType> fieldList = new ArrayList<FieldType>(5);
        if (this.m_searchFieldResults != null) {
            Iterator<Map.Entry<FieldType, DictSearchResult>> it = this.m_searchFieldResults.entrySet().iterator();
            while (it.hasNext()) {
                DictSearchResult dsr = it.next().getValue();
                if (dsr == null || dsr.m_areaList == null || dsr.m_type.getLevel() != FieldType.FieldLevel.LEVEL_POSTAL) continue;
                fieldList.add(dsr.m_type);
            }
        }
        return fieldList;
    }

    protected void setParsedAddressFieldWithSearchedFields(ParsedAddress parsedAddress) {
        Map fields = parsedAddress.getFields();
        if (fields != null) {
            fields.clear();
        }
        if (this.m_searchFieldResults != null) {
            for (Map.Entry<FieldType, DictSearchResult> en : this.m_searchFieldResults.entrySet()) {
                FieldType type = en.getKey();
                DictSearchResult dsr = en.getValue();
                if (dsr == null) continue;
                if (type == LOT_FIELD) {
                    this.setParsedAddressNumber(dsr, parsedAddress);
                    continue;
                }
                if (dsr.m_searchedWord == null || dsr.m_searchedAddressWord == null) continue;
                parsedAddress.setField(type, new AddressWord[]{dsr.m_searchedAddressWord});
            }
        }
    }

    private void setParsedAddressNumber(DictSearchResult dsr, ParsedAddress pa) {
        String parsedAN;
        String string = parsedAN = dsr.m_partialSearchWord != null ? new String(dsr.m_partialSearchWord) : dsr.m_searchedWord;
        if (parsedAN != null) {
            AddressNumber addrNum = null;
            if (JapaneseNumerals.isNumber(parsedAN)) {
                int num = JapaneseNumerals.toNumber(parsedAN);
                addrNum = new AddressNumber(num);
            } else {
                String digits = JapaneseNumerals.getStartingDigits(parsedAN);
                if (digits == null) {
                    digits = JapaneseNumerals.getStartingJapanesNumeral(parsedAN);
                }
                if (digits != null) {
                    int num = Integer.parseInt(digits);
                    addrNum = new AddressNumber(num);
                }
            }
            pa.setAddressNumber(addrNum);
        }
    }

    private String getUnparsedText() {
        DictSearchResult dsr;
        if (this.m_singleLnInputList != null && (dsr = this.getSearchFieldResult(LOT_FIELD)) != null) {
            SearchOffset searchOffset = this.getNextCharOffsetForMatching(this.m_singleLnInputList, dsr);
            StringBuilder sb = new StringBuilder();
            if (searchOffset.m_wordOffset < this.m_singleLnInputList.size()) {
                boolean isFirst = true;
                int charOffset = searchOffset.m_charOffset;
                for (int i = searchOffset.m_wordOffset; i < this.m_singleLnInputList.size(); ++i) {
                    char[] chars = this.m_singleLnInputList.get(i);
                    int size = chars.length - charOffset;
                    if (size > 0) {
                        if (size == chars.length) {
                            if (isFirst) {
                                sb.append(chars);
                                isFirst = false;
                            } else {
                                sb.append(" ");
                                sb.append(chars);
                            }
                        } else {
                            sb.append(CharArray.subArray(chars, charOffset, size));
                        }
                    }
                    charOffset = 0;
                }
            }
            if (sb.length() > 0) {
                return sb.toString();
            }
        }
        return null;
    }

    protected abstract boolean generateCases(IDataManager var1, ParsedAddress var2, GeocodeOptions var3, InternalCandidateList var4) throws DataFetchException, CGGEInternalException, DataNotInitialisedException;

    @Override
    public InternalCandidateList searchNextCase(IDataManager dataManager, ParsedAddress parsedAddress, GeocodeOptions options, InternalCandidateList curCandList) throws CGGEInternalException, DataFetchException, DataNotInitialisedException {
        InternalCandidateList cands = null;
        MMUtils.adjustDictionarySearchOrderForLanguage(parsedAddress.getLanguage(), options, dataManager, options.getGeocodeType());
        if (this.continueRetrying(parsedAddress, curCandList) && this.generateCases(dataManager, parsedAddress, options, curCandList)) {
            List<DictionaryAreaTermItem> searchAreaList = this.getAreaListForCandSearch();
            if (searchAreaList != null) {
                List<DictionaryAddressWord> searchWordList;
                FieldType addressSearchType = this.getAddressSearchField();
                DictSearchResult dsr = this.getSearchFieldResult(addressSearchType);
                List<DictionaryAddressWord> list = searchWordList = dsr == null ? null : dsr.m_dictWords;
                if (this.m_savedOptions == null) {
                    this.m_savedOptions = new GeocodeOptions(options);
                } else {
                    options = new GeocodeOptions(this.m_savedOptions);
                }
                cands = this.retrieveCandidates(dataManager, parsedAddress, searchAreaList, searchWordList, options);
                cands = this.filterCandidates(cands, parsedAddress, dataManager);
                this.removeOldCityAlternates(cands, dataManager);
                if (cands != null && cands.getCandidateCount() > 0) {
                    this.setParsedAddressFieldWithSearchedFields(parsedAddress);
                    parsedAddress.setFlagSeparatePostAddressFields();
                    parsedAddress.setFlagSeperateAreaFields();
                    this.setCandidateRangePlaceName(cands);
                }
            }
        } else {
            this.m_canTryAgain = false;
        }
        return cands;
    }

    protected void removeOldCityAlternates(InternalCandidateList cands, IDataManager dataManager) throws CGGEInternalException {
        int candCount = cands == null ? 0 : cands.getCandidateCount();
        for (int candNdx = 0; candNdx < candCount; ++candNdx) {
            InternalFieldValue oldCityValue;
            IDictionaryMetaData md;
            FieldType oldCityType;
            AddressWord[][] ooazaAlts;
            InternalScoringAddress cand = cands.getIndexedCandidate(candNdx);
            InternalFieldValue cityField = (InternalFieldValue)cand.getField(CITY_FIELD);
            InternalFieldValue ooazaField = (InternalFieldValue)cand.getField(OOAZA_FIELD);
            AddressWord[][] cityAlts = cityField != null ? (AddressWord[][])cityField.getAlternateValues() : (AddressWord[][])null;
            AddressWord[][] addressWordArray = ooazaAlts = ooazaField != null ? (AddressWord[][])ooazaField.getAlternateValues() : (AddressWord[][])null;
            if (cityAlts == null && ooazaAlts == null || (oldCityType = (md = dataManager.getMetaData(cand.getDictionaryNumber(), cand.getAddressType())).getFieldForName("old_city")) == null || (oldCityValue = (InternalFieldValue)cand.getField(oldCityType)) == null) continue;
            if (cityAlts != null) {
                JPNCandidateUtils.removeMatchingAlts(cityField, oldCityValue);
            }
            if (ooazaAlts == null) continue;
            JPNCandidateUtils.removeMatchingAlts(ooazaField, oldCityValue);
        }
    }

    private void setCandidateRangePlaceName(InternalCandidateList cands) {
        DictSearchResult dsr = this.getSearchFieldResult(LOT_FIELD);
        String unparsedText = this.getUnparsedText();
        if (dsr != null || unparsedText != null) {
            AddressWord word1 = dsr != null ? new AddressWord(dsr.m_searchedWord) : null;
            AddressWord word2 = unparsedText != null ? new AddressWord(unparsedText) : null;
            AddressWord[] words = null;
            words = new AddressWord[]{word1, word2};
            InternalFieldValue fv = new InternalFieldValue(words);
            for (InternalScoringAddress cand : cands.getCandidateList()) {
                cand.setField(FieldType.PLACE_NAME_FIELD_TYPE, fv);
            }
        }
    }

    protected boolean continueRetrying(ParsedAddress pAddr, InternalCandidateList currentList) {
        int closeMatchCount = currentList == null ? 0 : currentList.getNumberOfCloseMatches();
        return closeMatchCount < 1;
    }

    private InternalCandidateList retrieveCandidates(IDataManager dataManager, ParsedAddress parsedAddress, List<DictionaryAreaTermItem> areaList, List<DictionaryAddressWord> searchWordList, GeocodeOptions options) throws CGGEInternalException, DataFetchException, DataNotInitialisedException {
        InternalCandidateList candList = null;
        int geocodeType = this.getGeocodeType();
        List<DictionaryAreaSacs> areaSacList = dataManager.getSacsForAreas(geocodeType, areaList, options);
        if (areaSacList != null) {
            this.filterSacsForAreaIntersection(areaSacList, this.getSacIntersectionAreaList());
            if (areaSacList != null) {
                this.checkAn2An3IntersectionFound(areaSacList);
                Collection<InternalScoringAddress> cands = dataManager.findCandidates(geocodeType, areaSacList, searchWordList, options);
                if (cands != null) {
                    candList = new InternalCandidateList();
                    candList.addCandidates(cands);
                }
            }
        }
        return candList;
    }

    private void checkAn2An3IntersectionFound(List<DictionaryAreaSacs> areaSacList) {
        if (!this.an2an3intersectionFound) {
            boolean an2SacFound = false;
            boolean an3SacFound = false;
            for (DictionaryAreaSacs dictAreaSac : areaSacList) {
                if (!an2SacFound && dictAreaSac.m_type == FieldType.AREA_NAME_2_FIELD_TYPE) {
                    an2SacFound = this.hasSac(dictAreaSac);
                }
                if (an3SacFound || dictAreaSac.m_type != FieldType.AREA_NAME_3_FIELD_TYPE) continue;
                an3SacFound = this.hasSac(dictAreaSac);
            }
            this.an2an3intersectionFound = an2SacFound && an3SacFound;
        }
    }

    private boolean hasSac(DictionaryAreaSacs dictionaryAreaSacs) {
        int[] sacs = dictionaryAreaSacs.getAreaSac();
        return sacs != null && sacs.length > 0;
    }

    protected void filterSacsForAreaIntersection(List<DictionaryAreaSacs> areaSacList, List<FieldType> insersectionFieldList) {
        Iterator it;
        int areaCount = areaSacList == null ? 0 : areaSacList.size();
        HashMap<FieldType, IntArray> areaSacMap = new HashMap<FieldType, IntArray>(areaCount);
        for (int areaNdx = 0; areaNdx < areaCount; ++areaNdx) {
            int[] sacs;
            DictionaryAreaSacs das = areaSacList.get(areaNdx);
            FieldType type = das.getAreaTerm().m_type;
            if (!insersectionFieldList.contains(type) || (sacs = das.getAreaSac()) == null) continue;
            IntArray sacArray = (IntArray)areaSacMap.get(type);
            if (sacArray == null) {
                sacArray = new IntArray(sacs);
                areaSacMap.put(type, sacArray);
                continue;
            }
            sacArray.add(sacs);
        }
        IntArray intersectingSacs = null;
        if (areaSacMap.size() > 0 && (it = areaSacMap.values().iterator()).hasNext()) {
            IntArray array;
            intersectingSacs = (IntArray)it.next();
            while (it.hasNext() && (intersectingSacs = IntArray.getCommonItems(intersectingSacs, array = (IntArray)it.next())) != null) {
            }
        }
        if (intersectingSacs != null) {
            intersectingSacs.removeDuplicates();
        }
        int[] intersectingSacArray = intersectingSacs == null ? null : intersectingSacs.asArray();
        for (int areaNdx = 0; areaNdx < areaSacList.size(); ++areaNdx) {
            if (intersectingSacArray == null) {
                areaSacList.remove(areaNdx);
                --areaNdx;
                continue;
            }
            DictionaryAreaSacs das = areaSacList.get(areaNdx);
            FieldType type = das.getAreaTerm().m_type;
            if (!insersectionFieldList.contains(type)) continue;
            das.setAreaSac(intersectingSacArray);
        }
    }

    protected List<DictionaryAddressWord> getSearchableWords(AddressWord searchWord, FieldType type, IDataManager dataManager, double minQuality, GeocodeOptions options) throws CGGEInternalException, DataNotInitialisedException, DataFetchException {
        List<DictionaryAddressWord> searchableWordList = null;
        if (searchWord != null) {
            searchableWordList = dataManager.findMatchingWords(this.m_geoType, searchWord, type, minQuality, options);
        }
        if (searchableWordList != null) {
            Iterator addrWordIt = searchableWordList.iterator();
            while (addrWordIt.hasNext()) {
                ((DictionaryAddressWord)addrWordIt.next()).getAddressWord().m_wordType = type;
            }
        }
        return searchableWordList;
    }

    @Override
    public boolean hasMoreTries() {
        return this.m_canTryAgain;
    }

    @Override
    public String getCountry() {
        return this.m_country;
    }

    @Override
    public String getLanguage() {
        return this.m_language;
    }

    protected void saveDefaultSearchResult() {
        if (this.m_searchFieldResults != null) {
            this.m_savedSearchFieldResults = new HashMap<FieldType, DictSearchResult>();
            this.copySearchResultMaps(this.m_searchFieldResults, this.m_savedSearchFieldResults);
        } else {
            this.m_savedSearchFieldResults = null;
        }
    }

    protected void restoreDefaultSearchResult() {
        if (this.m_savedSearchFieldResults != null) {
            this.m_searchFieldResults = new HashMap<FieldType, DictSearchResult>();
            this.copySearchResultMaps(this.m_savedSearchFieldResults, this.m_searchFieldResults);
        } else {
            this.m_searchFieldResults = null;
        }
        this.m_searchResultStack.clear();
    }

    protected void saveCurrentSearchResult() {
        if (this.m_searchFieldResults != null) {
            HashMap<FieldType, DictSearchResult> savedSearchResult = new HashMap<FieldType, DictSearchResult>();
            this.copySearchResultMaps(this.m_searchFieldResults, savedSearchResult);
            this.m_searchResultStack.push(savedSearchResult);
        }
    }

    protected void restoreLastSearchResult() {
        Map<FieldType, DictSearchResult> savedSearchResult;
        Map<FieldType, DictSearchResult> map = savedSearchResult = this.m_searchResultStack.size() > 0 ? this.m_searchResultStack.pop() : null;
        if (savedSearchResult != null) {
            this.m_searchFieldResults = new HashMap<FieldType, DictSearchResult>();
            this.copySearchResultMaps(savedSearchResult, this.m_searchFieldResults);
        }
    }

    protected void copySearchResultMaps(Map<FieldType, DictSearchResult> copyFrom, Map<FieldType, DictSearchResult> copyTo) {
        for (Map.Entry<FieldType, DictSearchResult> en : copyFrom.entrySet()) {
            DictSearchResult dsr = en.getValue();
            if (dsr == null) continue;
            copyTo.put(en.getKey(), new DictSearchResult(dsr));
        }
    }

    protected AddressWord[] findPCAreaAndRemoveProbablePcsFromWords(AddressWord[] words, ParsedAddress parsedAddr, IDataManager dataManager, GeocodeOptions options) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        AddressWord[] pcWords = (AddressWord[])parsedAddr.getField(FieldType.POST_CODE_FIELD_TYPE);
        if (words != null && pcWords == null) {
            int wordCount = words.length;
            List<PostCode> pcs = parsedAddr.getProbablePostcodes();
            if (pcs != null && pcs.size() > 0) {
                PostCode pc = pcs.get(0);
                pcWords = pc.getWords();
                int[] pcPos = pc.getPositionInInputStreet();
                if (wordCount > pcPos[1] - pcPos[0]) {
                    AddressWord[] newMainWords = new AddressWord[wordCount - (pcPos[1] - pcPos[0])];
                    if (pcPos[0] > 0) {
                        AddressWordArray.arraycopy(words, 0, newMainWords, 0, pcPos[0]);
                    }
                    if (wordCount > pcPos[1]) {
                        AddressWordArray.arraycopy(words, pcPos[1], newMainWords, pcPos[0], wordCount - pcPos[1]);
                    }
                    words = newMainWords;
                } else {
                    words = null;
                }
            }
        }
        if (pcWords != null) {
            List<DictionaryAreaTermItem> pcList = dataManager.findAreaTerms(this.getGeocodeType(), pcWords, FieldType.POST_CODE_FIELD_TYPE, 1.0, options);
            DictSearchResult sr = new DictSearchResult();
            sr.m_areaList = pcList;
            if (parsedAddr.getField(FieldType.POST_CODE_FIELD_TYPE) == null) {
                parsedAddr.setField(FieldType.POST_CODE_FIELD_TYPE, pcWords);
            }
        }
        return words;
    }

    protected void addSearchFieldResult(FieldType type, DictSearchResult result) {
        if (this.m_searchFieldResults == null) {
            this.m_searchFieldResults = new HashMap<FieldType, DictSearchResult>(10);
        }
        this.m_searchFieldResults.put(type, result);
    }

    protected DictSearchResult getSearchFieldResult(FieldType type) {
        if (this.m_searchFieldResults != null) {
            return this.m_searchFieldResults.get(type);
        }
        return null;
    }

    protected void setAddressSearchField(FieldType type) {
        this.m_addressSearchField = type;
    }

    protected FieldType getAddressSearchField() {
        return this.m_addressSearchField;
    }

    protected int getSearchResultStackSize() {
        return this.m_searchResultStack.size();
    }

    protected class DictSearchResult {
        boolean m_chomeTranferableToBlock;
        boolean m_streetIdentifierFound;
        String m_searchedWord = null;
        char[] m_skippedSearchWord = null;
        AddressWord m_searchedAddressWord = null;
        char[] m_partialSearchWord = null;
        List<DictionaryAreaTermItem> m_areaList = null;
        List<DictionaryAddressWord> m_dictWords = null;
        FieldType m_type;
        SearchOffset m_searchOffset = null;

        DictSearchResult() {
        }

        DictSearchResult(List<DictionaryAreaTermItem> areaList, FieldType type, String searchedWord, AddressWord searchedAddressWord) {
            this.m_areaList = areaList;
            this.m_type = type;
            this.m_searchedWord = searchedWord;
            this.m_searchedAddressWord = searchedAddressWord;
            this.m_chomeTranferableToBlock = true;
            this.m_streetIdentifierFound = false;
        }

        DictSearchResult(DictSearchResult copy) {
            this.m_searchedWord = copy.m_searchedWord;
            this.m_partialSearchWord = copy.m_partialSearchWord;
            this.m_skippedSearchWord = copy.m_skippedSearchWord;
            this.m_searchedAddressWord = copy.m_searchedAddressWord;
            if (copy.m_areaList != null) {
                this.m_areaList = new ArrayList<DictionaryAreaTermItem>(copy.m_areaList);
            }
            if (copy.m_dictWords != null) {
                this.m_dictWords = new ArrayList<DictionaryAddressWord>(copy.m_dictWords);
            }
            this.m_type = copy.m_type;
            if (copy.m_searchOffset != null) {
                this.m_searchOffset = new SearchOffset(copy.m_searchOffset.m_wordOffset, copy.m_searchOffset.m_charOffset);
            }
            this.m_chomeTranferableToBlock = copy.m_chomeTranferableToBlock;
            this.m_streetIdentifierFound = copy.m_streetIdentifierFound;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Searched word=");
            sb.append(this.m_searchedWord == null ? "" : this.m_searchedWord);
            sb.append(", Searched Address Word=");
            sb.append(this.m_searchedAddressWord == null ? "" : this.m_searchedAddressWord.getWord());
            sb.append(", Skipped word=");
            sb.append(this.m_skippedSearchWord == null ? "" : new String(this.m_skippedSearchWord));
            sb.append(", Partial word=");
            sb.append(this.m_partialSearchWord == null ? "" : new String(this.m_partialSearchWord));
            return sb.toString();
        }

        private int getSearchLength() {
            if (this.m_searchedWord != null) {
                return this.m_searchedWord.length();
            }
            if (this.m_skippedSearchWord != null) {
                return this.m_skippedSearchWord.length;
            }
            return 0;
        }
    }

    protected class SearchOffset {
        int m_wordOffset;
        int m_charOffset;

        SearchOffset(int wordOffset, int charOffset) {
            this.m_wordOffset = wordOffset;
            this.m_charOffset = charOffset;
        }
    }
}

