/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.JPN.helper;

import com.mapinfo.mapmarker.JPN.helper.JPNAbstractHelper;
import com.mapinfo.mapmarker.JPN.utils.JPNCandidateUtils;
import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.dp.DataFetchException;
import com.mapinfo.mapmarker.cgge.dp.DataNotInitialisedException;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAreaSacs;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.cgge.dp.InternalCandidateList;
import com.mapinfo.mapmarker.cgge.parser.ICGGEParser;
import com.mapinfo.mapmarker.cgge.soundex.ICGGESoundex;
import com.mapinfo.mapmarker.cgge.utils.CharArray;
import com.mapinfo.mapmarker.cgge.utils.IntArray;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import java.util.ArrayList;
import java.util.List;

public class JPNGeographicGeocodingHelper
extends JPNAbstractHelper {
    private int m_tryCount;
    private ParsedAddress m_savedParsedAddress;

    @Override
    public boolean init(String country, String language) {
        super.init(country, language);
        this.m_tryCount = 0;
        this.setGeocodeType(3);
        this.setAddressSearchField(FieldType.AREA_NAME_4_FIELD_TYPE);
        return true;
    }

    private boolean setAddressSearchWords(JPNAbstractHelper.DictSearchResult dsr, FieldType type, IDataManager dataManager, GeocodeOptions options) throws CGGEInternalException, DataNotInitialisedException, DataFetchException {
        if (dsr != null) {
            AddressWord searchAddressWord = null;
            if (dsr.m_searchedAddressWord != null) {
                searchAddressWord = dsr.m_searchedAddressWord;
            } else if (dsr.m_searchedWord != null) {
                searchAddressWord = this.getParser().convertToAddressWord(dsr.m_searchedWord, this.getSoundex());
            }
            dsr.m_dictWords = searchAddressWord != null ? this.getSearchableWords(searchAddressWord, type, dataManager, 1.0, options) : null;
            this.setAddressSearchField(type);
            return dsr.m_dictWords != null;
        }
        return false;
    }

    @Override
    protected void filterSacsForAreaIntersection(List<DictionaryAreaSacs> areaSacList, List<FieldType> insersectionFieldList) {
        super.filterSacsForAreaIntersection(areaSacList, insersectionFieldList);
        if (insersectionFieldList != null && areaSacList != null) {
            boolean an4sacs = insersectionFieldList.contains(FieldType.AREA_NAME_4_FIELD_TYPE);
            boolean an3sacs = insersectionFieldList.contains(FieldType.AREA_NAME_3_FIELD_TYPE);
            boolean an2sacs = insersectionFieldList.contains(FieldType.AREA_NAME_2_FIELD_TYPE);
            boolean an1sacs = insersectionFieldList.contains(FieldType.AREA_NAME_1_FIELD_TYPE);
            int maxSacLenght = 11;
            if (an4sacs) {
                maxSacLenght = 11;
            } else if (an3sacs) {
                maxSacLenght = 8;
            } else if (an2sacs) {
                maxSacLenght = 5;
            } else if (an1sacs) {
                maxSacLenght = 2;
            }
            for (DictionaryAreaSacs das : areaSacList) {
                int[] sacs = das.getAreaSac();
                IntArray newSacs = new IntArray(sacs.length);
                for (int i = 0; i < sacs.length; ++i) {
                    if (MMUtils.getDigitCount(sacs[i]) > maxSacLenght) continue;
                    newSacs.add(sacs[i]);
                }
                das.setAreaSac(newSacs.asArray());
            }
        }
    }

    @Override
    protected boolean generateCases(IDataManager dataManager, ParsedAddress parsedAddr, GeocodeOptions options, InternalCandidateList candidateList) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        boolean supportOldAPI = false;
        if (parsedAddr.isCustomFlagSet(0x1000000)) {
            return this.generateCasesForSingleLine(dataManager, parsedAddr, options, candidateList);
        }
        switch (this.m_tryCount) {
            case 0: {
                JPNAbstractHelper.DictSearchResult sr;
                ++this.m_tryCount;
                if (this.m_savedParsedAddress == null) {
                    this.m_savedParsedAddress = new ParsedAddress(parsedAddr.getCountry(), parsedAddr.getLanguage());
                    this.m_savedParsedAddress.copy(parsedAddr);
                }
                AddressWord[] an1 = null;
                AddressWord[] an2 = null;
                AddressWord[] an3 = null;
                AddressWord[] an4 = null;
                AddressWord[] pc = null;
                AddressWord[] main = null;
                AddressWord[] blockAndLot = null;
                AddressWord[] lot = null;
                if (supportOldAPI) {
                    pc = (AddressWord[])this.m_savedParsedAddress.getField(FieldType.POST_CODE_FIELD_TYPE);
                    an1 = (AddressWord[])this.m_savedParsedAddress.getField(FieldType.AREA_NAME_1_FIELD_TYPE);
                    an2 = (AddressWord[])this.m_savedParsedAddress.getField(FieldType.AREA_NAME_3_FIELD_TYPE);
                    an4 = (AddressWord[])this.m_savedParsedAddress.getField(FieldType.AREA_NAME_4_FIELD_TYPE);
                    blockAndLot = (AddressWord[])this.m_savedParsedAddress.getField(FieldType.AREA_NAME_2_FIELD_TYPE);
                    main = (AddressWord[])this.m_savedParsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
                } else {
                    an1 = (AddressWord[])this.m_savedParsedAddress.getField(FieldType.AREA_NAME_1_FIELD_TYPE);
                    an2 = (AddressWord[])this.m_savedParsedAddress.getField(FieldType.AREA_NAME_2_FIELD_TYPE);
                    an3 = (AddressWord[])this.m_savedParsedAddress.getField(FieldType.AREA_NAME_3_FIELD_TYPE);
                    an4 = (AddressWord[])this.m_savedParsedAddress.getField(FieldType.AREA_NAME_4_FIELD_TYPE);
                    blockAndLot = (AddressWord[])this.m_savedParsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
                    lot = (AddressWord[])this.m_savedParsedAddress.getField(FieldType.ADDRESS_NUMBER_FIELD_TYPE);
                }
                ICGGESoundex soundex = this.getSoundex();
                ICGGEParser parser = this.getParser();
                parsedAddr.setField(FieldType.AREA_NAME_1_FIELD_TYPE, null);
                parsedAddr.setField(FieldType.AREA_NAME_2_FIELD_TYPE, null);
                parsedAddr.setField(FieldType.AREA_NAME_3_FIELD_TYPE, null);
                parsedAddr.setField(FieldType.AREA_NAME_4_FIELD_TYPE, null);
                parsedAddr.setField(FieldType.STREET_NAME_FIELD_TYPE, null);
                if (pc != null && pc.length == 1) {
                    sr = this.searchFieldInData(pc[0].getWordChars(), FieldType.POST_CODE_FIELD_TYPE, soundex, parser, dataManager, options, false);
                    this.addSearchFieldResult(FieldType.POST_CODE_FIELD_TYPE, sr);
                }
                if (an1 != null && an1.length == 1) {
                    sr = this.searchFieldInData(an1[0].getWordChars(), FieldType.AREA_NAME_1_FIELD_TYPE, soundex, parser, dataManager, options, false);
                    this.addSearchFieldResult(FieldType.AREA_NAME_1_FIELD_TYPE, sr);
                }
                if (an2 != null && an2.length == 1) {
                    sr = this.searchFieldInData(an2[0].getWordChars(), FieldType.AREA_NAME_2_FIELD_TYPE, soundex, parser, dataManager, options, false);
                    this.addSearchFieldResult(FieldType.AREA_NAME_3_FIELD_TYPE, sr);
                }
                if (an3 != null && an3.length == 1) {
                    sr = this.searchFieldInData(an3[0].getWordChars(), FieldType.AREA_NAME_3_FIELD_TYPE, soundex, parser, dataManager, options, false);
                    this.addSearchFieldResult(FieldType.AREA_NAME_3_FIELD_TYPE, sr);
                }
                if (supportOldAPI) {
                    if (an4 != null && an4.length > 0) {
                        List<char[]> ooazaAndChomeCharList = this.getAddressWordCharList(an4);
                        this.separateAreasAndBlockFromSingleLine(ooazaAndChomeCharList, null, parsedAddr, dataManager, options, FieldType.AREA_NAME_3_FIELD_TYPE, null);
                    }
                } else if (an4 != null && an4.length == 1) {
                    sr = this.searchFieldInData(an4[0].getWordChars(), FieldType.AREA_NAME_4_FIELD_TYPE, soundex, parser, dataManager, options, false);
                    this.addSearchFieldResult(FieldType.AREA_NAME_4_FIELD_TYPE, sr);
                }
                JPNAbstractHelper.DictSearchResult chomeSearchResult = this.getSearchFieldResult(FieldType.AREA_NAME_4_FIELD_TYPE);
                this.setAddressSearchWords(chomeSearchResult, FieldType.AREA_NAME_4_FIELD_TYPE, dataManager, options);
                return true;
            }
            case 1: {
                ++this.m_tryCount;
                JPNAbstractHelper.DictSearchResult chomeSearchResult = this.getSearchFieldResult(FieldType.AREA_NAME_4_FIELD_TYPE);
                if (chomeSearchResult != null && chomeSearchResult.m_searchedWord != null) {
                    char[] newChomeWords = CharArray.splitAtChars(chomeSearchResult.m_searchedWord.toCharArray(), this.getChomeIdentiers(), false);
                    JPNAbstractHelper.DictSearchResult newChomeSearchResult = this.searchFieldInData(newChomeWords, FieldType.AREA_NAME_4_FIELD_TYPE, this.getSoundex(), this.getParser(), dataManager, options, false);
                    this.addSearchFieldResult(FieldType.AREA_NAME_4_FIELD_TYPE, newChomeSearchResult);
                    if (this.setAddressSearchWords(newChomeSearchResult, FieldType.AREA_NAME_4_FIELD_TYPE, dataManager, options)) {
                        return true;
                    }
                }
            }
            case 2: {
                ++this.m_tryCount;
                JPNAbstractHelper.DictSearchResult ooazaSearchResult = this.getSearchFieldResult(FieldType.AREA_NAME_3_FIELD_TYPE);
                if (ooazaSearchResult != null && ooazaSearchResult.m_searchedWord != null && this.setAddressSearchWords(ooazaSearchResult, FieldType.AREA_NAME_3_FIELD_TYPE, dataManager, options)) {
                    return true;
                }
            }
            case 3: {
                ++this.m_tryCount;
                JPNAbstractHelper.DictSearchResult citySearchResult = this.getSearchFieldResult(FieldType.AREA_NAME_2_FIELD_TYPE);
                if (citySearchResult != null && citySearchResult.m_searchedWord != null && this.setAddressSearchWords(citySearchResult, FieldType.AREA_NAME_2_FIELD_TYPE, dataManager, options)) {
                    return true;
                }
            }
            case 4: {
                ++this.m_tryCount;
                JPNAbstractHelper.DictSearchResult citySearchResult = this.getSearchFieldResult(FieldType.AREA_NAME_1_FIELD_TYPE);
                if (citySearchResult == null || citySearchResult.m_searchedWord == null || !this.setAddressSearchWords(citySearchResult, FieldType.AREA_NAME_1_FIELD_TYPE, dataManager, options)) break;
                return true;
            }
        }
        return false;
    }

    private boolean generateCaseForChomeWithoutDirectionals(IDataManager dataManager, GeocodeOptions options) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        JPNAbstractHelper.DictSearchResult newChomeResult;
        String chomeWord;
        char lastChar;
        JPNAbstractHelper.DictSearchResult chomeResult = this.getSearchFieldResult(FieldType.AREA_NAME_4_FIELD_TYPE);
        if (chomeResult != null && chomeResult.m_searchedWord != null && ((lastChar = (chomeWord = chomeResult.m_searchedWord).charAt(chomeWord.length() - 1)) == '\u5357' || lastChar == '\u5357') && (newChomeResult = this.seperateField(this.getSingleLineInputList(), FieldType.AREA_NAME_4_FIELD_TYPE, chomeResult.m_searchOffset, chomeWord.length() - 1, this.getParser(), this.getSoundex(), dataManager, options)) != null) {
            this.addSearchFieldResult(FieldType.AREA_NAME_4_FIELD_TYPE, newChomeResult);
            return true;
        }
        return false;
    }

    @Override
    protected InternalCandidateList filterCandidates(InternalCandidateList candList, ParsedAddress parsedAddress, IDataManager dataManager) throws CGGEInternalException {
        candList = super.filterCandidates(candList, parsedAddress, dataManager);
        candList = this.filterMultiplesFromHistoricalOoazaSearch(candList, parsedAddress, dataManager);
        return candList;
    }

    protected InternalCandidateList filterMultiplesFromHistoricalOoazaSearch(InternalCandidateList candList, ParsedAddress parsedAddress, IDataManager dataManager) {
        if (candList != null && candList.getCandidateCount() > 0) {
            JPNAbstractHelper.DictSearchResult cityResult = this.getSearchFieldResult(CITY_FIELD);
            JPNAbstractHelper.DictSearchResult ooazaResult = this.getSearchFieldResult(OOAZA_FIELD);
            if (cityResult != null && ooazaResult != null && cityResult.m_searchedAddressWord != null && ooazaResult.m_searchedAddressWord != null && JPNCandidateUtils.isMatchingWord(cityResult.m_searchedAddressWord, ooazaResult.m_searchedAddressWord) && ooazaResult.m_skippedSearchWord != null) {
                ArrayList<InternalScoringAddress> bestList = new ArrayList<InternalScoringAddress>(candList.getCandidateCount());
                int bestOoazaPrefixLen = 0;
                for (InternalScoringAddress cand : candList.getCandidateList()) {
                    char[] checkChars;
                    int skippedCharLen;
                    char[] candOoazaChars = JPNCandidateUtils.getWordNormalizedCharacters(cand, OOAZA_FIELD);
                    for (skippedCharLen = ooazaResult.m_skippedSearchWord.length; skippedCharLen > 0 && !CharArray.endsWith(candOoazaChars, checkChars = this.getSoundex().normalizeChars(new String(CharArray.subArray(ooazaResult.m_skippedSearchWord, 0, skippedCharLen)))); --skippedCharLen) {
                    }
                    if (skippedCharLen <= 0 || skippedCharLen < bestOoazaPrefixLen) continue;
                    if (skippedCharLen > bestOoazaPrefixLen) {
                        if (bestList.size() > 0) {
                            bestList.clear();
                        }
                        bestOoazaPrefixLen = skippedCharLen;
                    }
                    bestList.add(cand);
                }
                candList = new InternalCandidateList(bestList);
            }
        }
        return candList;
    }

    protected boolean generateHistoricalCityNameSearchCase(ParsedAddress parsedAddr, IDataManager dataManager, GeocodeOptions options) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        JPNAbstractHelper.DictSearchResult sr;
        JPNAbstractHelper.DictSearchResult cityResult = this.getSearchFieldResult(CITY_FIELD);
        if (cityResult != null && cityResult.m_searchedWord != null && (sr = this.searchFieldInData(cityResult.m_searchedWord.toCharArray(), OOAZA_FIELD, this.getSoundex(), this.getParser(), dataManager, options, false)) != null && this.setAddressSearchWords(sr, OOAZA_FIELD, dataManager, options)) {
            char[] chars;
            sr.m_searchOffset = cityResult.m_searchOffset;
            int matchedLen = cityResult.m_searchedWord.length();
            int nextCharPos = cityResult.m_searchOffset.m_charOffset + matchedLen;
            if (nextCharPos < (chars = this.getSingleLineInputList().get(cityResult.m_searchOffset.m_wordOffset)).length - 1) {
                sr.m_skippedSearchWord = CharArray.subArray(chars, nextCharPos);
            }
            sr.m_partialSearchWord = sr.m_searchedWord.toCharArray();
            sr.m_searchedWord = null;
            this.addSearchFieldResult(OOAZA_FIELD, sr);
            return true;
        }
        return false;
    }

    protected boolean generateCasesForSingleLine(IDataManager dataManager, ParsedAddress parsedAddr, GeocodeOptions options, InternalCandidateList candidateList) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        if (this.m_savedParsedAddress == null) {
            this.m_savedParsedAddress = new ParsedAddress(parsedAddr.getCountry(), parsedAddr.getLanguage());
            this.m_savedParsedAddress.copy(parsedAddr);
        }
        switch (this.m_tryCount) {
            case 0: {
                ++this.m_tryCount;
                AddressWord[] inputStreetWords = (AddressWord[])parsedAddr.getField(FieldType.STREET_NAME_FIELD_TYPE);
                inputStreetWords = this.findPCAreaAndRemoveProbablePcsFromWords(inputStreetWords, parsedAddr, dataManager, options);
                inputStreetWords = this.removeDelimiterWords(inputStreetWords);
                List<char[]> streetWordChars = this.getAddressWordCharList(inputStreetWords);
                this.setSingleLineInputList(streetWordChars);
                this.saveDefaultSearchResult();
                if (streetWordChars != null) {
                    this.separateAreasAndBlockFromSingleLine(streetWordChars, parsedAddr, dataManager, options);
                    this.saveDefaultSearchResult();
                    JPNAbstractHelper.DictSearchResult chomeResult = this.getSearchFieldResult(FieldType.AREA_NAME_4_FIELD_TYPE);
                    if (chomeResult != null && chomeResult.m_searchedAddressWord != null && this.isValidChomeCase() && this.setAddressSearchWords(chomeResult, FieldType.AREA_NAME_4_FIELD_TYPE, dataManager, options)) {
                        return true;
                    }
                } else {
                    return false;
                }
            }
            case 1: {
                ++this.m_tryCount;
                JPNAbstractHelper.DictSearchResult chomeResult = this.getSearchFieldResult(FieldType.AREA_NAME_4_FIELD_TYPE);
                if (chomeResult != null && this.generateCaseForChomeWithoutDirectionals(dataManager, options)) {
                    chomeResult = this.getSearchFieldResult(FieldType.AREA_NAME_4_FIELD_TYPE);
                    if (this.isValidChomeCase() && this.setAddressSearchWords(chomeResult, FieldType.AREA_NAME_4_FIELD_TYPE, dataManager, options)) {
                        return true;
                    }
                }
            }
            case 2: {
                JPNAbstractHelper.DictSearchResult chomeResult;
                if (this.generateCaseForIncorrectOoazaChomeSplit(parsedAddr, dataManager, options) && (chomeResult = this.getSearchFieldResult(FieldType.AREA_NAME_4_FIELD_TYPE)) != null && chomeResult.m_searchedAddressWord != null && this.isValidChomeCase() && this.setAddressSearchWords(chomeResult, FieldType.AREA_NAME_4_FIELD_TYPE, dataManager, options)) {
                    return true;
                }
                this.restoreDefaultSearchResult();
                ++this.m_tryCount;
            }
            case 3: {
                JPNAbstractHelper.DictSearchResult chomeResult;
                boolean canContinue = false;
                do {
                    this.saveCurrentSearchResult();
                    if (this.generatePartialOoazaCases(parsedAddr, dataManager, options)) {
                        chomeResult = this.getSearchFieldResult(FieldType.AREA_NAME_4_FIELD_TYPE);
                        if (this.isValidChomeCase() && this.setAddressSearchWords(chomeResult, FieldType.AREA_NAME_4_FIELD_TYPE, dataManager, options)) {
                            return true;
                        }
                    }
                    this.restoreLastSearchResult();
                    canContinue = this.generateSubOoazaCase(parsedAddr, dataManager, options);
                    if (!canContinue || (chomeResult = this.getSearchFieldResult(FieldType.AREA_NAME_4_FIELD_TYPE)) == null || chomeResult.m_searchedAddressWord == null || !this.isValidChomeCase() || !this.setAddressSearchWords(chomeResult, FieldType.AREA_NAME_4_FIELD_TYPE, dataManager, options)) continue;
                    return true;
                } while (canContinue);
                this.restoreDefaultSearchResult();
                ++this.m_tryCount;
            }
            case 4: {
                JPNAbstractHelper.DictSearchResult chomeResult;
                ++this.m_tryCount;
                if (this.generateCaseForFullySkippedOoaza(parsedAddr, dataManager, options) && (chomeResult = this.getSearchFieldResult(FieldType.AREA_NAME_4_FIELD_TYPE)) != null && chomeResult.m_searchedAddressWord != null && this.isValidChomeCase() && this.setAddressSearchWords(chomeResult, FieldType.AREA_NAME_4_FIELD_TYPE, dataManager, options)) {
                    return true;
                }
                this.restoreDefaultSearchResult();
            }
            case 5: {
                JPNAbstractHelper.DictSearchResult chomeResult;
                boolean canContinue = false;
                do {
                    if (!(canContinue = this.generatePartialOoazaCases(parsedAddr, dataManager, options)) || (chomeResult = this.getSearchFieldResult(FieldType.AREA_NAME_4_FIELD_TYPE)) == null || chomeResult.m_searchedAddressWord == null || !this.isValidChomeCase() || !this.setAddressSearchWords(chomeResult, FieldType.AREA_NAME_4_FIELD_TYPE, dataManager, options)) continue;
                    return true;
                } while (canContinue);
                this.restoreDefaultSearchResult();
                ++this.m_tryCount;
            }
            case 6: {
                ++this.m_tryCount;
                this.separateAreasAndBlockFromSingleLine(this.getSingleLineInputList(), null, parsedAddr, dataManager, options, PREFECTURE_FIELD, CHOME_FIELD);
                JPNAbstractHelper.DictSearchResult chomeResult = this.getSearchFieldResult(FieldType.AREA_NAME_4_FIELD_TYPE);
                if (chomeResult != null && this.generateCaseForPartialCityName(parsedAddr, dataManager, options) && this.isValidChomeCase() && this.setAddressSearchWords(chomeResult, FieldType.AREA_NAME_4_FIELD_TYPE, dataManager, options)) {
                    return true;
                }
            }
            case 7: {
                JPNAbstractHelper.DictSearchResult chomeResult;
                if (this.generateCaseForIncorrectCityOoazaSplit(parsedAddr, dataManager, options) && (chomeResult = this.getSearchFieldResult(FieldType.AREA_NAME_4_FIELD_TYPE)) != null && chomeResult.m_searchedAddressWord != null && this.isValidChomeCase() && this.setAddressSearchWords(chomeResult, FieldType.AREA_NAME_4_FIELD_TYPE, dataManager, options)) {
                    return true;
                }
                ++this.m_tryCount;
            }
            case 8: {
                ++this.m_tryCount;
                this.separateAreasAndBlockFromSingleLine(this.getSingleLineInputList(), null, parsedAddr, dataManager, options, PREFECTURE_FIELD, OOAZA_FIELD);
                JPNAbstractHelper.DictSearchResult ooazaResult = this.getSearchFieldResult(FieldType.AREA_NAME_3_FIELD_TYPE);
                if (ooazaResult != null && ooazaResult.m_searchedAddressWord != null && this.setAddressSearchWords(ooazaResult, FieldType.AREA_NAME_3_FIELD_TYPE, dataManager, options)) {
                    this.addSearchFieldResult(FieldType.AREA_NAME_4_FIELD_TYPE, null);
                    return true;
                }
            }
            case 9: {
                ++this.m_tryCount;
                if (this.generateHistoricalCityNameSearchCase(parsedAddr, dataManager, options)) {
                    return true;
                }
            }
            case 10: {
                JPNAbstractHelper.DictSearchResult ooazaResult;
                ++this.m_tryCount;
                this.restoreDefaultSearchResult();
                if (this.generateCaseForPartialCityName(parsedAddr, dataManager, options) && (ooazaResult = this.getSearchFieldResult(FieldType.AREA_NAME_3_FIELD_TYPE)) != null && ooazaResult.m_searchedAddressWord != null && this.setAddressSearchWords(ooazaResult, FieldType.AREA_NAME_3_FIELD_TYPE, dataManager, options)) {
                    this.addSearchFieldResult(FieldType.AREA_NAME_4_FIELD_TYPE, null);
                    return true;
                }
            }
            case 11: {
                JPNAbstractHelper.DictSearchResult ooazaResult;
                if (this.generateCaseForIncorrectOoazaChomeSplit(parsedAddr, dataManager, options) && (ooazaResult = this.getSearchFieldResult(FieldType.AREA_NAME_3_FIELD_TYPE)) != null && ooazaResult.m_searchedAddressWord != null && this.setAddressSearchWords(ooazaResult, FieldType.AREA_NAME_3_FIELD_TYPE, dataManager, options)) {
                    this.addSearchFieldResult(FieldType.AREA_NAME_4_FIELD_TYPE, null);
                    return true;
                }
                ++this.m_tryCount;
            }
            case 12: {
                JPNAbstractHelper.DictSearchResult ooazaResult;
                if (this.generateSubOoazaCase(parsedAddr, dataManager, options) && (ooazaResult = this.getSearchFieldResult(FieldType.AREA_NAME_3_FIELD_TYPE)) != null && ooazaResult.m_searchedAddressWord != null && this.setAddressSearchWords(ooazaResult, FieldType.AREA_NAME_3_FIELD_TYPE, dataManager, options)) {
                    this.addSearchFieldResult(FieldType.AREA_NAME_4_FIELD_TYPE, null);
                    return true;
                }
                this.restoreDefaultSearchResult();
                ++this.m_tryCount;
            }
            case 13: {
                JPNAbstractHelper.DictSearchResult ooazaResult;
                ++this.m_tryCount;
                if (this.generateCaseForFullySkippedOoaza(parsedAddr, dataManager, options) && (ooazaResult = this.getSearchFieldResult(FieldType.AREA_NAME_3_FIELD_TYPE)) != null && ooazaResult.m_searchedAddressWord != null && this.setAddressSearchWords(ooazaResult, FieldType.AREA_NAME_3_FIELD_TYPE, dataManager, options)) {
                    this.addSearchFieldResult(FieldType.AREA_NAME_4_FIELD_TYPE, null);
                    return true;
                }
                this.restoreDefaultSearchResult();
            }
            case 14: {
                JPNAbstractHelper.DictSearchResult chomeResult;
                if (this.generatePartialOoazaCases(parsedAddr, dataManager, options) && (chomeResult = this.getSearchFieldResult(FieldType.AREA_NAME_4_FIELD_TYPE)) != null && chomeResult.m_searchedAddressWord != null && this.isValidChomeCase() && this.setAddressSearchWords(chomeResult, FieldType.AREA_NAME_4_FIELD_TYPE, dataManager, options)) {
                    return true;
                }
                this.restoreDefaultSearchResult();
                ++this.m_tryCount;
            }
            case 15: {
                JPNAbstractHelper.DictSearchResult ooazaResult;
                if (this.generateCaseForIncorrectCityOoazaSplit(parsedAddr, dataManager, options) && (ooazaResult = this.getSearchFieldResult(FieldType.AREA_NAME_3_FIELD_TYPE)) != null && ooazaResult.m_searchedAddressWord != null && this.setAddressSearchWords(ooazaResult, FieldType.AREA_NAME_3_FIELD_TYPE, dataManager, options)) {
                    this.addSearchFieldResult(FieldType.AREA_NAME_4_FIELD_TYPE, null);
                    return true;
                }
                ++this.m_tryCount;
            }
            case 16: {
                ++this.m_tryCount;
                this.separateAreasAndBlockFromSingleLine(this.getSingleLineInputList(), null, parsedAddr, dataManager, options, PREFECTURE_FIELD, CITY_FIELD);
                JPNAbstractHelper.DictSearchResult citySearchResult = this.getSearchFieldResult(FieldType.AREA_NAME_2_FIELD_TYPE);
                if (citySearchResult != null && citySearchResult.m_searchedAddressWord != null && this.setAddressSearchWords(citySearchResult, FieldType.AREA_NAME_2_FIELD_TYPE, dataManager, options)) {
                    this.addSearchFieldResult(FieldType.AREA_NAME_3_FIELD_TYPE, null);
                    this.addSearchFieldResult(FieldType.AREA_NAME_4_FIELD_TYPE, null);
                    return true;
                }
            }
            case 17: {
                ++this.m_tryCount;
                JPNAbstractHelper.DictSearchResult prefSearchResult = this.getSearchFieldResult(FieldType.AREA_NAME_1_FIELD_TYPE);
                if (prefSearchResult == null || prefSearchResult.m_searchedAddressWord == null || !this.setAddressSearchWords(prefSearchResult, FieldType.AREA_NAME_1_FIELD_TYPE, dataManager, options)) break;
                this.addSearchFieldResult(FieldType.AREA_NAME_2_FIELD_TYPE, null);
                this.addSearchFieldResult(FieldType.AREA_NAME_3_FIELD_TYPE, null);
                this.addSearchFieldResult(FieldType.AREA_NAME_4_FIELD_TYPE, null);
                return true;
            }
        }
        return false;
    }

    private boolean isValidChomeCase() {
        JPNAbstractHelper.DictSearchResult citySearchResult = this.getSearchFieldResult(CITY_FIELD);
        JPNAbstractHelper.DictSearchResult ooazaSearchResult = this.getSearchFieldResult(OOAZA_FIELD);
        return citySearchResult != null || ooazaSearchResult != null;
    }

    @Override
    public String getCountry() {
        return null;
    }

    @Override
    public String getLanguage() {
        return null;
    }
}

