/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.JPN.helper;

import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.dp.DataFetchException;
import com.mapinfo.mapmarker.cgge.dp.DataNotInitialisedException;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAddressWord;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAreaSacs;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAreaTermItem;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.cgge.dp.InternalCandidateList;
import com.mapinfo.mapmarker.cgge.helper.CGGEGeographicGeocodingHelper;
import com.mapinfo.mapmarker.cgge.utils.IntArray;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JPNLatinGeographicHelper
extends CGGEGeographicGeocodingHelper {
    private static final double PRETTY_GOOD_QUALITY = 0.85;
    private FieldType[] AREA_NAME_4_SAC_FIELDS = new FieldType[]{FieldType.AREA_NAME_1_FIELD_TYPE, FieldType.AREA_NAME_2_FIELD_TYPE, FieldType.AREA_NAME_3_FIELD_TYPE, FieldType.AREA_NAME_4_FIELD_TYPE};
    private FieldType[] AREA_NAME_3_SAC_FIELDS = new FieldType[]{FieldType.AREA_NAME_1_FIELD_TYPE, FieldType.AREA_NAME_2_FIELD_TYPE, FieldType.AREA_NAME_3_FIELD_TYPE};
    private FieldType[] AREA_NAME_2_SAC_FIELDS = new FieldType[]{FieldType.AREA_NAME_1_FIELD_TYPE, FieldType.AREA_NAME_2_FIELD_TYPE};
    private FieldType[] AREA_NAME_1_SAC_FIELDS = new FieldType[]{FieldType.AREA_NAME_1_FIELD_TYPE};
    private boolean m_bSingleLine = false;
    private boolean m_bMultiLine = false;
    private int m_currentSearchCase = 0;
    private Map<FieldType, DictSearchResult> m_sacFieldResults = null;
    private Map<FieldType, DictSearchResult> m_searchFieldResults = null;
    protected List<FieldType> m_areaSacIntersectionFieldList;
    private boolean m_bKeepTrying = true;
    private boolean filterAreaSacForAN1 = false;

    @Override
    public InternalCandidateList searchNextCase(IDataManager dataManager, ParsedAddress parsedAddress, GeocodeOptions options, InternalCandidateList curCandList) throws CGGEInternalException, DataFetchException, DataNotInitialisedException {
        MMUtils.adjustDictionarySearchOrderForLanguage(parsedAddress.getLanguage(), options, dataManager, options.getGeocodeType());
        if (!parsedAddress.isSeperatePostAddressFields()) {
            this.m_bSingleLine = true;
            return this.generateCandidatesForSingleLine(dataManager, parsedAddress, options, curCandList);
        }
        if (parsedAddress.isSeparateAreaFields()) {
            this.m_bMultiLine = true;
            return this.generateCandidatesForMultiLine(dataManager, parsedAddress, options, curCandList);
        }
        return super.searchNextCase(dataManager, parsedAddress, options, curCandList);
    }

    @Override
    public boolean hasMoreTries() {
        if (this.m_bSingleLine || this.m_bMultiLine) {
            return this.m_bKeepTrying;
        }
        return super.hasMoreTries();
    }

    private InternalCandidateList generateCandidatesForSingleLine(IDataManager dataManager, ParsedAddress parsed, GeocodeOptions options, InternalCandidateList currentCandList) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        InternalCandidateList cands;
        if (this.nextSearchCase(dataManager, parsed, options, currentCandList) && (cands = this.retrieveCandidates(dataManager, parsed, options)) != null && cands.getCandidateCount() > 0) {
            return cands;
        }
        return null;
    }

    @Override
    protected InternalCandidateList retrieveCandidates(IDataManager dataManager, ParsedAddress parsedAddress, GeocodeOptions options) throws CGGEInternalException, DataFetchException, DataNotInitialisedException {
        if (!this.m_bSingleLine && !this.m_bMultiLine) {
            return super.retrieveCandidates(dataManager, parsedAddress, options);
        }
        InternalCandidateList candList = null;
        List<DictionaryAreaTermItem> areaList = this.getAreaListForCandSearch();
        List<DictionaryAddressWord> searchWordList = this.getSearchWordsForCandSearch();
        if (areaList != null && searchWordList != null) {
            areaList = new ArrayList<DictionaryAreaTermItem>(areaList);
            searchWordList = new ArrayList<DictionaryAddressWord>(searchWordList);
            List<DictionaryAreaSacs> areaSacList = dataManager.getSacsForAreas(this.getGeocodeType(), areaList, options);
            if (areaSacList != null) {
                if (this.m_areaSacIntersectionFieldList != null && this.m_areaSacIntersectionFieldList.size() > 0) {
                    this.filterSacsForAreaIntersection(areaSacList, this.m_areaSacIntersectionFieldList);
                } else if (this.filterAreaSacForAN1) {
                    this.filterAreaSacOnLength(2, areaSacList);
                }
                this.filterSearchedSacs(areaSacList, searchWordList);
                Collection<InternalScoringAddress> cands = dataManager.findCandidates(this.getGeocodeType(), areaSacList, searchWordList, options);
                if (cands != null) {
                    candList = new InternalCandidateList();
                    candList.addCandidates(cands);
                }
            }
        }
        return candList;
    }

    private InternalCandidateList generateCandidatesForMultiLine(IDataManager dataManager, ParsedAddress parsed, GeocodeOptions options, InternalCandidateList currentCandList) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        InternalCandidateList cands;
        if (this.nextSearchMultiLineCase(dataManager, parsed, options, currentCandList) && (cands = this.retrieveCandidates(dataManager, parsed, options)) != null && cands.getCandidateCount() > 0) {
            return cands;
        }
        return null;
    }

    private List<DictionaryAreaTermItem> getAreaListForCandSearch() {
        ArrayList<DictionaryAreaTermItem> areaList = new ArrayList<DictionaryAreaTermItem>(10);
        if (this.m_sacFieldResults != null) {
            Iterator<Map.Entry<FieldType, DictSearchResult>> it = this.m_sacFieldResults.entrySet().iterator();
            while (it.hasNext()) {
                DictSearchResult dsr = it.next().getValue();
                if (dsr == null || dsr.m_areaList == null) continue;
                areaList.addAll(dsr.m_areaList);
            }
        }
        return areaList;
    }

    private List<DictionaryAddressWord> getSearchWordsForCandSearch() {
        ArrayList<DictionaryAddressWord> searchList = new ArrayList<DictionaryAddressWord>(10);
        if (this.m_searchFieldResults != null) {
            Iterator<Map.Entry<FieldType, DictSearchResult>> it = this.m_searchFieldResults.entrySet().iterator();
            while (it.hasNext()) {
                DictSearchResult dsr = it.next().getValue();
                if (dsr == null || dsr.m_dictWords == null) continue;
                searchList.addAll(dsr.m_dictWords);
            }
        }
        return searchList;
    }

    private boolean findAreaTerms(IDataManager dataManager, AddressWord[] postAddressWords, double quality, GeocodeOptions options, FieldType[] types) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        boolean bValid = false;
        if (postAddressWords != null && postAddressWords.length > 0) {
            for (FieldType type : types) {
                List<DictionaryAreaTermItem> areaList = dataManager.findAreaTerms(this.getGeocodeType(), postAddressWords, type, quality, options);
                if (areaList == null || areaList.size() <= 0) continue;
                bValid = true;
                DictSearchResult pcRes = new DictSearchResult();
                pcRes.m_areaList = areaList;
                this.addSacSearchFieldResult(type, pcRes);
                if (this.m_areaSacIntersectionFieldList == null) {
                    this.m_areaSacIntersectionFieldList = new ArrayList<FieldType>();
                }
                this.m_areaSacIntersectionFieldList.add(type);
            }
        }
        return bValid;
    }

    private boolean findAreaTermsML(IDataManager dataManager, ParsedAddress parsed, double quality, GeocodeOptions options, FieldType[] types) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        boolean bValid = false;
        for (FieldType type : types) {
            List<DictionaryAreaTermItem> areaList;
            AddressWord[] fieldWords = (AddressWord[])parsed.getField(type);
            if (fieldWords == null || fieldWords.length <= 0 || (areaList = dataManager.findAreaTerms(this.getGeocodeType(), fieldWords, type, quality, options)) == null || areaList.size() <= 0) continue;
            bValid = true;
            DictSearchResult pcRes = new DictSearchResult();
            pcRes.m_areaList = areaList;
            this.addSacSearchFieldResult(type, pcRes);
            if (this.m_areaSacIntersectionFieldList == null) {
                this.m_areaSacIntersectionFieldList = new ArrayList<FieldType>();
            }
            this.m_areaSacIntersectionFieldList.add(type);
        }
        return bValid;
    }

    @Override
    protected void filterSacsForAreaIntersection(List<DictionaryAreaSacs> areaSacList, List<FieldType> insersectionFieldList) {
        super.filterSacsForAreaIntersection(areaSacList, insersectionFieldList);
        if (!this.m_bSingleLine && !this.m_bMultiLine) {
            return;
        }
        if (insersectionFieldList != null && areaSacList != null) {
            boolean an4sacs = insersectionFieldList.contains(FieldType.AREA_NAME_4_FIELD_TYPE);
            boolean an3sacs = insersectionFieldList.contains(FieldType.AREA_NAME_3_FIELD_TYPE);
            boolean an2sacs = insersectionFieldList.contains(FieldType.AREA_NAME_2_FIELD_TYPE);
            boolean an1sacs = insersectionFieldList.contains(FieldType.AREA_NAME_1_FIELD_TYPE);
            int maxSacLenght = 11;
            if (an4sacs) {
                maxSacLenght = 11;
            } else if (an3sacs) {
                maxSacLenght = 8;
            } else if (an2sacs) {
                maxSacLenght = 5;
            } else if (an1sacs) {
                maxSacLenght = 2;
            }
            this.filterAreaSacOnLength(maxSacLenght, areaSacList);
        }
    }

    protected void filterAreaSacOnLength(int maxSecLength, List<DictionaryAreaSacs> areaSacList) {
        if (areaSacList != null && !areaSacList.isEmpty()) {
            for (DictionaryAreaSacs das : areaSacList) {
                int[] sacs = das.getAreaSac();
                IntArray newSacs = new IntArray(sacs.length);
                for (int i = 0; i < sacs.length; ++i) {
                    if (MMUtils.getDigitCount(sacs[i]) > maxSecLength) continue;
                    newSacs.add(sacs[i]);
                }
                if (newSacs.isEmpty()) continue;
                das.setAreaSac(newSacs.asArray());
            }
        }
    }

    private boolean nextSearchCase(IDataManager dataManager, ParsedAddress parsed, GeocodeOptions options, InternalCandidateList currentCandList) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        this.m_areaSacIntersectionFieldList = null;
        switch (this.m_currentSearchCase) {
            case 0: {
                List<DictionaryAddressWord> searchWords;
                AddressWord[] areaName4;
                ++this.m_currentSearchCase;
                if (parsed.getField(FieldType.AREA_NAME_4_FIELD_TYPE) != null && this.findAreaTerms(dataManager, areaName4 = (AddressWord[])parsed.getField(FieldType.AREA_NAME_4_FIELD_TYPE), 1.0, options, this.AREA_NAME_4_SAC_FIELDS) && (searchWords = this.searchWords(dataManager, areaName4, FieldType.AREA_NAME_4_FIELD_TYPE, 1.0, options)) != null) {
                    DictSearchResult dsr = new DictSearchResult();
                    dsr.m_dictWords = searchWords;
                    this.addSearchFieldResult(FieldType.AREA_NAME_4_FIELD_TYPE, dsr);
                    return true;
                }
            }
            case 1: {
                List<DictionaryAddressWord> searchWords;
                AddressWord[] areaName4;
                ++this.m_currentSearchCase;
                if (parsed.getField(FieldType.AREA_NAME_4_FIELD_TYPE) != null && ((areaName4 = (AddressWord[])parsed.getField(FieldType.AREA_NAME_4_FIELD_TYPE)).length != 1 || !areaName4[0].isNumeral()) && this.findAreaTerms(dataManager, areaName4, 0.85, options, this.AREA_NAME_4_SAC_FIELDS) && (searchWords = this.searchWords(dataManager, areaName4, FieldType.AREA_NAME_4_FIELD_TYPE, 0.85, options)) != null) {
                    DictSearchResult dsr = new DictSearchResult();
                    dsr.m_dictWords = searchWords;
                    this.addSearchFieldResult(FieldType.AREA_NAME_4_FIELD_TYPE, dsr);
                    return true;
                }
            }
            case 2: {
                AddressWord[] areaNames;
                List<DictionaryAddressWord> searchWords;
                ++this.m_currentSearchCase;
                if (parsed.getField(FieldType.POST_ADDRESS_FIELD_TYPE) != null && this.findAreaTerms(dataManager, areaNames = (AddressWord[])parsed.getField(FieldType.POST_ADDRESS_FIELD_TYPE), 1.0, options, this.AREA_NAME_3_SAC_FIELDS) && (searchWords = this.searchWords(dataManager, areaNames, FieldType.AREA_NAME_3_FIELD_TYPE, 1.0, options)) != null) {
                    DictSearchResult dsr = new DictSearchResult();
                    dsr.m_dictWords = searchWords;
                    this.addSearchFieldResult(FieldType.AREA_NAME_3_FIELD_TYPE, dsr);
                    return true;
                }
            }
            case 3: {
                AddressWord[] areaNames;
                List<DictionaryAddressWord> searchWords;
                ++this.m_currentSearchCase;
                if (parsed.getField(FieldType.POST_ADDRESS_FIELD_TYPE) != null && this.findAreaTerms(dataManager, areaNames = (AddressWord[])parsed.getField(FieldType.POST_ADDRESS_FIELD_TYPE), 0.85, options, this.AREA_NAME_3_SAC_FIELDS) && (searchWords = this.searchWords(dataManager, areaNames, FieldType.AREA_NAME_3_FIELD_TYPE, 0.85, options)) != null) {
                    DictSearchResult dsr = new DictSearchResult();
                    dsr.m_dictWords = searchWords;
                    this.addSearchFieldResult(FieldType.AREA_NAME_3_FIELD_TYPE, dsr);
                    return true;
                }
            }
            case 4: {
                AddressWord[] areaNames;
                List<DictionaryAddressWord> searchWords;
                ++this.m_currentSearchCase;
                if (parsed.getField(FieldType.POST_ADDRESS_FIELD_TYPE) != null && this.findAreaTerms(dataManager, areaNames = (AddressWord[])parsed.getField(FieldType.POST_ADDRESS_FIELD_TYPE), 1.0, options, this.AREA_NAME_2_SAC_FIELDS) && (searchWords = this.searchWords(dataManager, areaNames, FieldType.AREA_NAME_2_FIELD_TYPE, 1.0, options)) != null) {
                    DictSearchResult dsr = new DictSearchResult();
                    dsr.m_dictWords = searchWords;
                    this.addSearchFieldResult(FieldType.AREA_NAME_2_FIELD_TYPE, dsr);
                    return true;
                }
            }
            case 5: {
                AddressWord[] areaNames;
                List<DictionaryAddressWord> searchWords;
                ++this.m_currentSearchCase;
                if (parsed.getField(FieldType.POST_ADDRESS_FIELD_TYPE) != null && this.findAreaTerms(dataManager, areaNames = (AddressWord[])parsed.getField(FieldType.POST_ADDRESS_FIELD_TYPE), 0.85, options, this.AREA_NAME_2_SAC_FIELDS) && (searchWords = this.searchWords(dataManager, areaNames, FieldType.AREA_NAME_2_FIELD_TYPE, 0.85, options)) != null) {
                    DictSearchResult dsr = new DictSearchResult();
                    dsr.m_dictWords = searchWords;
                    this.addSearchFieldResult(FieldType.AREA_NAME_2_FIELD_TYPE, dsr);
                    return true;
                }
            }
            case 6: {
                AddressWord[] areaNames;
                List<DictionaryAddressWord> searchWords;
                ++this.m_currentSearchCase;
                if (parsed.getField(FieldType.POST_ADDRESS_FIELD_TYPE) != null && this.findAreaTerms(dataManager, areaNames = (AddressWord[])parsed.getField(FieldType.POST_ADDRESS_FIELD_TYPE), 1.0, options, this.AREA_NAME_1_SAC_FIELDS) && (searchWords = this.searchWords(dataManager, areaNames, FieldType.AREA_NAME_1_FIELD_TYPE, 1.0, options)) != null) {
                    DictSearchResult dsr = new DictSearchResult();
                    dsr.m_dictWords = searchWords;
                    this.addSearchFieldResult(FieldType.AREA_NAME_1_FIELD_TYPE, dsr);
                    return true;
                }
            }
            case 7: {
                AddressWord[] areaNames;
                List<DictionaryAddressWord> searchWords;
                ++this.m_currentSearchCase;
                if (parsed.getField(FieldType.POST_ADDRESS_FIELD_TYPE) == null || !this.findAreaTerms(dataManager, areaNames = (AddressWord[])parsed.getField(FieldType.POST_ADDRESS_FIELD_TYPE), 0.85, options, this.AREA_NAME_1_SAC_FIELDS) || (searchWords = this.searchWords(dataManager, areaNames, FieldType.AREA_NAME_1_FIELD_TYPE, 0.85, options)) == null) break;
                DictSearchResult dsr = new DictSearchResult();
                dsr.m_dictWords = searchWords;
                this.addSearchFieldResult(FieldType.AREA_NAME_1_FIELD_TYPE, dsr);
                return true;
            }
        }
        this.m_bKeepTrying = false;
        return false;
    }

    private boolean nextSearchMultiLineCase(IDataManager dataManager, ParsedAddress parsed, GeocodeOptions options, InternalCandidateList currentCandList) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        this.m_areaSacIntersectionFieldList = null;
        switch (this.m_currentSearchCase) {
            case 0: {
                List<DictionaryAddressWord> searchWords;
                AddressWord[] areaName4;
                ++this.m_currentSearchCase;
                if (parsed.getField(FieldType.AREA_NAME_4_FIELD_TYPE) != null) {
                    areaName4 = (AddressWord[])parsed.getField(FieldType.AREA_NAME_4_FIELD_TYPE);
                    if (this.findAreaTermsML(dataManager, parsed, 1.0, options, this.AREA_NAME_4_SAC_FIELDS) && (searchWords = this.searchWords(dataManager, areaName4, FieldType.AREA_NAME_4_FIELD_TYPE, 1.0, options)) != null) {
                        DictSearchResult dsr = new DictSearchResult();
                        dsr.m_dictWords = searchWords;
                        this.addSearchFieldResult(FieldType.AREA_NAME_4_FIELD_TYPE, dsr);
                        return true;
                    }
                }
            }
            case 1: {
                List<DictionaryAddressWord> searchWords;
                AddressWord[] areaName4;
                ++this.m_currentSearchCase;
                if (parsed.getField(FieldType.AREA_NAME_4_FIELD_TYPE) != null && ((areaName4 = (AddressWord[])parsed.getField(FieldType.AREA_NAME_4_FIELD_TYPE)).length != 1 || !areaName4[0].isNumeral()) && this.findAreaTermsML(dataManager, parsed, 0.85, options, this.AREA_NAME_4_SAC_FIELDS) && (searchWords = this.searchWords(dataManager, areaName4, FieldType.AREA_NAME_4_FIELD_TYPE, 0.85, options)) != null) {
                    DictSearchResult dsr = new DictSearchResult();
                    dsr.m_dictWords = searchWords;
                    this.addSearchFieldResult(FieldType.AREA_NAME_4_FIELD_TYPE, dsr);
                    return true;
                }
            }
            case 2: {
                AddressWord[] areaName3;
                List<DictionaryAddressWord> searchWords;
                ++this.m_currentSearchCase;
                if (parsed.getField(FieldType.AREA_NAME_3_FIELD_TYPE) != null && this.findAreaTermsML(dataManager, parsed, 1.0, options, this.AREA_NAME_3_SAC_FIELDS) && (searchWords = this.searchWords(dataManager, areaName3 = (AddressWord[])parsed.getField(FieldType.AREA_NAME_3_FIELD_TYPE), FieldType.AREA_NAME_3_FIELD_TYPE, 1.0, options)) != null) {
                    DictSearchResult dsr = new DictSearchResult();
                    dsr.m_dictWords = searchWords;
                    this.addSearchFieldResult(FieldType.AREA_NAME_3_FIELD_TYPE, dsr);
                    return true;
                }
            }
            case 3: {
                AddressWord[] areaNames;
                List<DictionaryAddressWord> searchWords;
                ++this.m_currentSearchCase;
                if (parsed.getField(FieldType.AREA_NAME_3_FIELD_TYPE) != null && this.findAreaTermsML(dataManager, parsed, 0.85, options, this.AREA_NAME_3_SAC_FIELDS) && (searchWords = this.searchWords(dataManager, areaNames = (AddressWord[])parsed.getField(FieldType.AREA_NAME_3_FIELD_TYPE), FieldType.AREA_NAME_3_FIELD_TYPE, 0.85, options)) != null) {
                    DictSearchResult dsr = new DictSearchResult();
                    dsr.m_dictWords = searchWords;
                    this.addSearchFieldResult(FieldType.AREA_NAME_3_FIELD_TYPE, dsr);
                    return true;
                }
            }
            case 4: {
                AddressWord[] areaNames;
                List<DictionaryAddressWord> searchWords;
                ++this.m_currentSearchCase;
                if (parsed.getField(FieldType.AREA_NAME_2_FIELD_TYPE) != null && this.findAreaTermsML(dataManager, parsed, 1.0, options, this.AREA_NAME_2_SAC_FIELDS) && (searchWords = this.searchWords(dataManager, areaNames = (AddressWord[])parsed.getField(FieldType.AREA_NAME_2_FIELD_TYPE), FieldType.AREA_NAME_2_FIELD_TYPE, 1.0, options)) != null) {
                    DictSearchResult dsr = new DictSearchResult();
                    dsr.m_dictWords = searchWords;
                    this.addSearchFieldResult(FieldType.AREA_NAME_2_FIELD_TYPE, dsr);
                    return true;
                }
            }
            case 5: {
                AddressWord[] areaNames;
                List<DictionaryAddressWord> searchWords;
                ++this.m_currentSearchCase;
                if (parsed.getField(FieldType.AREA_NAME_2_FIELD_TYPE) != null && this.findAreaTermsML(dataManager, parsed, 0.85, options, this.AREA_NAME_2_SAC_FIELDS) && (searchWords = this.searchWords(dataManager, areaNames = (AddressWord[])parsed.getField(FieldType.AREA_NAME_2_FIELD_TYPE), FieldType.AREA_NAME_2_FIELD_TYPE, 0.85, options)) != null) {
                    DictSearchResult dsr = new DictSearchResult();
                    dsr.m_dictWords = searchWords;
                    this.addSearchFieldResult(FieldType.AREA_NAME_2_FIELD_TYPE, dsr);
                    return true;
                }
            }
            case 6: {
                AddressWord[] areaNames;
                List<DictionaryAddressWord> searchWords;
                ++this.m_currentSearchCase;
                if (parsed.getField(FieldType.AREA_NAME_1_FIELD_TYPE) != null && this.findAreaTermsML(dataManager, parsed, 1.0, options, this.AREA_NAME_1_SAC_FIELDS) && (searchWords = this.searchWords(dataManager, areaNames = (AddressWord[])parsed.getField(FieldType.AREA_NAME_1_FIELD_TYPE), FieldType.AREA_NAME_1_FIELD_TYPE, 1.0, options)) != null) {
                    DictSearchResult dsr = new DictSearchResult();
                    dsr.m_dictWords = searchWords;
                    this.addSearchFieldResult(FieldType.AREA_NAME_1_FIELD_TYPE, dsr);
                    this.m_areaSacIntersectionFieldList = null;
                    this.filterAreaSacForAN1 = true;
                    return true;
                }
            }
            case 7: {
                AddressWord[] areaNames;
                List<DictionaryAddressWord> searchWords;
                ++this.m_currentSearchCase;
                if (parsed.getField(FieldType.AREA_NAME_1_FIELD_TYPE) == null || !this.findAreaTermsML(dataManager, parsed, 0.85, options, this.AREA_NAME_1_SAC_FIELDS) || (searchWords = this.searchWords(dataManager, areaNames = (AddressWord[])parsed.getField(FieldType.AREA_NAME_1_FIELD_TYPE), FieldType.AREA_NAME_1_FIELD_TYPE, 0.85, options)) == null) break;
                DictSearchResult dsr = new DictSearchResult();
                dsr.m_dictWords = searchWords;
                this.addSearchFieldResult(FieldType.AREA_NAME_1_FIELD_TYPE, dsr);
                this.m_areaSacIntersectionFieldList = null;
                this.filterAreaSacForAN1 = true;
                return true;
            }
        }
        this.m_bKeepTrying = false;
        return false;
    }

    private AddressWord[] getAddressWordsForFields(ParsedAddress parsed, FieldType ... types) {
        ArrayList<AddressWord> words = new ArrayList<AddressWord>();
        for (FieldType type : types) {
            AddressWord[] temp = (AddressWord[])parsed.getField(type);
            if (temp == null) continue;
            for (AddressWord w : temp) {
                words.add(new AddressWord(w));
            }
        }
        return words.toArray(new AddressWord[words.size()]);
    }

    private List<DictionaryAddressWord> searchWords(IDataManager dataManager, AddressWord[] words, FieldType type, double quality, GeocodeOptions options) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        ArrayList<DictionaryAddressWord> searchableWordList = new ArrayList<DictionaryAddressWord>();
        for (AddressWord word : words) {
            List<DictionaryAddressWord> subList = dataManager.findMatchingWords(this.getGeocodeType(), word, type, quality, options);
            if (subList == null) continue;
            for (DictionaryAddressWord foundWord : subList) {
                foundWord.getAddressWord().m_wordType = type;
            }
            searchableWordList.addAll(subList);
        }
        if (searchableWordList.isEmpty()) {
            return null;
        }
        return searchableWordList;
    }

    private void addSacSearchFieldResult(FieldType type, DictSearchResult result) {
        if (this.m_sacFieldResults == null) {
            this.m_sacFieldResults = new HashMap<FieldType, DictSearchResult>(10);
        }
        this.m_sacFieldResults.put(type, result);
    }

    private DictSearchResult getSacSearchFieldResult(FieldType type) {
        if (this.m_sacFieldResults != null) {
            return this.m_sacFieldResults.get(type);
        }
        return null;
    }

    private void addSearchFieldResult(FieldType type, DictSearchResult result) {
        if (this.m_searchFieldResults == null) {
            this.m_searchFieldResults = new HashMap<FieldType, DictSearchResult>(10);
        }
        this.m_searchFieldResults.put(type, result);
    }

    private DictSearchResult getSearchFieldResult(FieldType type) {
        if (this.m_searchFieldResults != null) {
            return this.m_searchFieldResults.get(type);
        }
        return null;
    }

    private class DictSearchResult {
        boolean m_chomeTranferableToBlock;
        boolean m_streetIdentifierFound;
        String m_searchedWord = null;
        char[] m_skippedSearchWord = null;
        AddressWord m_searchedAddressWord = null;
        char[] m_partialSearchWord = null;
        List<DictionaryAreaTermItem> m_areaList = null;
        List<DictionaryAddressWord> m_dictWords = null;
        FieldType m_type;

        DictSearchResult() {
        }

        DictSearchResult(List<DictionaryAreaTermItem> areaList, FieldType type, String searchedWord, AddressWord searchedAddressWord) {
            this.m_areaList = areaList;
            this.m_type = type;
            this.m_searchedWord = searchedWord;
            this.m_searchedAddressWord = searchedAddressWord;
            this.m_chomeTranferableToBlock = true;
            this.m_streetIdentifierFound = false;
        }

        DictSearchResult(DictSearchResult copy) {
            this.m_searchedWord = copy.m_searchedWord;
            this.m_partialSearchWord = copy.m_partialSearchWord;
            this.m_skippedSearchWord = copy.m_skippedSearchWord;
            this.m_searchedAddressWord = copy.m_searchedAddressWord;
            if (copy.m_areaList != null) {
                this.m_areaList = new ArrayList<DictionaryAreaTermItem>(copy.m_areaList);
            }
            if (copy.m_dictWords != null) {
                this.m_dictWords = new ArrayList<DictionaryAddressWord>(copy.m_dictWords);
            }
            this.m_type = copy.m_type;
            this.m_chomeTranferableToBlock = copy.m_chomeTranferableToBlock;
            this.m_streetIdentifierFound = copy.m_streetIdentifierFound;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Searched word=");
            sb.append(this.m_searchedWord == null ? "" : this.m_searchedWord);
            sb.append(", Searched Address Word=");
            sb.append(this.m_searchedAddressWord == null ? "" : this.m_searchedAddressWord.getWord());
            sb.append(", Skipped word=");
            sb.append(this.m_skippedSearchWord == null ? "" : new String(this.m_skippedSearchWord));
            sb.append(", Partial word=");
            sb.append(this.m_partialSearchWord == null ? "" : new String(this.m_partialSearchWord));
            return sb.toString();
        }

        private int getSearchLength() {
            if (this.m_searchedWord != null) {
                return this.m_searchedWord.length();
            }
            if (this.m_skippedSearchWord != null) {
                return this.m_skippedSearchWord.length;
            }
            return 0;
        }
    }
}

