/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.JPN.helper;

import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InputAddress;
import com.mapinfo.mapmarker.cgge.address.InternalFieldValue;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.dp.DataFetchException;
import com.mapinfo.mapmarker.cgge.dp.DataNotInitialisedException;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAddressWord;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAreaTermItem;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.cgge.dp.InternalCandidateList;
import com.mapinfo.mapmarker.cgge.helper.CGGEStreetGeocodingHelper;
import com.mapinfo.mapmarker.cgge.parser.ICGGEParser;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JPNLatinStreetGeocodingHelper
extends CGGEStreetGeocodingHelper {
    private boolean m_bSingleLine = false;
    private ParsedAddress m_savedParsedAddress;
    private GeocodeOptions m_savedOptions;
    private int m_currentCase = 0;
    private Map<FieldType, DictSearchResult> m_searchFieldResults = null;
    private boolean m_bKeepTrying = true;
    private InternalCandidateList internalCandidateList = null;

    @Override
    public InternalCandidateList searchNextCase(IDataManager dataManager, ParsedAddress parsedAddr, GeocodeOptions options, InternalCandidateList candidateList) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        ICGGEParser parser;
        String singleLineInputString;
        MMUtils.adjustDictionarySearchOrderForLanguage(parsedAddr.getLanguage(), options, dataManager, options.getGeocodeType());
        options.getGeocodeConstraints().setMustMatchAddressNumber(false);
        if (!parsedAddr.isSeperatePostAddressFields()) {
            if (candidateList.getNumberOfCloseMatches() > 0) {
                this.m_bKeepTrying = false;
                return null;
            }
            this.m_bSingleLine = true;
            return this.generateCandidatesForSingleLine(dataManager, parsedAddr, options, candidateList);
        }
        this.internalCandidateList = super.searchNextCase(dataManager, parsedAddr, options, candidateList);
        if (this.internalCandidateList != null) {
            return this.internalCandidateList;
        }
        if (this.m_areaSubTryCount == 27 && this.internalCandidateList == null && !StringUtilities.isEmpty((String)(singleLineInputString = (parser = this.getHelperParser()).reconstructFieldValue((AddressWord[])parsedAddr.getField(FieldType.GENERIC_FIELD_4_FIELD_TYPE))))) {
            InputAddress inputAddress = new InputAddress();
            inputAddress.setField(FieldType.STREET_NAME_FIELD_TYPE, singleLineInputString);
            inputAddress.setField(FieldType.COUNTRY_FIELD_TYPE, parsedAddr.getCountry());
            ParsedAddress[] parsedaddressArray = parser.parse(inputAddress, null);
            parsedAddr.copy(parsedaddressArray[0]);
            if (this.m_savedAreaSearchComboList != null && this.m_searchedSacMap != null) {
                this.m_savedAreaSearchComboList.clear();
                this.m_searchedSacMap.clear();
            }
            options.clear();
            return this.searchNextCase(dataManager, parsedAddr, options, candidateList);
        }
        return this.internalCandidateList;
    }

    @Override
    public boolean hasMoreTries() {
        if (this.m_bSingleLine) {
            return this.m_bKeepTrying;
        }
        return super.hasMoreTries();
    }

    private InternalCandidateList generateCandidatesForSingleLine(IDataManager dataManager, ParsedAddress parsed, GeocodeOptions options, InternalCandidateList currentCandList) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        if (parsed.getField(FieldType.STREET_NAME_FIELD_TYPE) == null) {
            this.m_bKeepTrying = false;
            return null;
        }
        if (this.getSavedParsedAddress() == null) {
            ParsedAddress savedParsedAddress = new ParsedAddress(parsed.getCountry(), parsed.getLanguage());
            savedParsedAddress.copy(parsed);
            this.setSavedParsedAddress(savedParsedAddress);
        }
        InternalCandidateList cands = null;
        while (this.nextAreaNameCase(dataManager, parsed, options, currentCandList)) {
            List<DictionaryAreaTermItem> searchAreaList = this.getAreaListForCandSearch();
            if (searchAreaList == null) continue;
            if (this.m_savedOptions == null) {
                this.m_savedOptions = new GeocodeOptions(options);
            } else {
                options = new GeocodeOptions(this.m_savedOptions);
            }
            AddressWord searchWord = ((AddressWord[])parsed.getField(FieldType.STREET_NAME_FIELD_TYPE))[0];
            List<DictionaryAddressWord> searchableWordList = dataManager.findMatchingWords(this.getGeocodeType(), searchWord, FieldType.STREET_NAME_FIELD_TYPE, 1.0, options);
            if (searchableWordList != null) {
                for (DictionaryAddressWord word : searchableWordList) {
                    word.getAddressWord().m_wordType = FieldType.STREET_NAME_FIELD_TYPE;
                }
                cands = this.retrieveCandidates(dataManager, parsed, searchAreaList, searchableWordList, options);
                if (cands == null || cands.getCandidateCount() <= 0) continue;
                this.setCandidatePlaceName(cands, parsed);
                return cands;
            }
            this.m_bKeepTrying = false;
            return null;
        }
        return cands;
    }

    private void setCandidatePlaceName(InternalCandidateList cands, ParsedAddress parsed) {
        AddressWord[] placeField = (AddressWord[])parsed.getField(FieldType.PLACE_NAME_FIELD_TYPE);
        if (placeField != null && placeField.length > 0) {
            InternalFieldValue fv = new InternalFieldValue(placeField);
            for (InternalScoringAddress addr : cands.getCandidateList()) {
                addr.setField(FieldType.PLACE_NAME_FIELD_TYPE, fv);
            }
        }
    }

    private boolean nextAreaNameCase(IDataManager dataManager, ParsedAddress parsed, GeocodeOptions options, InternalCandidateList currentCandList) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        this.m_areaSacIntersectionFieldList = null;
        switch (this.m_currentCase) {
            case 0: {
                List<DictionaryAreaTermItem> pcList;
                ++this.m_currentCase;
                AddressWord[] pcWords = (AddressWord[])parsed.getField(FieldType.POST_CODE_FIELD_TYPE);
                if (pcWords != null && pcWords.length != 0 && (pcList = dataManager.findAreaTerms(this.getGeocodeType(), pcWords, FieldType.POST_CODE_FIELD_TYPE, 1.0, options)) != null && pcList.size() > 0) {
                    DictSearchResult pcRes = new DictSearchResult();
                    pcRes.m_areaList = pcList;
                    this.addSearchFieldResult(FieldType.POST_CODE_FIELD_TYPE, pcRes);
                    return true;
                }
            }
            case 1: {
                ++this.m_currentCase;
                if (this.findAreaTerms(dataManager, (AddressWord[])parsed.getField(FieldType.POST_ADDRESS_FIELD_TYPE), 1.0, options, false, new FieldType[]{FieldType.AREA_NAME_2_FIELD_TYPE, FieldType.AREA_NAME_3_FIELD_TYPE})) {
                    return true;
                }
            }
            case 2: {
                ++this.m_currentCase;
                if (this.findAreaTerms(dataManager, (AddressWord[])parsed.getField(FieldType.POST_ADDRESS_FIELD_TYPE), 0.85, options, false, new FieldType[]{FieldType.AREA_NAME_2_FIELD_TYPE, FieldType.AREA_NAME_3_FIELD_TYPE})) {
                    return true;
                }
            }
            case 3: {
                List<DictionaryAreaTermItem> pcList;
                ++this.m_currentCase;
                AddressWord[] pcWords = (AddressWord[])parsed.getField(FieldType.POST_CODE_FIELD_TYPE);
                if (pcWords != null && pcWords.length != 0 && (pcList = dataManager.findAreaTerms(this.getGeocodeType(), pcWords, FieldType.POST_CODE_FIELD_TYPE, 0.85, options)) != null && pcList.size() > 0) {
                    DictSearchResult pcRes = new DictSearchResult();
                    pcRes.m_areaList = pcList;
                    this.addSearchFieldResult(FieldType.POST_CODE_FIELD_TYPE, pcRes);
                    return true;
                }
            }
            case 4: {
                ++this.m_currentCase;
                if (!this.findAreaTerms(dataManager, (AddressWord[])parsed.getField(FieldType.POST_ADDRESS_FIELD_TYPE), 1.0, options, false, new FieldType[]{FieldType.AREA_NAME_3_FIELD_TYPE})) break;
                return true;
            }
        }
        this.m_bKeepTrying = false;
        return false;
    }

    private boolean findAreaTerms(IDataManager dataManager, AddressWord[] postAddressWords, double quality, GeocodeOptions options, boolean bIncludeNumerics, FieldType[] feildTypeArray) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        boolean bValid = false;
        if (postAddressWords != null && postAddressWords.length > 0) {
            if (!bIncludeNumerics) {
                ArrayList<AddressWord> limitedWords = new ArrayList<AddressWord>();
                AddressWord[] addressWordArray = postAddressWords;
                int n = addressWordArray.length;
                for (int i = 0; i < n; ++i) {
                    AddressWord word = addressWordArray[i];
                    if (word.isNumeral()) continue;
                    limitedWords.add(word);
                }
                postAddressWords = limitedWords.toArray(new AddressWord[limitedWords.size()]);
            }
            for (FieldType type : feildTypeArray) {
                List<DictionaryAreaTermItem> areaList = dataManager.findAreaTerms(this.getGeocodeType(), postAddressWords, type, quality, options);
                if (areaList == null || areaList.size() <= 0) continue;
                bValid = true;
                DictSearchResult pcRes = new DictSearchResult();
                pcRes.m_areaList = areaList;
                this.addSearchFieldResult(type, pcRes);
                if (this.m_areaSacIntersectionFieldList == null) {
                    this.m_areaSacIntersectionFieldList = new ArrayList();
                }
                this.m_areaSacIntersectionFieldList.add(type);
            }
            if (this.m_areaSacIntersectionFieldList != null && this.m_areaSacIntersectionFieldList.size() <= 1) {
                this.m_areaSacIntersectionFieldList = null;
            }
        }
        return bValid;
    }

    protected List<DictionaryAreaTermItem> getAreaListForCandSearch() {
        ArrayList<DictionaryAreaTermItem> areaList = new ArrayList<DictionaryAreaTermItem>(10);
        if (this.m_searchFieldResults != null) {
            Iterator<Map.Entry<FieldType, DictSearchResult>> it = this.m_searchFieldResults.entrySet().iterator();
            while (it.hasNext()) {
                DictSearchResult dsr = it.next().getValue();
                if (dsr == null || dsr.m_areaList == null) continue;
                areaList.addAll(dsr.m_areaList);
            }
        }
        return areaList;
    }

    private void setSavedParsedAddress(ParsedAddress parsed) {
        this.m_savedParsedAddress = parsed;
    }

    private ParsedAddress getSavedParsedAddress() {
        return this.m_savedParsedAddress;
    }

    private void addSearchFieldResult(FieldType type, DictSearchResult result) {
        if (this.m_searchFieldResults == null) {
            this.m_searchFieldResults = new HashMap<FieldType, DictSearchResult>(10);
        }
        this.m_searchFieldResults.put(type, result);
    }

    private DictSearchResult getSearchFieldResult(FieldType type) {
        if (this.m_searchFieldResults != null) {
            return this.m_searchFieldResults.get(type);
        }
        return null;
    }

    private class DictSearchResult {
        boolean m_chomeTranferableToBlock;
        boolean m_streetIdentifierFound;
        String m_searchedWord = null;
        char[] m_skippedSearchWord = null;
        AddressWord m_searchedAddressWord = null;
        char[] m_partialSearchWord = null;
        List<DictionaryAreaTermItem> m_areaList = null;
        List<DictionaryAddressWord> m_dictWords = null;
        FieldType m_type;

        DictSearchResult() {
        }

        DictSearchResult(List<DictionaryAreaTermItem> areaList, FieldType type, String searchedWord, AddressWord searchedAddressWord) {
            this.m_areaList = areaList;
            this.m_type = type;
            this.m_searchedWord = searchedWord;
            this.m_searchedAddressWord = searchedAddressWord;
            this.m_chomeTranferableToBlock = true;
            this.m_streetIdentifierFound = false;
        }

        DictSearchResult(DictSearchResult copy) {
            this.m_searchedWord = copy.m_searchedWord;
            this.m_partialSearchWord = copy.m_partialSearchWord;
            this.m_skippedSearchWord = copy.m_skippedSearchWord;
            this.m_searchedAddressWord = copy.m_searchedAddressWord;
            if (copy.m_areaList != null) {
                this.m_areaList = new ArrayList<DictionaryAreaTermItem>(copy.m_areaList);
            }
            if (copy.m_dictWords != null) {
                this.m_dictWords = new ArrayList<DictionaryAddressWord>(copy.m_dictWords);
            }
            this.m_type = copy.m_type;
            this.m_chomeTranferableToBlock = copy.m_chomeTranferableToBlock;
            this.m_streetIdentifierFound = copy.m_streetIdentifierFound;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Searched word=");
            sb.append(this.m_searchedWord == null ? "" : this.m_searchedWord);
            sb.append(", Searched Address Word=");
            sb.append(this.m_searchedAddressWord == null ? "" : this.m_searchedAddressWord.getWord());
            sb.append(", Skipped word=");
            sb.append(this.m_skippedSearchWord == null ? "" : new String(this.m_skippedSearchWord));
            sb.append(", Partial word=");
            sb.append(this.m_partialSearchWord == null ? "" : new String(this.m_partialSearchWord));
            return sb.toString();
        }

        private int getSearchLength() {
            if (this.m_searchedWord != null) {
                return this.m_searchedWord.length();
            }
            if (this.m_skippedSearchWord != null) {
                return this.m_skippedSearchWord.length;
            }
            return 0;
        }
    }
}

