/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.JPN.parser;

import com.mapinfo.mapmarker.JPN.parser.JPNParserTerms;
import com.mapinfo.mapmarker.cgge.address.AddressNumber;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InputAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.parser.CGGEParser1;
import com.mapinfo.mapmarker.cgge.scorer.ICGGEScorer;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JPN_LatinParser
extends CGGEParser1 {
    private static final Pattern m_chomeBlockLot_Pattern = Pattern.compile("(.*?)\\s*\\b(\\d+)+\\b\\s*[-,\\s]{1}\\s*\\b(\\d+)+\\b\\s*[-,\\s]{1}\\s*\\b(\\d+)+\\b(.*?)$", 2);
    private static final Pattern m_chomeBlockLotNoAnchor_Pattern;
    private static final Pattern m_latinRecommended_Pattern;
    private static final Pattern m_blockLot_Pattern;
    private static final Pattern m_block_Pattern;
    private static final Pattern m_japaneseWithChome_Pattern;
    private static final Pattern m_japaneseWithChomeNoAnchor_Pattern;
    private static final Pattern m_japaneseNoChome_Pattern;
    private static final Pattern m_sapporoStd_Pattern;
    private static final Pattern m_sapporoCommonNonNumericChome_Pattern;
    private static final Pattern m_sapporoCommonNonNumericTest_Pattern;
    private static final Pattern m_sapporoSecond_Pattern;
    private static final Pattern m_sapporoChomeBlockLot_Pattern;
    private static final Pattern m_latinWithChomeAndAN3NoAnchor_Pattern;
    private static final Pattern m_sapporoTest_Pattern;
    private static final Pattern m_sapporoTestSecond_Pattern;
    private static final Pattern m_sapporoTestStd_Pattern;
    private static final Pattern m_postalAtEnd_Pattern;
    private static final Pattern m_postalAtBeginning_Pattern;
    private static final Pattern m_japanAtEnd_Pattern;
    private static final Pattern m_japanAtBeginning_Pattern;
    private static final Pattern m_PostalSignAtBeginning_Pattern;
    private static final Pattern m_chomeBlockOrLotLocation_Pattern;
    private static final Pattern m_PrefectureAtEnd_Pattern;
    private static final Pattern m_looksLikeAN_Pattern;

    @Override
    protected void initializeParserTerms() {
        this.m_parserTerms = new JPNParserTerms();
        this.m_parserTerms.setDataSetInfo(this.getDataSetInfo());
        this.m_parserTerms.init(this.getCountry(), this.getLanguage());
    }

    @Override
    public ParsedAddress[] parse(InputAddress inputAddress, ICGGEScorer scorer) {
        ParsedAddress[] pAddrArray = new ParsedAddress[]{new ParsedAddress(this.getCountry(), this.getLanguage())};
        pAddrArray[0].setField(FieldType.COUNTRY_FIELD_TYPE, this.getAddressWords((String)inputAddress.getField(FieldType.COUNTRY_FIELD_TYPE)));
        InputAddress cleanInputAddress = this.getCleanedInputAddress(inputAddress);
        if (this.isLatinInput(cleanInputAddress)) {
            pAddrArray[0].setInputAddress(cleanInputAddress);
            boolean bIsMultiline = this.isMultiLineInput(cleanInputAddress, pAddrArray[0]);
            int inputType = this.findInputType(cleanInputAddress, pAddrArray[0], bIsMultiline);
            this.parseInputAddress(inputType, cleanInputAddress, pAddrArray[0]);
        }
        return pAddrArray;
    }

    private boolean isMultiLineInput(InputAddress input, ParsedAddress parsed) {
        boolean isMultilineInput = false;
        String areaName1 = (String)input.getField(FieldType.AREA_NAME_1_FIELD_TYPE);
        String areaName2 = (String)input.getField(FieldType.AREA_NAME_2_FIELD_TYPE);
        String areaName3 = (String)input.getField(FieldType.AREA_NAME_3_FIELD_TYPE);
        String areaName4 = (String)input.getField(FieldType.AREA_NAME_4_FIELD_TYPE);
        String postCode = (String)input.getField(FieldType.POST_CODE_FIELD_TYPE);
        String postAddress = (String)input.getField(FieldType.POST_ADDRESS_FIELD_TYPE);
        if (postAddress != null) {
            parsed.setFlagSeparatePostAddressFields();
        }
        if (areaName1 != null || areaName2 != null || areaName3 != null || areaName4 != null || postCode != null) {
            parsed.setFlagSeperateAreaFields();
            return true;
        }
        return isMultilineInput;
    }

    private void adjustAN3WWords(String ANString, ParsedAddress parsed) {
        int pos2;
        if (ANString == null || !ANString.contains("MACHI")) {
            parsed.setField(FieldType.AREA_NAME_3_FIELD_TYPE, this.getAddressWords(ANString));
            return;
        }
        int pos1 = ANString.indexOf("MACHI");
        int pos2start = pos2 = pos1 - 1;
        while (pos2 > 0 && (ANString.charAt(pos2) == ' ' || ANString.charAt(pos2) == '-')) {
            --pos2;
        }
        if (pos2 != pos2start) {
            while (pos2 > 0 && ANString.charAt(pos2) != ' ' && ANString.charAt(pos2) != ',') {
                --pos2;
            }
            if (pos2 >= 0) {
                int endpos = pos1 + 5;
                String str = ANString.substring(pos2, endpos);
                String newstr = str.replaceAll("-\\s*MACH[I]+", "MACHI");
                if (newstr.equals(str)) {
                    newstr = str.replaceAll("\\s+MACH[I]+", "MACHI");
                }
                StringBuilder sb1 = new StringBuilder(ANString + " " + newstr);
                parsed.setField(FieldType.AREA_NAME_3_FIELD_TYPE, this.getAddressWords(sb1.toString()));
                return;
            }
        }
        parsed.setField(FieldType.AREA_NAME_3_FIELD_TYPE, this.getAddressWords(ANString));
    }

    protected void setParsedAddressForMultiline(InputAddress input, ParsedAddress parsed) {
        String hnr = (String)input.getField(FieldType.ADDRESS_NUMBER_FIELD_TYPE);
        AddressNumber hnrNumber = this.parserAddressNumber(hnr);
        parsed.setAddressNumber(hnrNumber);
        parsed.setFlagSeparatePostAddressFields();
        parsed.setField(FieldType.AREA_NAME_1_FIELD_TYPE, this.getAddressWords((String)input.getField(FieldType.AREA_NAME_1_FIELD_TYPE)));
        parsed.setField(FieldType.AREA_NAME_2_FIELD_TYPE, this.getAddressWords((String)input.getField(FieldType.AREA_NAME_2_FIELD_TYPE)));
        this.adjustAN3WWords((String)input.getField(FieldType.AREA_NAME_3_FIELD_TYPE), parsed);
        parsed.setField(FieldType.AREA_NAME_4_FIELD_TYPE, this.getAddressWords((String)input.getField(FieldType.AREA_NAME_4_FIELD_TYPE)));
        parsed.setField(FieldType.POST_CODE_FIELD_TYPE, this.getAddressWords(this.removeHyphen((String)input.getField(FieldType.POST_CODE_FIELD_TYPE))));
        if (input.getField(FieldType.STREET_NAME_FIELD_TYPE) != null) {
            parsed.setField(FieldType.STREET_NAME_FIELD_TYPE, this.getAddressWords("0"));
            boolean keepTrying = this.findChomeBlockLot_Sapporo((String)input.getField(FieldType.STREET_NAME_FIELD_TYPE), parsed);
            if (keepTrying) {
                keepTrying = this.findChomeBlockLot((String)input.getField(FieldType.STREET_NAME_FIELD_TYPE), parsed);
            }
            if (!keepTrying) {
                AddressWord[] genField1 = (AddressWord[])parsed.getField(FieldType.GENERIC_FIELD_1_FIELD_TYPE);
                AddressWord[] genField2 = (AddressWord[])parsed.getField(FieldType.GENERIC_FIELD_2_FIELD_TYPE);
                AddressWord[] An3 = (AddressWord[])parsed.getField(FieldType.AREA_NAME_3_FIELD_TYPE);
                String strGenField1 = this.convertToString(genField1);
                String strGenField2 = this.convertToString(genField2);
                String strAN3 = this.convertToString(An3);
                Matcher gf1 = m_looksLikeAN_Pattern.matcher(strGenField1);
                Matcher gf2 = m_looksLikeAN_Pattern.matcher(strGenField2);
                boolean genField1IsAN = false;
                boolean genField2IsAN = false;
                if (gf1.find()) {
                    genField1IsAN = true;
                }
                if (gf2.find()) {
                    genField2IsAN = true;
                }
                if (genField1IsAN && genField2IsAN) {
                    String str = strAN3 + " " + strGenField2;
                    this.adjustAN3WWords(str, parsed);
                    if (parsed.getField(FieldType.PLACE_NAME_FIELD_TYPE) == null) {
                        parsed.setField(FieldType.PLACE_NAME_FIELD_TYPE, parsed.getField(FieldType.GENERIC_FIELD_1_FIELD_TYPE));
                    }
                } else if (genField1IsAN) {
                    String str = strAN3 + " " + strGenField1;
                    this.adjustAN3WWords(str, parsed);
                    if (parsed.getField(FieldType.PLACE_NAME_FIELD_TYPE) == null) {
                        parsed.setField(FieldType.PLACE_NAME_FIELD_TYPE, parsed.getField(FieldType.GENERIC_FIELD_2_FIELD_TYPE));
                    }
                } else if (strGenField2.trim().length() > 0) {
                    String str = strAN3 + " " + strGenField2;
                    this.adjustAN3WWords(str, parsed);
                    if (parsed.getField(FieldType.PLACE_NAME_FIELD_TYPE) == null) {
                        parsed.setField(FieldType.PLACE_NAME_FIELD_TYPE, parsed.getField(FieldType.GENERIC_FIELD_1_FIELD_TYPE));
                    }
                } else if (strGenField1.trim().length() > 0) {
                    String str = strAN3 + " " + strGenField1;
                    parsed.setField(FieldType.AREA_NAME_3_FIELD_TYPE, this.getAddressWords(str));
                }
            }
        }
        parsed.setField(FieldType.POST_ADDRESS_FIELD_TYPE, this.getAddressWords((String)input.getField(FieldType.POST_ADDRESS_FIELD_TYPE)));
        parsed.setField(FieldType.GENERIC_FIELD_1_FIELD_TYPE, null);
        parsed.setField(FieldType.GENERIC_FIELD_2_FIELD_TYPE, null);
        this.makeMultilineToSingleLineInput(input, parsed);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    AddressType findAddressStyle(String inputAddr) {
        if (inputAddr == null) return AddressType.UNKNOWN;
        boolean isJapanese = false;
        boolean isEnglish = false;
        Matcher m = m_postalAtEnd_Pattern.matcher(inputAddr);
        if (m.find()) {
            isEnglish = true;
        }
        if ((m = m_postalAtBeginning_Pattern.matcher(inputAddr)).find()) {
            isJapanese = true;
        }
        if (isEnglish) {
            if (!isJapanese) return AddressType.ENGLISH;
            isJapanese = false;
            isEnglish = false;
        } else if (isJapanese) {
            return AddressType.JAPANESE;
        }
        m = m_japanAtBeginning_Pattern.matcher(inputAddr);
        if (m.find()) {
            return AddressType.JAPANESE;
        }
        m = m_japanAtEnd_Pattern.matcher(inputAddr);
        if (m.find()) {
            return AddressType.ENGLISH;
        }
        m = m_PostalSignAtBeginning_Pattern.matcher(inputAddr);
        if (m.find()) {
            return AddressType.JAPANESE;
        }
        m = m_PrefectureAtEnd_Pattern.matcher(inputAddr);
        if (m.find()) {
            return AddressType.ENGLISH;
        }
        m = m_chomeBlockOrLotLocation_Pattern.matcher(inputAddr);
        int start = 0;
        int end = 0;
        int i = 0;
        while (m.find()) {
            if (i == 0) {
                start = m.start(1);
            } else {
                end = m.end(1);
            }
            ++i;
        }
        if (end == 0) {
            end = start;
        }
        double inputLength = inputAddr.length();
        double firstNumberFoundAsPercOfString = (double)start / inputLength;
        double lastNumberFoundAsPercOfString = (double)end / inputLength;
        if (firstNumberFoundAsPercOfString < 0.1 && lastNumberFoundAsPercOfString < 0.75) {
            return AddressType.ENGLISH;
        }
        if (firstNumberFoundAsPercOfString > 0.25 && lastNumberFoundAsPercOfString > 0.9) {
            isJapanese = true;
        }
        if (isEnglish) {
            if (isJapanese) return AddressType.UNKNOWN;
            return AddressType.ENGLISH;
        }
        if (!isJapanese) return AddressType.UNKNOWN;
        return AddressType.JAPANESE;
    }

    private boolean findChomeBlockLot(String streetName, ParsedAddress parsed) {
        boolean keepTrying = true;
        if (streetName != null) {
            AddressNumber hnrNumber;
            Matcher m = m_chomeBlockLot_Pattern.matcher(streetName);
            if (m.find() && m.groupCount() == 5 && !m.group(1).matches("(?i).*(Chome|Choume|Come|Ch\u014dme).*") && !m.group(5).matches("(?i).*(Chome|Choume|Come|Ch\u014dme).*")) {
                keepTrying = false;
                parsed.setField(FieldType.AREA_NAME_4_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(2))));
                parsed.setField(FieldType.STREET_NAME_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(3))));
                hnrNumber = this.parserAddressNumber(this.trimString(m.group(4)));
                parsed.setAddressNumber(hnrNumber);
                parsed.setField(FieldType.GENERIC_FIELD_1_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(1))));
                parsed.setField(FieldType.GENERIC_FIELD_2_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(5))));
            }
            if (keepTrying && (m = m_latinRecommended_Pattern.matcher(streetName)).find() && m.groupCount() == 7 && m.group(4) != null && m.group(4).matches(".*[a-zA-Z]+.*") && !m.group(4).matches("(?i).*(Chome|Choume|Come|Ch\u014dme).*") && !m.group(1).matches("(?i).*(Chome|Choume|Come|Ch\u014dme).*")) {
                keepTrying = false;
                parsed.setField(FieldType.AREA_NAME_4_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(5))));
                parsed.setField(FieldType.STREET_NAME_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(2))));
                parsed.setField(FieldType.AREA_NAME_3_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(4))));
                hnrNumber = this.parserAddressNumber(this.trimString(m.group(3)));
                parsed.setAddressNumber(hnrNumber);
                parsed.setField(FieldType.GENERIC_FIELD_1_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(1))));
                parsed.setField(FieldType.PLACE_NAME_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(1))));
                parsed.setField(FieldType.GENERIC_FIELD_2_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(7))));
            }
            if (keepTrying && (m = m_japaneseWithChome_Pattern.matcher(streetName)).find() && m.groupCount() == 7) {
                keepTrying = false;
                parsed.setField(FieldType.AREA_NAME_4_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(2))));
                parsed.setField(FieldType.STREET_NAME_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(4))));
                if (m.group(5) != null) {
                    hnrNumber = this.parserAddressNumber(this.trimString(m.group(5)));
                    parsed.setAddressNumber(hnrNumber);
                }
                if (m.group(1) != null) {
                    parsed.setField(FieldType.GENERIC_FIELD_1_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(1))));
                }
                if (m.group(7) != null) {
                    parsed.setField(FieldType.GENERIC_FIELD_2_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(7))));
                    parsed.setField(FieldType.PLACE_NAME_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(7))));
                }
            }
            if (keepTrying && (m = m_chomeBlockLotNoAnchor_Pattern.matcher(streetName)).find() && m.groupCount() == 5) {
                keepTrying = false;
                parsed.setField(FieldType.GENERIC_FIELD_1_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(1))));
                parsed.setField(FieldType.PLACE_NAME_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(1))));
                parsed.setField(FieldType.AREA_NAME_4_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(2))));
                parsed.setField(FieldType.STREET_NAME_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(3))));
                hnrNumber = this.parserAddressNumber(this.trimString(m.group(4)));
                parsed.setAddressNumber(hnrNumber);
                parsed.setField(FieldType.GENERIC_FIELD_2_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(5))));
            }
            if (keepTrying && (m = m_japaneseWithChomeNoAnchor_Pattern.matcher(streetName)).find() && m.groupCount() == 8) {
                keepTrying = false;
                parsed.setField(FieldType.AREA_NAME_4_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(2))));
                parsed.setField(FieldType.AREA_NAME_3_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(4))));
                parsed.setField(FieldType.STREET_NAME_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(5))));
                if (m.group(6) != null) {
                    hnrNumber = this.parserAddressNumber(this.trimString(m.group(6)));
                    parsed.setAddressNumber(hnrNumber);
                }
                parsed.setField(FieldType.GENERIC_FIELD_1_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(1))));
                parsed.setField(FieldType.GENERIC_FIELD_2_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(8))));
            }
            if (keepTrying && (m = m_japaneseNoChome_Pattern.matcher(streetName)).find() && m.groupCount() == 7) {
                keepTrying = false;
                parsed.setField(FieldType.AREA_NAME_4_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(2))));
                parsed.setField(FieldType.AREA_NAME_3_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(4))));
                parsed.setField(FieldType.STREET_NAME_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(5))));
                parsed.setField(FieldType.GENERIC_FIELD_2_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(7))));
                parsed.setField(FieldType.PLACE_NAME_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(7))));
                if (m.group(6) != null) {
                    hnrNumber = this.parserAddressNumber(this.trimString(m.group(6)));
                    parsed.setAddressNumber(hnrNumber);
                }
            }
            if (keepTrying && (m = m_blockLot_Pattern.matcher(streetName)).find() && m.groupCount() == 4) {
                keepTrying = false;
                parsed.setField(FieldType.STREET_NAME_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(2))));
                hnrNumber = this.parserAddressNumber(this.trimString(m.group(3)));
                parsed.setAddressNumber(hnrNumber);
                parsed.setField(FieldType.GENERIC_FIELD_1_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(1))));
                parsed.setField(FieldType.GENERIC_FIELD_2_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(4))));
            }
            if (keepTrying && (m = m_block_Pattern.matcher(streetName)).find()) {
                int i = m.groupCount();
                String a = m.group(2);
                if (m.groupCount() == 3) {
                    keepTrying = false;
                    parsed.setField(FieldType.GENERIC_FIELD_1_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(1))));
                    parsed.setField(FieldType.STREET_NAME_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(2))));
                    parsed.setField(FieldType.GENERIC_FIELD_2_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(3))));
                }
            }
        }
        return keepTrying;
    }

    private boolean findChomeBlockLot_Sapporo(String streetName, ParsedAddress parsed) {
        boolean keepTrying = true;
        boolean chomeFound = false;
        boolean blockFound = false;
        boolean lotFound = false;
        Matcher m = null;
        if (streetName != null) {
            StringBuilder str;
            AddressNumber hnrNumber;
            m = m_sapporoTestStd_Pattern.matcher(streetName);
            if (m.find() && (m = m_sapporoStd_Pattern.matcher(streetName)).find() && m.groupCount() == 14 && m.group(5) != null) {
                keepTrying = false;
                parsed.setField(FieldType.AREA_NAME_3_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(5))));
                if (m.group(1) != null) {
                    parsed.setField(FieldType.GENERIC_FIELD_1_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(1))));
                    parsed.setField(FieldType.PLACE_NAME_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(1))));
                }
                if (m.group(14) != null) {
                    parsed.setField(FieldType.GENERIC_FIELD_2_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(14))));
                }
                if (m.group(9) != null) {
                    chomeFound = true;
                    parsed.setField(FieldType.AREA_NAME_4_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(9))));
                }
                if (m.group(2) != null) {
                    if (chomeFound) {
                        blockFound = true;
                        parsed.setField(FieldType.STREET_NAME_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(2))));
                    } else {
                        chomeFound = true;
                        parsed.setField(FieldType.AREA_NAME_4_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(2))));
                    }
                }
                if (m.group(3) != null) {
                    if (chomeFound && blockFound) {
                        lotFound = true;
                        hnrNumber = this.parserAddressNumber(this.trimString(m.group(3)));
                        parsed.setAddressNumber(hnrNumber);
                    } else {
                        blockFound = true;
                        parsed.setField(FieldType.STREET_NAME_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(3))));
                    }
                }
                if (m.group(4) != null && blockFound && !lotFound) {
                    lotFound = true;
                    hnrNumber = this.parserAddressNumber(this.trimString(m.group(4)));
                    parsed.setAddressNumber(hnrNumber);
                }
                if (!(chomeFound && blockFound && lotFound)) {
                    if (m.group(11) != null) {
                        if (!chomeFound) {
                            chomeFound = true;
                            parsed.setField(FieldType.AREA_NAME_4_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(11))));
                        } else if (!blockFound) {
                            blockFound = true;
                            parsed.setField(FieldType.STREET_NAME_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(11))));
                        } else {
                            lotFound = true;
                            hnrNumber = this.parserAddressNumber(this.trimString(m.group(11)));
                            parsed.setAddressNumber(hnrNumber);
                        }
                    }
                    if (m.group(12) != null) {
                        if (!blockFound) {
                            blockFound = true;
                            parsed.setField(FieldType.STREET_NAME_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(12))));
                        } else {
                            lotFound = true;
                            hnrNumber = this.parserAddressNumber(this.trimString(m.group(12)));
                            parsed.setAddressNumber(hnrNumber);
                        }
                    }
                    if (m.group(13) != null && !lotFound) {
                        lotFound = true;
                        hnrNumber = this.parserAddressNumber(this.trimString(m.group(13)));
                        parsed.setAddressNumber(hnrNumber);
                    }
                }
            }
            if (keepTrying && (m = m_sapporoTestSecond_Pattern.matcher(streetName)).find() && (m = m_sapporoSecond_Pattern.matcher(streetName)).find() && m.groupCount() == 14 && (m.group(10) != null || m.group(5) != null)) {
                AddressNumber hnrNumber2;
                keepTrying = false;
                str = new StringBuilder();
                str.append(m.group(10));
                str.append(m.group(5));
                parsed.setField(FieldType.AREA_NAME_3_FIELD_TYPE, this.getAddressWords(this.trimString(str.toString())));
                if (m.group(1) != null) {
                    parsed.setField(FieldType.GENERIC_FIELD_1_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(1))));
                    parsed.setField(FieldType.PLACE_NAME_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(1))));
                }
                if (m.group(14) != null) {
                    parsed.setField(FieldType.GENERIC_FIELD_2_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(14))));
                }
                if (m.group(9) != null && m.group(8) != null) {
                    chomeFound = true;
                    parsed.setField(FieldType.AREA_NAME_4_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(8))));
                } else {
                    if (m.group(6) != null) {
                        chomeFound = true;
                        parsed.setField(FieldType.AREA_NAME_4_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(6))));
                    }
                    if (m.group(7) != null && chomeFound) {
                        blockFound = true;
                        parsed.setField(FieldType.STREET_NAME_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(7))));
                    }
                    if (m.group(8) != null && blockFound && !lotFound) {
                        lotFound = true;
                        hnrNumber2 = this.parserAddressNumber(this.trimString(m.group(8)));
                        parsed.setAddressNumber(hnrNumber2);
                    }
                }
                if (m.group(2) != null) {
                    if (chomeFound) {
                        blockFound = true;
                        parsed.setField(FieldType.STREET_NAME_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(2))));
                    } else {
                        chomeFound = true;
                        parsed.setField(FieldType.AREA_NAME_4_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(2))));
                    }
                }
                if (m.group(3) != null) {
                    if (!chomeFound) {
                        chomeFound = true;
                        parsed.setField(FieldType.AREA_NAME_4_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(3))));
                    } else if (!blockFound) {
                        blockFound = true;
                        parsed.setField(FieldType.STREET_NAME_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(3))));
                    } else {
                        lotFound = true;
                        hnrNumber2 = this.parserAddressNumber(this.trimString(m.group(3)));
                        parsed.setAddressNumber(hnrNumber2);
                    }
                }
                if (m.group(4) != null) {
                    if (!chomeFound) {
                        chomeFound = true;
                        parsed.setField(FieldType.AREA_NAME_4_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(4))));
                    } else if (!blockFound) {
                        blockFound = true;
                        parsed.setField(FieldType.STREET_NAME_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(4))));
                    } else {
                        lotFound = true;
                        hnrNumber2 = this.parserAddressNumber(this.trimString(m.group(4)));
                        parsed.setAddressNumber(hnrNumber2);
                    }
                }
            }
            if (keepTrying && (m = m_sapporoCommonNonNumericTest_Pattern.matcher(streetName)).find() && (m = m_sapporoCommonNonNumericChome_Pattern.matcher(streetName)).find() && m.groupCount() == 6) {
                if (m.group(5) != null) {
                    keepTrying = false;
                    str = new StringBuilder();
                    str.append(m.group(4));
                    str.append(m.group(5));
                    parsed.setField(FieldType.AREA_NAME_4_FIELD_TYPE, this.getAddressWords(this.trimString(str.toString())));
                    chomeFound = true;
                }
                if (m.group(1) != null) {
                    parsed.setField(FieldType.GENERIC_FIELD_1_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(1))));
                    parsed.setField(FieldType.PLACE_NAME_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(1))));
                }
                if (m.group(2) != null) {
                    if (chomeFound) {
                        blockFound = true;
                        parsed.setField(FieldType.STREET_NAME_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(2))));
                    } else {
                        chomeFound = true;
                        parsed.setField(FieldType.AREA_NAME_4_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(2))));
                    }
                }
                if (m.group(3) != null) {
                    if (chomeFound && blockFound) {
                        lotFound = true;
                        hnrNumber = this.parserAddressNumber(this.trimString(m.group(3)));
                        parsed.setAddressNumber(hnrNumber);
                    } else {
                        blockFound = true;
                        parsed.setField(FieldType.STREET_NAME_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(3))));
                    }
                }
            }
            if (keepTrying && (m = m_sapporoChomeBlockLot_Pattern.matcher(streetName)).find() && m.groupCount() == 6) {
                if (m.group(5) != null && m.group(4) != null) {
                    keepTrying = false;
                    chomeFound = true;
                    parsed.setField(FieldType.AREA_NAME_4_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(4))));
                }
                if (m.group(1) != null) {
                    parsed.setField(FieldType.GENERIC_FIELD_1_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(1))));
                    parsed.setField(FieldType.PLACE_NAME_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(1))));
                }
                if (m.group(6) != null) {
                    parsed.setField(FieldType.GENERIC_FIELD_2_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(6))));
                }
                if (m.group(2) != null && chomeFound) {
                    blockFound = true;
                    parsed.setField(FieldType.STREET_NAME_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(2))));
                }
                if (m.group(3) != null) {
                    if (blockFound && !lotFound) {
                        lotFound = true;
                        hnrNumber = this.parserAddressNumber(this.trimString(m.group(3)));
                        parsed.setAddressNumber(hnrNumber);
                    } else if (!blockFound) {
                        blockFound = true;
                        parsed.setField(FieldType.STREET_NAME_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(2))));
                    }
                }
            }
            if (keepTrying && (m = m_latinWithChomeAndAN3NoAnchor_Pattern.matcher(streetName)).find() && m.groupCount() == 7) {
                if (m.group(5) != null && m.group(6) != null) {
                    keepTrying = false;
                    chomeFound = true;
                    parsed.setField(FieldType.AREA_NAME_4_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(5))));
                }
                if (m.group(1) != null) {
                    parsed.setField(FieldType.GENERIC_FIELD_1_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(1))));
                    parsed.setField(FieldType.PLACE_NAME_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(1))));
                }
                if (m.group(7) != null) {
                    parsed.setField(FieldType.GENERIC_FIELD_2_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(7))));
                }
                if (m.group(2) != null && chomeFound) {
                    blockFound = true;
                    parsed.setField(FieldType.STREET_NAME_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(2))));
                }
                if (m.group(3) != null) {
                    if (!blockFound) {
                        blockFound = true;
                        parsed.setField(FieldType.STREET_NAME_FIELD_TYPE, this.getAddressWords(this.trimString(m.group(2))));
                    } else if (!lotFound) {
                        lotFound = true;
                        hnrNumber = this.parserAddressNumber(this.trimString(m.group(3)));
                        parsed.setAddressNumber(hnrNumber);
                    }
                }
                if (m.group(4) != null) {
                    parsed.setField(FieldType.AREA_NAME_3_FIELD_TYPE, this.getAddressWords(m.group(4)));
                }
            }
        }
        return keepTrying;
    }

    private String trimString(String str) {
        if (str != null) {
            str = str.trim();
        }
        return str;
    }

    private String convertToString(AddressWord[] aw) {
        StringBuilder builder = new StringBuilder();
        if (aw != null) {
            for (int i = 0; i < aw.length; ++i) {
                builder.append(aw[i].getWord() + " ");
            }
        }
        return builder.toString();
    }

    private boolean isSingleLineInput(ParsedAddress parsed) {
        return !parsed.isSeparateAreaFields() && !parsed.isSeperatePostAddressFields() && parsed.getInputAddress().getField(FieldType.STREET_NAME_FIELD_TYPE) != null;
    }

    private int findInputType(InputAddress input, ParsedAddress parsed, boolean bIsMultiLine) {
        if (bIsMultiLine) {
            return 1;
        }
        if (this.isSingleLineInput(parsed)) {
            return 2;
        }
        if (this.isDoubleLine(parsed)) {
            return 3;
        }
        return 0;
    }

    private boolean isDoubleLine(ParsedAddress parsed) {
        return !parsed.isSeparateAreaFields() && parsed.isSeperatePostAddressFields();
    }

    private void parseInputAddress(int inputType, InputAddress input, ParsedAddress parsed) {
        if (inputType == 1) {
            this.setParsedAddressForMultiline(input, parsed);
        }
        if (inputType == 2) {
            this.setParsedAddressForSingle(input, parsed);
        }
        if (inputType == 3) {
            this.setParsedAddressForDoubleLine(input, parsed);
        }
    }

    protected void setParsedAddressForSingle(InputAddress input, ParsedAddress parsed) {
        String singleLineStreetAddress = (String)input.getField(FieldType.STREET_NAME_FIELD_TYPE);
        parsed.setField(FieldType.POST_ADDRESS_FIELD_TYPE, this.getAddressWords(singleLineStreetAddress));
        String updatedPostAddress = this.findPostcode(singleLineStreetAddress, parsed, input);
        String updatedInputAddress = this.UpdatedInputAdress(singleLineStreetAddress, input);
        boolean keepTrying = this.findChomeBlockLot_Sapporo(updatedInputAddress, parsed);
        if (keepTrying) {
            keepTrying = this.findChomeBlockLot(updatedInputAddress, parsed);
        }
        if (!keepTrying && this.getAddressWords((String)input.getField(FieldType.PLACE_NAME_FIELD_TYPE)) == null) {
            if (this.findAddressStyle(singleLineStreetAddress) == AddressType.JAPANESE) {
                parsed.setField(FieldType.PLACE_NAME_FIELD_TYPE, parsed.getField(FieldType.GENERIC_FIELD_2_FIELD_TYPE));
            } else {
                parsed.setField(FieldType.PLACE_NAME_FIELD_TYPE, parsed.getField(FieldType.GENERIC_FIELD_1_FIELD_TYPE));
            }
        }
        this.findPrefercture(singleLineStreetAddress, parsed);
        if (updatedPostAddress != null) {
            parsed.setField(FieldType.POST_ADDRESS_FIELD_TYPE, this.getAddressWords(updatedPostAddress));
        }
        parsed.setField(FieldType.GENERIC_FIELD_1_FIELD_TYPE, null);
        parsed.setField(FieldType.GENERIC_FIELD_2_FIELD_TYPE, null);
    }

    private void setParsedAddressForDoubleLine(InputAddress input, ParsedAddress parsed) {
        String inputAddress = (String)input.getField(FieldType.STREET_NAME_FIELD_TYPE);
        String postAddress = (String)input.getField(FieldType.POST_ADDRESS_FIELD_TYPE);
        boolean keepTrying = this.findChomeBlockLot_Sapporo(inputAddress, parsed);
        if (keepTrying) {
            keepTrying = this.findChomeBlockLot(inputAddress, parsed);
        }
        if (!keepTrying && parsed.getField(FieldType.PLACE_NAME_FIELD_TYPE) == null) {
            if (this.findAddressStyle(postAddress) == AddressType.JAPANESE) {
                parsed.setField(FieldType.PLACE_NAME_FIELD_TYPE, parsed.getField(FieldType.GENERIC_FIELD_2_FIELD_TYPE));
            } else {
                parsed.setField(FieldType.PLACE_NAME_FIELD_TYPE, parsed.getField(FieldType.GENERIC_FIELD_1_FIELD_TYPE));
            }
        }
        this.findPrefercture(postAddress, parsed);
        postAddress = this.findPostcode(postAddress, parsed, input);
        input.setField(FieldType.GENERIC_FIELD_4_FIELD_TYPE, null);
        parsed.setField(FieldType.POST_ADDRESS_FIELD_TYPE, this.getAddressWords(postAddress));
        parsed.setField(FieldType.GENERIC_FIELD_1_FIELD_TYPE, null);
        parsed.setField(FieldType.GENERIC_FIELD_2_FIELD_TYPE, null);
    }

    private void findPrefercture(String inputAddress, ParsedAddress parsed) {
        String prefecture = null;
        boolean flag = false;
        String[] arr = inputAddress.split(" ");
        for (int i = 0; i <= arr.length - 1; ++i) {
            String[] newArray = arr[i].split("-");
            for (int j = 0; j <= newArray.length - 1; ++j) {
                if (StringUtilities.isEmpty((String)newArray[j]) || !((JPNParserTerms)this.getParserTerms()).isPreferturedWord(newArray[j])) continue;
                String prefecturesuffix = newArray[j];
                prefecture = this.findAreaNamesBySuffixWithSpaces(prefecturesuffix, inputAddress);
                parsed.setField(FieldType.AREA_NAME_1_FIELD_TYPE, this.getAddressWords(prefecture));
                flag = true;
                break;
            }
            if (flag) break;
        }
    }

    private String findPostcode(String inputAddress, ParsedAddress parsed, InputAddress input) {
        String postCode = null;
        String[] arr = inputAddress.split(" ");
        int[] indexes = new int[2];
        for (int i = 0; i <= arr.length - 1; ++i) {
            String s = arr[i].toString();
            postCode = this.parsePostcode(s, indexes);
            if (postCode == null) {
                postCode = this.findPostCodeWithSpace(arr, i);
                postCode = this.parsePostcode(postCode, indexes);
            }
            if (postCode == null) continue;
            input.setField(FieldType.GENERIC_FIELD_4_FIELD_TYPE, postCode);
            String upDatedPostCode = this.removeHyphen(postCode);
            parsed.setField(FieldType.POST_CODE_FIELD_TYPE, this.getAddressWords(upDatedPostCode));
            StringBuilder builder = new StringBuilder();
            if (indexes[0] == 0 && indexes[1] == postCode.length()) {
                for (int j = 0; j < arr.length; ++j) {
                    if (j == i) continue;
                    builder.append(arr[j]);
                    builder.append(' ');
                }
            } else {
                for (int j = 0; j < arr.length; ++j) {
                    if (j != i) {
                        builder.append(arr[j]);
                        builder.append(' ');
                        continue;
                    }
                    if (indexes[0] == 0) {
                        builder.append(arr[j].substring(indexes[1]));
                        continue;
                    }
                    builder.append(inputAddress.substring(0, indexes[0]));
                    builder.append(inputAddress.substring(indexes[1]));
                    builder.append(' ');
                }
            }
            return builder.toString();
        }
        return inputAddress;
    }

    private String findAreaNamesBySuffixWithSpaces(String areaNameSuffix, String inputAddress) {
        int position = -1;
        String[] arr = inputAddress.split(" ");
        if (arr.length > -1) {
            for (int i = 0; i <= arr.length - 1; ++i) {
                if (!areaNameSuffix.equalsIgnoreCase(arr[i]) || ++position <= 0) continue;
                String areaName = arr[position - 1].toString();
                return areaName + " " + areaNameSuffix;
            }
        }
        return this.findAreaNamesBySuffixWithHyphen(areaNameSuffix, inputAddress);
    }

    private String findAreaNamesBySuffixWithHyphen(String areaNameSuffix, String inputAddress) {
        String[] arr = inputAddress.split(" ");
        for (int i = 0; i < arr.length; ++i) {
            String[] newArray = arr[i].split("-");
            for (int j = 0; j <= newArray.length - 1; ++j) {
                if (!areaNameSuffix.equalsIgnoreCase(newArray[j]) || j <= 0) continue;
                String areaName = newArray[j - 1].toString();
                return areaName + "-" + areaNameSuffix;
            }
        }
        return null;
    }

    private String removeHyphen(String postCode) {
        String properPostcode = null;
        if (postCode != null) {
            properPostcode = postCode.replaceAll("[\\s\\-()]", "");
        }
        return properPostcode;
    }

    private String findPostCodeWithSpace(String[] array, int i) {
        for (int a = 0; a <= array.length - 1; ++a) {
            if (a + 1 >= array.length || array[a + 1].toString().length() <= 0) continue;
            return this.concantPostCodeWithSpace(array[i].toString(), array[a + 1].toString());
        }
        return null;
    }

    private String concantPostCodeWithSpace(String firtPart, String secondPart) {
        if (MMUtils.isNumber(firtPart) && MMUtils.isNumber(secondPart)) {
            int firtsPartThreeDigits = firtPart.length();
            int secondPartFourDigits = secondPart.length();
            if (firtsPartThreeDigits == 3 && secondPartFourDigits == 4) {
                return firtPart.concat(secondPart);
            }
        }
        return null;
    }

    private String UpdatedInputAdress(String Address2, InputAddress input) {
        String original_Postcode = (String)input.getField(FieldType.GENERIC_FIELD_4_FIELD_TYPE);
        if (original_Postcode != null) {
            Address2 = Address2.replace(original_Postcode, "");
            input.setField(FieldType.GENERIC_FIELD_4_FIELD_TYPE, null);
        }
        return Address2;
    }

    private void makeMultilineToSingleLineInput(InputAddress input, ParsedAddress parsed) {
        StringBuilder multilineToSingleLineInput = new StringBuilder();
        ParsedAddress parsedObj = new ParsedAddress(this.getCountry(), this.getLanguage());
        parsedObj.setField(FieldType.COUNTRY_FIELD_TYPE, this.getAddressWords((String)input.getField(FieldType.COUNTRY_FIELD_TYPE)));
        if (input.getField(FieldType.STREET_NAME_FIELD_TYPE) != null) {
            multilineToSingleLineInput.append((String)input.getField(FieldType.STREET_NAME_FIELD_TYPE));
            multilineToSingleLineInput.append(" ");
            input.setField(FieldType.STREET_NAME_FIELD_TYPE, null);
        }
        if (input.getField(FieldType.AREA_NAME_3_FIELD_TYPE) != null) {
            multilineToSingleLineInput.append((String)input.getField(FieldType.AREA_NAME_3_FIELD_TYPE));
            multilineToSingleLineInput.append(" ");
            input.setField(FieldType.STREET_NAME_FIELD_TYPE, null);
        }
        if (input.getField(FieldType.POST_CODE_FIELD_TYPE) != null) {
            multilineToSingleLineInput.append((String)input.getField(FieldType.POST_CODE_FIELD_TYPE));
            multilineToSingleLineInput.append(" ");
            input.setField(FieldType.POST_CODE_FIELD_TYPE, null);
        }
        if (input.getField(FieldType.AREA_NAME_2_FIELD_TYPE) != null) {
            multilineToSingleLineInput.append((String)input.getField(FieldType.AREA_NAME_2_FIELD_TYPE));
            multilineToSingleLineInput.append(" ");
            input.setField(FieldType.AREA_NAME_2_FIELD_TYPE, null);
        }
        if (input.getField(FieldType.AREA_NAME_1_FIELD_TYPE) != null) {
            multilineToSingleLineInput.append((String)input.getField(FieldType.AREA_NAME_1_FIELD_TYPE));
            input.setField(FieldType.AREA_NAME_1_FIELD_TYPE, null);
        }
        input.setField(FieldType.STREET_NAME_FIELD_TYPE, multilineToSingleLineInput.toString());
        parsed.setField(FieldType.GENERIC_FIELD_4_FIELD_TYPE, this.getAddressWords(multilineToSingleLineInput.toString()));
    }

    private boolean containsKanji(String addstr) {
        for (int kj = 0; kj < addstr.length() - 1; ++kj) {
            if (Character.UnicodeBlock.of(addstr.charAt(kj)) != Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS && Character.UnicodeBlock.of(addstr.charAt(kj)) != Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A && Character.UnicodeBlock.of(addstr.charAt(kj)) != Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B && Character.UnicodeBlock.of(addstr.charAt(kj)) != Character.UnicodeBlock.CJK_COMPATIBILITY_FORMS && Character.UnicodeBlock.of(addstr.charAt(kj)) != Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS && Character.UnicodeBlock.of(addstr.charAt(kj)) != Character.UnicodeBlock.CJK_RADICALS_SUPPLEMENT && Character.UnicodeBlock.of(addstr.charAt(kj)) != Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION && Character.UnicodeBlock.of(addstr.charAt(kj)) != Character.UnicodeBlock.ENCLOSED_CJK_LETTERS_AND_MONTHS) continue;
            return true;
        }
        return false;
    }

    private boolean isLatinInput(InputAddress addr) {
        if (addr.getField(FieldType.STREET_NAME_FIELD_TYPE) != null && this.containsKanji((String)addr.getField(FieldType.STREET_NAME_FIELD_TYPE))) {
            return false;
        }
        if (addr.getField(FieldType.POST_ADDRESS_FIELD_TYPE) != null && this.containsKanji((String)addr.getField(FieldType.POST_ADDRESS_FIELD_TYPE))) {
            return false;
        }
        if (addr.getField(FieldType.AREA_NAME_4_FIELD_TYPE) != null && this.containsKanji((String)addr.getField(FieldType.AREA_NAME_4_FIELD_TYPE))) {
            return false;
        }
        if (addr.getField(FieldType.AREA_NAME_3_FIELD_TYPE) != null && this.containsKanji((String)addr.getField(FieldType.AREA_NAME_3_FIELD_TYPE))) {
            return false;
        }
        if (addr.getField(FieldType.AREA_NAME_2_FIELD_TYPE) != null && this.containsKanji((String)addr.getField(FieldType.AREA_NAME_2_FIELD_TYPE))) {
            return false;
        }
        if (addr.getField(FieldType.AREA_NAME_1_FIELD_TYPE) != null && this.containsKanji((String)addr.getField(FieldType.AREA_NAME_1_FIELD_TYPE))) {
            return false;
        }
        return addr.getField(FieldType.PLACE_NAME_FIELD_TYPE) == null || !this.containsKanji((String)addr.getField(FieldType.PLACE_NAME_FIELD_TYPE));
    }

    static {
        m_blockLot_Pattern = Pattern.compile("^(.*?)\\s*\\b(\\d+)\\s*[-,\\s]+\\s*(\\d+)\\b(.*?)$", 2);
        m_block_Pattern = Pattern.compile("^(.*)\\b(\\d{1,5})\\b(.*)$", 2);
        m_chomeBlockLotNoAnchor_Pattern = Pattern.compile("(.*?)\\s*(\\d{1,6})[-,\\s]+(\\d{1,6})[-,\\s]+(\\d{1,6})\\b(.*?)$", 2);
        m_latinRecommended_Pattern = Pattern.compile("^(.*?)\\s*(\\d+)\\s*[-,\\s]+\\s*(\\d+)\\b[,\\s*]+([ a-zA-Z]*[a-zA-Z][ a-zA-Z]*)[,\\s]+\\b(\\d+){1}\\b\\s*([-]*\\s*Chome|Choume|Come|Ch\u014dme)*+(.*?)$", 2);
        m_japaneseWithChome_Pattern = Pattern.compile("^(.*?)\\s*(\\d+){1}\\s*[-]*\\s*(Chome|Choume|Come|Ch\u014dme){1}[,\\s*]*(\\d+){1}\\s*[-,\\s]*\\s*(\\d+)*\\s*[-\\s]*\\s*(\\d+)*(.*?)$", 2);
        m_japaneseWithChomeNoAnchor_Pattern = Pattern.compile("^(.*?)\\s*(\\d+){1}\\s*[-]*\\s*(Chome|Choume|Come|Ch\u014dme){1}[,\\s*]*([ a-zA-Z-]{1,})(\\d+)\\s*[-,\\s]*\\s*(\\d+)*\\s*[-\\s]*\\s*(\\d{0,6})*(.*)$", 2);
        m_japaneseNoChome_Pattern = Pattern.compile("^(.*?)\\s*(\\d+){1}\\s*[-]*\\s*(Chome|Choume|Come|Ch\u014dme)?+[,\\s*]+([ a-zA-Z]{1,})\\s*+\\b(\\d+)\\b[-,\\s]+(\\d+)\\s*(.*)$", 2);
        m_sapporoTest_Pattern = Pattern.compile("^(?=.*(nishi|higashi))(?=.*(jo|jou|jyo|j\u014d))(?=.*(kita|minami)).*$", 2);
        m_sapporoTestSecond_Pattern = Pattern.compile("(nishi|higashi).*(minami|kita).*(jo|jyo|jou)", 2);
        m_sapporoTestStd_Pattern = Pattern.compile("(kita|minami).*(jo|jou|jyo).*(nishi|higashi)", 2);
        m_sapporoChomeBlockLot_Pattern = Pattern.compile("(?i)^(.*?)\\s*(\\d+)+[-,\\s]+(?:(\\d+)*[-,\\s]+){0,1}(\\d+)+[-,\\s]*(Chome|Choume|Come|Ch-me|Ch\u014dme)(.*?)$", 2);
        m_latinWithChomeAndAN3NoAnchor_Pattern = Pattern.compile("(?i)(.*?)\\b(\\d+){1}\\s*[-,\\s]+\\s*(\\d+){1}(.*)[-,\\s]+(\\d+)+[-,\\s]*(Chome|Choume|Come|Ch\u014dme|Ch-me)(.*?)$", 2);
        m_sapporoSecond_Pattern = Pattern.compile("(.*?)(\\d+)*\\s*[-,\\s]*\\s*(\\d+)*\\s*[-,\\s]*\\s*(\\d+)*\\s*[-,\\s]*\\s*(?:banchi)*\\s*[-,\\s]*\\s*(nishi|higashi)\\s*(\\d+)*\\s*[-,\\s]*\\s*(\\d+)*\\s*[-,\\s]*\\s*(\\d+)*\\s*[-,\\s]*\\s*(Chome|Choume|Come|Ch\u014dme|Ch-me)*[-,\\s]*((minami|kita)\\s*(\\d+)*[-,\\s]*(jo|jyo|jou|j\u00c5\u008d))[-,\\s]*(.*)$", 2);
        m_sapporoStd_Pattern = Pattern.compile("(.*?)\\s*(\\d+)*\\s*[-,\\s]*\\s*(\\d+)*[-,\\s]*(\\d+)*[-,\\s]*((kita|minami)[-,\\s]*(?:[ a-zA-Z1-9]{0,})[-,\\s]*(jo|jou|jyo|j\u00c5\u008d)[-,\\s]*(nishi|higashi))\\s*[-,\\s]*\\s*(\\d+)*\\s*[-,\\s]*\\s*(Chome|Choume|Come|Ch\u014dme|Ch-me)*\\s*[-,\\s]*\\s*(\\d+)*\\s*[-,\\s]*\\s*(\\d+)*\\s*[-,\\s]*\\s*(\\d+)*(.*)$", 2);
        m_sapporoCommonNonNumericChome_Pattern = Pattern.compile("(.*?)\\s*(\\d+)*+\\s*[-,\\s]*\\s*(\\d+)*[-,\\s]*(\\d+)+[-,\\s]*(kita|minami)\\b(.*)$", 2);
        m_sapporoCommonNonNumericTest_Pattern = Pattern.compile(".*(kita|minami).*", 2);
        m_looksLikeAN_Pattern = Pattern.compile("\\b(ken|fu|do|to|d\u014d|t\u014d|shi|gun|shichou|ku|cho|chou|machi|mura|son|aza|oaza)\\b", 2);
        m_postalAtEnd_Pattern = Pattern.compile("\\b\\d{3}\\s*[-,\\s]*\\s*\\d{4}[\\p{Z}\\s]*$", 2);
        m_postalAtBeginning_Pattern = Pattern.compile("^\\s*\\d{3}\\s*[-,\\s]*\\s*\\d{4}\\b", 2);
        m_japanAtEnd_Pattern = Pattern.compile("(:?JAPAN|JPN)[\\p{Z}\\s]*$", 2);
        m_japanAtBeginning_Pattern = Pattern.compile("^\\s*(:?JAPAN|JPN)", 2);
        m_PostalSignAtBeginning_Pattern = Pattern.compile("^\\s*\u00e3\u20ac\u2019", 2);
        m_PrefectureAtEnd_Pattern = Pattern.compile("(KEN|DO|KU|TO|FU)[\\p{Z}\\s]*$", 2);
        m_chomeBlockOrLotLocation_Pattern = Pattern.compile("\\b(\\d+)\\b", 2);
    }

    private static enum AddressType {
        JAPANESE,
        ENGLISH,
        UNKNOWN;

    }
}

