/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.JPN.utils;

import com.mapinfo.mapmarker.JPN.utils.JapaneseNumerals;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.CodedWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalFieldValue;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import java.util.ArrayList;
import java.util.Arrays;

public class JPNCandidateUtils {
    public static boolean contains(InternalFieldValue fv, AddressWord[] words) {
        if (JPNCandidateUtils.wordsMatched((AddressWord[])fv.getFieldValue(), words)) {
            return true;
        }
        if (fv.getAlternateValues() != null) {
            return JPNCandidateUtils.contains((AddressWord[][])fv.getAlternateValues(), words);
        }
        return false;
    }

    public static boolean contains(AddressWord[][] wordArray, AddressWord[] words) {
        if (wordArray != null && words != null) {
            for (AddressWord[] checkWords : wordArray) {
                if (!JPNCandidateUtils.wordsMatched(checkWords, words)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean wordsMatched(AddressWord[] words1, AddressWord[] words2) {
        if (words1.length == words2.length) {
            for (int i = 0; i < words1.length; ++i) {
                if (words1[i].getCodedWord().equals(words2[i].getCodedWord())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static void removeMatchingAlts(InternalFieldValue fv1, InternalFieldValue fv2) {
        JPNCandidateUtils.removeMatchingAlts(fv1, (AddressWord[])fv2.getFieldValue());
        AddressWord[][] alts = (AddressWord[][])fv2.getAlternateValues();
        if (alts != null) {
            for (AddressWord[] alt : alts) {
                JPNCandidateUtils.removeMatchingAlts(fv1, alt);
            }
        }
    }

    public static void removeMatchingAlts(InternalFieldValue fv, AddressWord[] checkWords) {
        AddressWord[][] alts = (AddressWord[][])fv.getAlternateValues();
        if (alts != null) {
            ArrayList<AddressWord[]> newAlts = new ArrayList<AddressWord[]>(alts.length);
            for (AddressWord[] alt : alts) {
                if (JPNCandidateUtils.wordsMatched(alt, checkWords)) continue;
                newAlts.add(alt);
            }
            if (newAlts.size() < alts.length) {
                if (newAlts.size() > 0) {
                    fv.setAlternateValues(newAlts.toArray((T[])new AddressWord[newAlts.size()][]));
                } else {
                    fv.setAlternateValues(null);
                }
            }
        }
    }

    public static boolean isMatchingWord(AddressWord word1, AddressWord word2) {
        if (CodedWord.compareBytes(word1.getCodedWord(), word2.getCodedWord()) == 0 || CodedWord.compareNormalizedBytes(word1.getCodedWord(), word2.getCodedWord()) == 0) {
            return true;
        }
        if (CodedWord.isNumber(word1.getAttributes()) && !CodedWord.isNumber(word2.getAttributes())) {
            return JPNCandidateUtils.numericMatch(word1, word2.getWord());
        }
        if (!CodedWord.isNumber(word1.getAttributes()) && CodedWord.isNumber(word2.getAttributes())) {
            return JPNCandidateUtils.numericMatch(word2, word1.getWord());
        }
        return false;
    }

    public static boolean numericMatch(AddressWord word, String probableNumeric) {
        if (JapaneseNumerals.isNumber(probableNumeric)) {
            int n = JapaneseNumerals.toNumber(probableNumeric);
            return Arrays.equals(("" + n).toCharArray(), word.getNormalizedChars());
        }
        return false;
    }

    public static char[] getWordCharacters(InternalScoringAddress cand, FieldType type) {
        InternalFieldValue fv = (InternalFieldValue)cand.getField(type);
        if (fv != null) {
            return JPNCandidateUtils.getWordCharacters((AddressWord[])fv.getFieldValue());
        }
        return null;
    }

    public static char[] getWordCharacters(AddressWord[] words) {
        if (words != null && words.length > 0) {
            return words[0].getWordChars();
        }
        return null;
    }

    public static char[] getWordNormalizedCharacters(InternalScoringAddress cand, FieldType type) {
        InternalFieldValue fv = (InternalFieldValue)cand.getField(type);
        if (fv != null) {
            return JPNCandidateUtils.getWordNormalizedCharacters((AddressWord[])fv.getFieldValue());
        }
        return null;
    }

    public static char[] getWordNormalizedCharacters(AddressWord[] words) {
        if (words != null && words.length > 0) {
            return words[0].getNormalizedChars();
        }
        return null;
    }

    public static boolean areSameWords(AddressWord[] words1, AddressWord[] words2) {
        int c2;
        int c1 = words1 == null ? 0 : words1.length;
        int n = c2 = words2 == null ? 0 : words2.length;
        if (c1 == c2 && c1 > 0) {
            for (int wordndx = 0; wordndx < c1; ++wordndx) {
                AddressWord word1 = words1[wordndx];
                AddressWord word2 = words2[wordndx];
                if (JPNCandidateUtils.isMatchingWord(word1, word2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean wordsMatchedWithFieldValue(AddressWord[] words, InternalFieldValue fv) {
        if (JPNCandidateUtils.areSameWords(words, (AddressWord[])fv.getFieldValue())) {
            return true;
        }
        AddressWord[][] alts = null;
        alts = (AddressWord[][])fv.getAlternateValues();
        if (alts != null) {
            for (AddressWord[] alt : alts) {
                if (!JPNCandidateUtils.areSameWords(words, alt)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean strMatchedWithFieldValue(String str, InternalFieldValue fv) {
        if (str.equals(JPNCandidateUtils.toStringWord((AddressWord[])fv.getFieldValue()))) {
            return true;
        }
        if (fv.hasAlternates()) {
            for (AddressWord[] alt : (AddressWord[][])fv.getAlternateValues()) {
                if (!str.equals(JPNCandidateUtils.toStringWord(alt))) continue;
                return true;
            }
        }
        return false;
    }

    public static String toStringWord(AddressWord[] words) {
        if (words != null && words.length == 1) {
            return words[0].getWord();
        }
        return null;
    }
}

