/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.JPN.utils;

import com.mapinfo.mapmarker.JPN.utils.JapaneseNumerals;
import com.mapinfo.mapmarker.cgge.utils.CharArray;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import java.util.Arrays;

public class JPNCharUtils {
    public static final int getMissingCharCount(char[] chars1, char[] chars2) {
        int size1 = chars1.length;
        int size2 = chars2.length;
        int missing = 0;
        if (size1 <= size2) {
            int j;
            int i = 0;
            for (j = 0; i < size1 && j < size2; ++i, ++j) {
                while (j < size2 && chars1[i] != chars2[j]) {
                    ++j;
                    ++missing;
                }
            }
            if (i > size1 || i == size1 && j <= size2) {
                while (j < size2) {
                    ++missing;
                    ++j;
                }
            }
        }
        return missing;
    }

    public static int findNextNumericPosition(char[] str, int from) {
        int n;
        int n2 = n = str == null ? 0 : str.length;
        if (from < 0) {
            from = 0;
        }
        for (int i = from; i < n; ++i) {
            char ch = str[i];
            if (!MMUtils.isDigit(ch) && !JapaneseNumerals.isDigit(ch)) continue;
            return i;
        }
        return -1;
    }

    public static char[] splitAtNumeric(char[] str) {
        int pos = JPNCharUtils.findNextNumericPosition(str, 0);
        if (pos > 0) {
            return CharArray.subArray(str, 0, pos);
        }
        return null;
    }

    public static int findNextNonNumericPosition(char[] str, int from) {
        int len = str.length;
        if (from < 0) {
            from = 0;
        }
        if (len > from) {
            for (int i = from; i < str.length; ++i) {
                char ch = str[i];
                if (MMUtils.isDigit(ch) || JapaneseNumerals.isDigit(ch)) continue;
                return i;
            }
        }
        return -1;
    }

    public static char[] splitFromLastNumber(char[] str) {
        if (str != null) {
            int lastCheckCharNdx;
            for (lastCheckCharNdx = str.length - 1; lastCheckCharNdx > 0 && !JapaneseNumerals.isDigit(str[lastCheckCharNdx]); --lastCheckCharNdx) {
            }
            if (lastCheckCharNdx > 0) {
                --lastCheckCharNdx;
                while (lastCheckCharNdx >= 0) {
                    if (!JapaneseNumerals.isDigit(str[lastCheckCharNdx])) {
                        return Arrays.copyOf(str, lastCheckCharNdx + 1);
                    }
                    --lastCheckCharNdx;
                }
            }
        }
        return null;
    }

    public static String getFirstNumber(String str) {
        if (str == null) {
            return null;
        }
        char[] chars = str.toCharArray();
        int startNdx = JPNCharUtils.findNextNumericPosition(chars, 0);
        if (startNdx >= 0) {
            int endNdx = JPNCharUtils.findNextNonNumericPosition(chars, startNdx);
            if (endNdx > -1) {
                return str.substring(startNdx, endNdx);
            }
            return str.substring(startNdx);
        }
        return null;
    }

    public static char[] getNumericPrefix(char[] str) {
        int n = str == null ? 0 : str.length;
        int digitCount = 0;
        boolean startsWithNormalDigits = true;
        for (int i = 0; i < n; ++i) {
            char ch = str[i];
            if (Character.isDigit(ch) && startsWithNormalDigits) {
                ++digitCount;
                continue;
            }
            if (digitCount != 0 && startsWithNormalDigits || !JapaneseNumerals.isKanjiDigit(ch)) break;
            ++digitCount;
            startsWithNormalDigits = false;
        }
        return digitCount > 0 ? Arrays.copyOf(str, digitCount) : null;
    }
}

