/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.KOR.helper;

import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.CodedWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.dp.DataFetchException;
import com.mapinfo.mapmarker.cgge.dp.DataNotInitialisedException;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAddressWord;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAreaTermItem;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.cgge.dp.InternalCandidateList;
import com.mapinfo.mapmarker.cgge.helper.CGGEStreetGeocodingHelper;
import com.mapinfo.mapmarker.cgge.parser.ICGGEParser;
import com.mapinfo.mapmarker.cgge.soundex.ICGGESoundex;
import com.mapinfo.mapmarker.cgge.utils.AddressWordArray;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class KORStreetGeocodingHelper
extends CGGEStreetGeocodingHelper {
    private boolean m_searchOnStreet = true;

    @Override
    protected AddressWord[] filterSearchWords(AddressWord[] words, boolean includeNormalWords, boolean combineAlphaNumeric, boolean noMultipleStreetTypeFiltering, int includeMask) {
        int wordsLen;
        AddressWord[] retAddressWords = null;
        int n = wordsLen = words == null ? 0 : words.length;
        if (wordsLen > 0) {
            if (wordsLen == 1) {
                retAddressWords = AddressWordArray.clone(words);
            } else {
                ICGGEParser parser = this.getHelperParser();
                ICGGESoundex soundex = this.getHelperSoundex();
                boolean containsTypeSeparator = false;
                ArrayList<AddressWord> filteredWordList = new ArrayList<AddressWord>(wordsLen);
                if (containsTypeSeparator = this.removeCommonWord(words, includeNormalWords, wordsLen, containsTypeSeparator, filteredWordList)) {
                    this.combineWordsWithTypeSeparator(words, wordsLen, parser, soundex, filteredWordList);
                }
                if (combineAlphaNumeric) {
                    this.combineAlphaNumericWords(words, wordsLen, parser, soundex, filteredWordList);
                }
                if (filteredWordList.size() > 0) {
                    retAddressWords = filteredWordList.toArray(new AddressWord[filteredWordList.size()]);
                }
            }
        }
        return retAddressWords;
    }

    private void combineAlphaNumericWords(AddressWord[] words, int wordsLen, ICGGEParser parser, ICGGESoundex soundex, List<AddressWord> filteredWordList) {
        StringBuilder builder = new StringBuilder();
        for (int wordNdx = 1; wordNdx < wordsLen; ++wordNdx) {
            AddressWord preWord;
            AddressWord word = words[wordNdx];
            if (!CodedWord.isNumber(word.getAttributes()) || CodedWord.isNumber((preWord = words[wordNdx - 1]).getAttributes()) || CodedWord.isDelimiter(preWord.getAttributes())) continue;
            builder.append(preWord.getWordChars());
            builder.append(word.getWordChars());
            filteredWordList.add(parser.convertToAddressWord(builder.toString(), soundex));
            builder.delete(0, builder.length());
            ++wordNdx;
        }
    }

    private void combineWordsWithTypeSeparator(AddressWord[] words, int wordsLen, ICGGEParser parser, ICGGESoundex soundex, List<AddressWord> filteredWordList) {
        StringBuilder builder = new StringBuilder();
        for (int searchWordNdx = 1; searchWordNdx < wordsLen - 1; ++searchWordNdx) {
            AddressWord searchWord = words[searchWordNdx];
            if (!CodedWord.isDelimiter(searchWord.getAttributes()) || !"%".equals(searchWord.getWord())) continue;
            builder.append(words[searchWordNdx - 1].getWord());
            builder.append(words[searchWordNdx + 1].getWord());
            filteredWordList.add(parser.convertToAddressWord(builder.toString(), soundex));
            builder.delete(0, builder.length());
        }
    }

    private boolean removeCommonWord(AddressWord[] words, boolean includeNormalWords, int wordsLen, boolean containsTypeSeparator, List<AddressWord> filteredWordList) {
        for (int wordNdx = 0; wordNdx < wordsLen; ++wordNdx) {
            AddressWord addrWord = words[wordNdx];
            short wordAttribs = addrWord.getAttributes();
            if (CodedWord.isDelimiter(wordAttribs)) {
                if (!"%".equals(addrWord.getWord())) continue;
                containsTypeSeparator = true;
                continue;
            }
            if (this.isNormalWord(includeNormalWords, addrWord, wordAttribs)) continue;
            filteredWordList.add(addrWord);
        }
        return containsTypeSeparator;
    }

    private boolean isNormalWord(boolean includeNormalWords, AddressWord addrWord, short wordAttribs) {
        return CodedWord.isNumber(wordAttribs) || CodedWord.isNumeric(wordAttribs) || CodedWord.isProbableRomanNumeral(wordAttribs) || CodedWord.isThoroughfareTypeWord(wordAttribs) || CodedWord.isArticleWord(wordAttribs) || CodedWord.isCommonWord(wordAttribs) || MMUtils.containsDigits(addrWord.getWordChars()) || !includeNormalWords;
    }

    @Override
    protected boolean generateStreetSubTries(IDataManager dataManager, ParsedAddress parsedAddress, GeocodeOptions options, InternalCandidateList candidateList) throws CGGEInternalException, DataNotInitialisedException, DataFetchException {
        boolean doingPOBox;
        if (parsedAddress.isIntersectionCase() || parsedAddress.isNearByFeature()) {
            return this.generateStreetSubTriesForIntersection(dataManager, parsedAddress, options, candidateList);
        }
        AddressWord[] searchWords = null;
        List<DictionaryAddressWord> searchWordList = null;
        boolean bl = doingPOBox = options != null && Boolean.valueOf(options.getGeocodeConstraints().getCustomString("POBOX_MATCH_IN_PROGRESS", "false")) != false;
        if (this.m_streetTryCaseMap == null) {
            this.m_streetTryCaseMap = new HashMap(9);
        }
        switch (this.m_streetSubTryCount) {
            case 0: {
                ++this.m_streetSubTryCount;
                if (this.setSavedSearchWordForSubTry(this.m_streetSubTryCount - 1)) {
                    return true;
                }
                this.m_searchOnStreet = this.isAddressSearchableField(FieldType.STREET_NAME_FIELD_TYPE);
                if (this.m_searchOnStreet) {
                    this.m_searchOnStreet = parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE) != null;
                    AddressWord[] streetWords = (AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
                    AddressWord[] filteredWords = this.filterSearchWords(streetWords, true, 0);
                    this.setAddressSearchWordList(this.getSearchableWords(filteredWords, FieldType.STREET_NAME_FIELD_TYPE, dataManager, this.getMinimumStreetSearchQuality(), options));
                    searchWordList = this.filterSearchWords(this.getAddressSearchWordList(), true, 0);
                    break;
                }
            }
            case 1: {
                ++this.m_streetSubTryCount;
                if (this.m_searchOnStreet && !doingPOBox) {
                    if (this.setSavedSearchWordForSubTry(this.m_streetSubTryCount - 1)) {
                        return true;
                    }
                    this.m_searchOnStreet = parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE) != null;
                    AddressWord[] streetWords = (AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
                    AddressWord[] filteredWords = this.filterSearchWords(streetWords, false, 12);
                    List<DictionaryAddressWord> searchableWords = this.getSearchableWords(filteredWords, FieldType.STREET_NAME_FIELD_TYPE, dataManager, this.getMinimumStreetSearchQuality(), options);
                    if (this.getAddressSearchWordList() != null) {
                        if (searchableWords != null) {
                            this.getAddressSearchWordList().addAll(searchableWords);
                        }
                    } else {
                        this.setAddressSearchWordList(searchableWords);
                    }
                    searchWordList = this.filterSearchWords(this.getAddressSearchWordList(), true, 1792);
                    break;
                }
            }
            case 2: {
                ++this.m_streetSubTryCount;
                if (this.m_searchOnStreet && !doingPOBox) {
                    if (this.setSavedSearchWordForSubTry(this.m_streetSubTryCount - 1)) {
                        return true;
                    }
                    AddressWord[] streetWords = (AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
                    AddressWord[] filteredWords = this.filterSearchWords(streetWords, false, 256);
                    List<DictionaryAddressWord> searchableWords = this.getSearchableWords(filteredWords, FieldType.STREET_NAME_FIELD_TYPE, dataManager, this.getMinimumStreetSearchQuality(), options);
                    if (this.getAddressSearchWordList() != null) {
                        if (searchableWords != null) {
                            this.getAddressSearchWordList().addAll(searchableWords);
                        }
                    } else {
                        this.setAddressSearchWordList(searchableWords);
                    }
                    searchWordList = this.filterSearchWords(searchableWords, true, 1536);
                    break;
                }
            }
            case 3: {
                ++this.m_streetSubTryCount;
                if (this.m_searchOnStreet && !doingPOBox) {
                    if (this.setSavedSearchWordForSubTry(this.m_streetSubTryCount - 1)) {
                        return true;
                    }
                    AddressWord[] streetWords = (AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
                    AddressWord[] filteredWords = this.filterSearchWords(streetWords, false, 2560);
                    List<DictionaryAddressWord> searchableWords = this.getSearchableWords(filteredWords, FieldType.STREET_NAME_FIELD_TYPE, dataManager, this.getMinimumStreetSearchQuality(), options);
                    if (this.getAddressSearchWordList() != null) {
                        if (searchableWords != null) {
                            this.getAddressSearchWordList().addAll(searchableWords);
                        }
                    } else {
                        this.setAddressSearchWordList(searchableWords);
                    }
                    searchWordList = this.filterSearchWords(searchableWords, true, 1024);
                    break;
                }
            }
            case 4: {
                ++this.m_streetSubTryCount;
                if (this.m_searchOnStreet && !doingPOBox) {
                    if (this.setSavedSearchWordForSubTry(this.m_streetSubTryCount - 1)) {
                        return true;
                    }
                    AddressWord[] words = this.getCombinedPossibles((AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE));
                    searchWords = this.filterSearchWords(words, true, 0);
                    searchWordList = this.getSearchableWords(searchWords, FieldType.STREET_NAME_FIELD_TYPE, dataManager, 1.0, options);
                    break;
                }
            }
            case 5: {
                List<FieldType> streetSearchFields;
                ++this.m_streetSubTryCount;
                if (!doingPOBox && this.m_areaSubTryCount < 10 && (streetSearchFields = this.getAddressSearchFields()) != null) {
                    for (FieldType searchType : streetSearchFields) {
                        if (searchType.getLevel() != FieldType.FieldLevel.LEVEL_RANGE || (searchWords = (AddressWord[])parsedAddress.getField(FieldType.GENERIC_FIELD_4_FIELD_TYPE)) == null) continue;
                        searchWordList = this.getSearchableWords(searchWords, searchType, dataManager, 1.0, options);
                    }
                    break;
                }
            }
            case 6: {
                ++this.m_streetSubTryCount;
                if (!this.m_searchOnStreet || doingPOBox || this.doesBestCandidateHasPerfectField(candidateList, FieldType.STREET_NAME_FIELD_TYPE) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE))) break;
                if (this.setSavedSearchWordForSubTry(this.m_streetSubTryCount - 1)) {
                    return true;
                }
                AddressWord[] words = this.getCombinedPossibles((AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE));
                searchWords = this.filterSearchWords(words, true, 0);
                searchWordList = this.getSearchableWords(searchWords, FieldType.STREET_NAME_FIELD_TYPE, dataManager, this.getMinimumStreetSearchQuality(), options);
                break;
            }
            case 7: {
                ++this.m_streetSubTryCount;
                if (this.m_searchOnStreet && !doingPOBox) {
                    if (!this.getAllowWrongCharChecks() || this.doesBestCandidateHasPerfectField(candidateList, FieldType.STREET_NAME_FIELD_TYPE) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE))) break;
                    if (this.setSavedSearchWordForSubTry(this.m_streetSubTryCount - 1)) {
                        return true;
                    }
                    AddressWord[] words = this.filterSearchWords((AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE), true, 0);
                    if (words == null) break;
                    ArrayList<AddressWord> list = new ArrayList<AddressWord>(10);
                    for (int i = 0; i < words.length; ++i) {
                        AddressWord codedWord = words[i];
                        List<AddressWord> l = this.makeAlternateWords(codedWord, 16);
                        if (l == null) continue;
                        list.addAll(l);
                    }
                    if (list.size() <= 0) break;
                    searchWords = list.toArray(new AddressWord[list.size()]);
                    searchWordList = this.getSearchableWords(searchWords, FieldType.STREET_NAME_FIELD_TYPE, dataManager, this.getMinimumStreetSearchQuality(), options);
                    break;
                }
            }
            case 8: {
                ++this.m_streetSubTryCount;
                if (!(!this.m_searchOnStreet || doingPOBox || !this.getAllowTransposedCharChecks() || this.doesBestCandidateHasPerfectField(candidateList, FieldType.STREET_NAME_FIELD_TYPE) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE)))) {
                    if (this.setSavedSearchWordForSubTry(this.m_streetSubTryCount - 1)) {
                        return true;
                    }
                    AddressWord[] words = this.filterSearchWords((AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE), true, 0);
                    if (words == null) break;
                    ArrayList<AddressWord> list = new ArrayList<AddressWord>(10);
                    for (int i = 0; i < words.length; ++i) {
                        AddressWord codedWord = words[i];
                        List<AddressWord> l = this.makeAlternateWords(codedWord, 8);
                        if (l == null) continue;
                        list.addAll(l);
                    }
                    if (list.size() <= 0) break;
                    searchWords = list.toArray(new AddressWord[list.size()]);
                    searchWordList = this.getSearchableWords(searchWords, FieldType.STREET_NAME_FIELD_TYPE, dataManager, this.getMinimumStreetSearchQuality(), options);
                    break;
                }
            }
            case 9: {
                ++this.m_streetSubTryCount;
            }
            case 10: {
                ++this.m_streetSubTryCount;
                if (!(!this.m_searchOnStreet || doingPOBox || !this.getAllowMissingCharChecks() || this.m_areaSubTryCount >= 24 || this.doesBestCandidateHasPerfectField(candidateList, FieldType.STREET_NAME_FIELD_TYPE) && (this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_3_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.AREA_NAME_4_FIELD_TYPE) || this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE)))) {
                    List<DictionaryAreaTermItem> areaList = this.getSearchAreaList();
                    if (this.m_areaSubTryCount < 16 || this.hasGoodQualityAreas(areaList, 0.9)) {
                        if (this.setSavedSearchWordForSubTry(this.m_streetSubTryCount - 1)) {
                            return true;
                        }
                        AddressWord[] words = this.filterSearchWords((AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE), true, 0);
                        if ((words = this.filterWordsInAreaList(words, areaList)) == null) break;
                        ArrayList<AddressWord> list = new ArrayList<AddressWord>(10);
                        for (int i = 0; i < words.length; ++i) {
                            AddressWord codedWord = words[i];
                            List<AddressWord> l = this.makeAlternateWords(codedWord, 2);
                            if (l == null) continue;
                            list.addAll(l);
                        }
                        if (list.size() <= 0) break;
                        searchWords = list.toArray(new AddressWord[list.size()]);
                        searchWordList = this.getSearchableWords(searchWords, FieldType.STREET_NAME_FIELD_TYPE, dataManager, this.getMinimumStreetSearchQuality(), options);
                        break;
                    }
                }
            }
            default: {
                return false;
            }
        }
        this.m_streetTryCaseMap.put(this.m_streetSubTryCount - 1, searchWordList);
        this.setSearchWordList(searchWordList);
        return true;
    }

    private boolean setSavedSearchWordForSubTry(int trycase) {
        if (this.m_streetTryCaseMap != null && this.m_streetTryCaseMap.containsKey(trycase)) {
            this.setSearchWordList((List)this.m_streetTryCaseMap.get(trycase));
            return true;
        }
        return false;
    }

    private boolean hasGoodQualityAreas(List<DictionaryAreaTermItem> areaList, double minimumQuality) {
        if (areaList != null) {
            for (DictionaryAreaTermItem areaItem : areaList) {
                if (!(areaItem.m_quality >= minimumQuality)) continue;
                return true;
            }
        }
        return false;
    }

    private AddressWord[] filterWordsInAreaList(AddressWord[] words, List<DictionaryAreaTermItem> areaList) {
        if (words != null && words.length > 0 && areaList != null && areaList.size() > 0) {
            int removed = 0;
            Iterator<DictionaryAreaTermItem> it = areaList.iterator();
            int wc = words.length;
            while (it.hasNext()) {
                DictionaryAreaTermItem areaItem = it.next();
                if (!(areaItem.m_quality >= 1.0)) continue;
                DictionaryAddressWord[] searchedWords = areaItem.getMatchedWords();
                int wc1 = searchedWords == null ? 0 : searchedWords.length;
                block1: for (int i = 0; i < wc1; ++i) {
                    DictionaryAddressWord searchWord = searchedWords[i];
                    if (searchWord == null) continue;
                    for (int j = 0; j < wc; ++j) {
                        if (words[j] == null || searchWord.getSearchWord() != words[j]) continue;
                        words[j] = null;
                        ++removed;
                        continue block1;
                    }
                }
            }
            if (removed > 0) {
                int remaining = wc - removed;
                if (remaining > 0) {
                    AddressWord[] filterdWords = new AddressWord[remaining];
                    int added = 0;
                    for (int j = 0; j < wc; ++j) {
                        if (words[j] == null) continue;
                        filterdWords[added++] = words[j];
                    }
                    return filterdWords;
                }
                return null;
            }
        }
        return words;
    }

    @Override
    protected boolean generateAreaSubTries(IDataManager dataManager, ParsedAddress parsedAddress, GeocodeOptions options, InternalCandidateList candidateList) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        switch (this.m_areaSubTryCount) {
            case 22: {
                ++this.m_areaSubTryCount;
                break;
            }
            default: {
                return super.generateAreaSubTries(dataManager, parsedAddress, options, candidateList);
            }
        }
        return true;
    }
}

