/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.MYS.parser;

import com.mapinfo.mapmarker.cgge.address.AddressNumber;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.parser.CGGEParser1;
import com.mapinfo.mapmarker.cgge.parser.ICGGEParserTerms;
import com.mapinfo.mapmarker.cgge.utils.IntArray;
import java.util.Iterator;
import java.util.List;

public class MYS_Parser
extends CGGEParser1 {
    private static final int DIGIT_THRESHOLD = 4;

    private List<AddressNumber> removeUnwantedProbableAddressNumber(AddressWord[] words, List<AddressNumber> probableList) {
        if (probableList != null && !probableList.isEmpty()) {
            Iterator<AddressNumber> iter = probableList.iterator();
            while (iter.hasNext()) {
                AddressNumber addressNumber = iter.next();
                if (addressNumber == null) continue;
                int hnrNumber1Len = String.valueOf(addressNumber.getHnrNumber1()).length();
                int hnrNumber2Len = String.valueOf(addressNumber.getHnrNumber2()).length();
                if (hnrNumber1Len == 4) {
                    AddressWord number1 = words[addressNumber.getPositionInInputStreet()[0]];
                    if (!number1.getWord().startsWith("0")) continue;
                    iter.remove();
                    continue;
                }
                if (hnrNumber1Len > 4) {
                    iter.remove();
                    continue;
                }
                if (hnrNumber2Len <= 4) continue;
                iter.remove();
            }
            if (probableList.isEmpty()) {
                probableList = null;
            }
        }
        return probableList;
    }

    @Override
    protected List<AddressNumber> findProbableAddressNumbers(AddressWord[] words, IntArray ignoreWordNdxs) {
        List<AddressNumber> probableList = super.findProbableAddressNumbers(words, ignoreWordNdxs);
        probableList = this.removeUnwantedProbableAddressNumber(words, probableList);
        return probableList;
    }

    @Override
    protected String cleanString(String str) {
        ICGGEParserTerms parserTerms = this.getParserTerms();
        if ((str = this.getUpperCase(str)) != null && !parserTerms.isDelimiter(str)) {
            char[] originalCharacters = str.trim().toCharArray();
            char[] newCharacters = new char[originalCharacters.length];
            int insertNdx = -1;
            for (int i = 0; i < originalCharacters.length; ++i) {
                ++insertNdx;
                if (!(!Character.isWhitespace(originalCharacters[i]) || this.isValidCharacter(originalCharacters[i - 1]) && this.isValidCharacter(originalCharacters[i + 1]) || Character.isWhitespace(originalCharacters[i - 1]) || '&' == originalCharacters[i - 1])) {
                    --insertNdx;
                    continue;
                }
                newCharacters[insertNdx] = originalCharacters[i];
            }
            return new String(newCharacters).trim();
        }
        return null;
    }

    private boolean isValidCharacter(char c) {
        boolean isValidChar = false;
        if ('\'' == c || Character.isLetterOrDigit(c)) {
            isValidChar = true;
        }
        return isValidChar;
    }

    @Override
    public AddressWord[] splitIntoWeightedWords(String str, FieldType type) {
        str = this.removeSpacesForSlashAndHyphen(str);
        return super.splitIntoWeightedWords(str, type);
    }

    private String removeSpacesForSlashAndHyphen(String str) {
        if (str != null) {
            str = str.replaceAll(" - ", "-");
            str = str.replaceAll(" / ", "/");
        }
        return str;
    }
}

