/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.NLD.convertor;

import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.NLD.address.NLD_ParsedAddress;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalFieldValue;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.InternalStreetAddress;
import com.mapinfo.mapmarker.cgge.convertor.CGGECandidateConvertor;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.user.IReverseGeocodeConstraints;
import com.mapinfo.mapmarker.user.ReverseGeocodeCandidateAddress;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.List;

public class NLDCandidateConvertor
extends CGGECandidateConvertor {
    private static final String EXTENDED_POST_CODE = "EXTENDED_POST_CODE";

    @Override
    public CandidateAddress covertCandidate(InternalScoringAddress scoringAddress, IDataManager dataManager, GeocodeOptions options) throws Exception {
        CandidateAddress candidate = super.covertCandidate(scoringAddress, dataManager, options);
        String extended_pc_input = ((NLD_ParsedAddress)scoringAddress.getParsedAddress()).getExtended_pc_input();
        extended_pc_input = extended_pc_input == null ? extended_pc_input : extended_pc_input.replaceAll("\\s", "");
        this.addExtendedPostCodeInAdditionalField((AddressImpl)candidate, (InternalFieldValue)scoringAddress.getField(FieldType.POST_CODE_FIELD_TYPE), extended_pc_input);
        if ("ExactMode".equals(options.getGeocodeConstraints().getMatchMode()) && extended_pc_input != null && !extended_pc_input.equalsIgnoreCase(candidate.getPostCode1())) {
            return null;
        }
        return candidate;
    }

    @Override
    public ReverseGeocodeCandidateAddress convertToReverseGeocodeCandidateAddress(InternalStreetAddress streetAddress, IDataManager dataManager, GeocodeOptions options, IReverseGeocodeConstraints constraints) {
        ReverseGeocodeCandidateAddress candidate = super.convertToReverseGeocodeCandidateAddress(streetAddress, dataManager, options, constraints);
        this.addExtendedPostCodeInAdditionalField((AddressImpl)candidate, (InternalFieldValue)streetAddress.getField(FieldType.POST_CODE_FIELD_TYPE), null);
        return candidate;
    }

    private void addExtendedPostCodeInAdditionalField(AddressImpl candidate, InternalFieldValue postcodeFieldVal, String extended_pc_input) {
        if (postcodeFieldVal != null) {
            AddressWord[][] extendedPostWords = (AddressWord[][])postcodeFieldVal.getAlternateValues();
            ArrayList<String> extendedPCList = new ArrayList<String>();
            if (extendedPostWords != null) {
                AddressWord[][] addressWordArray = extendedPostWords;
                int n = addressWordArray.length;
                for (int i = 0; i < n; ++i) {
                    AddressWord[] addWords;
                    for (AddressWord addWord : addWords = addressWordArray[i]) {
                        extendedPCList.add(addWord.getWord());
                    }
                }
            }
            if (!extendedPCList.isEmpty()) {
                String candidateFourDigitPC = postcodeFieldVal.toString().replaceAll("\\s", "");
                StringBuilder extendedPCValue = new StringBuilder();
                for (String extendedPC : extendedPCList) {
                    extendedPCValue.append(candidateFourDigitPC + extendedPC + "/");
                }
                extendedPCValue.setLength(extendedPCValue.length() - 1);
                candidate.getAdditionalFields().put(EXTENDED_POST_CODE, extendedPCValue.toString());
                if (extended_pc_input != null && extendedPostWords != null) {
                    this.updatePostcodeAndFLA(candidate, extended_pc_input, extendedPCList, candidateFourDigitPC);
                }
            }
        }
    }

    private void updatePostcodeAndFLA(AddressImpl candidate, String extended_pc_input, List<String> extendedPCList, String candidateFourDigitPC) {
        String postCode = candidate.getPostCode1();
        this.setPostalCode(candidate, extended_pc_input, extendedPCList, candidateFourDigitPC);
        if (postCode != null && extended_pc_input.length() == 6) {
            String formattedLocation = ((CandidateAddress)candidate).getFormattedLocationAddress();
            ((CandidateAddress)candidate).setFormattedLocationAddress(StringUtilities.replaceFirstOccurenceWith((String)formattedLocation, (String)postCode, (String)candidate.getPostCode1()));
        }
    }

    private void setPostalCode(AddressImpl candidate, String extended_pc_input, List<String> extendedPCList, String candidateFourDigitPC) {
        if (candidate.getPostCode1().equalsIgnoreCase(extended_pc_input)) {
            return;
        }
        String extendedPCChars = extended_pc_input.substring(4);
        if (extendedPCList.contains(extendedPCChars)) {
            candidate.setPostCode1(candidateFourDigitPC + extendedPCChars);
        }
    }
}

