/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.NLD.helper;

import com.mapinfo.mapmarker.NLD.address.NLD_ParsedAddress;
import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.CodedWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalFieldValue;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.address.PostCode;
import com.mapinfo.mapmarker.cgge.dp.DataFetchException;
import com.mapinfo.mapmarker.cgge.dp.DataNotInitialisedException;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAddressWord;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAreaTermItem;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.cgge.dp.InternalCandidateList;
import com.mapinfo.mapmarker.cgge.helper.CGGEStreetGeocodingHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class NLDStreetGeocodingHelper
extends CGGEStreetGeocodingHelper {
    public static final FieldType FIELD_HOLDING_EXTENDED_PC = FieldType.POST_CODE_FIELD_TYPE;
    private boolean m_searchWithExtendedPc = true;
    List<InternalScoringAddress> m_previousCands;
    private int m_tryCount = 0;
    private boolean m_hasMoreTries = true;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public InternalCandidateList searchNextCase(IDataManager dataManager, ParsedAddress parsedAddress, GeocodeOptions options, InternalCandidateList curCandList) throws CGGEInternalException, DataFetchException, DataNotInitialisedException {
        InternalCandidateList candList = null;
        if (this.continueRetrying(parsedAddress, curCandList)) {
            ++this.m_tryCount;
            switch (this.m_tryCount) {
                case 1: {
                    NLD_ParsedAddress localParsedAddress = (NLD_ParsedAddress)parsedAddress;
                    boolean isSpecialRequest = localParsedAddress.isSpecialSixDigitPCRequest();
                    if (this.m_searchWithExtendedPc && isSpecialRequest && (localParsedAddress.getAddressNumber() != null || localParsedAddress.getProbableAddressNumbers() != null)) {
                        AddressWord[] searchWords;
                        if (parsedAddress.isIntersectionCase()) return candList;
                        options = new GeocodeOptions(options);
                        List<DictionaryAddressWord> searchWordList = null;
                        this.findPCAreaList(dataManager, parsedAddress, true, options);
                        List areaList = this.m_pcAreaList;
                        if (this.m_pcAreaList != null && (searchWords = this.getPCExWords(parsedAddress)) != null && (searchWordList = this.getSearchableWords(searchWords, FIELD_HOLDING_EXTENDED_PC, dataManager, 1.0, options)) != null) {
                            candList = this.retrieveCandidates(dataManager, parsedAddress, areaList, searchWordList, options);
                        }
                        if (candList != null && candList.getCandidateCount() > 0) {
                            this.m_previousCands = new ArrayList<InternalScoringAddress>(candList.getCandidateList());
                        }
                        this.setExtendedPCFromSearchWord(candList);
                        return candList;
                    }
                }
                case 2: {
                    if (this.m_searchWithExtendedPc) {
                        this.m_searchWithExtendedPc = false;
                        if (curCandList != null && curCandList.getCandidateList() != null) {
                            int closeMatchCount = curCandList.getNumberOfCloseMatches();
                            Iterator<InternalScoringAddress> candlistIterator = curCandList.getCandidateList().iterator();
                            while (candlistIterator.hasNext()) {
                                InternalScoringAddress candAddr = candlistIterator.next();
                                if (candAddr.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE) == null || !(candAddr.getFieldScore((FieldType)FieldType.STREET_NAME_FIELD_TYPE).m_value > 0.0)) continue;
                                candlistIterator.remove();
                                if (!candAddr.isCloseMatch()) continue;
                                --closeMatchCount;
                            }
                            curCandList.setNumberOfCloseMatches(closeMatchCount);
                        }
                    }
                    ((NLD_ParsedAddress)parsedAddress).setSpecialSixDigitPCRequest(false);
                }
                default: {
                    return super.searchNextCase(dataManager, parsedAddress, options, curCandList);
                }
            }
        } else {
            this.m_hasMoreTries = false;
        }
        return candList;
    }

    @Override
    public boolean hasMoreTries() {
        if (this.m_hasMoreTries) {
            return super.hasMoreTries();
        }
        return false;
    }

    @Override
    protected boolean continueRetrying(ParsedAddress pAddr, InternalCandidateList currentList) {
        if (this.m_tryCount < 2 && currentList != null && currentList.getNumberOfCloseMatches() > 0) {
            this.m_hasMoreTries = false;
            return false;
        }
        return super.continueRetrying(pAddr, currentList);
    }

    @Override
    protected InternalCandidateList retrieveCandidates(IDataManager dataManager, ParsedAddress parsedAddress, List<DictionaryAreaTermItem> areaList, List<DictionaryAddressWord> searchWordList, GeocodeOptions options) throws CGGEInternalException, DataFetchException, DataNotInitialisedException {
        if (!this.m_searchWithExtendedPc && searchWordList != null) {
            Iterator<DictionaryAddressWord> searchWordIt = searchWordList.iterator();
            while (searchWordIt.hasNext()) {
                if (searchWordIt.next().getAddressWord().m_wordType != FIELD_HOLDING_EXTENDED_PC) continue;
                searchWordIt.remove();
            }
        }
        return super.retrieveCandidates(dataManager, parsedAddress, areaList, searchWordList, options);
    }

    private void setExtendedPCFromSearchWord(InternalCandidateList candList) {
        int candCount;
        int n = candCount = candList == null ? 0 : candList.getCandidateCount();
        if (candCount > 0) {
            for (InternalScoringAddress cand : candList.getCandidateList()) {
                AddressWord searchWord = new AddressWord(cand.getSearchWords().get(0));
                searchWord.m_weight = (byte)100;
                InternalFieldValue fv = new InternalFieldValue(new AddressWord[]{searchWord});
                cand.setField(FieldType.POST_CODE_EX_FIELD_TYPE, fv);
            }
        }
    }

    private InternalCandidateList filterNonMatchingPCCandidates(List<DictionaryAreaTermItem> pcList, InternalCandidateList candList) {
        int candCount;
        int n = candCount = candList == null ? 0 : candList.getCandidateCount();
        if (candCount > 0) {
            List<AddressWord[]> strPCs = this.getAreaPCs(pcList);
            ArrayList<InternalScoringAddress> newList = new ArrayList<InternalScoringAddress>(candCount);
            for (InternalScoringAddress cand : candList.getCandidateList()) {
                InternalFieldValue fv = (InternalFieldValue)cand.getField(FieldType.POST_CODE_FIELD_TYPE);
                if (!fv.hasAlternates()) continue;
                AddressWord[][] n2 = (AddressWord[][])fv.getAlternateValues();
                for (int i = 0; i < n2.length; ++i) {
                    if (!this.containsPC(strPCs, n2[i])) continue;
                    newList.add(cand);
                }
            }
            candList = newList.size() > 0 ? new InternalCandidateList(newList) : null;
        }
        return candList;
    }

    private boolean containsPC(List<AddressWord[]> list, AddressWord[] search) {
        if (list != null) {
            for (Object[] objectArray : list) {
                if (!Arrays.equals(objectArray, search)) continue;
                return true;
            }
        }
        return false;
    }

    private List<AddressWord[]> getAreaPCs(List<DictionaryAreaTermItem> pcList) {
        ArrayList<AddressWord[]> strPCs = new ArrayList<AddressWord[]>(pcList.size());
        if (pcList != null) {
            Iterator<DictionaryAreaTermItem> it = pcList.iterator();
            while (it.hasNext()) {
                strPCs.add(it.next().m_areaWords);
            }
        }
        return strPCs;
    }

    private AddressWord[] getPCExWords(ParsedAddress parsedAddress) {
        ArrayList<AddressWord> postcodes = new ArrayList<AddressWord>(10);
        AddressWord[] pc = (AddressWord[])parsedAddress.getField(FieldType.POST_CODE_FIELD_TYPE);
        if (pc != null && pc.length > 1) {
            postcodes.add(pc[1]);
        } else {
            List<PostCode> pcs = parsedAddress.getProbablePostcodes();
            if (pcs != null) {
                for (PostCode pcObj : pcs) {
                    AddressWord pcExWord;
                    pc = pcObj.getWords();
                    if (pc == null || pc.length <= 1 || !this.isPCEx(pcExWord = pc[pc.length - 1])) continue;
                    postcodes.add(pcExWord);
                }
            }
        }
        int n = postcodes.size();
        if (n > 0) {
            return postcodes.toArray(new AddressWord[n]);
        }
        return null;
    }

    private boolean isPCEx(AddressWord word) {
        return word != null && word.getWordLength() == 2;
    }

    @Override
    protected boolean findPCAreaList(IDataManager dataManager, ParsedAddress parsedAddr, boolean bPerfectArea, GeocodeOptions options) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        List<PostCode> pcProbables;
        double minQuality = bPerfectArea ? 1.0 : this.getMinimumPostCodeSearchQuality();
        AddressWord[] pcWords = (AddressWord[])parsedAddr.getField(FieldType.POST_CODE_FIELD_TYPE);
        boolean isSixdigitRequest = ((NLD_ParsedAddress)parsedAddr).isSpecialSixDigitPCRequest();
        Iterator<PostCode> pcProbableIt = null;
        if (pcWords == null && (pcProbables = parsedAddr.getProbablePostcodes()) != null && (pcProbableIt = pcProbables.iterator()).hasNext()) {
            pcWords = pcProbableIt.next().getWords();
        }
        while (pcWords != null) {
            int wordCount;
            ArrayList<AddressWord> wordList = new ArrayList<AddressWord>();
            for (AddressWord addressWord : pcWords) {
                if (addressWord.getWordLength() != 4) continue;
                wordList.add(addressWord);
            }
            pcWords = wordList.toArray(new AddressWord[wordList.size()]);
            List<DictionaryAreaTermItem> pcAreaList = dataManager.findAreaTerms(1, pcWords, FieldType.POST_CODE_FIELD_TYPE, minQuality, options);
            if (pcAreaList == null && (wordCount = pcWords.length) > 0) {
                StringBuilder builder = new StringBuilder(10);
                for (int wordndx = 0; wordndx < wordCount; ++wordndx) {
                    if (!CodedWord.isNumber(pcWords[wordndx].getAttributes())) continue;
                    builder.append(pcWords[wordndx].getWordChars());
                }
                if (builder.length() > 0) {
                    AddressWord pcWord = this.getHelperParser().convertToAddressWord(builder.toString(), this.getHelperSoundex());
                    pcAreaList = dataManager.findAreaTerms(1, new AddressWord[]{pcWord}, FieldType.POST_CODE_FIELD_TYPE, minQuality, options);
                }
            }
            if (pcAreaList != null) {
                if (this.m_pcAreaList == null) {
                    this.m_pcAreaList = pcAreaList;
                } else {
                    this.m_pcAreaList.addAll(pcAreaList);
                }
            }
            if (pcProbableIt != null && pcProbableIt.hasNext()) {
                pcWords = pcProbableIt.next().getWords();
                continue;
            }
            pcWords = null;
        }
        return this.m_pcAreaList != null && this.m_pcAreaList.size() > 0;
    }
}

