/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.NLD.matcher;

import com.mapinfo.mapmarker.NLD.address.NLD_ParsedAddress;
import com.mapinfo.mapmarker.NLD.matcher.NLDInternalScoringAddressComparator;
import com.mapinfo.mapmarker.cgge.AddressNumberScore;
import com.mapinfo.mapmarker.cgge.CGGEHandler;
import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.MatchingOptions;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.InternalScoringRange;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.address.PostCode;
import com.mapinfo.mapmarker.cgge.address.ScoringItem;
import com.mapinfo.mapmarker.cgge.dp.InternalCandidateList;
import com.mapinfo.mapmarker.cgge.matcher.CGGEMatcher1;
import com.mapinfo.mapmarker.cgge.parser.ICGGEParser;
import com.mapinfo.mapmarker.cgge.scorer.ICGGEScorer;
import com.mapinfo.mapmarker.cgge.soundex.ICGGESoundex;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class NLDMatcher
extends CGGEMatcher1 {
    @Override
    protected FieldScore scorePostCode(ScoringItem addr, ParsedAddress parsedAddr, Map<FieldType, FieldScore> currentScores, MatchingOptions matchingOptions, ICGGEScorer scorer) {
        FieldScore score = super.scorePostCode(addr, parsedAddr, currentScores, matchingOptions, scorer);
        if (score.m_value != 1.0) {
            AddressWord[] pcWords = (AddressWord[])parsedAddr.getField(FieldType.POST_CODE_FIELD_TYPE);
            Iterator<PostCode> pcProbableIt = null;
            if (pcWords == null) {
                List<PostCode> pcProbables = parsedAddr.getProbablePostcodes();
                if (pcProbables != null) {
                    pcProbableIt = pcProbables.iterator();
                    while (pcProbableIt.hasNext()) {
                        pcWords = pcProbableIt.next().getWords();
                        if (score.m_value == 1.0 || pcWords == null || pcWords.length <= 0) continue;
                        FieldScore pcScore = this.rescorePostCode(addr, parsedAddr, currentScores, matchingOptions, scorer, score, pcWords);
                        if (!(pcScore.m_value > score.m_value)) continue;
                        score = pcScore;
                    }
                }
            } else {
                FieldScore pcScore = this.rescorePostCode(addr, parsedAddr, currentScores, matchingOptions, scorer, score, pcWords);
                if (pcScore.m_value > score.m_value) {
                    score = pcScore;
                }
            }
        }
        return score;
    }

    private FieldScore rescorePostCode(ScoringItem addr, ParsedAddress parsedAddr, Map<FieldType, FieldScore> currentScores, MatchingOptions matchingOptions, ICGGEScorer scorer, FieldScore score, AddressWord[] pcWords) {
        FieldScore pcScore = new FieldScore();
        AddressWord combinedWord = this.generateNewAddressWordforPC(pcWords);
        if (combinedWord != null) {
            ParsedAddress pa = new ParsedAddress(parsedAddr.getCountry(), parsedAddr.getLanguage());
            pa.copy(parsedAddr);
            pa.setField(FieldType.POST_CODE_FIELD_TYPE, new AddressWord[]{combinedWord});
            pcScore = super.scorePostCode(addr, pa, currentScores, matchingOptions, scorer);
        }
        return pcScore;
    }

    AddressWord generateNewAddressWordforPC(AddressWord[] pcWords) {
        AddressWord combinedWord = null;
        if (pcWords != null && pcWords.length >= 1) {
            CGGEHandler handler = CGGEHandler.getInstance(this.getDataSetInfo(), this.getCountry(), this.getLanguage());
            ICGGEParser parser = handler.getParser();
            ICGGESoundex soundex = handler.getSoundex();
            for (AddressWord pcWord : pcWords) {
                if (pcWord.getWordLength() <= 3) continue;
                String postcode = String.valueOf(pcWord.getWordChars());
                combinedWord = parser.convertToAddressWord(postcode.substring(0, 4), soundex);
                combinedWord.setAlternates(pcWord.getAlternates());
            }
        }
        return combinedWord;
    }

    @Override
    protected void calculateCombinedStreetScore(InternalScoringAddress scoringAddr, ParsedAddress parsedAddress, MatchingOptions options) {
        FieldScore streetScore;
        FieldScore pcScore;
        if (this.searchedOnExtendedPC(scoringAddr) && ((NLD_ParsedAddress)parsedAddress).isSpecialSixDigitPCRequest() && (pcScore = scoringAddr.getFieldScore(FieldType.POST_CODE_FIELD_TYPE)) != null && pcScore.m_value >= 1.0 && ((streetScore = scoringAddr.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE)) == null || !streetScore.m_inputFieldPresent || streetScore.m_value < 0.01)) {
            scoringAddr.setCombinedStreetScore(1.0);
            return;
        }
        super.calculateCombinedStreetScore(scoringAddr, parsedAddress, options);
    }

    @Override
    public double calculateCombinedAddressScore(InternalScoringAddress scoringAddr, MatchingOptions matchOptions) {
        double combinedScore = super.calculateCombinedAddressScore(scoringAddr, matchOptions);
        if (this.searchedOnExtendedPC(scoringAddr)) {
            InternalScoringRange range;
            boolean removeScore = true;
            InternalScoringRange internalScoringRange = range = scoringAddr.getRangeCount() > 0 ? scoringAddr.getRangeAt(0) : null;
            if (range != null) {
                AddressNumberScore score = (AddressNumberScore)range.getFieldScore(FieldType.ADDRESS_NUMBER_FIELD_TYPE);
                if (score == null) {
                    removeScore = false;
                } else if (score.m_matched || score.isTypeMatch() && score.getOffset() < matchOptions.getMaxAddressNumberOffsetAllowed()) {
                    removeScore = false;
                }
            }
            if (removeScore) {
                scoringAddr.setCombinedScore(0.0);
                combinedScore = 0.0;
            }
        }
        return combinedScore;
    }

    private boolean searchedOnExtendedPC(InternalScoringAddress cand) {
        List<AddressWord> words = cand.getSearchWords();
        return words != null && words.size() > 0 && words.get((int)0).m_wordType == FieldType.POST_CODE_FIELD_TYPE && words.get(0).getWordLength() == 2;
    }

    @Override
    public boolean passMustMatchContraints(InternalScoringAddress scoringAddr, MatchingOptions matchOptions) {
        boolean isCloseMatch = super.passMustMatchContraints(scoringAddr, matchOptions);
        boolean isStreetPresentinSearchWord = false;
        List<AddressWord> addressSearchWords = scoringAddr.getSearchWords();
        for (AddressWord addressWord : addressSearchWords) {
            if (!FieldType.STREET_NAME_FIELD_TYPE.equals(addressWord.m_wordType)) continue;
            isStreetPresentinSearchWord = true;
            break;
        }
        if (!isStreetPresentinSearchWord && matchOptions.getGeocodeOptions().isMustMatchStreetName() && scoringAddr.getCombinedPostalScore() >= matchOptions.getCloseMatchCutoff()) {
            isCloseMatch = true;
        }
        if (matchOptions.getGeocodeOptions().isMustMatchAddressNumber()) {
            AddressNumberScore numScore;
            InternalScoringRange range;
            InternalScoringRange internalScoringRange = range = scoringAddr.getRangeCount() > 0 ? scoringAddr.getRangeAt(0) : null;
            if (range != null && (numScore = (AddressNumberScore)range.getFieldScore(FieldType.ADDRESS_NUMBER_FIELD_TYPE)) != null && numScore.m_inputFieldPresent && matchOptions.getFieldWeight(FieldType.ADDRESS_NUMBER_FIELD_TYPE) > 0.0 && (numScore == null || !numScore.isMatched())) {
                isCloseMatch = false;
            }
        }
        return isCloseMatch;
    }

    @Override
    public void mergeCandidates(InternalCandidateList candList1, InternalCandidateList candList2) {
        if (candList2 == null) {
            return;
        }
        int candCount1 = candList1.getCandidateCount();
        int candCount2 = candList2.getCandidateCount();
        if (candCount1 == 0) {
            candList1.setCandidateList(candList2.getCandidateList());
            candList1.setNumberOfCloseMatches(candList2.getNumberOfCloseMatches());
        } else if (candCount2 > 0) {
            List<InternalScoringAddress> internalList1 = candList1.getCandidateList();
            List<InternalScoringAddress> internalList2 = candList2.getCandidateList();
            LinkedList<InternalScoringAddress> tempCombinedList = new LinkedList<InternalScoringAddress>(internalList1);
            Comparator<InternalScoringAddress> reverseComparator = MMUtils.getReverseComparator(new NLDInternalScoringAddressComparator());
            for (int i = 0; i < candCount2; ++i) {
                InternalScoringAddress scoringAddr = internalList2.get(i);
                int ndx = MMUtils.nextInsertPosition(tempCombinedList, scoringAddr, reverseComparator);
                tempCombinedList.add(ndx, scoringAddr);
            }
            internalList1.clear();
            internalList1.addAll(tempCombinedList);
            candList1.setNumberOfCloseMatches(candList1.getNumberOfCloseMatches() + candList2.getNumberOfCloseMatches());
        }
    }
}

