/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.PRT.helper;

import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.dp.DataFetchException;
import com.mapinfo.mapmarker.cgge.dp.DataNotInitialisedException;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAddressWord;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAreaTermItem;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.cgge.dp.InternalCandidateList;
import com.mapinfo.mapmarker.cgge.helper.CGGEGeographicGeocodingHelper;
import com.mapinfo.mapmarker.cgge.utils.ListUtils;
import java.util.List;

public class PRT_GeographicGeocodingHelper
extends CGGEGeographicGeocodingHelper {
    private int m_tryCount;
    private boolean m_area3SacKeyAllowed = false;
    private boolean m_area4SacKeyAllowed = false;

    @Override
    public boolean init(String country, String language) {
        super.init(country, language);
        this.m_tryCount = 0;
        return true;
    }

    private void setSearchableFields(IDataManager dataManager) throws CGGEInternalException {
        this.initSacAndStreetSearchFields(dataManager);
        List<FieldType> sacSearchFields = this.getSacSearchFields();
        if (sacSearchFields != null) {
            if (!this.m_area3SacKeyAllowed) {
                this.m_area3SacKeyAllowed = sacSearchFields.contains(FieldType.AREA_NAME_3_FIELD_TYPE);
            }
            if (!this.m_area4SacKeyAllowed) {
                this.m_area4SacKeyAllowed = sacSearchFields.contains(FieldType.AREA_NAME_4_FIELD_TYPE);
            }
        }
    }

    @Override
    protected boolean generateCases(IDataManager dataManager, ParsedAddress parsedAddr, GeocodeOptions options, InternalCandidateList candidateList) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        boolean separateAreaFields = parsedAddr.getField(FieldType.AREA_NAME_3_FIELD_TYPE) != null || parsedAddr.getField(FieldType.AREA_NAME_4_FIELD_TYPE) != null || parsedAddr.getField(FieldType.AREA_NAME_2_FIELD_TYPE) != null || parsedAddr.getField(FieldType.AREA_NAME_1_FIELD_TYPE) != null;
        AddressWord[] lookUpAreaWords = null;
        List<DictionaryAreaTermItem> areaList = null;
        List<DictionaryAddressWord> searchWordList = null;
        switch (this.m_tryCount) {
            case 0: {
                this.setSearchableFields(dataManager);
                ++this.m_tryCount;
                if (this.m_area4SacKeyAllowed && (lookUpAreaWords = separateAreaFields ? (AddressWord[])parsedAddr.getField(FieldType.AREA_NAME_4_FIELD_TYPE) : this.getAreaWords((AddressWord[])parsedAddr.getField(FieldType.POST_ADDRESS_FIELD_TYPE))) != null && !ListUtils.isEmpty(areaList = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_4_FIELD_TYPE, 1.0, dataManager, options))) {
                    searchWordList = this.getSearchableWords(lookUpAreaWords, dataManager, true, options);
                    break;
                }
            }
            case 1: {
                ++this.m_tryCount;
                if (this.m_area3SacKeyAllowed && (lookUpAreaWords = separateAreaFields ? (AddressWord[])parsedAddr.getField(FieldType.AREA_NAME_3_FIELD_TYPE) : this.getAreaWords((AddressWord[])parsedAddr.getField(FieldType.POST_ADDRESS_FIELD_TYPE))) != null && !ListUtils.isEmpty(areaList = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_3_FIELD_TYPE, 1.0, dataManager, options))) {
                    searchWordList = this.getSearchableWords(lookUpAreaWords, dataManager, true, options);
                    break;
                }
            }
            case 2: {
                ++this.m_tryCount;
                if (this.m_area4SacKeyAllowed && !options.isMustMatchAreaName4() && (lookUpAreaWords = separateAreaFields ? (AddressWord[])parsedAddr.getField(FieldType.AREA_NAME_4_FIELD_TYPE) : this.getAreaWords((AddressWord[])parsedAddr.getField(FieldType.POST_ADDRESS_FIELD_TYPE))) != null && !ListUtils.isEmpty(areaList = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_4_FIELD_TYPE, 0.8, dataManager, options))) {
                    searchWordList = this.getSearchableWords(lookUpAreaWords, dataManager, false, options);
                    break;
                }
            }
            case 3: {
                ++this.m_tryCount;
                if (this.m_area3SacKeyAllowed && !options.isMustMatchAreaName3() && (lookUpAreaWords = separateAreaFields ? (AddressWord[])parsedAddr.getField(FieldType.AREA_NAME_3_FIELD_TYPE) : this.getAreaWords((AddressWord[])parsedAddr.getField(FieldType.POST_ADDRESS_FIELD_TYPE))) != null && !ListUtils.isEmpty(areaList = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_3_FIELD_TYPE, 0.8, dataManager, options))) {
                    searchWordList = this.getSearchableWords(lookUpAreaWords, dataManager, false, options);
                    break;
                }
            }
            case 4: {
                if (this.m_area4SacKeyAllowed) {
                    ++this.m_tryCount;
                    if (separateAreaFields && (lookUpAreaWords = (AddressWord[])parsedAddr.getField(FieldType.AREA_NAME_3_FIELD_TYPE)) != null && !ListUtils.isEmpty(areaList = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_4_FIELD_TYPE, 1.0, dataManager, options))) {
                        searchWordList = this.getSearchableWords(lookUpAreaWords, dataManager, false, options);
                        break;
                    }
                }
            }
            case 5: {
                ++this.m_tryCount;
                if (this.m_area3SacKeyAllowed && separateAreaFields && (lookUpAreaWords = (AddressWord[])parsedAddr.getField(FieldType.AREA_NAME_4_FIELD_TYPE)) != null && !ListUtils.isEmpty(areaList = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_3_FIELD_TYPE, 1.0, dataManager, options))) {
                    searchWordList = this.getSearchableWords(lookUpAreaWords, dataManager, false, options);
                    break;
                }
            }
            case 6: {
                if (this.m_area4SacKeyAllowed) {
                    ++this.m_tryCount;
                    if (separateAreaFields && !options.isMustMatchAreaName4() && (lookUpAreaWords = (AddressWord[])parsedAddr.getField(FieldType.AREA_NAME_3_FIELD_TYPE)) != null && !ListUtils.isEmpty(areaList = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_4_FIELD_TYPE, 0.8, dataManager, options))) {
                        searchWordList = this.getSearchableWords(lookUpAreaWords, dataManager, false, options);
                        break;
                    }
                }
            }
            case 7: {
                ++this.m_tryCount;
                if (this.m_area3SacKeyAllowed && separateAreaFields && !options.isMustMatchAreaName3() && (lookUpAreaWords = (AddressWord[])parsedAddr.getField(FieldType.AREA_NAME_4_FIELD_TYPE)) != null && !ListUtils.isEmpty(areaList = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_3_FIELD_TYPE, 0.8, dataManager, options))) {
                    searchWordList = this.getSearchableWords(lookUpAreaWords, dataManager, false, options);
                    break;
                }
            }
            default: {
                return false;
            }
        }
        if (areaList != null && searchWordList != null) {
            this.setSearchAreaList(areaList);
            this.setSearchWordList(searchWordList);
        }
        return true;
    }
}

