/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.PRT.helper;

import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.address.PostCode;
import com.mapinfo.mapmarker.cgge.dp.DataFetchException;
import com.mapinfo.mapmarker.cgge.dp.DataNotInitialisedException;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAddressWord;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAreaTermItem;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.cgge.dp.InternalCandidateList;
import com.mapinfo.mapmarker.cgge.helper.CGGEPostalGeocodingHelper;
import com.mapinfo.mapmarker.cgge.utils.ListUtils;
import java.util.List;

public class PRT_PostalGeocodingHelper
extends CGGEPostalGeocodingHelper {
    private int m_tryCount;
    public boolean m_pcAreaIntersectionSacsOnly;

    @Override
    public boolean init(String country, String language) {
        super.init(country, language);
        this.m_tryCount = 0;
        this.m_pcAreaIntersectionSacsOnly = false;
        return true;
    }

    @Override
    protected boolean generateCases(IDataManager dataManager, ParsedAddress parsedAddr, GeocodeOptions options, InternalCandidateList candidateList) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        switch (this.m_tryCount) {
            case 0: {
                if (this.getSacSearchFields() == null || this.getAddressSearchFields() == null) {
                    this.initSacAndStreetSearchFields(dataManager);
                }
                ++this.m_tryCount;
                AddressWord[] pcWords = (AddressWord[])parsedAddr.getField(FieldType.POST_CODE_FIELD_TYPE);
                List<DictionaryAreaTermItem> areaList = null;
                List<DictionaryAddressWord> searchWordList = null;
                if (pcWords != null) {
                    areaList = this.findAreaList(pcWords, 1.0, dataManager, options);
                    if (areaList != null) {
                        searchWordList = this.getSearchableWords(pcWords, dataManager, 1.0, options);
                    }
                } else {
                    List<PostCode> probablePcs = parsedAddr.getProbablePostcodes();
                    if (probablePcs != null) {
                        for (PostCode pc : probablePcs) {
                            pcWords = pc.getWords();
                            areaList = ListUtils.addToList(areaList, this.findAreaList(pcWords, 1.0, dataManager, options));
                            searchWordList = ListUtils.addToList(searchWordList, this.getSearchableWords(pcWords, dataManager, 1.0, options));
                        }
                    }
                }
                if (areaList != null && searchWordList != null) {
                    this.setSearchAreaList(areaList);
                    this.setSearchWordList(searchWordList);
                    return true;
                }
            }
            case 1: {
                ++this.m_tryCount;
                AddressWord[] pcWords = (AddressWord[])parsedAddr.getField(FieldType.GENERIC_FIELD_4_FIELD_TYPE);
                List<DictionaryAreaTermItem> areaList = null;
                List<DictionaryAddressWord> searchWordList = null;
                if (pcWords != null && (areaList = this.findAreaList(pcWords, 1.0, dataManager, options)) != null) {
                    searchWordList = this.getSearchableWords(pcWords, dataManager, 1.0, options);
                }
                if (areaList == null || searchWordList == null) break;
                this.setSearchAreaList(areaList);
                this.setSearchWordList(searchWordList);
                return true;
            }
        }
        return false;
    }
}

