/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.PRT.helper;

import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.address.PostCode;
import com.mapinfo.mapmarker.cgge.dp.DataFetchException;
import com.mapinfo.mapmarker.cgge.dp.DataNotInitialisedException;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAreaTermItem;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.cgge.helper.CGGEStreetGeocodingHelper;
import com.mapinfo.mapmarker.cgge.utils.ListUtils;
import java.util.List;

public class PRT_StreetGeocodingHelper
extends CGGEStreetGeocodingHelper {
    @Override
    protected boolean findPCAreaList(IDataManager dataManager, ParsedAddress parsedAddr, boolean bPerfectArea, GeocodeOptions options) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        double minQuality = bPerfectArea ? 1.0 : this.getMinimumPostCodeSearchQuality();
        List<DictionaryAreaTermItem> pcAreaList = this.findPCAreaList(dataManager, parsedAddr, minQuality, options);
        this.setPCAreaList(pcAreaList);
        return pcAreaList != null;
    }

    @Override
    protected List<DictionaryAreaTermItem> findPCAreaList(IDataManager dataManager, ParsedAddress parsedAddr, double minQuality, GeocodeOptions options) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        FieldType pcType = FieldType.POST_CODE_FIELD_TYPE;
        AddressWord[] pcWords = (AddressWord[])parsedAddr.getField(pcType);
        if (pcWords != null) {
            List<DictionaryAreaTermItem> pcAreaList = this.findAreaList(pcWords, pcType, minQuality, dataManager, options);
            pcAreaList = this.findPCAreaListOnInitial4digits(dataManager, parsedAddr, options, pcType, pcAreaList);
            return pcAreaList;
        }
        List<DictionaryAreaTermItem> pcAreaList = null;
        List<PostCode> pcProbables = parsedAddr.getProbablePostcodes();
        if (pcProbables != null) {
            for (PostCode pc : pcProbables) {
                List<DictionaryAreaTermItem> pcList = this.findAreaList(pc.getWords(), pcType, minQuality, dataManager, options);
                pcList = this.findPCAreaListOnInitial4digits(dataManager, parsedAddr, options, pcType, pcList);
                pcAreaList = ListUtils.addToList(pcAreaList, pcList);
            }
        }
        return pcAreaList;
    }

    private List<DictionaryAreaTermItem> findPCAreaListOnInitial4digits(IDataManager dataManager, ParsedAddress parsedAddr, GeocodeOptions options, FieldType pcType, List<DictionaryAreaTermItem> pcAreaList) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        if (pcAreaList == null || pcAreaList.isEmpty()) {
            pcAreaList = this.findAreaList((AddressWord[])parsedAddr.getField(FieldType.GENERIC_FIELD_4_FIELD_TYPE), pcType, 1.0, dataManager, options);
        }
        return pcAreaList;
    }
}

