/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.SGP.helper;

import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.address.PostCode;
import com.mapinfo.mapmarker.cgge.dp.DataFetchException;
import com.mapinfo.mapmarker.cgge.dp.DataNotInitialisedException;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.cgge.dp.InternalCandidateList;
import com.mapinfo.mapmarker.cgge.helper.CGGEPostalGeocodingHelper;
import com.mapinfo.mapmarker.cgge.parser.ICGGEParser;
import com.mapinfo.mapmarker.cgge.soundex.ICGGESoundex;
import java.util.Iterator;
import java.util.List;

public class SGPPostalGeocodingHelper
extends CGGEPostalGeocodingHelper {
    @Override
    public InternalCandidateList searchNextCase(IDataManager dataManager, ParsedAddress parsedAddress, GeocodeOptions options, InternalCandidateList curCandList) throws CGGEInternalException, DataFetchException, DataNotInitialisedException {
        AddressWord[] pcWords = (AddressWord[])parsedAddress.getField(FieldType.POST_CODE_FIELD_TYPE);
        if (pcWords != null && pcWords.length > 0) {
            AddressWord combinedWord = this.combineWords(pcWords);
            if (combinedWord != null) {
                parsedAddress.setField(FieldType.POST_CODE_FIELD_TYPE, new AddressWord[]{combinedWord});
            }
        } else {
            List<PostCode> pcs = parsedAddress.getProbablePostcodes();
            if (pcs != null) {
                Iterator<PostCode> it = pcs.iterator();
                while (it.hasNext()) {
                    PostCode pc = it.next();
                    pcWords = pc.getWords();
                    AddressWord combinedWord = this.combineWords(pcWords);
                    if (combinedWord != null) {
                        pc.setWords(new AddressWord[]{combinedWord});
                        continue;
                    }
                    it.remove();
                }
            }
        }
        return super.searchNextCase(dataManager, parsedAddress, options, curCandList);
    }

    private AddressWord combineWords(AddressWord[] pcWords) {
        if (pcWords != null && pcWords.length == 2) {
            StringBuilder sb = new StringBuilder(10);
            sb.append(pcWords[0].getWordChars());
            sb.append(pcWords[1].getWordChars());
            ICGGEParser parser = this.getHelperParser();
            ICGGESoundex soundex = this.getHelperSoundex();
            AddressWord combinedWord = parser.convertToAddressWord(sb.toString(), soundex);
            return combinedWord;
        }
        return null;
    }
}

