/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.SGP.helper;

import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.CodedWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.address.PostCode;
import com.mapinfo.mapmarker.cgge.dp.DataFetchException;
import com.mapinfo.mapmarker.cgge.dp.DataNotInitialisedException;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAreaTermItem;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.cgge.dp.InternalCandidateList;
import com.mapinfo.mapmarker.cgge.helper.CGGEStreetGeocodingHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class SGPStreetGeocodingHelper
extends CGGEStreetGeocodingHelper {
    @Override
    protected boolean generateAreaSubTries(IDataManager dataManager, ParsedAddress parsedAddress, GeocodeOptions options, InternalCandidateList candidateList) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        this.m_filterSearchedAreaItemAndWordCombo = true;
        List<DictionaryAreaTermItem> areaList = null;
        switch (this.m_areaSubTryCount) {
            case 0: {
                List<PostCode> pcProbables;
                ++this.m_areaSubTryCount;
                this.m_areaTryCaseMap = new HashMap(15);
                AddressWord[] pcWords = (AddressWord[])parsedAddress.getField(FieldType.POST_CODE_FIELD_TYPE);
                Iterator<PostCode> pcProbableIt = null;
                if (pcWords == null && (pcProbables = parsedAddress.getProbablePostcodes()) != null) {
                    ArrayList<AddressWord> pcWordList = new ArrayList<AddressWord>(5);
                    pcProbableIt = pcProbables.iterator();
                    while (pcProbableIt.hasNext()) {
                        AddressWord[] pc = pcProbableIt.next().getWords();
                        if (pc == null || pc.length <= 0) continue;
                        pcWordList.add(pc[0]);
                    }
                    if (pcWordList != null && pcWordList.size() > 0) {
                        pcWords = pcWordList.toArray(new AddressWord[pcWordList.size()]);
                    }
                }
                if ((areaList = dataManager.findAreaTerms(1, pcWords, FieldType.POST_CODE_FIELD_TYPE, 1.0, options)) != null) {
                    AddressWord[] lookUpAreaWords = (AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
                    if (lookUpAreaWords == null) break;
                    List<DictionaryAreaTermItem> areaListFromStreet = dataManager.findAreaTerms(1, lookUpAreaWords, FieldType.STREET_NAME_FIELD_TYPE, 1.0, options);
                    if ((areaListFromStreet = this.filterAreaListMatchedOnInSignificantWord(areaListFromStreet)) == null || areaListFromStreet.size() <= 0) break;
                    areaList.addAll(areaListFromStreet);
                    this.m_areaSacIntersectionFieldList = new ArrayList(2);
                    this.m_areaSacIntersectionFieldList.add(FieldType.POST_CODE_FIELD_TYPE);
                    this.m_areaSacIntersectionFieldList.add(FieldType.STREET_NAME_FIELD_TYPE);
                    break;
                }
            }
            case 1: {
                ++this.m_areaSubTryCount;
                if (this.m_areaList != null && this.m_areaSacIntersectionFieldList != null) {
                    this.m_areaSacIntersectionFieldList = null;
                    Iterator areaIt = this.m_areaList.iterator();
                    while (areaIt.hasNext()) {
                        if (FieldType.POST_CODE_FIELD_TYPE == ((DictionaryAreaTermItem)areaIt.next()).m_type) continue;
                        areaIt.remove();
                    }
                    break;
                }
            }
            case 2: {
                AddressWord[] lookUpAreaWords;
                ++this.m_areaSubTryCount;
                if (!(this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE) && this.doesBestCandidateHasPerfectField(candidateList, FieldType.STREET_NAME_FIELD_TYPE) || (lookUpAreaWords = (AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE)) == null)) {
                    areaList = dataManager.findAreaTerms(1, lookUpAreaWords, FieldType.STREET_NAME_FIELD_TYPE, 1.0, options);
                    areaList = this.filterAreaListMatchedOnInSignificantWord(areaList);
                }
                if (areaList != null) break;
            }
            case 3: {
                AddressWord[] lookUpAreaWords;
                ++this.m_areaSubTryCount;
                if (parsedAddress.getField(FieldType.POST_CODE_FIELD_TYPE) == null) {
                    if (!(this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE) && this.doesBestCandidateHasPerfectField(candidateList, FieldType.STREET_NAME_FIELD_TYPE) || (lookUpAreaWords = (AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE)) == null)) {
                        areaList = dataManager.findAreaTerms(1, lookUpAreaWords, FieldType.STREET_NAME_FIELD_TYPE, this.getMinimumAreaSearchQuality(), options);
                        areaList = this.filterAreaListMatchedOnInSignificantWord(areaList);
                    }
                    if (areaList != null) break;
                }
            }
            case 4: {
                AddressWord[] lookUpAreaWords;
                ++this.m_areaSubTryCount;
                if (!(this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE) && this.doesBestCandidateHasPerfectField(candidateList, FieldType.STREET_NAME_FIELD_TYPE) || (lookUpAreaWords = (AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE)) == null)) {
                    areaList = dataManager.findAreaTerms(1, lookUpAreaWords, FieldType.RANGE_PLACE_NAME_FIELD_TYPE, 1.0, options);
                    areaList = this.filterAreaListMatchedOnInSignificantWord(areaList);
                }
                if (areaList != null) break;
            }
            case 5: {
                AddressWord[] lookUpAreaWords;
                ++this.m_areaSubTryCount;
                if (!(this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE) && this.doesBestCandidateHasPerfectField(candidateList, FieldType.STREET_NAME_FIELD_TYPE) || (lookUpAreaWords = (AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE)) == null)) {
                    areaList = dataManager.findAreaTerms(1, lookUpAreaWords, FieldType.RANGE_PLACE_NAME_FIELD_TYPE, this.getMinimumAreaSearchQuality(), options);
                    areaList = this.filterAreaListMatchedOnInSignificantWord(areaList);
                }
                if (areaList != null) break;
            }
            default: {
                this.m_areaList = null;
                return false;
            }
        }
        if (areaList != null && areaList.size() > 0) {
            ArrayList<DictionaryAreaTermItem> savedAreaList = new ArrayList<DictionaryAreaTermItem>(areaList);
            this.m_areaTryCaseMap.put(this.m_areaSubTryCount - 1, savedAreaList);
        } else {
            this.m_areaTryCaseMap.put(this.m_areaSubTryCount - 1, areaList);
        }
        this.m_areaList = areaList != null && areaList.size() > 0 ? areaList : null;
        return true;
    }

    private List<DictionaryAreaTermItem> filterAreaListMatchedOnInSignificantWord(List<DictionaryAreaTermItem> areaList) {
        if (areaList != null) {
            Iterator<DictionaryAreaTermItem> it = areaList.iterator();
            while (it.hasNext()) {
                DictionaryAreaTermItem areaItem = it.next();
                AddressWord[] areaWords = areaItem.m_areaWords;
                int wordLen = areaWords.length;
                int matchedWordCount = 0;
                boolean remove = true;
                for (int wordNdx = 0; wordNdx < wordLen && remove; ++wordNdx) {
                    AddressWord areaWord = areaWords[wordNdx];
                    if (!CodedWord.isDelimiter(areaWord.getAttributes()) && AddressWord.isSignificantWord(areaWord)) {
                        remove = false;
                        continue;
                    }
                    if (areaWord.m_weight <= 0 || ++matchedWordCount <= 1) continue;
                    remove = false;
                }
                if (!remove) continue;
                it.remove();
            }
        }
        return areaList;
    }

    @Override
    protected boolean generateStreetSubTries(IDataManager dataManager, ParsedAddress parsedAddress, GeocodeOptions options, InternalCandidateList candidateList) throws CGGEInternalException, DataNotInitialisedException, DataFetchException {
        if (this.m_streetTryCaseMap == null) {
            this.m_streetTryCaseMap = new HashMap(4);
        }
        this.m_searchWordList = null;
        switch (this.m_streetSubTryCount) {
            case 0: {
                ++this.m_streetSubTryCount;
                this.m_searchWordList = (List)this.m_streetTryCaseMap.get(this.m_streetSubTryCount - 1);
                if (this.m_searchWordList != null || this.m_streetTryCaseMap.containsKey(this.m_streetSubTryCount - 1)) {
                    return true;
                }
                AddressWord[] pc = (AddressWord[])parsedAddress.getField(FieldType.POST_CODE_FIELD_TYPE);
                if (pc == null) {
                    List<PostCode> pcProbables = parsedAddress.getProbablePostcodes();
                    if (pcProbables == null) break;
                    ArrayList<AddressWord> pcWordList = new ArrayList<AddressWord>(5);
                    Iterator<PostCode> pcProbableIt = pcProbables.iterator();
                    while (pcProbableIt.hasNext()) {
                        pc = pcProbableIt.next().getWords();
                        if (pc == null || pc.length != 2 || pc[1].getSoundex() <= 0) continue;
                        pcWordList.add(pc[1]);
                    }
                    if (pcWordList == null || pcWordList.size() <= 0) break;
                    AddressWord[] pcWords = pcWordList.toArray(new AddressWord[pcWordList.size()]);
                    this.m_searchWordList = this.getSearchableWords(pcWords, FieldType.POST_CODE_EX_FIELD_TYPE, dataManager, this.getMinimumPostCodeSearchQuality(), options);
                    break;
                }
                if (pc.length != 2 || pc[1].getSoundex() <= 0) break;
                this.m_searchWordList = this.getSearchableWords(new AddressWord[]{pc[1]}, FieldType.POST_CODE_EX_FIELD_TYPE, dataManager, this.getMinimumPostCodeSearchQuality(), options);
                break;
            }
            case 1: {
                ++this.m_streetSubTryCount;
                if (this.doesBestCandidateHasPerfectField(candidateList, FieldType.STREET_NAME_FIELD_TYPE) && this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE)) break;
                this.m_searchWordList = (List)this.m_streetTryCaseMap.get(this.m_streetSubTryCount - 1);
                if (this.m_searchWordList != null || this.m_streetTryCaseMap.containsKey(this.m_streetSubTryCount - 1)) {
                    this.m_filterSearchedAreaItemAndWordCombo = false;
                    return true;
                }
                AddressWord[] addrWords = (AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
                addrWords = this.filterSearchWords(addrWords, true, false, 0);
                this.m_searchWordList = this.getSearchableWords(addrWords, FieldType.STREET_NAME_FIELD_TYPE, dataManager, 1.0, options);
                this.m_filterSearchedAreaItemAndWordCombo = false;
                break;
            }
            case 2: {
                ++this.m_streetSubTryCount;
                if (this.doesBestCandidateHasPerfectField(candidateList, FieldType.STREET_NAME_FIELD_TYPE) && this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE)) break;
                this.m_searchWordList = (List)this.m_streetTryCaseMap.get(this.m_streetSubTryCount - 1);
                if (this.m_searchWordList != null || this.m_streetTryCaseMap.containsKey(this.m_streetSubTryCount - 1)) {
                    return true;
                }
                AddressWord[] addrWords = (AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
                addrWords = this.filterSearchWords(addrWords, true, false, 0);
                this.m_searchWordList = this.getSearchableWords(addrWords, FieldType.RANGE_PLACE_NAME_FIELD_TYPE, dataManager, 1.0, options);
                break;
            }
            case 3: {
                ++this.m_streetSubTryCount;
                if (this.doesBestCandidateHasPerfectField(candidateList, FieldType.STREET_NAME_FIELD_TYPE) && this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE)) break;
                this.m_searchWordList = (List)this.m_streetTryCaseMap.get(this.m_streetSubTryCount - 1);
                if (this.m_searchWordList != null || this.m_streetTryCaseMap.containsKey(this.m_streetSubTryCount - 1)) {
                    return true;
                }
                AddressWord[] addrWords = (AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
                addrWords = this.filterSearchWords(addrWords, true, false, 0);
                this.m_searchWordList = this.getSearchableWords(addrWords, FieldType.STREET_NAME_FIELD_TYPE, dataManager, this.getMinimumStreetSearchQuality(), options);
                break;
            }
            case 4: {
                ++this.m_streetSubTryCount;
                if (this.doesBestCandidateHasPerfectField(candidateList, FieldType.STREET_NAME_FIELD_TYPE) && this.doesBestCandidateHasPerfectField(candidateList, FieldType.POST_CODE_FIELD_TYPE)) break;
                this.m_searchWordList = (List)this.m_streetTryCaseMap.get(this.m_streetSubTryCount - 1);
                if (this.m_searchWordList != null || this.m_streetTryCaseMap.containsKey(this.m_streetSubTryCount - 1)) {
                    return true;
                }
                AddressWord[] addrWords = (AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
                addrWords = this.filterSearchWords(addrWords, false, false, 256);
                this.m_searchWordList = this.getSearchableWords(addrWords, FieldType.STREET_NAME_FIELD_TYPE, dataManager, this.getMinimumStreetSearchQuality(), options);
                break;
            }
            default: {
                return false;
            }
        }
        this.m_streetTryCaseMap.put(this.m_streetSubTryCount - 1, this.m_searchWordList);
        return true;
    }

    @Override
    protected AddressWord[] filterSearchWords(AddressWord[] words, boolean includeNormalWords, boolean combineAlphaNumeric, int includeMask) {
        if (words != null && includeMask == 0) {
            boolean filterTypes = (includeMask & 0x200) != 512;
            boolean filterCommonWord = (includeMask & 0x100) != 256;
            boolean filterArticles = (includeMask & 0x400) != 1024;
            boolean filterNumbers = (includeMask & 4) != 4;
            boolean filterNumerics = (includeMask & 8) != 8;
            int wordLen = words.length;
            int probableWordCount = 0;
            int firstProbableWordNdx = 0;
            for (int wordNdx = 0; wordNdx < wordLen && probableWordCount < 2; ++wordNdx) {
                if (CodedWord.isDelimiter(words[wordNdx].getAttributes())) continue;
                ++probableWordCount;
                firstProbableWordNdx = wordNdx;
            }
            if (probableWordCount == 1) {
                AddressWord addressWord = words[firstProbableWordNdx];
            }
        }
        return super.filterSearchWords(words, includeNormalWords, combineAlphaNumeric, includeMask);
    }

    @Override
    protected boolean continueRetrying(ParsedAddress pAddr, InternalCandidateList currentList) {
        int closeMatchCount = currentList.getNumberOfCloseMatches();
        if (pAddr.isIntersectionCase() && closeMatchCount > 1) {
            return false;
        }
        if (closeMatchCount > 0) {
            InternalScoringAddress cand = currentList.getIndexedCandidate(0);
            List<AddressWord> searchWords = cand.getSearchWords();
            for (AddressWord searchWord : searchWords) {
                if (!AddressWord.isSignificantWord(searchWord)) {
                    FieldScore score = cand.getFieldScore(searchWord.m_wordType == FieldType.POST_CODE_EX_FIELD_TYPE ? FieldType.POST_CODE_FIELD_TYPE : searchWord.m_wordType);
                    if (score == null || !(score.m_value > 0.9)) continue;
                    return false;
                }
                return false;
            }
        }
        return true;
    }
}

