/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.SGP.matcher;

import com.mapinfo.mapmarker.cgge.AddressNumberScore;
import com.mapinfo.mapmarker.cgge.CGGEHandler;
import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.MatchingOptions;
import com.mapinfo.mapmarker.cgge.address.AddressNumber;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalFieldValue;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.InternalScoringRange;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.address.ScoringItem;
import com.mapinfo.mapmarker.cgge.matcher.CGGEMatcher1;
import com.mapinfo.mapmarker.cgge.matcher.ICGGEMatcher;
import com.mapinfo.mapmarker.cgge.parser.ICGGEParser;
import com.mapinfo.mapmarker.cgge.scorer.ICGGEScorer;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SGPMatcher
extends CGGEMatcher1
implements ICGGEMatcher {
    private boolean containsFieldSearchWords(InternalScoringAddress addr, FieldType type) {
        List<AddressWord> searchWords = addr.getSearchWords();
        if (searchWords != null) {
            Iterator<AddressWord> it = searchWords.iterator();
            while (it.hasNext()) {
                if (type != it.next().m_wordType) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public double calculateCombinedAddressScore(InternalScoringAddress scoringAddr, MatchingOptions matchOptions) {
        double scorePossible = 0.0;
        double score = 0.0;
        double postScore = scoringAddr.getCombinedPostalScore();
        double streetScore = scoringAddr.getCombinedStreetScore();
        boolean includePostalScore = true;
        boolean includeStreetScore = true;
        if (postScore < 0.001 || streetScore < 1.0E-4) {
            InternalScoringRange range;
            FieldScore buildingScore;
            if (postScore < 0.001 && !this.hasScorablePostFields(scoringAddr) && !this.containsFieldSearchWords(scoringAddr, FieldType.POST_CODE_EX_FIELD_TYPE)) {
                if (this.containsFieldSearchWords(scoringAddr, FieldType.STREET_NAME_FIELD_TYPE)) {
                    FieldScore streetFieldScore = scoringAddr.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE);
                    if (streetFieldScore != null && SGPMatcher.acceptScore(streetFieldScore, FieldType.STREET_NAME_FIELD_TYPE, matchOptions)) {
                        includePostalScore = false;
                    }
                } else if (this.containsFieldSearchWords(scoringAddr, FieldType.RANGE_PLACE_NAME_FIELD_TYPE) && scoringAddr.getRangeCount() > 0 && (buildingScore = (range = scoringAddr.getRangeAt(0)).getFieldScore(FieldType.RANGE_PLACE_NAME_FIELD_TYPE)) != null && SGPMatcher.acceptScore(buildingScore, FieldType.STREET_NAME_FIELD_TYPE, matchOptions)) {
                    includePostalScore = false;
                }
            }
            if (streetScore < 0.001 && !this.containsFieldSearchWords(scoringAddr, FieldType.STREET_NAME_FIELD_TYPE)) {
                if (this.containsFieldSearchWords(scoringAddr, FieldType.POST_CODE_EX_FIELD_TYPE)) {
                    FieldScore pcFieldScore = scoringAddr.getFieldScore(FieldType.POST_CODE_FIELD_TYPE);
                    if (pcFieldScore != null && SGPMatcher.acceptScore(pcFieldScore, FieldType.POST_CODE_FIELD_TYPE, matchOptions)) {
                        includeStreetScore = false;
                    }
                } else if (this.containsFieldSearchWords(scoringAddr, FieldType.RANGE_PLACE_NAME_FIELD_TYPE) && scoringAddr.getRangeCount() > 0 && (buildingScore = (range = scoringAddr.getRangeAt(0)).getFieldScore(FieldType.RANGE_PLACE_NAME_FIELD_TYPE)) != null && SGPMatcher.acceptScore(buildingScore, FieldType.STREET_NAME_FIELD_TYPE, matchOptions)) {
                    includeStreetScore = false;
                }
            }
        }
        if (includePostalScore) {
            double postalWeight = matchOptions.getPostAddressWeight();
            scorePossible += postalWeight;
            score += postalWeight * postScore;
        }
        if (includeStreetScore) {
            double streetWeight = matchOptions.getStreetAddressWeight();
            scorePossible += streetWeight;
            score += streetWeight * streetScore;
        }
        if (scoringAddr.getRangeCount() > 0) {
            double rangeWeight = matchOptions.getRangeAddressWeight();
            scorePossible += rangeWeight;
            score += scoringAddr.getRangeAt(0).getCombinedScore() * rangeWeight;
        }
        if (scorePossible > 0.0) {
            score /= scorePossible;
        }
        scoringAddr.setCombinedScore(score);
        return score;
    }

    @Override
    public boolean calculateCloseMatch(InternalScoringAddress scoringAddr, ParsedAddress parsedAddr, GeocodeOptions options, MatchingOptions matchOptions) throws CGGEInternalException {
        boolean closeMatch = false;
        if (this.passMustMatchContraints(scoringAddr, matchOptions)) {
            closeMatch = scoringAddr.getCombinedScore() >= matchOptions.getCloseMatchCutoff();
        }
        scoringAddr.setCloseMatch(closeMatch);
        return closeMatch;
    }

    private boolean hasScorablePostFields(InternalScoringAddress scoringAddr) {
        Map<FieldType, FieldScore> scores = scoringAddr.getFieldScores();
        if (scores != null) {
            for (Map.Entry<FieldType, FieldScore> scoreEn : scores.entrySet()) {
                FieldType type = scoreEn.getKey();
                if (type.getLevel() != FieldType.FieldLevel.LEVEL_POSTAL) continue;
                FieldScore score = scoreEn.getValue();
                if (!score.m_inputFieldPresent) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected FieldScore scorePostCode(ScoringItem addr, ParsedAddress parsedAddr, Map<FieldType, FieldScore> currentScores, MatchingOptions matchingOptions, ICGGEScorer scorer) {
        FieldScore pcScore = super.scorePostCode(addr, parsedAddr, currentScores, matchingOptions, scorer);
        boolean ismustMatchPC = matchingOptions.getGeocodeOptions().getGeocodeConstraints().isMustMatchPostalCode();
        if (ismustMatchPC) {
            ICGGEParser parser = CGGEHandler.getInstance(this.getDataSetInfo(), "SGP", null).getParser();
            String inputPostcode = parser.reconstructFieldValue(pcScore.m_inputWords);
            String candPostcode = parser.reconstructFieldValue(pcScore.m_candWords);
            if (!StringUtilities.isEmpty((String)inputPostcode) && !inputPostcode.equals(candPostcode) && pcScore.m_value == 1.0) {
                pcScore.m_value = 0.98;
                pcScore.m_matched = false;
            }
        }
        return pcScore;
    }

    @Override
    protected void calculateCombinedRangeScore(InternalScoringRange scoringRange, ParsedAddress parsedAddr, MatchingOptions matchingOptions) {
        double rangeScore = 0.0;
        double scorePossible = 0.0;
        Map<FieldType, FieldScore> fieldMap = scoringRange.getFieldScores();
        if (fieldMap != null && fieldMap.size() > 0) {
            for (Map.Entry<FieldType, FieldScore> entry : fieldMap.entrySet()) {
                double fieldWeight;
                FieldType type = entry.getKey();
                FieldScore fieldScore = entry.getValue();
                if (fieldScore == null || type.getLevel() != FieldType.FieldLevel.LEVEL_RANGE || type == FieldType.ADDRESS_NUMBER_FIELD_TYPE || !((fieldWeight = matchingOptions.getFieldWeight(type)) > 0.0)) continue;
                boolean acceptScore = this.acceptRangeScore(fieldScore);
                boolean hasSeparateInput = this.hasSeparateRangeInput(parsedAddr, type);
                if (acceptScore || this.inputFieldPresent(fieldScore) || hasSeparateInput) {
                    scorePossible += fieldWeight;
                    if (!acceptScore) continue;
                    rangeScore += fieldScore.m_value * fieldWeight;
                    continue;
                }
                if (fieldScore == null || !fieldScore.m_candidateFieldPresent || matchingOptions.isOptionalField(type)) continue;
                scorePossible += fieldWeight * 0.01;
            }
        }
        AddressNumberScore addrScore = (AddressNumberScore)scoringRange.getFieldScore(FieldType.ADDRESS_NUMBER_FIELD_TYPE);
        double addrNumWeight = matchingOptions.getFieldWeight(FieldType.ADDRESS_NUMBER_FIELD_TYPE);
        if (addrScore != null && addrScore.m_inputFieldPresent && addrNumWeight > 0.0) {
            scorePossible += addrNumWeight;
            rangeScore += addrScore.calculateAndSetScoreValue(matchingOptions) * addrNumWeight;
        }
        if (scorePossible > 0.0) {
            scoringRange.setCombinedScore(rangeScore / scorePossible);
        } else {
            scoringRange.setCombinedScore(0.0);
        }
    }

    private boolean acceptRangeScore(FieldScore fieldScore) {
        return fieldScore != null && fieldScore.m_value > 0.75;
    }

    @Override
    protected void scoreRangeAddressNumber(InternalScoringAddress scoringAddr, InternalScoringRange scoringRange, ParsedAddress pAddr, MatchingOptions matchingOptions, ICGGEScorer scorer) {
        List<AddressNumber> addressNumberList;
        AddressNumber inputAddressNumber2;
        super.scoreRangeAddressNumber(scoringAddr, scoringRange, pAddr, matchingOptions, scorer);
        FieldScore addressNumberScore = scoringRange.getFieldScore(FieldType.ADDRESS_NUMBER_FIELD_TYPE);
        if (!(addressNumberScore != null && addressNumberScore.m_value != 0.0 || (inputAddressNumber2 = pAddr.getAddressNumber()) != null || (addressNumberList = pAddr.getProbableAddressNumbers()) == null || addressNumberList.isEmpty() || addressNumberList.size() <= 0)) {
            for (AddressNumber inputAddressNumber2 : addressNumberList) {
                AddressNumber scoringAddressNumber;
                if (inputAddressNumber2 == null || StringUtilities.isEmpty((String)inputAddressNumber2.toString()) || (scoringAddressNumber = scoringRange.getFrom()) == null || StringUtilities.isEmpty((String)scoringAddressNumber.toString()) || !scoringAddressNumber.toString().equalsIgnoreCase(inputAddressNumber2.toString())) continue;
                AddressNumberScore addrNumScore = new AddressNumberScore();
                addrNumScore.setInputAddressNumber(scoringAddressNumber);
                boolean numner1Matched = scoringAddressNumber.getHnrNumber1() > 0;
                boolean numner2Matched = scoringAddressNumber.getHnrNumber2() > 0;
                boolean suffix1Matched = !StringUtilities.isEmpty((String)scoringAddressNumber.getHnrSuffix1());
                addrNumScore.setNumber1Matched(numner1Matched);
                addrNumScore.setNumber2Matched(numner2Matched);
                addrNumScore.setSuffix1Matched(suffix1Matched);
                addrNumScore.setMatched(true);
                addrNumScore.m_value = 1.0;
                addrNumScore.m_inputFieldPresent = true;
                scoringRange.setFieldScore(FieldType.ADDRESS_NUMBER_FIELD_TYPE, addrNumScore);
            }
        }
    }

    @Override
    protected void scoreRange(InternalScoringAddress scoringAddr, InternalScoringRange scoringRange, ParsedAddress pAddr, MatchingOptions matchingOptions, ICGGEScorer scorer) {
        super.scoreRange(scoringAddr, scoringRange, pAddr, matchingOptions, scorer);
        if (scoringRange.getField(FieldType.RANGE_PLACE_NAME_FIELD_TYPE) != null) {
            FieldScore rangePlaceNameScore = new FieldScore();
            this.scoreAddressWords((AddressWord[])pAddr.getField(FieldType.STREET_NAME_FIELD_TYPE), (InternalFieldValue)scoringRange.getField(FieldType.RANGE_PLACE_NAME_FIELD_TYPE), FieldType.RANGE_PLACE_NAME_FIELD_TYPE, rangePlaceNameScore, scorer);
            if (this.acceptRangeScore(rangePlaceNameScore)) {
                AddressNumber scoringAddressNumber;
                scoringRange.setFieldScore(FieldType.RANGE_PLACE_NAME_FIELD_TYPE, rangePlaceNameScore);
                if (rangePlaceNameScore.m_value == 1.0 && (scoringAddressNumber = scoringRange.getFrom()) != null && !StringUtilities.isEmpty((String)scoringAddressNumber.toString())) {
                    AddressNumberScore addrNumScore = new AddressNumberScore();
                    addrNumScore.setInputAddressNumber(scoringAddressNumber);
                    addrNumScore.setNumber1Matched(true);
                    addrNumScore.setMatched(true);
                    if (!StringUtilities.isEmpty((String)scoringAddressNumber.getHnrSuffix1())) {
                        addrNumScore.setSuffix1Matched(true);
                    }
                    addrNumScore.m_value = 1.0;
                    scoringRange.setFieldScore(FieldType.ADDRESS_NUMBER_FIELD_TYPE, addrNumScore);
                }
            }
        }
    }
}

