/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.SVK.matcher;

import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.MatchingOptions;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalFieldValue;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.InternalScoringRange;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.matcher.CGGEMatcher1;
import com.mapinfo.mapmarker.cgge.scorer.ICGGEScorer;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Map;

public class SVK_Matcher1
extends CGGEMatcher1 {
    private static final String LRN_CODE = "LRN_CODE";

    @Override
    public void scoreRanges(InternalScoringAddress scoringAddr, ParsedAddress parsedAddr, MatchingOptions matchingOptions, ICGGEScorer scorer) {
        super.scoreRanges(scoringAddr, parsedAddr, matchingOptions, scorer);
        FieldScore streetScore = scoringAddr.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE);
        InternalScoringRange range = scoringAddr.getRangeAt(0);
        String lrn = (String)parsedAddr.getInputAddress().getField(FieldType.GENERIC_FIELD_4_FIELD_TYPE);
        if (range != null && !StringUtilities.isEmpty((String)lrn)) {
            Map fields = range.getFields();
            FieldScore addressNumberScore = range.getFieldScore(FieldType.ADDRESS_NUMBER_FIELD_TYPE);
            if (fields != null && fields.size() > 0) {
                for (Map.Entry entry : fields.entrySet()) {
                    FieldType type = entry.getKey();
                    if (!LRN_CODE.equalsIgnoreCase(type.getName())) continue;
                    if (addressNumberScore == null || addressNumberScore.m_value < 1.0) {
                        this.setStreetScore(streetScore);
                        continue;
                    }
                    InternalFieldValue value = (InternalFieldValue)entry.getValue();
                    if (lrn.equalsIgnoreCase(((AddressWord[])value.getFieldValue())[0].getWord())) continue;
                    this.setStreetScore(streetScore);
                }
            }
        }
    }

    public void setStreetScore(FieldScore fs) {
        if (fs != null) {
            fs.m_value = 0.0;
        }
    }
}

