/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.SVK.parser;

import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InputAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.parser.CGGEParser1;
import com.mapinfo.mapmarker.cgge.scorer.ICGGEScorer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SVK_Parser
extends CGGEParser1 {
    private static final String lrnString = "\\b(((((\\d{1,5})[\\\\\\/-])+){1})(\\d{1,4}\\/*[A-Z]?))\\b";
    private static final Pattern LRN_PATTERN = Pattern.compile("\\b(((((\\d{1,5})[\\\\\\/-])+){1})(\\d{1,4}\\/*[A-Z]?))\\b", 2);

    @Override
    public ParsedAddress[] parse(InputAddress inputAddress, ICGGEScorer scorer) {
        this.parseLRNfromInputAddress(inputAddress);
        ParsedAddress[] parsedAddresses = super.parse(inputAddress, scorer);
        return parsedAddresses;
    }

    private void parseLRNfromInputAddress(InputAddress inputAddress) {
        String streetname;
        Matcher streetnameMatcher;
        if (null != inputAddress && !inputAddress.isEmpty(FieldType.STREET_NAME_FIELD_TYPE) && (streetnameMatcher = LRN_PATTERN.matcher(streetname = (String)inputAddress.getField(FieldType.STREET_NAME_FIELD_TYPE))).find()) {
            String tlrn = streetnameMatcher.group(2);
            String lrn = streetnameMatcher.group(5);
            if (null != lrn) {
                streetname = streetname.replace(tlrn, "");
                inputAddress.setField(FieldType.GENERIC_FIELD_4_FIELD_TYPE, lrn);
                inputAddress.setField(FieldType.STREET_NAME_FIELD_TYPE, streetname);
            }
        }
    }
}

