/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.THA.matcher;

import com.mapinfo.mapmarker.THA.matcher.THAMatcher_Utils;
import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.MatchingOptions;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.CodedWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalFieldValue;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.matcher.CGGEMatcher1;
import com.mapinfo.mapmarker.cgge.scorer.ICGGEScorer;

public class THA_TH_Matcher
extends CGGEMatcher1 {
    private static final double STREET_ADJUST_VAL = 0.93;
    private static final String DashSpecial = "\u2013";

    @Override
    protected void scoreStreetFields(InternalScoringAddress scoringAddr, ParsedAddress pAddr, MatchingOptions matchingOptions, ICGGEScorer scorer) {
        super.scoreStreetFields(scoringAddr, pAddr, matchingOptions, scorer);
        if (pAddr.isIntersectionCase()) {
            return;
        }
        int countCandSignificantWords = 0;
        FieldScore score = scoringAddr.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE);
        if (score == null || score.m_matched) {
            return;
        }
        AddressWord[] inpAddressWords = score.getInputWords();
        InternalFieldValue ifv = (InternalFieldValue)scoringAddr.getField(FieldType.STREET_NAME_FIELD_TYPE);
        if (null == ifv || null == inpAddressWords) {
            return;
        }
        AddressWord[] streetCandWords = (AddressWord[])ifv.getFieldValue();
        for (int i = 0; i < streetCandWords.length; ++i) {
            AddressWord streetWord = streetCandWords[i];
            if (!AddressWord.isSignificantWord(streetWord)) continue;
            ++countCandSignificantWords;
        }
        if (countCandSignificantWords < 2) {
            if (this.handletwoTypes(pAddr, scoringAddr)) {
                score.m_value = 0.93;
                score.m_matched = true;
            }
            return;
        }
        int firstPos = -1;
        int matched = 0;
        for (int i = 0; i < streetCandWords.length; ++i) {
            AddressWord streetWord = streetCandWords[i];
            if (!AddressWord.isSignificantWord(streetWord)) continue;
            for (int j = 0; j < inpAddressWords.length; ++j) {
                AddressWord addressWord = inpAddressWords[j];
                if (!AddressWord.isSignificantWord(streetWord) || !AddressWord.isSignificantWord(addressWord) || !(scorer.scoreAddressWords(streetWord, addressWord) >= 0.99)) continue;
                if (firstPos == -1) {
                    firstPos = j;
                    ++matched;
                    break;
                }
                if (firstPos == -1 || j <= firstPos) break;
                ++matched;
                break;
            }
            if (countCandSignificantWords != matched) continue;
            score.m_value = matchingOptions.getStreetFieldCutoff() + 0.15;
            score.m_matched = true;
        }
    }

    @Override
    public boolean calculateCloseMatch(InternalScoringAddress scoringAddr, ParsedAddress parsedAddr, GeocodeOptions options, MatchingOptions matchOptions) throws CGGEInternalException {
        boolean closeMatch = super.calculateCloseMatch(scoringAddr, parsedAddr, options, matchOptions);
        if (closeMatch && !THAMatcher_Utils.isPlotGood(parsedAddr, scoringAddr)) {
            return false;
        }
        FieldScore streetScore = scoringAddr.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE);
        FieldScore postcodeScore = scoringAddr.getFieldScore(FieldType.POST_CODE_FIELD_TYPE);
        FieldScore townScore = scoringAddr.getFieldScore(FieldType.AREA_NAME_3_FIELD_TYPE);
        if (parsedAddr.isSeparateAreaFields() && townScore != null && townScore.m_value < 0.53) {
            closeMatch = false;
        }
        if (closeMatch && streetScore != null && streetScore.m_value < 0.95 && postcodeScore != null && postcodeScore.m_value < 0.95) {
            if (townScore == null) {
                closeMatch = false;
            } else if (townScore.m_value < 0.98) {
                closeMatch = false;
                scoringAddr.setCloseMatch(false);
            }
        }
        if (closeMatch && streetScore != null && !parsedAddr.isIntersectionCase()) {
            if (streetScore.m_value > 0.84) {
                if (townScore == null) {
                    if (postcodeScore != null) {
                        if (postcodeScore.m_value < 1.0) {
                            closeMatch = false;
                            scoringAddr.setCloseMatch(false);
                        }
                    } else {
                        closeMatch = false;
                        scoringAddr.setCloseMatch(false);
                    }
                } else if (townScore.m_value > 0.95 && (postcodeScore == null || postcodeScore.m_value < 0.95) && townScore.m_value < 1.0) {
                    closeMatch = false;
                    scoringAddr.setCloseMatch(false);
                }
            } else if (!(townScore != null && townScore.m_value >= 1.0 && streetScore.m_value > 0.72 || postcodeScore != null && postcodeScore.m_value >= 1.0 && streetScore.m_value > 0.72)) {
                closeMatch = false;
                scoringAddr.setCloseMatch(false);
            }
        }
        scoringAddr.setCloseMatch(closeMatch);
        return closeMatch;
    }

    @Override
    protected void calculateCombinedStreetScore(InternalScoringAddress scoringAddr, ParsedAddress parsedAddress, MatchingOptions options) {
        super.calculateCombinedStreetScore(scoringAddr, parsedAddress, options);
        if (scoringAddr.getCombinedStreetScore() < 0.9 && this.handletwoTypes(parsedAddress, scoringAddr)) {
            scoringAddr.setCombinedStreetScore(0.93);
            scoringAddr.getFieldScore((FieldType)FieldType.STREET_NAME_FIELD_TYPE).m_value = 0.93;
            scoringAddr.getFieldScore((FieldType)FieldType.STREET_NAME_FIELD_TYPE).m_matched = true;
        }
    }

    private String buildStreetString(int firstTypepos, int sepPos, int end, AddressWord[] words) {
        int cntr;
        if (firstTypepos < 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder(words[firstTypepos].getWord());
        for (cntr = firstTypepos + 1; cntr < sepPos; ++cntr) {
            sb.append(" ");
            sb.append(words[cntr].getWord());
        }
        if (sepPos + 1 < end) {
            sb.append(words[sepPos + 1].getWord());
        }
        for (cntr = sepPos + 2; cntr <= end; ++cntr) {
            sb.append(" ");
            sb.append(words[cntr].getWord());
        }
        return sb.toString();
    }

    protected boolean handletwoTypes(ParsedAddress parsedAddr, InternalScoringAddress scoringAddr) {
        AddressWord[] streetWords = (AddressWord[])parsedAddr.getField(FieldType.STREET_NAME_FIELD_TYPE);
        boolean foundFirst = false;
        boolean chCase = false;
        if (streetWords != null && streetWords.length > 0) {
            int start = -1;
            int end = -1;
            int sepPos = -1;
            for (int cntr = 0; cntr < streetWords.length; ++cntr) {
                int idx;
                AddressWord stWord = streetWords[cntr];
                if (!foundFirst && CodedWord.isThoroughfareTypeWord(stWord.getAttributes())) {
                    foundFirst = true;
                    start = cntr;
                }
                if (foundFirst && stWord.getWord().equals("%")) {
                    sepPos = cntr;
                }
                if (!foundFirst || !CodedWord.isThoroughfareTypeWord(stWord.getAttributes()) || cntr + 1 >= streetWords.length || !Character.isDigit(streetWords[cntr + 1].getWord().charAt(0))) continue;
                end = ++cntr;
                for (idx = cntr + 2; idx < streetWords.length && (CodedWord.isNumber(streetWords[idx].getAttributes()) || streetWords[idx].getWord().equals("/") || streetWords[idx].getWord().equals("-") || streetWords[idx].getWord().equals(DashSpecial)); ++idx) {
                }
                if (idx > cntr + 2) {
                    end = idx - 1;
                }
                chCase = true;
            }
            if (end != -1) {
                InternalFieldValue candStreetIfv = (InternalFieldValue)scoringAddr.getField(FieldType.STREET_NAME_FIELD_TYPE);
                String candStreet = candStreetIfv.toString();
                String streetStr = this.buildStreetString(start, sepPos, end, streetWords);
                if (chCase && streetStr != null && streetStr.equals(candStreet.trim())) {
                    return true;
                }
            }
        }
        return false;
    }
}

