/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.THA.parser;

import com.mapinfo.mapmarker.THA.parser.THAParserUtils;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InputAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.parser.CGGEParser1;
import com.mapinfo.mapmarker.cgge.parser.ICGGEParserTerms;
import com.mapinfo.mapmarker.cgge.scorer.ICGGEScorer;

public class THA_TH_Parser
extends CGGEParser1 {
    private static String thaiScriptRoadAbbrev = "\u0e16.";
    private static String thaiScriptRoad = "\u0e16\u0e19\u0e19";
    private static String thaiScriptSoi = "\u0e0b\u0e2d\u0e22";
    private static String[] replaceCharsPreClean = new String[]{";", "\\$"};

    @Override
    public ParsedAddress[] parse(InputAddress inputAddress, ICGGEScorer scorer) {
        ParsedAddress[] parsedAddresses = super.parse(inputAddress, scorer);
        THAParserUtils.separatePlotAndHouse(inputAddress, parsedAddresses[0]);
        for (ParsedAddress pa : parsedAddresses) {
            pa.setParseAlwaysDeterminesHnr(true);
        }
        return parsedAddresses;
    }

    @Override
    protected String cleanString(String str) {
        ICGGEParserTerms parserTerms = this.getParserTerms();
        if ((str = this.getUpperCase(str)) != null && !parserTerms.isDelimiter(str)) {
            char[] originalCharacters = str.trim().toCharArray();
            char[] newCharacters = new char[originalCharacters.length];
            int insertNdx = -1;
            for (int i = 0; i < originalCharacters.length; ++i) {
                ++insertNdx;
                if (!(!Character.isWhitespace(originalCharacters[i]) || THAParserUtils.isThaiLetterOrDigit(originalCharacters[i - 1]) && THAParserUtils.isThaiLetterOrDigit(originalCharacters[i + 1]) || originalCharacters[i - 1] == '.' && THAParserUtils.isThaiLetterOrDigit(originalCharacters[i + 1]) || Character.isWhitespace(originalCharacters[i - 1]) || Character.isDigit(originalCharacters[i + 1]) && originalCharacters[i - 1] == '.' || '&' == originalCharacters[i - 1])) {
                    --insertNdx;
                    continue;
                }
                newCharacters[insertNdx] = originalCharacters[i];
            }
            return new String(newCharacters).trim();
        }
        return null;
    }

    @Override
    protected void addTypeSeparators(StringBuilder buffer) {
        int[] pos;
        super.addTypeSeparators(buffer);
        int len = buffer.length();
        int startNdx = 0;
        boolean typeFound = false;
        while (len > 0 && (pos = this.getThoroughfareTypeHandler().findThoroughfareTypeHandlesAttachedPreTypes(buffer.substring(startNdx, startNdx + len))) != null) {
            boolean canInsert;
            char ch;
            boolean possibleBackToBackTypes;
            boolean bl = possibleBackToBackTypes = startNdx - 1 > 0 && buffer.charAt(startNdx - 1) == '%';
            if (pos[0] > 0) {
                ch = '*';
                if (pos[1] != buffer.length()) {
                    ch = buffer.charAt(pos[1]);
                }
                if (Character.isLetterOrDigit(ch)) {
                    String word;
                    boolean bl2 = canInsert = !typeFound;
                    if (!canInsert) {
                        canInsert = pos[1] == buffer.length();
                        for (int i = pos[0]; i < buffer.length(); ++i) {
                            String chStr = "" + buffer.charAt(i);
                            if (!this.m_parserTerms.isDelimiter(chStr)) continue;
                            if ("%".equals(chStr)) break;
                            canInsert = true;
                            break;
                        }
                    }
                    if (canInsert && (this.m_parserTerms.isAbbreviatableWord(word = this.findWordAtPosition(buffer, startNdx + pos[0])) || this.m_parserTerms.isCommonWord(word))) {
                        canInsert = false;
                    }
                    if (canInsert) {
                        buffer.insert(startNdx + pos[1], "%");
                        typeFound = true;
                    }
                }
                len = pos[1] - pos[0] > 1 ? pos[0] + 1 : pos[0];
                continue;
            }
            if (pos[0] != 0 || pos[1] >= len) break;
            ch = buffer.charAt(startNdx + pos[1]);
            if (Character.isLetterOrDigit(ch)) {
                boolean bl3 = canInsert = !typeFound;
                if (!canInsert) {
                    boolean bl4 = canInsert = pos[1] == buffer.length() || pos[1] - pos[0] == 3;
                    if (!canInsert) break;
                    int lengthToUse = buffer.length();
                    if (pos[1] - pos[0] == 3) {
                        lengthToUse = 3;
                    }
                    for (int i = pos[0]; i < lengthToUse; ++i) {
                        String chStr = "" + buffer.charAt(i);
                        if (!"%".equals(chStr) && !this.m_parserTerms.isDelimiter(chStr)) continue;
                        canInsert = false;
                        break;
                    }
                }
                if (canInsert && !possibleBackToBackTypes) {
                    buffer.insert(startNdx + pos[1], "%");
                    typeFound = true;
                }
                startNdx = pos[1] + 1;
            } else {
                startNdx = pos[1];
            }
            len -= startNdx;
        }
    }

    @Override
    protected int thoroughfareTypeDelimiterPosition(String str) {
        int[] startEnd;
        int returnpos = -1;
        if (str.length() > 0 && (startEnd = this.getThoroughfareTypeHandler().findThoroughfareTypeHandlesAttachedPreTypes(str)) != null) {
            char ch;
            if (startEnd[0] > 0) {
                char ch2 = str.charAt(startEnd[0] - 1);
                if (Character.isLetterOrDigit(ch2)) {
                    returnpos = startEnd[0];
                }
            } else if (startEnd[1] < str.length() && Character.isLetterOrDigit(ch = str.charAt(startEnd[1]))) {
                returnpos = startEnd[1];
            }
        }
        return returnpos;
    }

    private void doPreClean(InputAddress addr) {
        String streetField = (String)addr.getField(FieldType.STREET_NAME_FIELD_TYPE);
        if (streetField != null) {
            for (int i = 0; i < replaceCharsPreClean.length; ++i) {
                streetField = streetField.replaceAll(replaceCharsPreClean[i], " ");
            }
            if (streetField.contains(thaiScriptRoadAbbrev)) {
                streetField = streetField.replaceAll(thaiScriptRoadAbbrev, thaiScriptRoad);
            }
            addr.setField(FieldType.STREET_NAME_FIELD_TYPE, streetField);
        }
    }

    @Override
    protected InputAddress getCleanedInputAddress(InputAddress inAddr) {
        this.doPreClean(inAddr);
        return super.getCleanedInputAddress(inAddr);
    }
}

