/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.TUR.matcher;

import com.mapinfo.mapmarker.cgge.AddressNumberScore;
import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.MatchingOptions;
import com.mapinfo.mapmarker.cgge.address.AddressNumber;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.InternalScoringRange;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.matcher.CGGEMatcher;
import com.mapinfo.mapmarker.cgge.scorer.ICGGEScorer;
import com.mapinfo.mapmarker.cgge.utils.IntArray;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TURMatcher
extends CGGEMatcher {
    @Override
    public boolean calculateCloseMatch(InternalScoringAddress scoringAddr, ParsedAddress parsedAddr, GeocodeOptions options, MatchingOptions matchOptions) throws CGGEInternalException {
        FieldScore score;
        boolean isCloseMatch = super.calculateCloseMatch(scoringAddr, parsedAddr, options, matchOptions);
        if (isCloseMatch && scoringAddr.getSearchWords() != null && scoringAddr.getRangeCount() > 0 && !scoringAddr.getRangeAt(0).isCloseMatch() && this.isPointCandidate(scoringAddr) && ((score = scoringAddr.getFieldScore(FieldType.ADDRESS_NUMBER_FIELD_TYPE)) == null || score.m_value == 0.0)) {
            isCloseMatch = false;
        }
        scoringAddr.setCloseMatch(isCloseMatch);
        return isCloseMatch;
    }

    @Override
    public void scoreRanges(InternalScoringAddress scoringAddr, ParsedAddress parsedAddr, MatchingOptions matchingOptions, ICGGEScorer scorer) {
        super.scoreRanges(scoringAddr, parsedAddr, matchingOptions, scorer);
        Map<FieldType, FieldScore> scores = scoringAddr.getRangeAt(0).getFieldScores();
        if (scores != null && scores.size() > 0) {
            scoringAddr.setFieldScores(scores);
        }
    }

    @Override
    protected void scorePostalFields(InternalScoringAddress scoringAddr, ParsedAddress pAddr, MatchingOptions matchingOptions, ICGGEScorer scorer) {
        super.scorePostalFields(scoringAddr, pAddr, matchingOptions, scorer);
        this.promoteLocalityScore(scoringAddr);
    }

    @Override
    protected void scoreRange(InternalScoringAddress scoringAddr, InternalScoringRange scoringRange, ParsedAddress pAddr, MatchingOptions matchingOptions, ICGGEScorer scorer) {
        Map<FieldType, FieldScore> scores = scoringAddr.getFieldScores();
        if (scores != null && scores.size() > 0) {
            for (Map.Entry<FieldType, FieldScore> scoreEntry : scores.entrySet()) {
                FieldScore score = scoreEntry.getValue();
                if (score == null) continue;
                FieldScore clonedScore = new FieldScore();
                clonedScore.copy(score);
                scoringRange.setFieldScore(scoreEntry.getKey(), clonedScore);
            }
        }
        super.scoreRange(scoringAddr, scoringRange, pAddr, matchingOptions, scorer);
    }

    @Override
    protected void scoreRangeAddressNumber(InternalScoringAddress scoringAddr, InternalScoringRange scoringRange, ParsedAddress pAddr, MatchingOptions matchingOptions, ICGGEScorer scorer) {
        super.scoreRangeAddressNumber(scoringAddr, scoringRange, pAddr, matchingOptions, scorer);
        AddressNumberScore addressNumberScore = (AddressNumberScore)scoringRange.getFieldScore(FieldType.ADDRESS_NUMBER_FIELD_TYPE);
        AddressNumber inputHouseNumber = pAddr.getAddressNumber();
        if (inputHouseNumber == null && this.isPointCandidate(scoringAddr)) {
            String hnrNumberToScore2 = "";
            if (addressNumberScore != null && addressNumberScore.getInputAddressNumber() != null && !StringUtilities.isEmpty((String)addressNumberScore.getInputAddressNumber().toString())) {
                addressNumberScore.m_value = 1.0;
                scoringRange.setFieldScore(FieldType.ADDRESS_NUMBER_FIELD_TYPE, addressNumberScore);
            } else {
                List<String> addressNumberList = this.getHNRListFromProbableHRN(pAddr, scoringAddr);
                if (addressNumberList != null && !addressNumberList.isEmpty()) {
                    for (String hnrNumberToScore2 : addressNumberList) {
                        AddressNumber rangeAddressNumber;
                        if (StringUtilities.isEmpty((String)hnrNumberToScore2.toString()) || (rangeAddressNumber = scoringRange.getFrom()) == null || StringUtilities.isEmpty((String)rangeAddressNumber.toString()) || !rangeAddressNumber.toString().equalsIgnoreCase(hnrNumberToScore2)) continue;
                        AddressNumberScore addrNumScore = new AddressNumberScore();
                        addrNumScore.setInputAddressNumber(rangeAddressNumber);
                        boolean numner1Matched = rangeAddressNumber.getHnrNumber1() > 0;
                        boolean numner2Matched = rangeAddressNumber.getHnrNumber2() > 0;
                        boolean suffix1Matched = !StringUtilities.isEmpty((String)rangeAddressNumber.getHnrSuffix1());
                        addrNumScore.setNumber1Matched(numner1Matched);
                        addrNumScore.setNumber2Matched(numner2Matched);
                        addrNumScore.setSuffix1Matched(suffix1Matched);
                        addrNumScore.setMatched(true);
                        addrNumScore.m_value = 1.0;
                        addrNumScore.m_inputFieldPresent = true;
                        scoringRange.setFieldScore(FieldType.ADDRESS_NUMBER_FIELD_TYPE, addrNumScore);
                        break;
                    }
                }
            }
        }
    }

    private boolean isPointCandidate(InternalScoringAddress scoringAddr) {
        return scoringAddr.getRangeAt(0).getFrom() != null && scoringAddr.getRangeAt(0).getTo() == null;
    }

    private List<String> getHNRListFromProbableHRN(ParsedAddress pAddr, InternalScoringAddress scoringAddr) {
        IntArray matchedNdxs;
        ArrayList<String> probHNRList = new ArrayList<String>();
        AddressWord[] inputWords = (AddressWord[])pAddr.getField(FieldType.STREET_NAME_FIELD_TYPE);
        if (inputWords != null && inputWords.length > 0 && (matchedNdxs = this.getAllMatchingWordIndex(scoringAddr.getFieldScoreList(), inputWords)) != null && !matchedNdxs.isEmpty()) {
            for (int i = 0; i < inputWords.length; ++i) {
                if (matchedNdxs == null || matchedNdxs.contains(i) || String.valueOf(inputWords[i].getNormalizedChars()[0]).matches("[^a-z A-Z0-9]") || !this.isAcceptableHNR(scoringAddr, i)) continue;
                String hnr = String.valueOf(inputWords[i].getNormalizedChars());
                List<AddressNumber> addressNumberList = pAddr.getProbableAddressNumbers();
                if (addressNumberList == null) continue;
                for (AddressNumber addressNumber : addressNumberList) {
                    if (addressNumber == null || StringUtilities.isEmpty((String)addressNumber.toString()) || !addressNumber.toString().contains(hnr)) continue;
                    probHNRList.add(hnr);
                }
            }
        }
        return probHNRList;
    }

    private IntArray getAllMatchingWordIndex(Collection<FieldScore> fieldScores, AddressWord[] inputWords) {
        IntArray matchingWordNdxs = null;
        if (fieldScores != null) {
            Iterator<FieldScore> itr = fieldScores.iterator();
            FieldScore score = null;
            while (itr.hasNext()) {
                score = itr.next();
                if (score == null || !(score.m_value > 0.5) || score.m_inputWords != inputWords || score.m_matchedInputWords == null) continue;
                if (matchingWordNdxs == null) {
                    matchingWordNdxs = new IntArray(inputWords.length);
                }
                matchingWordNdxs.add(score.m_matchedInputWords);
            }
            if (matchingWordNdxs != null) {
                matchingWordNdxs.sort();
            }
        }
        return matchingWordNdxs;
    }

    private boolean isAcceptableHNR(InternalScoringAddress scoringAddr, int hnrIndex) {
        boolean acceptHNR = false;
        FieldScore streetScore = scoringAddr.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE);
        IntArray streetWordNdxs = streetScore == null ? null : streetScore.m_matchedInputWords;
        int streetStartNdx = -1;
        int streetEndNdx = -1;
        if (streetWordNdxs != null && streetWordNdxs.size() > 0) {
            streetStartNdx = streetWordNdxs.min();
            streetEndNdx = streetWordNdxs.max();
        }
        if (hnrIndex < streetStartNdx || hnrIndex > streetEndNdx) {
            acceptHNR = true;
        }
        return acceptHNR;
    }

    private void promoteLocalityScore(InternalScoringAddress scoringAddr) {
        FieldScore score = scoringAddr.getFieldScore(FieldType.AREA_NAME_4_FIELD_TYPE);
        if (score != null && score.m_value > 0.91 && score.m_value < 1.0) {
            IntArray m_matchedCandWords = score.m_matchedCandWords;
            AddressWord[] candidateWords = score.getCandidateWords();
            boolean promoteScore = true;
            for (int i = 0; i < candidateWords.length; ++i) {
                AddressWord word;
                if (m_matchedCandWords.contains(i) || !AddressWord.isSignificantWord(word = candidateWords[i])) continue;
                promoteScore = false;
                break;
            }
            if (promoteScore) {
                score.m_value = 1.0;
            }
        }
    }
}

