/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.TUR.parser;

import com.mapinfo.mapmarker.cgge.address.AddressNumber;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InputAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.address.PostCode;
import com.mapinfo.mapmarker.cgge.parser.CGGEParser1;
import com.mapinfo.mapmarker.cgge.scorer.ICGGEScorer;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TUR_Parser
extends CGGEParser1 {
    private static final String PARTIAL_POSTALCODE_FORMAT = "\\d{4}";
    private static final Pattern PARTIAL_POSTALCODE = Pattern.compile("\\d{4}", 2);

    @Override
    public ParsedAddress[] parse(InputAddress inputAddress, ICGGEScorer scorer) {
        ParsedAddress parsedAddress;
        List<PostCode> probablePostCode;
        ParsedAddress[] addresses = super.parse(inputAddress, scorer);
        boolean pcNotFound = true;
        if (addresses != null && addresses.length > 0 && ((probablePostCode = (parsedAddress = addresses[0]).getProbablePostcodes()) == null || probablePostCode.isEmpty()) && parsedAddress.getField(FieldType.POST_CODE_FIELD_TYPE) == null) {
            List<AddressNumber> probableAddressNumbers;
            Matcher matcher;
            String postAddress;
            if (inputAddress.getField(FieldType.POST_ADDRESS_FIELD_TYPE) != null && !MMUtils.isEmpty(postAddress = (String)inputAddress.getField(FieldType.POST_ADDRESS_FIELD_TYPE)) && (matcher = PARTIAL_POSTALCODE.matcher(postAddress)).find()) {
                parsedAddress.setField(FieldType.POST_CODE_FIELD_TYPE, this.splitIntoWeightedWords(matcher.group(0), FieldType.POST_CODE_FIELD_TYPE));
                pcNotFound = false;
            }
            if (pcNotFound && (probableAddressNumbers = parsedAddress.getProbableAddressNumbers()) != null && probableAddressNumbers.size() > 0) {
                for (AddressNumber addrNum : probableAddressNumbers) {
                    if (addrNum.getHnrNumber1() <= 999 || addrNum.getPositionInInputStreet()[0] <= ((AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE)).length / 2) continue;
                    PostCode pc = new PostCode(this.splitIntoWeightedWords(Integer.toString(addrNum.getHnrNumber1()), FieldType.STREET_NAME_FIELD_TYPE), addrNum.getPositionInInputStreet());
                    if (probablePostCode == null) {
                        probablePostCode = new ArrayList<PostCode>();
                    }
                    probablePostCode.add(pc);
                }
            }
            parsedAddress.setProbablePostcodes(probablePostCode);
        }
        return addresses;
    }

    @Override
    public AddressWord[] splitIntoWeightedWords(String str, FieldType type) {
        if (type != null && FieldType.STREET_NAME_FIELD_TYPE == type) {
            str = this.cleanInputString(str);
        }
        return super.splitIntoWeightedWords(str, type);
    }

    private String cleanInputString(String str) {
        String[] words = MMUtils.splitString(str, this.getParserTerms().getDelimiters(), true);
        String[] modifiedWords = null;
        String prevWord = "";
        if (words != null && words.length > 0) {
            for (int i = words.length - 1; i > 0; --i) {
                if (!StringUtilities.isEmpty((String)prevWord) && prevWord.equals(".") && this.getThoroughfareTypeHandler().isThoroughfareType(words[i])) {
                    modifiedWords = Arrays.copyOf(words, words.length - 1);
                }
                prevWord = words[i];
            }
        }
        return modifiedWords != null ? this.concatenateStringFromArray(modifiedWords) : str;
    }

    private String concatenateStringFromArray(String[] modifiedWords) {
        StringBuilder stBuilder = new StringBuilder();
        if (modifiedWords != null && modifiedWords.length > 0) {
            for (String string : modifiedWords) {
                stBuilder.append(string);
            }
        }
        return stBuilder.toString();
    }
}

